/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor.common;

import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class ToggleControl
extends Canvas {
    private boolean fCollapsed;
    private Color fDecorationColor;
    private Color fActiveColor;
    private Cursor fActiveCursor;
    private boolean fHasFocus;
    private boolean fHover = false;
    private static final int MARGIN_WIDTH = 2;
    private static final int MARGIN_HEIGHT = 2;
    private static final int DEFAULT_HEIGHT = 8;
    private static final int[] EXPANDED_POINTS = new int[]{0, 2, 8, 2, 4, 6};
    private static final int[] COLLAPSED_POINTS = new int[]{2, 0, 2, 8, 6, 4};
    private int fMultiplier = 2;
    private int fHeight = 8;
    private String fName;
    private String fDescription;

    public ToggleControl(Composite composite, int i) {
        super(composite, i);
        this.initAccessible();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintevent) {
                ToggleControl.this.paint(paintevent);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseevent) {
                ToggleControl.this.notifyListeners(13);
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyevent) {
                if (keyevent.character == '\r' || keyevent.character == ' ') {
                    ToggleControl.this.notifyListeners(13);
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail != 4) {
                    event.doit = true;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusevent) {
                if (!ToggleControl.this.fHasFocus) {
                    ToggleControl.this.fHasFocus = true;
                    ToggleControl.this.redraw();
                }
            }

            public void focusLost(FocusEvent focusevent) {
                if (ToggleControl.this.fHasFocus) {
                    ToggleControl.this.fHasFocus = false;
                    ToggleControl.this.redraw();
                }
            }
        });
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionevent) {
                ToggleControl.this.fCollapsed = !ToggleControl.this.fCollapsed;
                ToggleControl.this.redraw();
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent mouseevent) {
                ToggleControl.this.fHover = true;
                if (ToggleControl.this.fActiveCursor != null) {
                    ToggleControl.this.setCursor(ToggleControl.this.fActiveCursor);
                }
                ToggleControl.this.redraw();
            }

            public void mouseExit(MouseEvent mouseevent) {
                ToggleControl.this.fHover = false;
                if (ToggleControl.this.fActiveCursor != null) {
                    ToggleControl.this.setCursor(null);
                }
                ToggleControl.this.redraw();
            }
        });
    }

    public void addSelectionListener(SelectionListener selectionlistener) {
        this.checkWidget();
        if (selectionlistener != null) {
            this.addListener(13, (Listener)new TypedListener((SWTEventListener)selectionlistener));
        }
    }

    public void setDecorationColor(Color color) {
        this.fDecorationColor = color;
    }

    public Color getDecorationColor() {
        return this.fDecorationColor;
    }

    public void setActiveDecorationColor(Color color) {
        this.fActiveColor = color;
    }

    public void removeSelectionListener(SelectionListener selectionlistener) {
        this.checkWidget();
        if (selectionlistener != null) {
            this.removeListener(13, (SWTEventListener)selectionlistener);
        }
    }

    public void setActiveCursor(Cursor cursor) {
        this.fActiveCursor = cursor;
    }

    public Color getActiveDecorationColor() {
        return this.fActiveColor;
    }

    public Point computeSize(int i, int j, boolean flag) {
        return new Point(i == -1 ? this.fHeight + 4 : i, j == -1 ? this.fHeight + 4 : j);
    }

    protected void paint(PaintEvent paintevent) {
        GC gc = paintevent.gc;
        Point point = this.getSize();
        gc.setFont(this.getFont());
        this.paint(gc);
        if (this.fHasFocus) {
            gc.setForeground(this.getForeground());
            gc.drawFocus(0, 0, point.x, point.y);
        }
    }

    protected void paint(GC gc) {
        if (this.fHover && this.fActiveColor != null) {
            gc.setBackground(this.fActiveColor);
        } else if (this.fDecorationColor != null) {
            gc.setBackground(this.fDecorationColor);
        } else {
            gc.setBackground(this.getForeground());
        }
        Point point = this.getSize();
        gc.fillPolygon(this.translate(this.fCollapsed ? COLLAPSED_POINTS : EXPANDED_POINTS, (point.x - this.fHeight) / 2, (point.y - this.fHeight) / 2));
        gc.setBackground(this.getBackground());
    }

    private int[] translate(int[] ai, int i, int j) {
        int[] ai1 = new int[ai.length];
        for (int k = 0; k < ai.length; k += 2) {
            ai1[k] = ai[k] * this.fHeight / 8 + i;
        }
        for (int l = 1; l < ai.length; l += 2) {
            ai1[l] = ai[l] * this.fHeight / 8 + j;
        }
        return ai1;
    }

    public void setHeight(int i) {
        this.fHeight = i;
    }

    private void notifyListeners(int i) {
        Event event = new Event();
        event.type = i;
        event.widget = this;
        this.notifyListeners(i, event);
    }

    public boolean getSelection() {
        return this.fCollapsed;
    }

    public void setSelection(boolean flag) {
        this.fCollapsed = flag;
    }

    public void setName(String s) {
        this.fName = s;
    }

    public void setDescription(String s) {
        this.fDescription = s;
    }

    private void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleevent) {
                accessibleevent.result = ToggleControl.this.fName;
            }

            public void getDescription(AccessibleEvent accessibleevent) {
                accessibleevent.result = ToggleControl.this.fDescription;
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getLocation(AccessibleControlEvent accessiblecontrolevent) {
                Rectangle rectangle = ToggleControl.this.getBounds();
                Point point = ToggleControl.this.toDisplay(new Point(rectangle.x, rectangle.y));
                accessiblecontrolevent.x = point.x;
                accessiblecontrolevent.y = point.y;
                accessiblecontrolevent.width = rectangle.width;
                accessiblecontrolevent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessiblecontrolevent) {
                accessiblecontrolevent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessiblecontrolevent) {
                accessiblecontrolevent.detail = 35;
            }

            public void getState(AccessibleControlEvent accessiblecontrolevent) {
                accessiblecontrolevent.detail = ToggleControl.this.fCollapsed ? 1024 : 512;
            }
        });
    }
}

