/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.properties.solution;

import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.management.DeployOptionsCollection;
import com.kingdee.bos.tool.celleditors.BooleanCellEditor;
import com.kingdee.bos.tool.properties.solution.Messages;
import com.kingdee.bos.tool.solution.StudioConfigurationOptions;
import com.kingdee.bos.tool.utils.IndexLocateUtil;
import com.kingdee.bos.ui.dtp.model.ComponentNameManager;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.IProgressService;

public class DeployOptionsInfoDialogPage
extends PropertyPage {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.properties.solution.DeployOptionsInfoDialogPage");
    private static final String NAME = "name";
    private static final String ALIAS = "alias";
    private static final String ISDEFAULT = "isdefault";
    private IProject project;
    private DeployOptionsCollection deploies;
    private DeployOptionInfo defaultDeployInfo;
    private DeployOptionInfo currentDeployInfo;
    private ComponentNameManager nameManager;
    private TableViewer tableView;
    private DirectoryFieldEditor javaPathEditor;
    private DirectoryFieldEditor j2eePathEditor;
    private DirectoryFieldEditor metadataPathEditor;
    private Button apusicEditor;
    private Button weblogicEditor;
    private Button websphereEditor;
    private Button genCodeEditor;
    private Button genMetadataEditor;
    private Button genConfigEditor;
    private Button appendCfg;
    private Button overwriteCfg;
    private Button xhtmlDeploy;
    private Button mbeanDeploy;
    private Composite pathZoneParent;
    private HashMap cancompleteMap = new HashMap();
    private DirectoryFieldEditor wuSrcPathEditor;
    private DirectoryFieldEditor wuRootEditor;
    private static String JAVA_PATH = "java";
    private static String J2EE_PATH = "j2ee";
    private static String MD_PATH = "metadata";
    Map oldInfoCopies = new HashMap();

    public DeployOptionsInfoDialogPage() {
        this.setDescription(Messages.DeployOptionsInfoDialogPage_SheZhiJieJueFangAnDeFaBuFangAn);
        this.deploies = new DeployOptionsCollection();
        this.nameManager = new ComponentNameManager();
    }

    public boolean performOk() {
        HashMap<String, DeployOptionInfo> map = new HashMap<String, DeployOptionInfo>();
        Collection oldInfos = StudioConfigurationOptions.loadDeployOptions(this.project);
        for (DeployOptionInfo info : oldInfos) {
            map.put(info.getName(), info);
        }
        ArrayList<DeployOptionInfo> tempCollection = new ArrayList<DeployOptionInfo>();
        int j = this.deploies.size();
        for (int i = 0; i < j; ++i) {
            DeployOptionInfo tempInfo = this.deploies.get(i);
            DeployOptionInfo oldInfo = (DeployOptionInfo)this.oldInfoCopies.get(tempInfo.getName());
            DeployOptionInfo fileInfo = (DeployOptionInfo)map.get(tempInfo.getName());
            if (oldInfo != null && fileInfo != null) {
                if (tempInfo.equals((Object)oldInfo)) {
                    tempInfo = fileInfo;
                } else if (!oldInfo.equals((Object)fileInfo)) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"\u8b66\u544a", (String)("\u53d1\u5e03\u65b9\u6848\u4fe1\u606f[" + tempInfo.getName() + "]\u5728\u540e\u53f0\u88ab\u4fee\u6539,\u5c06\u4f7f\u7528\u5f53\u524d\u8bbe\u7f6e\u8986\u76d6!"));
                }
            }
            if (tempInfo.equals((Object)this.defaultDeployInfo)) {
                tempInfo.setDefault(true);
            } else if (tempInfo.isDefault()) {
                tempInfo.setDefault(true);
            } else {
                tempInfo.setDefault(false);
            }
            tempCollection.add(tempInfo);
        }
        if (!tempCollection.isEmpty()) {
            StudioConfigurationOptions.storeDeployOptions(tempCollection);
        }
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        this.initDeployInfos();
        Composite container = new Composite(parent, 0);
        container.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.numColumns = 1;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        Control header = this.createHeader(container);
        GridData data = new GridData(1808);
        data.verticalSpan = 5;
        header.setLayoutData((Object)data);
        Control detail = this.createDetail(container);
        data = new GridData(768);
        data.verticalSpan = 7;
        detail.setLayoutData((Object)data);
        this.initControlState();
        return container;
    }

    private Control createHeader(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Table table = new Table(container, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn nameCol = new TableColumn(table, 0x1000000);
        nameCol.setText(Messages.DeployOptionsInfoDialogPage_MingCheng);
        nameCol.setWidth(120);
        nameCol.setAlignment(0x1000000);
        TableColumn aliasCol = new TableColumn(table, 0x1000000);
        aliasCol.setText(Messages.DeployOptionsInfoDialogPage_BieMing);
        aliasCol.setWidth(140);
        aliasCol.setAlignment(0x1000000);
        TableColumn defaultCol = new TableColumn(table, 0x1000000);
        defaultCol.setText(Messages.DeployOptionsInfoDialogPage_ShiFouQueSheng);
        defaultCol.setWidth(60);
        defaultCol.setAlignment(0x1000000);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        TextCellEditor nameCellEditor = new TextCellEditor((Composite)table);
        TextCellEditor aliasCellEditor = new TextCellEditor((Composite)table);
        BooleanCellEditor isdefalutCellEditor = new BooleanCellEditor((Composite)table);
        this.tableView = new TableViewer(table);
        this.tableView.setColumnProperties(new String[]{NAME, ALIAS, ISDEFAULT});
        this.tableView.setContentProvider((IContentProvider)new DeployContentProvider());
        this.tableView.setLabelProvider((IBaseLabelProvider)new DeployLabelProvider());
        this.tableView.setCellEditors(new CellEditor[]{nameCellEditor, aliasCellEditor, isdefalutCellEditor});
        this.tableView.setCellModifier((ICellModifier)new DeployModifer());
        this.tableView.setInput((Object)this.deploies);
        this.tableView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                ISelection sel = event.getSelection();
                if (sel instanceof StructuredSelection && (obj = ((StructuredSelection)sel).getFirstElement()) instanceof DeployOptionInfo) {
                    DeployOptionsInfoDialogPage.this.selectionChangeDeployInfo((DeployOptionInfo)obj);
                }
            }
        });
        Composite buttonContainer = new Composite(container, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        buttonContainer.setLayout((Layout)layout);
        data = new GridData(2);
        buttonContainer.setLayoutData((Object)data);
        Button addBtn = new Button(buttonContainer, 0);
        addBtn.setText(Messages.DeployOptionsInfoDialogPage_XinZengN);
        data = new GridData();
        data.verticalAlignment = 2;
        data.widthHint = 80;
        addBtn.setLayoutData((Object)data);
        final Button delBtn = new Button(buttonContainer, 0);
        delBtn.setText(Messages.DeployOptionsInfoDialogPage_ShanChuD);
        addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeployOptionInfo info = new DeployOptionInfo();
                info.setName(DeployOptionsInfoDialogPage.this.nameManager.getNameByName(Messages.DeployOptionsInfoDialogPage_XinFaBuFangAn));
                String dsrc = DeployOptionsInfoDialogPage.this.getDefaultSrc();
                info.setJavaOutputDir(dsrc);
                info.setJ2eeOutputDir(dsrc);
                if (dsrc != null && dsrc.length() > 0 && new File(dsrc).exists()) {
                    String root = new File(dsrc).getParent();
                    info.setMetaDataRepository(root + "/deployed_metas");
                    info.setWebUiRootPath(root + "/web/websrc");
                    info.setWebUiSrcPath(root + "/web/webRoot");
                } else {
                    info.setJ2eeOutputDir("");
                    info.setJavaOutputDir("");
                    info.setMetaDataRepository("");
                    info.setWebUiRootPath("");
                    info.setWebUiSrcPath("");
                }
                if (DeployOptionsInfoDialogPage.this.deploies != null && DeployOptionsInfoDialogPage.this.deploies.size() < 1) {
                    info.setDefault(true);
                }
                DeployOptionsInfoDialogPage.this.deploies.add(info);
                DeployOptionsInfoDialogPage.this.tableView.getTable().setRedraw(false);
                DeployOptionsInfoDialogPage.this.tableView.refresh();
                DeployOptionsInfoDialogPage.this.tableView.setSelection((ISelection)new StructuredSelection((Object)info));
                DeployOptionsInfoDialogPage.this.tableView.getTable().setRedraw(true);
                if (DeployOptionsInfoDialogPage.this.deploies.size() == 1) {
                    delBtn.setEnabled(true);
                    DeployOptionsInfoDialogPage.this.innerSetControlState(true);
                }
            }
        });
        delBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeployOptionsInfoDialogPage.this.tableView.getTable().getSelectionCount() <= 0) {
                    MessageDialogWithToggle.openInformation((Shell)DeployOptionsInfoDialogPage.this.tableView.getControl().getShell(), (String)Messages.DeployOptionsInfoDialogPage_TiShi, (String)Messages.DeployOptionsInfoDialogPage_QingXuanZeSuoYaoShanChuDeFaBuFangAn);
                    return;
                }
                int nextSelIndex = DeployOptionsInfoDialogPage.this.getNextItem(DeployOptionsInfoDialogPage.this.tableView.getTable().getSelectionIndices());
                TableItem[] items = DeployOptionsInfoDialogPage.this.tableView.getTable().getSelection();
                for (int i = 0; i < items.length; ++i) {
                    DeployOptionInfo info = (DeployOptionInfo)items[i].getData();
                    DeployOptionsInfoDialogPage.this.deploies.remove(info);
                    DeployOptionsInfoDialogPage.this.nameManager.remove(info.getName());
                    if (!DeployOptionsInfoDialogPage.this.isDefaultDeploy(info)) continue;
                    if (DeployOptionsInfoDialogPage.this.deploies.size() > 0) {
                        DeployOptionsInfoDialogPage.this.defaultDeployInfo = DeployOptionsInfoDialogPage.this.deploies.get(0);
                        continue;
                    }
                    DeployOptionsInfoDialogPage.this.defaultDeployInfo = null;
                }
                DeployOptionsInfoDialogPage.this.tableView.getTable().setRedraw(false);
                DeployOptionsInfoDialogPage.this.tableView.refresh();
                if (nextSelIndex >= 0) {
                    DeployOptionsInfoDialogPage.this.tableView.setSelection((ISelection)new StructuredSelection(DeployOptionsInfoDialogPage.this.tableView.getElementAt(nextSelIndex)));
                }
                DeployOptionsInfoDialogPage.this.tableView.getTable().setRedraw(true);
                if (DeployOptionsInfoDialogPage.this.deploies.size() == 0) {
                    delBtn.setEnabled(false);
                    DeployOptionsInfoDialogPage.this.innerSetControlState(false);
                }
            }
        });
        data = new GridData();
        data.verticalAlignment = 2;
        data.widthHint = 80;
        delBtn.setLayoutData((Object)data);
        return container;
    }

    private void initControlState() {
        DeployOptionInfo tempDefaultSel = this.defaultDeployInfo;
        if (tempDefaultSel == null && this.deploies != null && this.deploies.size() > 0) {
            tempDefaultSel = this.deploies.get(0);
        }
        if (tempDefaultSel != null) {
            this.tableView.setSelection((ISelection)new StructuredSelection((Object)tempDefaultSel));
            this.innerSetControlState(true);
        } else {
            this.innerSetControlState(false);
        }
    }

    private void innerSetControlState(boolean enabled) {
        this.javaPathEditor.setEnabled(enabled, this.pathZoneParent);
        this.j2eePathEditor.setEnabled(enabled, this.pathZoneParent);
        this.metadataPathEditor.setEnabled(enabled, this.pathZoneParent);
        this.wuRootEditor.setEnabled(enabled, this.pathZoneParent);
        this.wuSrcPathEditor.setEnabled(enabled, this.pathZoneParent);
        this.apusicEditor.setEnabled(enabled);
        this.weblogicEditor.setEnabled(enabled);
        this.websphereEditor.setEnabled(enabled);
        this.genCodeEditor.setEnabled(enabled);
        this.genMetadataEditor.setEnabled(enabled);
        this.genConfigEditor.setEnabled(enabled);
        this.appendCfg.setEnabled(enabled);
        this.overwriteCfg.setEnabled(enabled);
        this.xhtmlDeploy.setEnabled(enabled);
        this.mbeanDeploy.setEnabled(enabled);
    }

    private Control createDetail(Composite parent) {
        Group container = new Group(parent, 0);
        container.setFont(parent.getFont());
        container.setText(Messages.DeployOptionsInfoDialogPage_FaBuFangAnDeMingXiXinXi);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        Control path = this.createPathZone((Composite)container);
        GridData data = new GridData(768);
        path.setLayoutData((Object)data);
        Control appser = this.createAppSerZone((Composite)container);
        data = new GridData(768);
        appser.setLayoutData((Object)data);
        Control option = this.createOptionZone((Composite)container);
        data = new GridData(768);
        option.setLayoutData((Object)data);
        Control outputType = this.createCfgOutputType((Composite)container);
        data = new GridData(768);
        outputType.setLayoutData((Object)data);
        Control webType = this.createWebDeployType((Composite)container);
        data = new GridData(768);
        webType.setLayoutData((Object)data);
        return container;
    }

    private Control createPathZone(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        this.javaPathEditor = new DirectoryFieldEditor(NAME, Messages.DeployOptionsInfoDialogPage_JAVAFaBuMuLu, container);
        this.j2eePathEditor = new DirectoryFieldEditor(ALIAS, Messages.DeployOptionsInfoDialogPage_J2EEFaBuMuLu, container);
        this.metadataPathEditor = new DirectoryFieldEditor(ALIAS, Messages.DeployOptionsInfoDialogPage_YuanShuJuFaBuMuLu, container);
        this.wuSrcPathEditor = new DirectoryFieldEditor("wuSrcPath", "WEB UI SRC\u76ee\u5f55\uff1a", container);
        this.wuRootEditor = new DirectoryFieldEditor("wuRootPath", "WEB\u6839\u76ee\u5f55\uff1a", container);
        this.pathZoneParent = container;
        this.javaPathEditor.setEmptyStringAllowed(false);
        this.j2eePathEditor.setEmptyStringAllowed(false);
        this.metadataPathEditor.setEmptyStringAllowed(false);
        this.wuSrcPathEditor.setEmptyStringAllowed(false);
        this.wuRootEditor.setEmptyStringAllowed(false);
        this.j2eePathEditor.setChangeButtonText(Messages.DeployOptionsInfoDialogPage_LanJ);
        this.metadataPathEditor.setChangeButtonText(Messages.DeployOptionsInfoDialogPage_LanM);
        this.wuSrcPathEditor.setChangeButtonText("\u6d4f\u89c8(&C)...");
        this.wuRootEditor.setChangeButtonText("\u6d4f\u89c8(&R)...");
        this.javaPathEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("field_editor_is_valid".equals(event.getProperty())) {
                    if (Boolean.FALSE.equals(event.getNewValue())) {
                        DeployOptionsInfoDialogPage.this.setErrorMessage(Messages.DeployOptionsInfoDialogPage_QingShuRuXuanZeYouXiaoDeJAVAFaBuMuLu);
                        DeployOptionsInfoDialogPage.this.setValid(false);
                    } else {
                        DeployOptionsInfoDialogPage.this.setErrorMessage(null);
                        DeployOptionsInfoDialogPage.this.setValid(true);
                    }
                } else if ("field_editor_value".equals(event.getProperty())) {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setJavaOutputDir(DeployOptionsInfoDialogPage.this.javaPathEditor.getStringValue());
                }
                String inputtext = DeployOptionsInfoDialogPage.this.javaPathEditor.getStringValue();
                DeployOptionsInfoDialogPage.this.checkComplete(inputtext, JAVA_PATH);
            }
        });
        this.j2eePathEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("field_editor_is_valid".equals(event.getProperty())) {
                    if (Boolean.FALSE.equals(event.getNewValue())) {
                        DeployOptionsInfoDialogPage.this.setErrorMessage(Messages.DeployOptionsInfoDialogPage_QingShuRuXuanZeYouXiaoDeJ2EEFaBuMuLu);
                    } else {
                        DeployOptionsInfoDialogPage.this.setErrorMessage(null);
                    }
                } else if ("field_editor_value".equals(event.getProperty())) {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setJ2eeOutputDir(DeployOptionsInfoDialogPage.this.j2eePathEditor.getStringValue());
                }
                String inputtext = DeployOptionsInfoDialogPage.this.j2eePathEditor.getStringValue();
                DeployOptionsInfoDialogPage.this.checkComplete(inputtext, J2EE_PATH);
            }
        });
        this.metadataPathEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("field_editor_is_valid".equals(event.getProperty())) {
                    if (Boolean.FALSE.equals(event.getNewValue())) {
                        DeployOptionsInfoDialogPage.this.setErrorMessage(Messages.DeployOptionsInfoDialogPage_QingShuRuXuanZeYouXiaoDeYuanShuJuFaBuMuLu);
                    } else {
                        DeployOptionsInfoDialogPage.this.setErrorMessage(null);
                    }
                } else if ("field_editor_value".equals(event.getProperty())) {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setMetaDataRepository(DeployOptionsInfoDialogPage.this.metadataPathEditor.getStringValue());
                }
                String inputtext = DeployOptionsInfoDialogPage.this.metadataPathEditor.getStringValue();
                DeployOptionsInfoDialogPage.this.checkComplete(inputtext, MD_PATH);
            }
        });
        this.wuSrcPathEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("field_editor_is_valid".equals(event.getProperty())) {
                    if (Boolean.FALSE.equals(event.getNewValue())) {
                        DeployOptionsInfoDialogPage.this.setErrorMessage("\u8bf7\u9009\u62e9\u6709\u6548\u7684\u76ee\u5f55");
                        DeployOptionsInfoDialogPage.this.setValid(false);
                    } else {
                        DeployOptionsInfoDialogPage.this.setErrorMessage(null);
                        DeployOptionsInfoDialogPage.this.setValid(true);
                    }
                } else if ("field_editor_value".equals(event.getProperty())) {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setWebUiSrcPath(DeployOptionsInfoDialogPage.this.wuSrcPathEditor.getStringValue());
                }
                String inputtext = DeployOptionsInfoDialogPage.this.wuSrcPathEditor.getStringValue();
                DeployOptionsInfoDialogPage.this.checkComplete(inputtext, "wusrc");
            }
        });
        this.wuRootEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("field_editor_is_valid".equals(event.getProperty())) {
                    if (Boolean.FALSE.equals(event.getNewValue())) {
                        DeployOptionsInfoDialogPage.this.setErrorMessage("\u8bf7\u9009\u62e9\u6709\u6548\u7684\u76ee\u5f55");
                        DeployOptionsInfoDialogPage.this.setValid(false);
                    } else {
                        DeployOptionsInfoDialogPage.this.setErrorMessage(null);
                        DeployOptionsInfoDialogPage.this.setValid(true);
                    }
                } else if ("field_editor_value".equals(event.getProperty())) {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setWebUiRootPath(DeployOptionsInfoDialogPage.this.wuRootEditor.getStringValue());
                }
                String inputtext = DeployOptionsInfoDialogPage.this.wuRootEditor.getStringValue();
                DeployOptionsInfoDialogPage.this.checkComplete(inputtext, "wuroot");
            }
        });
        return container;
    }

    private void checkComplete(String path, String target) {
        File checkfile;
        if (target == null || path == null) {
            this.setValid(true);
        }
        if (!(checkfile = new File(path)).exists() && path.length() > 0) {
            if (target.equals(JAVA_PATH)) {
                this.cancompleteMap.put(JAVA_PATH, Messages.DeployOptionsInfoDialogPage_QingShuRuXuanZeYouXiaoDeJAVAFaBuMuLu);
            } else if (target.equals(J2EE_PATH)) {
                this.cancompleteMap.put(J2EE_PATH, Messages.DeployOptionsInfoDialogPage_QingShuRuXuanZeYouXiaoDeJ2EEFaBuMuLu);
            } else if (target.equals(MD_PATH)) {
                this.cancompleteMap.put(MD_PATH, Messages.DeployOptionsInfoDialogPage_QingShuRuXuanZeYouXiaoDeYuanShuJuFaBuMuLu);
            } else if (target.equals("wusrc")) {
                this.cancompleteMap.put("wusrc", "\u8bf7\u8f93\u5165\u6709\u6548\u7684WEB UI SRC\u76ee\u5f55");
            } else if (target.equals("wudeploy")) {
                this.cancompleteMap.put("wudeploy", "\u8bf7\u8f93\u5165\u6709\u6548\u7684WEB UI\u53d1\u5e03\u76ee\u5f55");
            } else if (target.equals("wuroot")) {
                this.cancompleteMap.put("wuroot", "\u8bf7\u8f93\u5165\u6709\u6548\u7684WEB\u6839\u76ee\u5f55");
            }
        } else {
            this.cancompleteMap.remove(target);
        }
        int size = this.cancompleteMap.size();
        if (size > 0) {
            StringBuffer sb = new StringBuffer();
            for (Object value : this.cancompleteMap.values()) {
                if (value == null) continue;
                if (sb.length() > 0) {
                    sb.append("\uff0c");
                }
                sb.append(value);
            }
            this.setErrorMessage(sb.toString());
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    private Control createAppSerZone(Composite parent) {
        Group container = new Group(parent, 0);
        container.setText(Messages.DeployOptionsInfoDialogPage_FaBuYingYongFuWuQi);
        container.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        this.apusicEditor = new Button((Composite)container, 32);
        this.apusicEditor.setText("Apusic");
        this.weblogicEditor = new Button((Composite)container, 32);
        this.weblogicEditor.setText("Weblogic");
        this.websphereEditor = new Button((Composite)container, 32);
        this.websphereEditor.setText("Websphere");
        AppSerListener listener = new AppSerListener();
        this.apusicEditor.addSelectionListener((SelectionListener)listener);
        this.weblogicEditor.addSelectionListener((SelectionListener)listener);
        this.websphereEditor.addSelectionListener((SelectionListener)listener);
        return container;
    }

    private Control createOptionZone(Composite parent) {
        Group container = new Group(parent, 0);
        container.setFont(parent.getFont());
        container.setText(Messages.DeployOptionsInfoDialogPage_FaBuXuanXiang);
        GridLayout layout = new GridLayout(4, false);
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        this.genCodeEditor = new Button((Composite)container, 32);
        this.genCodeEditor.setText(Messages.DeployOptionsInfoDialogPage_ShengChengDaiMa);
        this.genMetadataEditor = new Button((Composite)container, 32);
        this.genMetadataEditor.setText(Messages.DeployOptionsInfoDialogPage_FaBuYuanShuJu);
        this.genConfigEditor = new Button((Composite)container, 32);
        this.genConfigEditor.setText(Messages.DeployOptionsInfoDialogPage_ShengChengPeiZhiXinXi);
        this.genCodeEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeployOptionsInfoDialogPage.this.genCodeEditor.getSelection()) {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setDeployLevel(DeployOptionsInfoDialogPage.this.currentDeployInfo.getDeployLevel() | 1);
                } else {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setDeployLevel(DeployOptionsInfoDialogPage.this.currentDeployInfo.getDeployLevel() & 0xFFFFFFFE);
                }
            }
        });
        this.genMetadataEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeployOptionsInfoDialogPage.this.genMetadataEditor.getSelection()) {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setDeployLevel(DeployOptionsInfoDialogPage.this.currentDeployInfo.getDeployLevel() | 2);
                } else {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setDeployLevel(DeployOptionsInfoDialogPage.this.currentDeployInfo.getDeployLevel() & 0xFFFFFFFD);
                }
            }
        });
        this.genConfigEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeployOptionsInfoDialogPage.this.genConfigEditor.getSelection()) {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setDeployLevel(DeployOptionsInfoDialogPage.this.currentDeployInfo.getDeployLevel() | 4);
                    DeployOptionsInfoDialogPage.this.appendCfg.setEnabled(true);
                    DeployOptionsInfoDialogPage.this.overwriteCfg.setEnabled(true);
                } else {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setDeployLevel(DeployOptionsInfoDialogPage.this.currentDeployInfo.getDeployLevel() & 0xFFFFFFFB);
                    DeployOptionsInfoDialogPage.this.appendCfg.setEnabled(false);
                    DeployOptionsInfoDialogPage.this.overwriteCfg.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return container;
    }

    private Control createCfgOutputType(Composite parent) {
        Group container = new Group(parent, 0);
        container.setText(Messages.DeployOptionsInfoDialogPage_PeiZhiWenJianShuChuFangShi);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        GridData data = new GridData(768);
        container.setLayoutData((Object)data);
        this.appendCfg = new Button((Composite)container, 16);
        this.appendCfg.setText(Messages.DeployOptionsInfoDialogPage_ZhuiJia);
        this.overwriteCfg = new Button((Composite)container, 16);
        this.overwriteCfg.setText(Messages.DeployOptionsInfoDialogPage_FuGai);
        this.appendCfg.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeployOptionsInfoDialogPage.this.currentDeployInfo.setOverrideDeployFile(false);
            }
        });
        this.overwriteCfg.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeployOptionsInfoDialogPage.this.currentDeployInfo.setOverrideDeployFile(true);
            }
        });
        return container;
    }

    private Control createWebDeployType(Composite parent) {
        Group container = new Group(parent, 0);
        container.setText("web\u4ee3\u7801\u53d1\u5e03\u65b9\u5f0f");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        GridData data = new GridData(768);
        container.setLayoutData((Object)data);
        this.xhtmlDeploy = new Button((Composite)container, 16);
        this.xhtmlDeploy.setText("xhtml\u6a21\u5f0f");
        this.mbeanDeploy = new Button((Composite)container, 16);
        this.mbeanDeploy.setText("mbean\u6a21\u5f0f");
        this.xhtmlDeploy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeployOptionsInfoDialogPage.this.currentDeployInfo.setMBeanDeploy(false);
            }
        });
        this.mbeanDeploy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeployOptionsInfoDialogPage.this.currentDeployInfo.setMBeanDeploy(true);
            }
        });
        return container;
    }

    private void initDeployInfos() {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.runInUI((IRunnableContext)progressService, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.setCanceled(false);
                    monitor.beginTask(Messages.DeployOptionsInfoDialogPage_ZhuangZaiJieJueFangAnDeFaBuFangAnXinXi, 100);
                    monitor.setTaskName(Messages.DeployOptionsInfoDialogPage_ZhengZaiZhuangZaiJieJueFangAnDeFaBuFangAnXinXiQingShaoDeng);
                    monitor.subTask(Messages.DeployOptionsInfoDialogPage_ZhengZaiDuQuGongChengXiangMu);
                    IAdaptable adapter = DeployOptionsInfoDialogPage.this.getElement();
                    monitor.worked(10);
                    if (adapter != null) {
                        DeployOptionsInfoDialogPage.this.project = (IProject)adapter.getAdapter(IResource.class);
                        if (DeployOptionsInfoDialogPage.this.project != null) {
                            try {
                                monitor.subTask(Messages.DeployOptionsInfoDialogPage_ZhengZaiDuQuFaBuFangAnXinXi);
                                Collection tempInfos = StudioConfigurationOptions.loadDeployOptions(DeployOptionsInfoDialogPage.this.project);
                                monitor.worked(50);
                                if (tempInfos != null) {
                                    Iterator iter = tempInfos.iterator();
                                    int i = 1;
                                    int j = tempInfos.size();
                                    while (iter.hasNext()) {
                                        monitor.worked(40 + 50 / j * i);
                                        DeployOptionInfo tempInfo = (DeployOptionInfo)iter.next();
                                        DeployOptionsInfoDialogPage.this.deploies.add(tempInfo);
                                        DeployOptionsInfoDialogPage.this.oldInfoCopies.put(tempInfo.getName(), tempInfo.clone());
                                        DeployOptionsInfoDialogPage.this.nameManager.put(tempInfo.getName());
                                        if (!tempInfo.isDefault()) continue;
                                        DeployOptionsInfoDialogPage.this.defaultDeployInfo = tempInfo;
                                    }
                                    monitor.subTask(Messages.DeployOptionsInfoDialogPage_ZhengZaiGouJianFaBuXinXiBianJiJieMian);
                                }
                            }
                            catch (Exception e) {
                                DeployOptionsInfoDialogPage.this.setErrorMessage(Messages.DeployOptionsInfoDialogPage_ZaiZhuangJieJueFangAnDeFaBuXinXiChuCuoQingYuGuanLiYuanLianXi);
                                logger.error((Object)"error", (Throwable)e);
                            }
                        }
                    }
                }
            }, null);
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(Messages.DeployOptionsInfoDialogPage_ZaiZhuangJieJueFangAnDeFaBuXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.setErrorMessage(Messages.DeployOptionsInfoDialogPage_ZaiZhuangJieJueFangAnDeFaBuXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
        }
    }

    private boolean isDefaultDeploy(DeployOptionInfo info) {
        if (this.defaultDeployInfo != null && this.defaultDeployInfo.equals((Object)info)) {
            return true;
        }
        return info != null && info.isDefault();
    }

    private int getNextItem(int[] removeIndecies) {
        return IndexLocateUtil.getNextSelectionIndex((int)this.deploies.size(), (int[])removeIndecies);
    }

    private void selectionChangeDeployInfo(DeployOptionInfo info) {
        this.innerSetControlState(true);
        this.currentDeployInfo = info;
        this.javaPathEditor.setStringValue(info.getJavaOutputDir());
        this.j2eePathEditor.setStringValue(info.getJ2eeOutputDir());
        this.metadataPathEditor.setStringValue(info.getMetaDataRepository());
        this.wuRootEditor.setStringValue(info.getWebUiRootPath());
        this.wuSrcPathEditor.setStringValue(info.getWebUiSrcPath());
        this.apusicEditor.setSelection((info.getTargetAppServer() & 1) > 0);
        this.weblogicEditor.setSelection((info.getTargetAppServer() & 4) > 0);
        this.websphereEditor.setSelection((info.getTargetAppServer() & 2) > 0);
        this.genCodeEditor.setSelection(info.isDeployCode());
        this.genMetadataEditor.setSelection(info.isDeployMetadata());
        this.genConfigEditor.setSelection(info.isDeployConfigFile());
        this.overwriteCfg.setEnabled(info.isDeployConfigFile());
        this.appendCfg.setEnabled(info.isDeployConfigFile());
        if (info.isDeployConfigFile()) {
            this.overwriteCfg.setSelection(info.isOverrideDeployFile());
            this.appendCfg.setSelection(!info.isOverrideDeployFile());
        }
        this.xhtmlDeploy.setSelection(!info.isMBeanDeploy());
        this.mbeanDeploy.setSelection(info.isMBeanDeploy());
    }

    private String getDefaultSrc() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            IProject pro = projects[i];
            boolean isJavaPro = false;
            try {
                if (pro.isOpen()) {
                    isJavaPro = pro.hasNature("org.eclipse.jdt.core.javanature");
                }
            }
            catch (CoreException e) {
                logger.debug((Object)"error", (Throwable)e);
            }
            if (!isJavaPro) continue;
            try {
                IClasspathEntry[] classpaths = JavaCore.create((IProject)pro).getRawClasspath();
                for (int j = 0; j < classpaths.length; ++j) {
                    if (classpaths[j] == null || classpaths[j].getEntryKind() != 3) continue;
                    IPath path = classpaths[j].getPath();
                    IResource srcFolder = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                    if (srcFolder == null) continue;
                    return srcFolder.getLocation().toOSString();
                }
                continue;
            }
            catch (JavaModelException e) {
                logger.debug((Object)"error", (Throwable)e);
            }
        }
        return "";
    }

    class AppSerListener
    implements SelectionListener {
        AppSerListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (DeployOptionsInfoDialogPage.this.apusicEditor == e.getSource()) {
                this.setModel(1, DeployOptionsInfoDialogPage.this.apusicEditor.getSelection());
            } else if (DeployOptionsInfoDialogPage.this.weblogicEditor == e.getSource()) {
                this.setModel(4, DeployOptionsInfoDialogPage.this.weblogicEditor.getSelection());
            } else if (DeployOptionsInfoDialogPage.this.websphereEditor == e.getSource()) {
                this.setModel(2, DeployOptionsInfoDialogPage.this.websphereEditor.getSelection());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        private void setModel(int appSerType, boolean isSelected) {
            if (1 == appSerType) {
                if (isSelected) {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setTargetAppServer(DeployOptionsInfoDialogPage.this.currentDeployInfo.getTargetAppServer() | 1);
                } else {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setTargetAppServer(DeployOptionsInfoDialogPage.this.currentDeployInfo.getTargetAppServer() & 0xFFFFFFFE);
                }
            } else if (4 == appSerType) {
                if (isSelected) {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setTargetAppServer(DeployOptionsInfoDialogPage.this.currentDeployInfo.getTargetAppServer() | 4);
                } else {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setTargetAppServer(DeployOptionsInfoDialogPage.this.currentDeployInfo.getTargetAppServer() & 0xFFFFFFFB);
                }
            } else if (2 == appSerType) {
                if (isSelected) {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setTargetAppServer(DeployOptionsInfoDialogPage.this.currentDeployInfo.getTargetAppServer() | 2);
                } else {
                    DeployOptionsInfoDialogPage.this.currentDeployInfo.setTargetAppServer(DeployOptionsInfoDialogPage.this.currentDeployInfo.getTargetAppServer() & 0xFFFFFFFD);
                }
            }
        }
    }

    class DeployModifer
    implements ICellModifier {
        DeployModifer() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            String retString = null;
            if (element instanceof DeployOptionInfo) {
                DeployOptionInfo info = (DeployOptionInfo)element;
                if (DeployOptionsInfoDialogPage.NAME.equals(property)) {
                    retString = info.getName();
                    return retString == null ? "" : retString;
                }
                if (DeployOptionsInfoDialogPage.ALIAS.equals(property)) {
                    retString = info.getAlias();
                    return retString == null ? "" : retString;
                }
                if (DeployOptionsInfoDialogPage.ISDEFAULT.equals(property)) {
                    return DeployOptionsInfoDialogPage.this.isDefaultDeploy(info);
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (((TableItem)element).getData() instanceof DeployOptionInfo) {
                DeployOptionInfo info = (DeployOptionInfo)((TableItem)element).getData();
                if (DeployOptionsInfoDialogPage.NAME.equals(property)) {
                    if (StringUtils.isEmpty((String)((String)value))) {
                        DeployOptionsInfoDialogPage.this.setMessage(Messages.DeployOptionsInfoDialogPage_XiuGaiMingChengShiBaiFaBuFangAnDeMingChengBuNengWeiKong, 1);
                        return;
                    }
                    if (!info.getName().equals(value) && DeployOptionsInfoDialogPage.this.nameManager.isUsed((String)value)) {
                        DeployOptionsInfoDialogPage.this.setMessage(Messages.DeployOptionsInfoDialogPage_XiuGaiMingChengShiBai + value + Messages.DeployOptionsInfoDialogPage_GaiMingChengYiBeiShiYong, 1);
                        return;
                    }
                    DeployOptionsInfoDialogPage.this.setMessage(null, 1);
                    DeployOptionsInfoDialogPage.this.nameManager.rename(info.getName(), (String)value);
                    info.setName((String)value);
                } else if (DeployOptionsInfoDialogPage.ALIAS.equals(property)) {
                    info.setAlias((String)value);
                } else if (DeployOptionsInfoDialogPage.ISDEFAULT.equals(property)) {
                    boolean isDefault = false;
                    isDefault = value instanceof Boolean ? ((Boolean)value).booleanValue() : Boolean.valueOf(value == null ? "false" : value.toString()).booleanValue();
                    info.setDefault(isDefault);
                    if (info.equals((Object)DeployOptionsInfoDialogPage.this.defaultDeployInfo) && !isDefault) {
                        info.setDefault(true);
                    }
                    if (isDefault) {
                        DeployOptionsInfoDialogPage.this.defaultDeployInfo = info;
                        int size = DeployOptionsInfoDialogPage.this.deploies.size();
                        for (int i = 0; i < size; ++i) {
                            DeployOptionInfo temp = DeployOptionsInfoDialogPage.this.deploies.get(i);
                            if (info.equals((Object)temp)) continue;
                            temp.setDefault(false);
                        }
                    }
                }
                int selIndex = DeployOptionsInfoDialogPage.this.tableView.getTable().getSelectionIndex();
                DeployOptionsInfoDialogPage.this.tableView.getTable().setRedraw(false);
                DeployOptionsInfoDialogPage.this.tableView.refresh();
                DeployOptionsInfoDialogPage.this.tableView.getTable().setSelection(selIndex);
                DeployOptionsInfoDialogPage.this.tableView.getTable().setRedraw(true);
            }
        }
    }

    class DeployLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        DeployLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String retText = "";
            if (element instanceof DeployOptionInfo) {
                switch (columnIndex) {
                    case 0: {
                        retText = ((DeployOptionInfo)element).getName();
                        break;
                    }
                    case 1: {
                        retText = ((DeployOptionInfo)element).getAlias();
                        break;
                    }
                    case 2: {
                        retText = this.getDefaultDeployLabel((DeployOptionInfo)element);
                    }
                }
            }
            return retText == null ? "" : retText;
        }

        private String getDefaultDeployLabel(DeployOptionInfo info) {
            if (DeployOptionsInfoDialogPage.this.isDefaultDeploy(info)) {
                return Messages.DeployOptionsInfoDialogPage_GOU;
            }
            return "";
        }
    }

    class DeployContentProvider
    implements IStructuredContentProvider {
        DeployContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof DeployOptionInfo[]) {
                return (DeployOptionInfo[])inputElement;
            }
            if (inputElement instanceof DeployOptionsCollection) {
                int size = ((DeployOptionsCollection)inputElement).size();
                Object[] infos = new DeployOptionInfo[size];
                for (int i = 0; i < size; ++i) {
                    infos[i] = ((DeployOptionsCollection)inputElement).get(i);
                }
                return infos;
            }
            return new DeployOptionInfo[0];
        }
    }
}

