/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.utils;

import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.application.AppViewInfo;
import com.kingdee.bos.metadata.management.application.ApplicationCollection;
import com.kingdee.bos.metadata.management.application.ApplicationInfo;
import com.kingdee.bos.tool.context.IToolContext;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.ORMUtil;
import com.kingdee.bos.tool.utils.Messages;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class CheckUtils {
    public static boolean existProject(String name) {
        if (name == null) {
            throw new IllegalArgumentException(Messages.CheckUtils_GongChengMingChengBuNengWeiNULL);
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!name.equalsIgnoreCase(projects[i].getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean checkWorkspaceInUse(String path) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!path.equalsIgnoreCase(projects[i].getLocation().toOSString()) && path.indexOf(projects[i].getLocation().toOSString() + "/") == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidSolutionName(String name) {
        return CheckUtils.isValidFileName(name);
    }

    public static boolean isValidFileName(String name) {
        return !StringUtils.isEmpty((String)name) && name.indexOf(60) == -1 && name.indexOf(42) == -1 && name.indexOf(47) == -1 && name.indexOf(58) == -1 && name.indexOf(63) == -1 && name.indexOf(34) == -1 && name.indexOf(92) == -1 && !name.startsWith(".") && !name.endsWith(".");
    }

    public static boolean isValidBasicCode(String code) {
        if (StringUtils.isEmpty((String)code) || code.length() > 3) {
            return false;
        }
        char[] chars = code.trim().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetter(chars[i]) && Character.isUpperCase(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidDiagramName(String name) {
        return CheckUtils.isValidFileName(name);
    }

    public static boolean isValidPackageName(String name) {
        return StringUtils.isJavaClassName((String)name);
    }

    public static boolean isValidBOSType(String s) {
        return StringUtils.isJavaIdentifier((String)s) && s.length() == 4;
    }

    public static boolean isCommonMetaDataName(BOSObjectType type, String s) {
        if (type.equals((Object)MetaDataTypeList.DATATABLE) || type.equals((Object)MetaDataTypeList.ABSTRACTTABLE) || type.equals((Object)MetaDataTypeList.CROSSTABLE) || type.equals((Object)MetaDataTypeList.EXTENDEDTABLE)) {
            return CheckUtils.isValidTableName(s);
        }
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidMetaDataName(String s) {
        return StringUtils.isJavaIdentifier((String)s);
    }

    public static boolean isValidEventName(String s) {
        return StringUtils.isJavaIdentifier((String)s);
    }

    public static boolean isValidBizDataType(String s) {
        return StringUtils.isJavaIdentifier((String)s);
    }

    public static boolean isValidTableName(String s) {
        return CheckUtils.isValidMetaDataName(s) && s.length() <= 30;
    }

    public static boolean isValidDeployOptionName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidLanguageName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidImageResourceName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidApplicationName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidSubSystemName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidEntityName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidEnumName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidResourceName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidPermissionName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidExceptionName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidFacadeName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidFunctionName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidUiObjectName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidMDqueryName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidRelationshipName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidQueryName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidRuleName(String s) {
        return CheckUtils.isValidMetaDataName(s);
    }

    public static boolean isValidBizImplName(String s) {
        return CheckUtils.isValidPackageName(s);
    }

    public static boolean isValidControllerName(String s) {
        return CheckUtils.isValidPackageName(s);
    }

    public static boolean isValidEAIMetaDataName(String name, BOSObjectType bosType) {
        return CheckUtils.isValidMetaDataName(name);
    }

    public static boolean isValidMetaDataName(String name, BOSObjectType bosType) {
        assert (bosType != null);
        if (bosType.equals((Object)MetaDataTypeList.DATATABLE) || bosType.equals((Object)MetaDataTypeList.ABSTRACTTABLE) || bosType.equals((Object)MetaDataTypeList.CROSSTABLE) || bosType.equals((Object)MetaDataTypeList.EXTENDEDTABLE)) {
            return CheckUtils.isValidTableName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.ENTITY)) {
            return CheckUtils.isValidEntityName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.RELATIONSHIP)) {
            return CheckUtils.isValidRelationshipName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZENUM)) {
            return CheckUtils.isValidEnumName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZEXCEPTION)) {
            return CheckUtils.isValidExceptionName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.MULTILANGUAGE)) {
            return CheckUtils.isValidLanguageName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.IMAGE_RESOURCE_TYPE)) {
            return CheckUtils.isValidImageResourceName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.JOINQUERY) || bosType.equals((Object)MetaDataTypeList.BASEQUERY) || bosType.equals((Object)MetaDataTypeList.UNIONQUERY)) {
            return CheckUtils.isValidQueryName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.FACADE)) {
            return CheckUtils.isValidFacadeName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.UIOBJECT)) {
            return CheckUtils.isValidUiObjectName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.FUNCTION)) {
            return CheckUtils.isValidFunctionName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.RULE)) {
            return CheckUtils.isValidRuleName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.MDQUERY)) {
            return CheckUtils.isValidMDqueryName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZDATATYPE)) {
            return CheckUtils.isValidBizDataType(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.EVENT_FOR_WF)) {
            return CheckUtils.isValidEventName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.APPVIEW)) {
            return CheckUtils.isValidApplicationName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZUNIT)) {
            return CheckUtils.isValidMetaDataName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.REPORT)) {
            return CheckUtils.isValidMetaDataName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.PERMISSION)) {
            return CheckUtils.isValidMetaDataName(name);
        }
        if (bosType.equals((Object)MetaDataTypeList.LOG)) {
            return CheckUtils.isValidMetaDataName(name);
        }
        return false;
    }

    public static boolean exist(IMDProject project, String pk, String name, BOSObjectType type) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null!");
        }
        return MDResourceUtil.getFile(project, pk + "." + name, type).exists();
    }

    public static boolean exist(IFolder folder, String pk, String name, BOSObjectType type) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null!");
        }
        IMetaDataPK mpk = MetaDataPKFactory.getMetaDataPK((String)(pk + "." + name));
        IFile file = ORMUtil.getFile(folder, type, mpk);
        return file.exists() || file.getLocation().toFile().exists();
    }

    public static boolean exist(IProject project, String pk, String name, BOSObjectType type) {
        IMetaDataPK mpk;
        if (name == null) {
            throw new IllegalArgumentException("name can't be null!");
        }
        IToolContext ctx = ToolContextManager.getContext(project);
        IFolder folder = project.getFolder(ctx.getSrcName());
        IFile file = ORMUtil.getFile(folder, type, mpk = MetaDataPKFactory.getMetaDataPK((String)(pk + "." + name)));
        return file.exists() || file.getLocation().toFile().exists();
    }

    public static boolean existApplication(AppViewInfo info, String name) {
        ApplicationCollection c = info.getApplications();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (!name.equals(((ApplicationInfo)i.next()).getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean existSubSystem(AppViewInfo info, String appName, String name) {
        ApplicationInfo aInfo = info.getApplicationFromName(appName);
        return aInfo == null ? false : aInfo.getSubSystemFromName(name) != null;
    }

    public static boolean isValidFilePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if ("".equals(path)) {
            return false;
        }
        int colonCount = 0;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '*' || c == '|' || c == '<' || c == '>' || c == '?' || c == '\"') {
                return false;
            }
            if (c != ':') continue;
            ++colonCount;
        }
        if (colonCount > 1) {
            return false;
        }
        return path.indexOf("//") == -1;
    }
}

