/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.utils;

import com.kingdee.bos.dao.xml.CheckReportItem;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.tool.console.IUserStream;
import com.kingdee.bos.tool.console.UserStreamManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.eclipse.swt.graphics.Color;

public class DeployCheckReport
implements ICheckReport {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.studio.wizard.deploy.DeployCheckReport");
    private Collection items = new LinkedList();
    private IUserStream stream;
    private FileOutputStream out;

    public DeployCheckReport(IUserStream stream, FileOutputStream out) {
        this.stream = stream;
        this.out = out;
    }

    public Collection getItems() {
        return this.items;
    }

    public void addItem(CheckReportItem item) {
        this.items.add(item);
        if (this.stream != null) {
            this.printToConsole(item);
        }
        if (this.out != null) {
            this.printToFile(item);
        }
    }

    private void printToConsole(CheckReportItem item) {
        Color c = UserStreamManager.ERROR_COLOR;
        if (item.getState() == 0) {
            c = UserStreamManager.NORMAL_COLOR;
        }
        this.stream.println(item.getKey() + ":" + item.getStateDescription(), c);
        if (item.getMessages() != null) {
            for (int i = 0; i < item.getMessages().length; ++i) {
                this.stream.println("    " + item.getMessages()[i], c);
            }
        }
    }

    private void printToFile(CheckReportItem item) {
        try {
            this.out.write((item.getKey() + ":" + item.getState()).getBytes());
            if (item.getMessages() != null) {
                for (int i = 0; i < item.getMessages().length; ++i) {
                    this.out.write(("    " + item.getMessages()[i]).getBytes());
                    this.out.write("\n".getBytes());
                }
            }
        }
        catch (IOException e) {
            logger.debug((Object)e);
        }
    }
}

