/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.utils;

import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.md.multipageeditor.IMDFileEditorInput;
import com.kingdee.bos.md.multipageeditor.IMDSourceEditor;
import com.kingdee.bos.md.multipageeditor.MDFileEditorInput;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.solution.SolutionHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class EditorHelper {
    private static final String[] MDFILE_EXTENSIONS = new String[]{"bizunit", "biztemplate", "entity", "table", "facade", "function", "exception", "enum", "relation", "rule", "query", "permission", "log", "mutex", "resource", "imageresource", "bizdatatype", "mdquery", "ui", "webui"};

    public static boolean hasFileOpen(IMDProject project, boolean onlyDirty) {
        IEditorReference[] editors = null;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        }
        if (editors == null || editors.length == 0) {
            return false;
        }
        for (int i = 0; i < editors.length; ++i) {
            if (onlyDirty && !editors[i].isDirty()) continue;
            IEditorInput input = editors[i].getEditor(true).getEditorInput();
            IMDFile file = null;
            if (input instanceof IFileEditorInput) {
                file = MDResourceUtil.toMDFile(((IFileEditorInput)input).getFile());
            } else if (input instanceof IMDFileEditorInput) {
                file = ((IMDFileEditorInput)input).getFile();
            }
            if (file == null || !file.getMDProject().equals(project)) continue;
            return true;
        }
        return false;
    }

    public static IMDFile[] findOpenFiles(IMDProject project, boolean onlyDirty) {
        IEditorPart[] parts = EditorHelper.findOpenEditors(project, onlyDirty);
        IMDFile[] files = new IMDFile[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            IEditorInput input = parts[i].getEditorInput();
            if (input instanceof IFileEditorInput) {
                files[i] = MDResourceUtil.toMDFile(((IFileEditorInput)input).getFile());
                continue;
            }
            if (!(input instanceof IMDFileEditorInput)) continue;
            files[i] = ((IMDFileEditorInput)input).getFile();
        }
        return files;
    }

    public static IMDFileEditorInput transEditor(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            IMDFile file = EditorHelper.getMDFile(((IFileEditorInput)input).getFile());
            return file == null ? null : new MDFileEditorInput(file);
        }
        if (input instanceof IMDFileEditorInput) {
            return (IMDFileEditorInput)input;
        }
        return null;
    }

    public static IProject getProject(IFile ifile) {
        String name;
        IProject project = null;
        if (!SolutionHelper.validSolutionProject(ifile.getProject()) && ifile.getProject().getParent() != null && ifile.getProject().getLocationURI() != null && (name = new File(ifile.getProject().getLocationURI()).getParentFile().getName()).length() > 0 && SolutionHelper.validSolutionProject(project = ResourcesPlugin.getWorkspace().getRoot().getProject(name)) && !project.getFolder("metadata").isLinked()) {
            return project;
        }
        project = EditorHelper.getLinkProject(ifile);
        if (project != null) {
            return project;
        }
        return ifile.getProject();
    }

    public static IProject getLinkProject(IFile ifile) {
        IProject[] prjs;
        for (IProject prj : prjs = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            if (!SolutionHelper.validSolutionProject(prj) || !prj.getFolder("metadata").isLinked() || !ifile.getLocation().toPortableString().toLowerCase(Locale.ENGLISH).startsWith(prj.getFolder("metadata").getLocation().toPortableString().toLowerCase(Locale.ENGLISH))) continue;
            return prj;
        }
        return null;
    }

    public static IMDFile getMDFile(IFile ifile) {
        IMDProject mdprj = MDResourceUtil.toMDProject(EditorHelper.getProject(ifile));
        return mdprj == null ? null : mdprj.getRoot().getChildFile(ifile.getLocation().toOSString());
    }

    public static void closeEditor(IWorkbenchPage page, IMDFile[] files, boolean save) {
        IEditorPart[] parts = EditorHelper.findEditors(page, files);
        if (parts.length == 0) {
            return;
        }
        if (page == null) {
            page = ToolCommonPlugin.getActivePage();
        }
        for (int i = 0; i < parts.length; ++i) {
            page.closeEditor(parts[i], save);
        }
    }

    public static IEditorPart[] findOpenEditors(IMDProject project, boolean onlyDirty) {
        IEditorReference[] editors = null;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        }
        if (editors == null || editors.length == 0) {
            return new IEditorPart[0];
        }
        ArrayList<IEditorPart> list = new ArrayList<IEditorPart>();
        for (int i = 0; i < editors.length; ++i) {
            if (onlyDirty && !editors[i].isDirty()) continue;
            if (project == null) {
                list.add(editors[i].getEditor(true));
                continue;
            }
            IEditorInput input = editors[i].getEditor(true).getEditorInput();
            IMDFile file = null;
            if (input instanceof IFileEditorInput) {
                file = MDResourceUtil.toMDFile(((IFileEditorInput)input).getFile());
            } else if (input instanceof IMDFileEditorInput) {
                file = ((IMDFileEditorInput)input).getFile();
            }
            if (file == null || !file.getMDProject().equals(project)) continue;
            list.add(editors[i].getEditor(true));
        }
        return list.toArray(new IEditorPart[list.size()]);
    }

    public static IEditorPart findEditor(IMDFile file) {
        IEditorPart[] ps = EditorHelper.findEditors(null, new IMDFile[]{file});
        if (ps.length == 0) {
            return null;
        }
        return ps[0];
    }

    public static IEditorPart[] findEditors(IWorkbenchPage page, IMDFile[] files) {
        if (page == null) {
            page = ToolCommonPlugin.getActivePage();
        }
        IEditorReference[] editors = page.getEditorReferences();
        ArrayList<IEditorPart> list = new ArrayList<IEditorPart>();
        for (int i = 0; i < files.length; ++i) {
            IMDFile file = files[i];
            IFile ifile = null;
            if (file.toFile().exists()) {
                ifile = MDResourceUtil.toIFile(file);
            }
            for (int j = 0; j < editors.length; ++j) {
                IEditorPart part = (IEditorPart)editors[j].getPart(false);
                if (part == null) continue;
                IEditorInput input = part.getEditorInput();
                if (input instanceof FileEditorInput) {
                    if (!((FileEditorInput)input).getFile().equals(ifile)) continue;
                    list.add(part);
                    continue;
                }
                if (!(input instanceof IMDFileEditorInput) || !((IMDFileEditorInput)input).getFile().equals(file)) continue;
                list.add(part);
            }
        }
        return list.toArray(new IEditorPart[list.size()]);
    }

    public static void refreshOpenedEditor(IMDFile file) {
        if (file == null) {
            return;
        }
        IEditorPart part = EditorHelper.findEditor(file);
        if (part != null && part instanceof IMDSourceEditor) {
            ((IMDSourceEditor)part).reLoad();
            ((IMDSourceEditor)part).refreshPages();
        }
    }

    public static void openFile(final IMDFile file) {
        Display display;
        if (file == null || !file.exists()) {
            return;
        }
        final IWorkbenchPage page = ToolCommonPlugin.getActivePage();
        if (page != null && (display = ToolCommonPlugin.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if ("log".equalsIgnoreCase(file.getExtension())) {
                        try {
                            page.openEditor((IEditorInput)new MDFileEditorInput(file), "com.kingdee.bos.studio.multipageeditor.log.LogEditor", true);
                        }
                        catch (PartInitException e) {
                            LogTool.logError("\u521d\u59cb\u5316\u7f16\u8f91\u5668\u65f6\u53d1\u751f\u9519\u8bef", e);
                        }
                        return;
                    }
                    EditorHelper.openEditor(file);
                }
            });
        }
    }

    public static boolean isBOSEditor(IEditorDescriptor descriptor) {
        return descriptor != null && descriptor.getId().startsWith("com.kingdee.bos");
    }

    public static void openEditor(IMDFile file) {
        IWorkbenchPage page = ToolCommonPlugin.getActivePage();
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = editorReg.getDefaultEditor(file.getName());
        try {
            if (EditorHelper.isBOSEditor(descriptor)) {
                IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new MDFileEditorInput(file), (String)descriptor.getId());
            } else {
                IFile ifile = EditorHelper.toIFile(file);
                if (ifile.exists()) {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)ifile, (boolean)OpenStrategy.activateOnOpen());
                } else {
                    descriptor = editorReg.getDefaultEditor(".unknown");
                    IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new MDFileEditorInput(file), (String)descriptor.getId());
                }
            }
        }
        catch (Exception ex) {
            LogTool.logError("\u521d\u59cb\u5316\u7f16\u8f91\u5668\u65f6\u53d1\u751f\u9519\u8bef", ex);
        }
    }

    public static IFile toIFile(IMDFile file) {
        IFolder folder = MDResourceUtil.toIFolder(file.getParent());
        IFile f = folder.getFile(file.getName());
        return f;
    }

    private static boolean useMDInput(IMDFile file) {
        String ext = file.getExtension();
        if (ext == null) {
            return false;
        }
        ext = ext.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < MDFILE_EXTENSIONS.length; ++i) {
            if (!ext.equals(MDFILE_EXTENSIONS[i])) continue;
            return true;
        }
        return false;
    }

    public static IEditorInput getEmptyEditorInput(IMDProject project) {
        IFile tempFile = MDResourceUtil.toIProject(project).getFile(".project");
        return new FileEditorInput(tempFile);
    }

    public static IMDProject getMDProject(IEditorPart part) {
        if (part == null) {
            return null;
        }
        IEditorInput input = part.getEditorInput();
        if (input instanceof IMDFileEditorInput) {
            return ((IMDFileEditorInput)input).getFile().getMDProject();
        }
        if (input instanceof IFileEditorInput) {
            IProject p = ((IFileEditorInput)input).getFile().getProject();
            return MDResourceUtil.toMDProject(p);
        }
        return null;
    }
}

