/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.utils;

import com.kingdee.bos.license.License;
import com.kingdee.bos.license.LicenseFileErrorException;
import com.kingdee.bos.license.impl.BOSLicenseManager;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.utils.MD5;
import com.kingdee.util.Base64Encoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class LicenseUtils {
    public static final int LICENSE_TYPE_BIM = 0;
    public static final int LICENSE_TYPE_STUDIO = 1;
    public static final int LICENSE_TYPE_WORKFLOW = 2;
    public static final int DAY_TIME = 86400000;
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
    private static final SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
    public static final String[] TOOL_NAMES = new String[]{"\u4e1a\u52a1\u5efa\u6a21\u5de5\u5177", "\u4e1a\u52a1\u5f00\u53d1\u5de5\u5177", "\u6d41\u7a0b\u5efa\u6a21\u5de5\u5177"};
    public static final String IP_link = "http://service.kingdee.com/csso/customer/getClientIP.action";
    public static final String SERVICE_LOGIN_URL = "http://service.kingdee.com/csso/customer/productLogin.action";
    public static final String SERVICE_SITE = "http://cskb.kingdee.com:8080/utility/blank.aspx";
    public static final String SERVICE_HELP = "http://csrc.kingdee.com";
    public static final String SERVICE_REQ = "http://service.kingdee.com/csso/help/serviceInfo.htm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getQueryString(int type) throws IOException, JDOMException, LicenseFileErrorException {
        HttpURLConnection connection = null;
        String ip = null;
        InputStream stream = null;
        ByteArrayInputStream inputStream = null;
        try {
            URL url = new URL(IP_link);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            stream = connection.getInputStream();
            int available = stream.available();
            byte[] bt = new byte[available];
            stream.read(bt);
            String str = new String(bt);
            inputStream = new ByteArrayInputStream(str.trim().getBytes());
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((InputStream)inputStream);
            ip = doc.getRootElement().getText();
        }
        catch (Throwable throwable) {
            FileUtils.close(inputStream);
            FileUtils.close(stream);
            if (connection != null) {
                connection.disconnect();
            }
            throw throwable;
        }
        FileUtils.close(inputStream);
        FileUtils.close(stream);
        if (connection != null) {
            connection.disconnect();
        }
        License license = LicenseUtils.getLicense(type);
        boolean isRegistered = license.isRegistered();
        String no = license.getUserName();
        no = no != null ? Base64Encoder.byteArrayToBase64((byte[])no.getBytes()) : "";
        String hash = "";
        if (isRegistered) {
            String dt = df2.format(new Date());
            String tempHash = no + dt + ip;
            MD5 md5 = new MD5();
            md5.update(tempHash.getBytes());
            hash = LicenseUtils.bytesToHexString(md5.getFinal());
        }
        return "productno=" + no + "&hash=" + hash;
    }

    private static String bytesToHexString(byte[] bt) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < bt.length; ++i) {
            String s = Integer.toHexString(bt[i] & 0xFF);
            if (s.length() == 1) {
                buffer.append("0");
            }
            buffer.append(s);
        }
        return buffer.toString();
    }

    public static License getLicense(int type) throws LicenseFileErrorException {
        BOSLicenseManager manager = new BOSLicenseManager();
        License license = null;
        switch (type) {
            case 0: {
                license = manager.getBIMLicense();
                break;
            }
            case 1: {
                license = manager.getStudioLicense();
                break;
            }
            case 2: {
                license = manager.getWFDLicense();
            }
        }
        if (license != null) {
            try {
                String to = license.getLicenseTo();
                String name = license.getUserName();
                String info = "";
                if (to != null) {
                    info = info + "\u8bb8\u53ef\u7ed9\uff1a" + to + "\n";
                }
                if (name != null) {
                    info = info + "\u4ea7\u54c1\u5e8f\u5217\u53f7\uff1a" + name + "\n";
                }
                System.getProperties().put("license_information", info);
            }
            catch (Exception ex) {
                LogTool.logError("\u8bfb\u53d6\u8bb8\u53ef\u4fe1\u606f\u65f6\u51fa\u9519", ex);
            }
        }
        return license;
    }

    public static boolean isServiceExpire(int type, Date compareDate) throws LicenseFileErrorException {
        License license = LicenseUtils.getLicense(type);
        if (license == null) {
            return true;
        }
        Date serviceDate = license.getServiceDate();
        if (serviceDate == null) {
            return true;
        }
        if (compareDate == null) {
            compareDate = new Date();
        }
        return compareDate.after(serviceDate);
    }

    public static void checkServiceLicense(int type, Shell shell) throws LicenseFileErrorException {
        Date compareDate = new Date(System.currentTimeMillis() + -1702967296L);
        if (!LicenseUtils.isServiceExpire(type, compareDate)) {
            return;
        }
        if (shell == null) {
            return;
        }
        IPreferenceStore p = PlatformUI.getPreferenceStore();
        boolean alerted = p.getBoolean("Service_License_alerted_BOS");
        if (!alerted) {
            LicenseUtils.showExpireDialog(type, shell);
            p.putValue("Service_License_alerted_BOS", Boolean.toString(true));
        }
    }

    public static Date getServiceDate(License license) {
        return new Date();
    }

    public static void showExpireDialog(int type, Shell shell) throws LicenseFileErrorException {
        Date date = null;
        License license = LicenseUtils.getLicense(type);
        if (license != null) {
            date = LicenseUtils.getServiceDate(license);
        }
        String msg = LicenseUtils.getExpireDescription(date, TOOL_NAMES[type]);
        MessageDialog dialog = new MessageDialog(shell, "\u670d\u52a1\u63d0\u9192", null, msg, 2, new String[]{"\u5ffd\u7565", "\u7533\u8bf7"}, 0);
        if (dialog.open() == 1) {
            try {
                Runtime.getRuntime().exec("explorer http://service.kingdee.com/csso/help/serviceInfo.htm");
            }
            catch (Exception e) {
                LogTool.logError("\u6267\u884cexplorer\u65f6\u53d1\u751f\u9519\u8bef", e);
                MessageDialog.openError((Shell)shell, (String)"\u6267\u884c\u9519\u8bef", (String)"\u6267\u884cexplorer\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u53c2\u8003\u9519\u8bef\u65e5\u5fd7");
            }
        }
    }

    public static String getExpireDescription(Date date, String toolName) {
        String msg = null;
        msg = date == null ? "\u60a8\u5c1a\u672a\u6ce8\u518c\u6b63\u5f0f\u7248\u672c\uff0c\u6682\u65f6\u65e0\u6cd5\u4f7f\u7528\u5728\u7ebf\u670d\u52a1\u529f\u80fd,\u8bf7\u70b9\u201c\u7533\u8bf7\u201d\u8fdb\u884c\u7533\u8bf7" : "\u60a8\u7684\u670d\u52a1\u6709\u6548\u671f\u5230" + df.format(date) + "\uff0c\u5982\u679c\u60f3\u7533\u8bf7\u5ef6\u957f\u6709\u6548\u671f\uff0c\u8bf7\u70b9\u201c\u7533\u8bf7\u201d";
        return msg;
    }

    public static void checkBosLicense() throws Exception {
    }
}

