/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.views;

import com.kingdee.bos.tool.actions.CompositeActionGroup;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.ViewPart;

public abstract class TreeViewPart
extends ViewPart {
    private TreeViewer fViewer;
    private CompositeActionGroup fActionGroup;

    public void setFocus() {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().getTree().setFocus();
        }
    }

    public void dispose() {
        if (this.getActionGroup() != null) {
            this.getActionGroup().dispose();
        }
        super.dispose();
    }

    public TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    protected void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        this.getActionGroup().setContext(new ActionContext((ISelection)selection));
        this.getActionGroup().fillContextMenu(menu);
    }

    protected void createViewer(Composite parent, int style) {
        this.fViewer = new TreeViewer(parent, style);
    }

    protected void setContentProvider(IContentProvider provider) {
        this.getTreeViewer().setContentProvider(provider);
    }

    protected void setLabelProvider(ILabelProvider provider, boolean decorative) {
        if (decorative) {
            ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
            this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider(provider, decorator));
        } else {
            this.getTreeViewer().setLabelProvider((IBaseLabelProvider)provider);
        }
    }

    protected void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new Separator("group.importmetadata"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.operation"));
        menu.add((IContributionItem)new Separator("group.deploy"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    protected void setViewInput(Object input) {
        this.getTreeViewer().setInput(input);
    }

    protected void initListeners() {
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeViewPart.this.handleSelectionChanged(event);
            }
        });
        this.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeViewPart.this.handleDoubleClick(event);
            }
        });
        this.getTreeViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TreeViewPart.this.handleOpen(event);
            }
        });
    }

    protected void handleOpen(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.getActionGroup().runDefaultAction(selection);
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object element = selection.getFirstElement();
        TreeViewer viewer = this.getTreeViewer();
        if (viewer.isExpandable(element)) {
            viewer.setExpandedState(element, !viewer.getExpandedState(element));
        }
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateActionBars(sel);
    }

    protected void updateActionBars(IStructuredSelection selection) {
        CompositeActionGroup group = this.getActionGroup();
        if (group != null) {
            group.setContext(new ActionContext((ISelection)selection));
            group.updateActionBars();
        }
    }

    protected CompositeActionGroup getActionGroup() {
        return this.fActionGroup;
    }

    protected void setActionGroup(CompositeActionGroup actionGroup) {
        this.fActionGroup = actionGroup;
    }
}

