/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.wizard.i18n;

import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.wizard.i18n.I18NResourceContentProvider;
import com.kingdee.bos.tool.wizard.i18n.I18NResourceLableProvider;
import com.kingdee.bos.tool.wizard.i18n.ResourceInfo;
import com.kingdee.bos.tool.wizard.i18n.SelectionTreeViewer;
import com.kingdee.bos.tool.wizard.i18n.StringExtrWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SESelectionWizardPage
extends WizardPage {
    private SelectionTreeViewer treeViewer;
    private I18NResourceContentProvider contentProvider;
    private Combo resourceTypeCombo = null;
    private final String[] RESOURCE_TYPES = new String[]{"JAVA\u6587\u4ef6", "JavaScript\u6587\u4ef6"};
    private final String[] RESOURCE_SUFIXES = new String[]{".java", ".js"};
    private Button showEmptyBtn;
    ResourceInfo resourceInfo = null;
    private boolean canComplete = true;

    public SESelectionWizardPage(String pageName) {
        super(pageName);
        this.setTitle("\u5b57\u7b26\u4e32\u5904\u7406\u5411\u5bfc");
        super.setDescription("\u5904\u7406\u6587\u4ef6\u4e2d\u7684\u5b57\u7b26\u4e32\u8d44\u6e90");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("\u8bf7\u4ece\u4e0b\u9762\u9009\u62e9\u8981\u5904\u7406\u7684\u6587\u4ef6");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.treeViewer = new SelectionTreeViewer(container);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.contentProvider = new I18NResourceContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new I18NResourceLableProvider());
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SESelectionWizardPage.this.syncCheckState(event.getElement(), event.getChecked());
                SESelectionWizardPage.this.checkState();
            }
        });
        Composite panel = new Composite(container, 0);
        panel.setLayoutData((Object)new GridData(768));
        panel.setLayout((Layout)new GridLayout(3, false));
        Label label2 = new Label(panel, 0);
        label2.setText("\u6587\u4ef6\u7c7b\u578b\uff1a");
        this.resourceTypeCombo = new Combo(panel, 12);
        this.resourceTypeCombo.setItems(this.RESOURCE_TYPES);
        this.resourceTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SESelectionWizardPage.this.parseInfo();
            }
        });
        this.resourceTypeCombo.setLayoutData((Object)new GridData(768));
        this.resourceTypeCombo.select(0);
        this.showEmptyBtn = new Button(panel, 32);
        this.showEmptyBtn.setText("\u5c4f\u853d\u4e3a\u7a7a\u7684\u76ee\u5f55");
        this.showEmptyBtn.setSelection(true);
        this.showEmptyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SESelectionWizardPage.this.parseInfo();
            }
        });
        super.setPageComplete(false);
        this.setControl((Control)container);
    }

    private void syncCheckState(Object element, boolean flag) {
        Object[] elements = this.contentProvider.getChildren(element);
        for (int i = 0; i < elements.length; ++i) {
            this.treeViewer.setChecked(elements[i], flag);
            this.syncCheckState(elements[i], flag);
        }
    }

    private void parseInfo(ResourceInfo info, IResource res, String type, boolean showEmpty) throws CoreException {
        if (res instanceof IFolder) {
            IResource[] rss = ((IFolder)res).members();
            for (int i = 0; i < rss.length; ++i) {
                if (rss[i] instanceof IFile && !rss[i].getName().endsWith(type)) continue;
                ResourceInfo sInfo = new ResourceInfo(rss[i]);
                this.parseInfo(sInfo, rss[i], type, showEmpty);
                if (!(rss[i] instanceof IFile) && !showEmpty && sInfo.getChildren().size() <= 0) continue;
                info.getChildren().add(sInfo);
            }
        }
    }

    private void parseInfo() {
        this.resourceInfo = new ResourceInfo();
        String type = this.RESOURCE_SUFIXES[this.resourceTypeCombo.getSelectionIndex()];
        IStructuredSelection selection = ((StringExtrWizard)this.getWizard()).getSelection();
        if (selection == null) {
            return;
        }
        IResource res = null;
        Object object = selection.getFirstElement();
        if (object instanceof IJavaElement) {
            res = ((IJavaElement)object).getResource();
        } else if (object instanceof IResource) {
            res = (IResource)object;
        }
        if (!(res instanceof IFile) || res.getName().endsWith(type)) {
            boolean showEmpty = !this.showEmptyBtn.getSelection();
            ResourceInfo sub = new ResourceInfo(res);
            this.resourceInfo.getChildren().add(sub);
            try {
                this.parseInfo(sub, res, type, showEmpty);
            }
            catch (CoreException e) {
                LogTool.logError("\u89e3\u6790\u8d44\u6e90\u65f6\u53d1\u751f\u9519\u8bef", e);
            }
        }
        this.treeViewer.setInput(this.resourceInfo);
        this.treeViewer.refresh();
    }

    public void setVisible(boolean visible) {
        if (visible && this.resourceInfo == null) {
            this.parseInfo();
        }
        super.setVisible(visible);
    }

    private void checkState() {
        this.canComplete = true;
        Object[] elements = this.treeViewer.getCheckedElements();
        if (elements.length == 0) {
            this.canComplete = false;
            super.setErrorMessage("\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u4e2a\u6587\u4ef6");
        }
        if (this.canComplete) {
            boolean hasSelectFile = false;
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] instanceof IFile) {
                    hasSelectFile = true;
                    break;
                }
                if (this.treeViewer.isParsed(elements[i])) continue;
                hasSelectFile = true;
                break;
            }
            if (!hasSelectFile) {
                this.canComplete = false;
                super.setErrorMessage("\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u4e2a\u6587\u4ef6");
            }
        }
        if (this.canComplete) {
            super.setErrorMessage(null);
        }
        this.getWizard().getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        return this.canComplete;
    }

    public IFile[] getSelectedFile() {
        Object[] obj = this.treeViewer.getSelectedElements(IFile.class);
        return (IFile[])obj;
    }
}

