/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.wizard.solution;

import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.tool.utils.CheckUtils;
import com.kingdee.bos.tool.wizard.solution.AbstractNewSolutionWizardPage;
import com.kingdee.bos.tool.wizard.solution.Messages;
import com.kingdee.bos.tool.wizard.solution.NewSolutionCreationWizard;
import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewSolutionWizardPage
extends AbstractNewSolutionWizardPage {
    private static final String SOLUTION_NAME = "NewSolutionWizardPage";
    private Text root;
    private Button isDefault;
    private Button button;

    public NewSolutionWizardPage() {
        super(SOLUTION_NAME);
        this.setTitle(Messages.NewSolutionWizardPage_JieJueFangAn);
        this.setDescription(Messages.NewSolutionWizardPage_ChuangJianYiGeJieJueFangAn);
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 10;
        this.layoutCommonData(container);
        this.layoutSolutionLocation(container);
        this.addTextListener();
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    private void addTextListener() {
        TextModifyListener listener = new TextModifyListener();
        this.fName.addModifyListener((ModifyListener)listener);
        this.solutionName.addModifyListener((ModifyListener)listener);
        this.fAlias.addModifyListener((ModifyListener)listener);
        this.fDesc.addModifyListener((ModifyListener)listener);
        this.root.addModifyListener((ModifyListener)listener);
    }

    private void layoutSolutionLocation(Composite parent) {
        Group url = new Group(parent, 0);
        url.setText(Messages.NewSolutionWizardPage_XiangMuNeiRong);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        url.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        url.setLayout((Layout)layout);
        this.isDefault = new Button((Composite)url, 32);
        this.isDefault.setText(Messages.NewSolutionWizardPage_ShiYongQueShengZhiD);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        this.isDefault.setLayoutData((Object)gridData);
        this.isDefault.setSelection(true);
        this.isDefault.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        Label label = new Label((Composite)url, 16448);
        label.setText(Messages.NewSolutionWizardPage_MuLuY);
        label.setLayoutData((Object)new GridData(256));
        this.root = new Text((Composite)url, 2052);
        this.root.setText(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        this.root.setEditable(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.root.setLayoutData((Object)gridData);
        this.button = new Button((Composite)url, 8);
        this.button.setEnabled(false);
        this.button.setText(Messages.NewSolutionWizardPage_LanV);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.grabExcessHorizontalSpace = false;
        this.button.setLayoutData((Object)gridData);
        this.button.addSelectionListener((SelectionListener)new ButtonSelectionListener());
    }

    protected void inputIntoModel(ModifyEvent e) {
        NewSolutionCreationWizard wizard = (NewSolutionCreationWizard)this.getWizard();
        SolutionInfo model = wizard.getModel();
        if (e.getSource().equals(this.fName)) {
            wizard.setProjectName(this.fName.getText().trim());
            if (this.isDefault.getSelection()) {
                String strPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
                this.root.setText(strPath + System.getProperty("file.separator") + this.fName.getText().trim());
            }
        } else if (e.getSource().equals(this.solutionName)) {
            model.setName(this.solutionName.getText().trim());
        } else if (e.getSource().equals(this.fAlias)) {
            model.setAlias(this.fAlias.getText().trim());
        } else if (e.getSource().equals(this.fDesc)) {
            model.setDescription(this.fDesc.getText().trim());
        } else if (e.getSource().equals(this.root)) {
            wizard.setDirPath(this.root.getText());
        }
    }

    protected void verify() {
        if (CheckUtils.existProject(this.fName.getText().trim()) || !CheckUtils.isValidSolutionName(this.fName.getText().trim())) {
            this.setErrorMsg(Messages.NewSolutionWizardPage_GongChengMingChengBuHeFaHuoZheCunZaiTongMingDeGongCheng);
            return;
        }
        if (!CheckUtils.isValidSolutionName(this.solutionName.getText().trim())) {
            this.setErrorMsg(Messages.NewSolutionWizardPage_JieJueFangAnMingChengBuHeFa);
            return;
        }
        if (!CheckUtils.isValidFilePath(this.root.getText().trim())) {
            this.setErrorMessage(Messages.NewSolutionWizardPage_BuHeFaDeMuLuLuJing);
            return;
        }
        this.setErrorMsg(null);
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            NewSolutionWizardPage.this.inputIntoModel(e);
            NewSolutionWizardPage.this.verify();
        }
    }

    private class ButtonSelectionListener
    extends SelectionAdapter {
        private ButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource().equals(NewSolutionWizardPage.this.isDefault)) {
                if (NewSolutionWizardPage.this.isDefault.getSelection()) {
                    NewSolutionWizardPage.this.root.setText(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
                    NewSolutionWizardPage.this.root.setEditable(false);
                    NewSolutionWizardPage.this.button.setEnabled(false);
                } else {
                    NewSolutionWizardPage.this.root.setText("");
                    NewSolutionWizardPage.this.root.setEditable(true);
                    NewSolutionWizardPage.this.button.setEnabled(true);
                }
            } else {
                String url;
                DirectoryDialog dialog = new DirectoryDialog(NewSolutionWizardPage.this.getWizard().getContainer().getShell(), 65536);
                dialog.setText(Messages.NewSolutionWizardPage_LanWenJianJia);
                dialog.setMessage(Messages.NewSolutionWizardPage_XuanZeXiangMuNeiRongMuLu);
                if (new File(NewSolutionWizardPage.this.root.getText()).exists()) {
                    dialog.setFilterPath(NewSolutionWizardPage.this.root.getText());
                }
                if ((url = dialog.open()) != null) {
                    NewSolutionWizardPage.this.root.setText(url + System.getProperty("file.separator") + NewSolutionWizardPage.this.fName.getText());
                }
            }
        }
    }
}

