/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.wizard.solution;

import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.solution.SolutionDelegate;
import com.kingdee.bos.tool.solution.SolutionHelper;
import com.kingdee.bos.tool.wizard.solution.ListViewerContentProvider;
import com.kingdee.bos.tool.wizard.solution.ListViewerLabelProvider;
import com.kingdee.bos.tool.wizard.solution.Messages;
import com.kingdee.bos.tool.wizard.solution.NewSolutionCreationWizard;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewSolutionWizardPage2
extends WizardPage {
    protected Text src;
    private static final String SOLUTION_NAME = "NewSolutionWizardPage2";
    private Button makeExtSol;
    private ListViewer stdListViewer;
    private ListViewer extListViewer;
    private org.eclipse.swt.widgets.List stdList;
    private org.eclipse.swt.widgets.List extList;
    private List stdDirList = new ArrayList();
    private List extDirList = new ArrayList();
    private Button addStdDirBtn;
    private Button delStdDirBtn;
    private Button addExtDirBtn;
    private Button delExtDirBtn;

    public NewSolutionWizardPage2() {
        super(SOLUTION_NAME);
        this.setTitle(Messages.NewSolutionWizardPage2_JieJueFangAn);
        this.setDescription(Messages.NewSolutionWizardPage2_ChuangJianYiGeJieJueFangAn);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.layoutSource(container);
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initSource();
        }
    }

    public void performFinish(IProgressMonitor monitor) throws IDEException {
        String s;
        int i;
        NewSolutionCreationWizard wizard = (NewSolutionCreationWizard)this.getWizard();
        SolutionInfo info = wizard.getModel();
        String srcName = wizard.getSrcPath();
        srcName = !StringUtils.isEmpty((String)srcName) && srcName.indexOf("/") != -1 ? srcName.substring(srcName.indexOf("/") + 1) : "metadata";
        SolutionDelegate solDele = new SolutionDelegate();
        solDele.setExtSolution(this.makeExtSol.getSelection());
        solDele.setName(info.getName());
        String metafolder = StringUtils.isEmpty((String)srcName) ? "metadata" : srcName;
        String res = "resources";
        solDele.setSource(metafolder);
        solDele.setResource(res);
        int j = this.stdDirList.size();
        for (i = 0; i < j; ++i) {
            s = (String)this.stdDirList.get(i);
            solDele.addStdDir(s);
        }
        j = this.extDirList.size();
        for (i = 0; i < j; ++i) {
            s = (String)this.extDirList.get(i);
            solDele.addExtDir(s);
        }
        if (this.makeExtSol.getSelection()) {
            solDele.setSource((String)this.extDirList.get(0));
        }
        SolutionHelper.newSolution(info, wizard.getProjectName(), wizard.getDirPath(), solDele);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(wizard.getProjectName());
        if (project == null || !project.exists()) {
            return;
        }
        try {
            project.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            throw new IDEException((Throwable)e);
        }
    }

    private void initSource() {
        NewSolutionCreationWizard wizard = (NewSolutionCreationWizard)this.getWizard();
        String str = wizard.getProjectName();
        this.src.setText(str + "/" + "metadata");
    }

    private void layoutSource(Composite container) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 10;
        container.setLayout((Layout)layout);
        new Label(container, 16448).setText(Messages.NewSolutionWizardPage2_MuLuD);
        this.src = new Text(container, 2052);
        this.src.addModifyListener((ModifyListener)new SrcModifyListener());
        GridData gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        this.src.setLayoutData((Object)gridData);
        this.makeExtSol = new Button(container, 32);
        this.makeExtSol.setText("\u751f\u6210\u884c\u4e1a\u7248\u89e3\u51b3\u65b9\u6848");
        GridData makeExtSolBtnGD = new GridData(256);
        makeExtSolBtnGD.grabExcessHorizontalSpace = true;
        makeExtSolBtnGD.horizontalSpan = 2;
        this.makeExtSol.setLayoutData((Object)makeExtSolBtnGD);
        this.makeExtSol.addSelectionListener((SelectionListener)new ButtonListener());
        Group stdGroup = new Group(container, 0);
        GridData stdGroupGD = new GridData(768);
        stdGroupGD.horizontalSpan = 2;
        stdGroup.setLayoutData((Object)stdGroupGD);
        GridLayout stdGroupLayout = new GridLayout();
        stdGroupLayout.numColumns = 2;
        stdGroupLayout.makeColumnsEqualWidth = false;
        stdGroup.setLayout((Layout)stdGroupLayout);
        stdGroup.setText("\u6807\u51c6\u5143\u6570\u636e\u76ee\u5f55");
        this.stdListViewer = new ListViewer((Composite)stdGroup, 2816);
        this.stdListViewer.setContentProvider((IContentProvider)new ListViewerContentProvider());
        this.stdListViewer.setLabelProvider((IBaseLabelProvider)new ListViewerLabelProvider());
        this.stdListViewer.setUseHashlookup(true);
        this.stdListViewer.setInput((Object)this.stdDirList);
        this.stdList = this.stdListViewer.getList();
        GridData stdListGD = new GridData(1808);
        stdListGD.horizontalSpan = 1;
        this.stdList.setLayoutData((Object)stdListGD);
        Composite stdBtnComposit = new Composite((Composite)stdGroup, 0);
        GridLayout stdBtnLayout = new GridLayout();
        stdBtnLayout.numColumns = 1;
        stdBtnComposit.setLayout((Layout)stdBtnLayout);
        GridData stdBtnComGD = new GridData(3);
        stdBtnComGD.horizontalSpan = 1;
        stdBtnComposit.setLayoutData((Object)stdBtnComGD);
        this.addStdDirBtn = new Button(stdBtnComposit, 0);
        this.addStdDirBtn.setText("\u589e\u52a0");
        this.delStdDirBtn = new Button(stdBtnComposit, 0);
        this.delStdDirBtn.setText("\u5220\u9664");
        this.addStdDirBtn.addSelectionListener((SelectionListener)new ButtonListener());
        this.delStdDirBtn.addSelectionListener((SelectionListener)new ButtonListener());
        Group extGroup = new Group(container, 0);
        GridData extGroupGD = new GridData(768);
        extGroupGD.horizontalSpan = 2;
        extGroup.setLayoutData((Object)extGroupGD);
        GridLayout extGroupLayout = new GridLayout();
        extGroupLayout.numColumns = 2;
        extGroupLayout.makeColumnsEqualWidth = false;
        extGroup.setLayout((Layout)extGroupLayout);
        extGroup.setText("\u884c\u4e1a\u5143\u6570\u636e\u76ee\u5f55");
        this.extListViewer = new ListViewer((Composite)extGroup, 2816);
        this.extListViewer.setContentProvider((IContentProvider)new ListViewerContentProvider());
        this.extListViewer.setLabelProvider((IBaseLabelProvider)new ListViewerLabelProvider());
        this.extListViewer.setUseHashlookup(true);
        this.extListViewer.setInput((Object)this.extDirList);
        this.extList = this.extListViewer.getList();
        GridData extListGD = new GridData(1808);
        extListGD.horizontalSpan = 1;
        this.extList.setLayoutData((Object)extListGD);
        Composite extBtnComposit = new Composite((Composite)extGroup, 0);
        GridLayout extBtnLayout = new GridLayout();
        extBtnLayout.numColumns = 1;
        extBtnComposit.setLayout((Layout)extBtnLayout);
        GridData extBtnComGD = new GridData(3);
        extBtnComGD.horizontalSpan = 1;
        extBtnComposit.setLayoutData((Object)extBtnComGD);
        this.addExtDirBtn = new Button(extBtnComposit, 0);
        this.addExtDirBtn.setText("\u589e\u52a0");
        this.delExtDirBtn = new Button(extBtnComposit, 0);
        this.delExtDirBtn.setText("\u5220\u9664");
        this.addExtDirBtn.addSelectionListener((SelectionListener)new ButtonListener());
        this.delExtDirBtn.addSelectionListener((SelectionListener)new ButtonListener());
        this.setBtnEnable(false);
    }

    private void buttonEvent(SelectionEvent e) {
        String input;
        InputDialog stdNameDlg;
        int ret;
        if (e.getSource().equals(this.makeExtSol)) {
            boolean flag = this.makeExtSol.getSelection();
            this.setBtnEnable(flag);
        }
        if (e.getSource().equals(this.addStdDirBtn) && (ret = (stdNameDlg = new InputDialog(ToolCommonPlugin.getShell(), "\u8f93\u5165\u76ee\u5f55\u540d\u79f0", "\u76ee\u5f55\u540d\u79f0:", "", (IInputValidator)new DialogValidator())).open()) == 0) {
            input = stdNameDlg.getValue();
            this.stdDirList.add(input);
            this.stdListViewer.refresh();
        }
        if (e.getSource().equals(this.delStdDirBtn)) {
            StructuredSelection sel = (StructuredSelection)this.stdListViewer.getSelection();
            if (sel.getFirstElement() == null) {
                return;
            }
            String selStr = (String)sel.getFirstElement();
            this.stdDirList.remove(selStr);
            this.stdListViewer.refresh();
        }
        if (e.getSource().equals(this.addExtDirBtn)) {
            InputDialog extNameDlg = new InputDialog(ToolCommonPlugin.getShell(), "\u8f93\u5165\u76ee\u5f55\u540d\u79f0", "\u76ee\u5f55\u540d\u79f0:", "", (IInputValidator)new DialogValidator());
            ret = extNameDlg.open();
            if (ret == 0) {
                input = extNameDlg.getValue();
                this.extDirList.add(input);
                this.extListViewer.refresh();
            }
            if (this.extDirList.size() > 0) {
                this.addExtDirBtn.setEnabled(false);
            } else {
                this.addExtDirBtn.setEnabled(true);
            }
        }
        if (e.getSource().equals(this.delExtDirBtn)) {
            StructuredSelection sel = (StructuredSelection)this.extListViewer.getSelection();
            if (sel.getFirstElement() == null) {
                return;
            }
            String selStr = (String)sel.getFirstElement();
            this.extDirList.remove(selStr);
            this.extListViewer.refresh();
            if (this.extDirList.size() > 0) {
                this.addExtDirBtn.setEnabled(false);
            } else {
                this.addExtDirBtn.setEnabled(true);
            }
        }
    }

    private void setBtnEnable(boolean flag) {
        this.src.setEnabled(!flag);
        this.stdList.setEnabled(flag);
        this.addStdDirBtn.setEnabled(flag);
        this.delStdDirBtn.setEnabled(flag);
        this.extList.setEnabled(flag);
        this.addExtDirBtn.setEnabled(flag);
        this.delExtDirBtn.setEnabled(flag);
    }

    private class DialogValidator
    implements IInputValidator {
        private DialogValidator() {
        }

        public String isValid(String input) {
            if (input == null || input.length() == 0) {
                return " ";
            }
            if (NewSolutionWizardPage2.this.stdDirList.contains(input) || NewSolutionWizardPage2.this.extDirList.contains(input)) {
                return "\u8be5\u76ee\u5f55\u5df2\u5b58\u5728!";
            }
            if ("basetemp".equals(input) || input.equals("resources") || "exporttemp".equals(input)) {
                return "\u8be5\u76ee\u5f55\u4e3a\u7cfb\u7edf\u4fdd\u7559\u76ee\u5f55\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528!";
            }
            return null;
        }
    }

    private class ButtonListener
    implements SelectionListener {
        private ButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            NewSolutionWizardPage2.this.buttonEvent(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class SrcModifyListener
    implements ModifyListener {
        private SrcModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            NewSolutionCreationWizard wizard = (NewSolutionCreationWizard)NewSolutionWizardPage2.this.getWizard();
            String pjName = wizard.getProjectName();
            if (NewSolutionWizardPage2.this.src.getText().startsWith(pjName + "/") && StringUtils.isJavaIdentifier((String)NewSolutionWizardPage2.this.src.getText().substring(pjName.length() + 1))) {
                NewSolutionWizardPage2.this.setErrorMessage(null);
                NewSolutionWizardPage2.this.setPageComplete(true);
                wizard.setSrcPath(NewSolutionWizardPage2.this.src.getText());
            } else {
                NewSolutionWizardPage2.this.setErrorMessage(Messages.NewSolutionWizardPage2_BuHeFaDeYuanShuJuMuLu);
                NewSolutionWizardPage2.this.setPageComplete(false);
            }
        }
    }
}

