/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.xpath.XPath;

public class XMLUtils {
    public static final String DEFAULT_NUMESPACE = "ns";

    public static List findElement(Document dom, String[] ElementCondition) throws JDOMException {
        XPath path = XPath.newInstance((String)XMLUtils.trans(ElementCondition, DEFAULT_NUMESPACE));
        path.addNamespace(DEFAULT_NUMESPACE, dom.getRootElement().getNamespaceURI());
        return path.selectNodes((Object)dom);
    }

    private static String trans(String[] ElementCondition, String nameSpace) {
        ArrayList<String> list = new ArrayList<String>();
        for (String old : ElementCondition) {
            if (old.indexOf("[") == -1) {
                if ("/".equals(old)) {
                    list.add(old);
                    continue;
                }
                list.add("ns:" + old);
                continue;
            }
            list.add(XMLUtils.tran(old, nameSpace));
        }
        StringBuffer buf = new StringBuffer("//");
        for (String s : list) {
            buf.append(s.equals("/") ? "" : s).append("/");
        }
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString();
    }

    private static String tran(String old, String nameSpace) {
        Pattern p = Pattern.compile("(\\w+)\\[(@)?(\\w+)=(.*)?\\]");
        Matcher match = p.matcher(old);
        StringBuffer buf = new StringBuffer();
        if (match.find()) {
            String ele_tag = match.group(1);
            String isAttr = match.group(2);
            String attrName = match.group(3);
            String attrValue = match.group(4);
            buf.append(nameSpace).append(":").append(ele_tag);
            buf.append("[");
            if (null != match.group(2)) {
                attrValue = attrValue.replaceFirst("^'", "");
                String[] values = (attrValue = attrValue.replaceFirst("'$", "")).split(",");
                if (values.length <= 1) {
                    buf.append("@").append(attrName).append("='");
                    buf.append(values[0]).append("']");
                } else {
                    for (String val : values) {
                        if (val.trim().length() <= 0) continue;
                        buf.append("contains(@").append(attrName).append(",'").append(val).append("')");
                        buf.append(" and ");
                    }
                    if (buf.length() > 0) {
                        buf.delete(buf.length() - 6, buf.length() - 1);
                    }
                    buf.append(")]");
                }
            } else {
                buf.append(nameSpace).append(":").append(attrName);
                buf.append("=").append(attrValue).append("]");
            }
            return buf.toString();
        }
        return old;
    }
}

