/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.axis;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

public class WSDLEmitter {
    private String locationUrl;
    private Definition intefaceDefinition;

    public void setLocationUrl(String locationUrl) {
        this.locationUrl = locationUrl;
    }

    public void setIntefaceDefinition(Definition intefaceDefinition) {
        this.intefaceDefinition = intefaceDefinition;
    }

    public Document emit() throws WSDLException {
        Definition definition = this.intefaceDefinition;
        this.writeDefinitionHeader(definition);
        Binding binding = this.writeBinding(definition);
        this.writeBinding(definition, binding);
        this.writeService(definition, binding);
        Document doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
        return doc;
    }

    protected void writeService(Definition def, Binding binding) {
        QName serviceElementQName = new QName(this.intefaceDefinition.getTargetNamespace(), this.generateServiceName());
        Service service = def.createService();
        service.setQName(serviceElementQName);
        def.addService(service);
        Port port = def.createPort();
        port.setBinding(binding);
        port.setName(this.generateServicePortName());
        SOAPAddressImpl addr = new SOAPAddressImpl();
        addr.setLocationURI(this.locationUrl);
        port.addExtensibilityElement((ExtensibilityElement)addr);
        service.addPort(port);
    }

    private String generateServiceName() {
        return this.intefaceDefinition.getQName().getLocalPart() + "Service";
    }

    private String generateServicePortName() {
        String name = this.locationUrl.lastIndexOf(47) > 0 ? this.locationUrl.substring(this.locationUrl.lastIndexOf(47) + 1) : (this.locationUrl.lastIndexOf(92) > 0 ? this.locationUrl.substring(this.locationUrl.lastIndexOf(92) + 1) : null);
        return name;
    }

    private Binding writeBinding(Definition def) {
        QName bindingQName = new QName(this.intefaceDefinition.getTargetNamespace(), this.generateServicePortName());
        Binding binding = def.createBinding();
        binding.setUndefined(false);
        binding.setQName(bindingQName);
        SOAPBindingImpl soapBinding = new SOAPBindingImpl();
        soapBinding.setStyle("document");
        soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        def.addBinding(binding);
        return binding;
    }

    protected ExtensibilityElement writeSOAPBody() {
        SOAPBodyImpl soapBody = new SOAPBodyImpl();
        soapBody.setUse("literal");
        soapBody.setNamespaceURI(this.intefaceDefinition.getTargetNamespace());
        return soapBody;
    }

    protected BindingOperation writeBindingOperation(Definition def, Binding binding, Operation oper) {
        BindingOperation bindingOper = def.createBindingOperation();
        BindingInput bindingInput = def.createBindingInput();
        BindingOutput bindingOutput = def.createBindingOutput();
        bindingOper.setName(oper.getName());
        bindingOper.setOperation(oper);
        SOAPOperationImpl soapOper = new SOAPOperationImpl();
        soapOper.setSoapActionURI("");
        bindingOper.addExtensibilityElement((ExtensibilityElement)soapOper);
        ExtensibilityElement input = this.writeSOAPBody();
        bindingInput.addExtensibilityElement(input);
        ExtensibilityElement output = this.writeSOAPBody();
        bindingOutput.addExtensibilityElement(output);
        bindingOper.setBindingInput(bindingInput);
        bindingOper.setBindingOutput(bindingOutput);
        binding.addBindingOperation(bindingOper);
        return bindingOper;
    }

    private void writeBinding(Definition def, Binding binding) {
        PortType portType = (PortType)def.getPortTypes().values().iterator().next();
        List operations = portType.getOperations();
        for (Operation thisOper : operations) {
            this.writeBindingOperation(def, binding, thisOper);
            binding.setPortType(portType);
        }
    }

    private void writeDefinitionHeader(Definition def) {
        def.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        def.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        def.addNamespace("soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
        def.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        def.addNamespace("apachesoap", "http://xml.apache.org/xml-soap");
    }
}

