/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz.event;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.EventType;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.TimerIntermediateEventActivityDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.app.AbstractApplicationManager;
import com.kingdee.bos.workflow.metas.EventProcMetaInfo;
import com.kingdee.bos.workflow.timeliness.EventTimerWaiter;
import com.kingdee.bos.workflow.timeliness.TimelinessProvider;
import com.kingdee.bos.workflow.util.CommonEventUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EventApplicationmanager
extends AbstractApplicationManager {
    public EventApplicationmanager(WfActivity activityInst) {
        super(activityInst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeApplication(ApplicationDef application, ActualParameterCollection parameters) throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "invokeApplication", null);
        }
        try {
            if (application == null) {
                return;
            }
            EventType eventType = this.innerInvoke(application, parameters);
            if (EventApplicationmanager.isCompletedAfterInvoke(eventType)) {
                this.activityInst.complete("");
            }
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    public static boolean isCompletedAfterInvoke(EventType eventType) {
        return eventType == EventType.EVENT_INTERMEDIATE_SENDSIGNAL || eventType == EventType.EVENT_END_SENDSIGNAL;
    }

    public EventType innerInvoke(ApplicationDef application, ActualParameterCollection parameters) throws WfException {
        EventActivityDef eventActivityDef = (EventActivityDef)this.activityInst.getDefinition();
        EventType eventType = eventActivityDef.getEventType();
        if (eventType == EventType.EVENT_START_SIGNALSTART || eventType == EventType.EVENT_INTERMEDIATE_RECEIVESIGNAL || eventType == EventType.EVENT_END_RECEIVESIGNAL) {
            this.invokeEventReceiver(application, this.activityInst, this.getProcessContext(), parameters);
        } else if (EventApplicationmanager.isCompletedAfterInvoke(eventType)) {
            this.invokeEventSender(application, this.activityInst, this.getProcessContext(), parameters);
        } else if (eventType == EventType.EVENT_INTERMEDIATE_TIMER) {
            this.invokeEventTimer(application, this.activityInst, this.getProcessContext(), parameters);
        }
        return eventType;
    }

    private void invokeEventTimer(ApplicationDef application, WfActivity activity, ProcessContext context, ActualParameterCollection parameters) {
        if (activity == null) {
            return;
        }
        if (!(activity.getDefinition() instanceof TimerIntermediateEventActivityDef)) {
            return;
        }
        TimerIntermediateEventActivityDef timerEventDef = (TimerIntermediateEventActivityDef)activity.getDefinition();
        WfEngine wfengine = activity.getWfEngine();
        String ais = wfengine.getEngineAis();
        String solution = wfengine.getEngineSolution();
        TimelinessProvider.getProvider(ais, solution).addTimeEventWaiter(new EventTimerWaiter(activity, timerEventDef));
    }

    private void invokeEventReceiver(ApplicationDef application, WfActivity activity, ProcessContext context, ActualParameterCollection parameters) throws WfException {
        if (application == null || activity == null) {
            return;
        }
        if (!(activity.getDefinition() instanceof EventActivityDef)) {
            return;
        }
        EventActivityDef eventActivityDef = (EventActivityDef)activity.getDefinition();
        EventProcMetaInfo info = CommonEventUtils.constructEventProcMetaInfo(activity, eventActivityDef);
        activity.getWfEngine().setEventProcRelation(new EventProcMetaInfo[]{info});
    }

    private void invokeEventSender(ApplicationDef application, WfActivity activity, ProcessContext context, ActualParameterCollection actualParameters) throws WfException {
        if (application == null || activity == null) {
            return;
        }
        if (!(activity.getDefinition() instanceof EventActivityDef)) {
            return;
        }
        EventActivityDef eventActivityDef = (EventActivityDef)activity.getDefinition();
        FormalParameterCollection formalParameters = application.getFormalParameters();
        Map parameterMap = this.getParameterMap(activity, context, actualParameters, formalParameters);
        try {
            activity.getWfEngine().getEventProducer().createAndSendEvent(eventActivityDef, parameterMap);
        }
        catch (Exception e) {
            if (e instanceof WfException) {
                throw (WfException)((Object)e);
            }
            throw new WfException(e.getMessage(), (Throwable)e, true);
        }
    }

    private Map getParameterMap(WfActivity activity, ProcessContext context, ActualParameterCollection actualParameters, FormalParameterCollection formalParameters) {
        Iterator iter = actualParameters.iterator();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        String key = null;
        while (iter.hasNext()) {
            ActualParameterDef item = (ActualParameterDef)iter.next();
            if (item.getIndex() >= formalParameters.size()) continue;
            FormalParameterDef formalParameter = formalParameters.get(item.getIndex());
            key = formalParameter.getName();
            Object value = context.getDataFieldValue(item.getDataFieldNameWithProp(activity.getDefinition()));
            parameterMap.put(key, value);
        }
        return parameterMap;
    }
}

