/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz.event;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.event.ActivityEventExecutor;
import com.kingdee.bos.workflow.biz.event.DummyEventExecutor;
import com.kingdee.bos.workflow.biz.event.IEventExecutor;
import com.kingdee.bos.workflow.biz.event.ProcessEventExecutor;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.ParticipantHelper;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.metas.EventProcMetaInfo;
import com.kingdee.bos.workflow.metas.EventTypeEnum;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.util.CommonEventUtils;
import com.kingdee.util.StringUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EventExecutorDelegator {
    private static IEventExecutor activityEventExecutor = new ActivityEventExecutor();
    private static IEventExecutor processEventExecutor = new ProcessEventExecutor();
    private static IEventExecutor dummyEventExecutor = new DummyEventExecutor();

    public void delegateToEventExecutor(ICommonEvent event, EventProcMetaInfo[] eventProcMetaInfos, WfEngine wfEngine) throws WfException {
        if (eventProcMetaInfos == null || eventProcMetaInfos.length <= 0 || wfEngine == null) {
            return;
        }
        EventProcMetaInfo emp = this.filterEventInfo(event, eventProcMetaInfos, wfEngine);
        if (emp != null) {
            this.getEventExecutor(emp.getEventType()).execute(event, emp, wfEngine);
        }
    }

    EventProcMetaInfo filterEventInfo(ICommonEvent event, EventProcMetaInfo[] eventProcMetaInfos, WfEngine wfEngine) throws WfException {
        List list = Arrays.asList((Object[])eventProcMetaInfos);
        Collections.sort(list, new Comparator(){

            public int compare(Object paramObject1, Object paramObject2) {
                EventProcMetaInfo epm1 = (EventProcMetaInfo)paramObject1;
                EventProcMetaInfo epm2 = (EventProcMetaInfo)paramObject2;
                int c = epm1.getProcPriority() - epm2.getProcPriority();
                return -c;
            }
        });
        Person initiator = CommonEventUtils.getPersonFromEvent(event, wfEngine);
        for (EventProcMetaInfo emp : list) {
            List l;
            String procdefid = emp.getProcDefId().toString();
            WfProcessMgr pmgr = wfEngine.getProcessMgr(procdefid);
            if (pmgr == null || !pmgr.getData().isEnable()) continue;
            ProcessDef procDef = pmgr.getProcessDef();
            ActivityDef actDef = CommonEventUtils.getActDefByEventActivated(procDef, event);
            ParticipantCollection pc = null;
            if (actDef instanceof ManpowerActivityDef) {
                EventActivityDef eventActivityDef;
                ManpowerActivityDef def = (ManpowerActivityDef)actDef;
                if (!StringUtils.isEmpty((String)def.getRefEventActDefId()) && (eventActivityDef = (EventActivityDef)procDef.getActivityDef(def.getRefEventActDefId())) != null && event.getName().equalsIgnoreCase(eventActivityDef.getEventName())) {
                    pc = eventActivityDef.getParticipants();
                }
            } else if (actDef instanceof EventActivityDef) {
                EventActivityDef eventActivityDef = (EventActivityDef)actDef;
                if (event.getName().equalsIgnoreCase(eventActivityDef.getEventName())) {
                    pc = eventActivityDef.getParticipants();
                }
            }
            if (pc != null && pc.size() != 0 && !(l = ParticipantHelper.getPersonsByParticipants(wfEngine, pmgr.getData().getMd5HashValue(), actDef.getID(), initiator.getUserId(), true)).contains(initiator)) continue;
            return emp;
        }
        return null;
    }

    public IEventExecutor getEventExecutor(EventTypeEnum eventTypeEnum) {
        if (eventTypeEnum == null) {
            return dummyEventExecutor;
        }
        if (eventTypeEnum == EventTypeEnum.PROCESSTRIGGER) {
            return processEventExecutor;
        }
        if (eventTypeEnum == EventTypeEnum.ACTIVITYTRIGGER) {
            return activityEventExecutor;
        }
        return dummyEventExecutor;
    }
}

