/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.store.ForwardStep;
import com.kingdee.bos.workflow.store.WorkItemStorer;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.ScriptUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProcessControlDataKScriptAdapter {
    private ProcessInstInfo processInstInfo;
    private Locale curLocale;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.ProcessControlDataKScriptAdapter");
    private WfEngine engine;

    public ProcessControlDataKScriptAdapter(ProcessInstInfo processInfo, Locale locale, WfEngine engine) throws BOSException {
        this.processInstInfo = processInfo;
        this.curLocale = locale;
        this.engine = engine;
    }

    public String getInitializer() {
        return this.processInstInfo.getInitiatorName(this.curLocale);
    }

    public Date getCreateTime() {
        return this.processInstInfo.getCreatedTime();
    }

    public Object getInfomation(String key) {
        return this.processInstInfo.getData(key);
    }

    public String getActivityParticipants(String actName) {
        ActivityInstInfo actInst = this.getActvityInstInfo(actName);
        if (actInst != null) {
            return actInst.getPerformerInfoList();
        }
        return "";
    }

    public Date getActivityCreatedTime(String actName) {
        ActivityInstInfo actInst = this.getActvityInstInfo(actName);
        if (actInst != null) {
            return actInst.getCreatedTime();
        }
        return null;
    }

    public Date getActivityCompleteTime(String actName) {
        ActivityInstInfo actInst = this.getActvityInstInfo(actName);
        if (actInst != null) {
            return actInst.getCompleteTime();
        }
        return null;
    }

    public String getActivityUntreatedPerformerUserName(String actName, String split) {
        StringBuffer rtn = new StringBuffer();
        boolean flag = false;
        try {
            ActivityInstInfo actInst = this.getActvityInstInfo(actName);
            AssignmentInfo[] assignmentInfo = this.engine.getAssignmentByActInstId(actInst.getActInstId());
            for (int i = 0; i < assignmentInfo.length; ++i) {
                AssignmentInfo assignInfo = assignmentInfo[i];
                if (!WfAssignmentState.ACCEPTED.equals((Object)assignInfo.getState()) && !WfAssignmentState.ASSIGNED.equals((Object)assignInfo.getState()) && !WfAssignmentState.CANCELED.equals((Object)assignInfo.getState())) continue;
                if (flag) {
                    rtn.append(split);
                }
                rtn.append(assignInfo.getUserName(this.curLocale));
                flag = true;
            }
        }
        catch (Throwable t) {
            rtn = new StringBuffer();
        }
        return rtn.toString();
    }

    public String[] getActivityUntreatedPerformerUserId(String actName) {
        ArrayList<String> rtn = new ArrayList<String>();
        try {
            ActivityInstInfo actInst = this.getActvityInstInfo(actName);
            AssignmentInfo[] assignmentInfo = this.engine.getAssignmentByActInstId(actInst.getActInstId());
            for (int i = 0; i < assignmentInfo.length; ++i) {
                AssignmentInfo assignInfo = assignmentInfo[i];
                if (!WfAssignmentState.ACCEPTED.equals((Object)assignInfo.getState()) && !WfAssignmentState.ASSIGNED.equals((Object)assignInfo.getState()) && !WfAssignmentState.CANCELED.equals((Object)assignInfo.getState()) || rtn.contains(assignInfo.getUserId())) continue;
                rtn.add(assignInfo.getUserId());
            }
        }
        catch (Throwable t) {
            rtn.clear();
        }
        return rtn.toArray(new String[0]);
    }

    public String getActivityPerformerUserName(String actName, String split) {
        StringBuffer rtn = new StringBuffer();
        boolean flag = false;
        try {
            ActivityInstInfo actInst = this.getActvityInstInfo(actName);
            AssignmentInfo[] assignmentInfo = this.engine.getAssignmentByActInstId(actInst.getActInstId());
            for (int i = 0; i < assignmentInfo.length; ++i) {
                AssignmentInfo assignInfo = assignmentInfo[i];
                if (!WfAssignmentState.COMPLETED.equals((Object)assignInfo.getState())) continue;
                if (flag) {
                    rtn.append(split);
                }
                rtn.append(assignInfo.getUserName(this.curLocale));
                flag = true;
            }
        }
        catch (Throwable t) {
            rtn = new StringBuffer();
        }
        return rtn.toString();
    }

    public String[] getActivityPerformerUserId(String actName) {
        ArrayList<String> rtn = new ArrayList<String>();
        try {
            ActivityInstInfo actInst = this.getActvityInstInfo(actName);
            AssignmentInfo[] assignmentInfo = this.engine.getAssignmentByActInstId(actInst.getActInstId());
            for (int i = 0; i < assignmentInfo.length; ++i) {
                AssignmentInfo assignInfo = assignmentInfo[i];
                if (!WfAssignmentState.COMPLETED.equals((Object)assignInfo.getState()) || rtn.contains(assignInfo.getUserId())) continue;
                rtn.add(assignInfo.getUserId());
            }
        }
        catch (Throwable t) {
            rtn.clear();
        }
        return rtn.toArray(new String[0]);
    }

    public String getActivityUntreatedPerformerEmpName(String actName, String split) {
        StringBuffer rtn = new StringBuffer();
        boolean flag = false;
        try {
            ActivityInstInfo actInst = this.getActvityInstInfo(actName);
            AssignmentInfo[] assignmentInfo = this.engine.getAssignmentByActInstId(actInst.getActInstId());
            for (int i = 0; i < assignmentInfo.length; ++i) {
                AssignmentInfo assignInfo = assignmentInfo[i];
                if (!WfAssignmentState.ACCEPTED.equals((Object)assignInfo.getState()) && !WfAssignmentState.ASSIGNED.equals((Object)assignInfo.getState()) && !WfAssignmentState.CANCELED.equals((Object)assignInfo.getState())) continue;
                if (flag) {
                    rtn.append(split);
                }
                rtn.append(assignInfo.getEmployeeName(this.curLocale));
                flag = true;
            }
        }
        catch (Throwable t) {
            rtn = new StringBuffer();
        }
        return rtn.toString();
    }

    public String[] getActivityUntreatedPerformerEmpId(String actName) {
        ArrayList<String> rtn = new ArrayList<String>();
        try {
            ActivityInstInfo actInst = this.getActvityInstInfo(actName);
            AssignmentInfo[] assignmentInfo = this.engine.getAssignmentByActInstId(actInst.getActInstId());
            for (int i = 0; i < assignmentInfo.length; ++i) {
                AssignmentInfo assignInfo = assignmentInfo[i];
                if (!WfAssignmentState.ACCEPTED.equals((Object)assignInfo.getState()) && !WfAssignmentState.ASSIGNED.equals((Object)assignInfo.getState()) && !WfAssignmentState.CANCELED.equals((Object)assignInfo.getState()) || rtn.contains(assignInfo.getEmployeeId())) continue;
                rtn.add(assignInfo.getEmployeeId());
            }
        }
        catch (Throwable t) {
            rtn.clear();
        }
        return rtn.toArray(new String[0]);
    }

    public String getActivityPerformerEmpName(String actName, String split) {
        StringBuffer rtn = new StringBuffer();
        boolean flag = false;
        try {
            ActivityInstInfo actInst = this.getActvityInstInfo(actName);
            AssignmentInfo[] assignmentInfo = this.engine.getAssignmentByActInstId(actInst.getActInstId());
            for (int i = 0; i < assignmentInfo.length; ++i) {
                AssignmentInfo assignInfo = assignmentInfo[i];
                if (!WfAssignmentState.COMPLETED.equals((Object)assignInfo.getState())) continue;
                if (flag) {
                    rtn.append(split);
                }
                rtn.append(assignInfo.getEmployeeName(this.curLocale));
                flag = true;
            }
        }
        catch (Throwable t) {
            rtn = new StringBuffer();
        }
        return rtn.toString();
    }

    public String[] getActivityPerformerEmpId(String actName) {
        ArrayList<String> rtn = new ArrayList<String>();
        try {
            ActivityInstInfo actInst = this.getActvityInstInfo(actName);
            AssignmentInfo[] assignmentInfo = this.engine.getAssignmentByActInstId(actInst.getActInstId());
            for (int i = 0; i < assignmentInfo.length; ++i) {
                AssignmentInfo assignInfo = assignmentInfo[i];
                if (!WfAssignmentState.COMPLETED.equals((Object)assignInfo.getState()) || rtn.contains(assignInfo.getEmployeeId())) continue;
                rtn.add(assignInfo.getEmployeeId());
            }
        }
        catch (Throwable t) {
            rtn.clear();
        }
        return rtn.toArray(new String[0]);
    }

    public Object getActivityInfomation(String actName, String key) {
        ActivityInstInfo actInst = this.getActvityInstInfo(actName);
        if (actInst != null) {
            return actInst.getData(key);
        }
        return null;
    }

    public ActivityInstInfo getActvityInstInfo(String actDefName) {
        try {
            Context ctx = this.engine.context();
            Locale[] locales = ApplicationUtil.getContextLocales((Context)ctx);
            HashMap<String, ActivityInstInfo> actInsts = new HashMap<String, ActivityInstInfo>();
            String procInstID = this.processInstInfo.getProcInstId();
            ActivityInstInfo[] actInstInfos = this.engine.getActInstMetaArrayByProcInstId(procInstID);
            block2: for (int i = 0; i < actInstInfos.length; ++i) {
                for (int j = 0; j < locales.length; ++j) {
                    String currentName = actInstInfos[i].getActDefName(locales[j]);
                    if (currentName == null || !currentName.equals(actDefName)) continue;
                    actInsts.put(actInstInfos[i].getActInstId(), actInstInfos[i]);
                    continue block2;
                }
            }
            ActivityInstInfo lastActInst = null;
            for (ActivityInstInfo actInst : actInsts.values()) {
                if (lastActInst == null) {
                    lastActInst = actInst;
                    continue;
                }
                if (actInst.getCreatedTime().compareTo(lastActInst.getCreatedTime()) <= 0) continue;
                lastActInst = actInst;
            }
            return lastActInst;
        }
        catch (Throwable t) {
            logger.warn((Object)"error occured", t);
            return null;
        }
    }

    public String getTopConstituent(String actDefName) {
        try {
            String forwardPath;
            ActivityInstInfo actInst = this.getActvityInstInfo(actDefName);
            if (actInst == null) {
                return "";
            }
            String actInstIdStr = actInst.getActInstId().toString();
            String constituent = "";
            WorkItemStorer storer = this.engine.getStoreManager().getWorkItemStorer();
            AssignmentInfo assignment = storer.getLastCompletedAssignment(actInstIdStr);
            while (assignment != null && (forwardPath = assignment.getForwardPath()) != null && forwardPath.length() > 0) {
                String fromAssignmentIsStr;
                ForwardStep forwardStep = new ForwardStep();
                forwardStep.initial(forwardPath);
                if (!"devolve".equals(forwardStep.getType()) || (fromAssignmentIsStr = forwardStep.getFromAssignment()) == null || fromAssignmentIsStr.length() <= 0 || (assignment = storer.getWorkItem(fromAssignmentIsStr)) == null) break;
                constituent = assignment.getUserId();
            }
            return constituent;
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public String getPreviousConstituent(String actDefName) {
        try {
            ActivityInstInfo actInst = this.getActvityInstInfo(actDefName);
            if (actInst == null) {
                return "";
            }
            String actInstIdStr = actInst.getActInstId().toString();
            WorkItemStorer storer = this.engine.getStoreManager().getWorkItemStorer();
            AssignmentInfo assignment = storer.getLastCompletedAssignment(actInstIdStr);
            if (assignment == null) {
                return "";
            }
            String forwardPath = assignment.getForwardPath();
            if (forwardPath == null || forwardPath.length() <= 0) {
                return "";
            }
            ForwardStep forwardStep = new ForwardStep();
            forwardStep.initial(forwardPath);
            if (!"devolve".equals(forwardStep.getType())) {
                return "";
            }
            String fromAssignmentIsStr = forwardStep.getFromAssignment();
            if (fromAssignmentIsStr == null || fromAssignmentIsStr.length() <= 0) {
                return "";
            }
            AssignmentInfo fromAssignment = storer.getWorkItem(fromAssignmentIsStr);
            if (fromAssignment == null) {
                return "";
            }
            return fromAssignment.getUserId();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public String getBillEntryInfoBySelectItem(String billId, String[] head, String[] selector) {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append("<table style=\"color:#535353\" width=\"100%\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\" bordercolor=\"#CBD9EB\" bordercolordark=\"#FFFFFF\" bgcolor=\"#FFFFFF\"><tr style=\"font-size:9pt\" align=\"center\">");
            SelectorItemInfo item = null;
            SelectorItemCollection col = new SelectorItemCollection();
            for (int i = 0; i < selector.length; ++i) {
                item = new SelectorItemInfo("entries." + selector[i]);
                col.add(item);
                buffer.append("<td style=\"padding:5px;background-color:#D2E3F3;color:#427DA9;\"><b>").append(head[i] != null ? head[i] : "").append("</b></td>");
            }
            buffer.append("</tr>");
            IObjectValue billEntryInfo = ScriptUtil.getBizObject(this.engine.context(), billId, col);
            AbstractObjectCollection entryCol = (AbstractObjectCollection)billEntryInfo.get("entries");
            IObjectValue entryInfo = null;
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumFractionDigits(2);
            for (int j = 0; j < entryCol.size(); ++j) {
                entryInfo = entryCol.getObject(j);
                buffer.append("<tr align=\"left\" style=\"font-size:9pt\" >");
                for (int k = 0; k < selector.length; ++k) {
                    IObjectValue objectValue = entryInfo;
                    String[] propertiesStr = selector[k].split("\\.");
                    int length = propertiesStr.length;
                    for (int m = 0; m < length - 1; ++m) {
                        if (objectValue == null) continue;
                        objectValue = (IObjectValue)objectValue.get(propertiesStr[m]);
                    }
                    if (objectValue != null) {
                        Object tempObj = objectValue.get(propertiesStr[length - 1]);
                        if (tempObj != null) {
                            if (tempObj instanceof Number) {
                                buffer.append("<td align=\"right\" style=\"padding:5px;\">").append(nf.format(tempObj)).append("</td>");
                                continue;
                            }
                            buffer.append("<td style=\"padding:5px;\">").append(tempObj.toString()).append("</td>");
                            continue;
                        }
                        buffer.append("<td style=\"padding:5px;\">&nbsp;</td>");
                        continue;
                    }
                    buffer.append("<td style=\"padding:5px;\">&nbsp;</td>");
                }
                buffer.append("</tr>");
            }
            buffer.append("</table>");
        }
        catch (WfException e) {
            logger.error((Object)"out put billentry info error", (Throwable)e);
        }
        return buffer.toString();
    }
}

