/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.bos.service.job.util.Xml;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.SubmitAssignResult;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.WfLogConfig;
import com.kingdee.bos.workflow.biz.BizProcInfo;
import com.kingdee.bos.workflow.biz.DefaultBizProcFinder;
import com.kingdee.bos.workflow.biz.FunctionHelper;
import com.kingdee.bos.workflow.biz.IBizProcFinder;
import com.kingdee.bos.workflow.biz.WfBizEvent;
import com.kingdee.bos.workflow.biz.WfDirectCreateProcessEvent;
import com.kingdee.bos.workflow.biz.event.WfEventProducer;
import com.kingdee.bos.workflow.botp.IBotpProvider;
import com.kingdee.bos.workflow.cleaner.ProcessContextCleaner;
import com.kingdee.bos.workflow.cust.app.impl.WfRoleUtils;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityEvent;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.AssignmentEvent;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.ConditionDef;
import com.kingdee.bos.workflow.define.ConditionType;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.ExpressionCollection;
import com.kingdee.bos.workflow.define.ExpressionDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessEvent;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.enactment.ApplicationRunState;
import com.kingdee.bos.workflow.enactment.BufferedAssignmentChecker;
import com.kingdee.bos.workflow.enactment.ErrMessageSender;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.RuntimeSystemVariable;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfCorrelationMatchMgr;
import com.kingdee.bos.workflow.enactment.WfDefinitionMgr;
import com.kingdee.bos.workflow.enactment.WfEventService;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.enactment.WfProcessServiceMgr;
import com.kingdee.bos.workflow.enactment.WfRuntimeStat;
import com.kingdee.bos.workflow.enactment.cache.IWfCacheManager;
import com.kingdee.bos.workflow.enactment.cache.WfCacheManagerTxWapper;
import com.kingdee.bos.workflow.enactment.message.WfMessageManager;
import com.kingdee.bos.workflow.enactment.message.WfMessageSender;
import com.kingdee.bos.workflow.enactment.queue.impl.WfTransQueueEntry;
import com.kingdee.bos.workflow.enactment.trace.WfLogUtils;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.engine.core.FlowContextLoader;
import com.kingdee.bos.workflow.engine.core.FlowProfileLoader;
import com.kingdee.bos.workflow.engine.core.IFlowCache;
import com.kingdee.bos.workflow.engine.core.IFlowParser;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.ThreadCache;
import com.kingdee.bos.workflow.engine.core.thread.DumpBizAlterInfo;
import com.kingdee.bos.workflow.engine.core.thread.WfAssignEventHandler;
import com.kingdee.bos.workflow.engine.core.thread.WfAssignExecutor;
import com.kingdee.bos.workflow.engine.core.thread.WfBizEventHandler;
import com.kingdee.bos.workflow.engine.core.thread.WfDirectCreateProcessEventHandler;
import com.kingdee.bos.workflow.event.WfEvent;
import com.kingdee.bos.workflow.event.WfEventPolicy;
import com.kingdee.bos.workflow.exception.BizObjectNotFoundException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.bos.workflow.exception.TransactionRollbackException;
import com.kingdee.bos.workflow.exception.engine.WfEngineNotRunningException;
import com.kingdee.bos.workflow.extscheme.mailApprove.microsoft.MicroSoftGraphWorker;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.DataTypeEnum;
import com.kingdee.bos.workflow.metas.EventProcMetaInfo;
import com.kingdee.bos.workflow.metas.IOption;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.OptionFactory;
import com.kingdee.bos.workflow.metas.OptionInfo;
import com.kingdee.bos.workflow.metas.OptionType;
import com.kingdee.bos.workflow.metas.ProcInstBizObjInfo;
import com.kingdee.bos.workflow.metas.ProcInstInfo;
import com.kingdee.bos.workflow.metas.ProcessDefOperationEnum;
import com.kingdee.bos.workflow.metas.ProcessInstEventEnum;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.ParticipantProviderFactory;
import com.kingdee.bos.workflow.participant.PerformerType;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.participant.PersonAllInfo;
import com.kingdee.bos.workflow.security.IPermissionProvider;
import com.kingdee.bos.workflow.service.WorkCalendarService;
import com.kingdee.bos.workflow.store.ActivityStorer;
import com.kingdee.bos.workflow.store.EventStorer;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.store.StoreManager;
import com.kingdee.bos.workflow.store.WorkItemStorer;
import com.kingdee.bos.workflow.timeliness.TimelinessProvider;
import com.kingdee.bos.workflow.transaction.SnapshotRecorder;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.bos.workflow.util.PermissionUtil;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.bos.workflow.util.WfDbUtil;
import com.kingdee.bos.workflow.util.WfRoleInvoke;
import com.kingdee.bos.workflow.util.WorkflowClusterConfig;
import com.kingdee.bos.workflow.util.WorkflowLogUtil;
import com.kingdee.bos.workflow.util.WorkflowUtils;
import com.kingdee.bos.workflow.workcalendar.IWorkCalendarDayProvider;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.LowTimer;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.objbuddy.BuddyObjectFactory;
import com.kingdee.util.objbuddy.IBuddyObject;
import com.kingdee.util.profile.ObjectProfileInterceptor;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WfEngine {
    public static final String LAST_PROCESSED_ASSIGN = "$LAST_PROCESSED_ASSIGN$";
    private final IBuddyObject buddy;
    protected static final Logger logger = Logger.getLogger(WfEngine.class);
    private static final String FLOW_PARSER = "com.kingdee.bos.workflow.engine.parser.FlowParser";
    private static final String FLOW_CACHE = "com.kingdee.bos.workflow.engine.adapter.FlowCache";
    private static IFlowParser parser;
    private static ConcurrentHashMap engineMap;
    private StoreManager storeManger;
    private WfDefinitionMgr definitionMgr;
    private String wfEngineKey;
    private String wfSolution;
    private String wfAis;
    private WfMessageManager wfMessageManager;
    private WfMessageSender wfMessageSender;
    private IWfCacheManager cacheMgr;
    private ArrayList eventPolicies = new ArrayList();
    private Locale locale;
    private Context context;
    private IParticipantProvider participantProvider;
    private IPermissionProvider permissionProvider;
    private IBotpProvider botpProvider;
    private IWorkCalendarDayProvider workCalendarDayProvider;
    private IBizProcFinder bizProcFinder;
    public static final int NOT_RUNNING = 0;
    public static final int RUNNING = 1;
    private int state = 0;
    private WfLogConfig logConfig = new WfLogConfig();
    private WfLogger wfLogger;
    private Context initCtx;
    public Date createdDate = new Date();
    private WfEventProducer eventProducer;
    private WfProcessServiceMgr processServiceMgr;
    private WfCorrelationMatchMgr correlationMatchMgr;
    private HashMap applicationRunState;
    private IFlowCache flowCache;
    private FlowContextLoader flowContextLoader;
    private FlowProfileLoader profileLoader;
    private volatile long usedTime = 0L;
    private volatile int newProcessInstCount = 0;
    private volatile int completeProcessInstCount = 0;
    private WfEventService eventSvc = new WfEventService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearInvalidTransqueue(Context ctx) {
        Statement smt;
        Connection cn;
        block4: {
            cn = null;
            smt = null;
            try {
                cn = WfDbUtil.getConnection((Context)ctx);
                smt = cn.createStatement();
                String sql = "delete from t_wfr_transqueque where not exists(select fprocinstid from t_wfr_procinst where fprocinstid=t_wfr_transqueque.fprocinstid)";
                int i = WfEngine.executeUpdate(sql, smt);
                if (i <= 0) break block4;
                String msg = "{" + i + "} transqueue items were deleted because their procinsts were lost!";
                logger.warn((Object)msg);
            }
            catch (Throwable t) {
                try {
                    logger.warn((Object)"remove invalid transqueue items failed!", t);
                }
                catch (Throwable throwable) {
                    WfDbUtil.cleanup(smt, (Connection)cn);
                    throw throwable;
                }
                WfDbUtil.cleanup((Statement)smt, (Connection)cn);
            }
        }
        WfDbUtil.cleanup((Statement)smt, (Connection)cn);
    }

    private WfEngine(String key) throws WfException {
        String solution = key.substring(key.indexOf(124) + 1);
        String ais = key.substring(0, key.indexOf(124));
        if (ais == null || ais.length() == 0) {
            throw new IllegalArgumentException("ais is empty");
        }
        if (solution == null || solution.length() == 0) {
            throw new IllegalArgumentException("solution is empty");
        }
        this.wfAis = ais;
        this.wfSolution = solution;
        this.createdDate = new Date();
        this.wfEngineKey = key;
        if (this.getLocale() == null) {
            this.setLocale(new Locale("l2"));
        }
        this.initFlowCache();
        this.flowContextLoader = new FlowContextLoader(this.context());
        this.profileLoader = new FlowProfileLoader(this.context());
        WfEngine.clearInvalidTransqueue(this.context());
        this.init();
        this.applicationRunState = new HashMap();
        this.buddy = BuddyObjectFactory.getInstance((Object)this);
        try {
            this.buddy.initialize();
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
        }
    }

    private void initFlowCache() throws WfException {
        try {
            Class<?> cls = Class.forName(FLOW_CACHE);
            this.flowCache = (IFlowCache)cls.newInstance();
            this.flowCache.setEngine(this);
        }
        catch (Exception e) {
            logger.error((Object)"{com.kingdee.bos.workflow.engine.adapter.FlowCache}\u6ca1\u6709\u90e8\u7f72!", (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    private void initStoreManager() {
        this.storeManger = new StoreManager(this);
    }

    private void initContext() {
        Context ctx = this.context();
        if (this.initCtx == null) {
            this.initCtx = ctx;
        }
    }

    private void initLogConfig() {
        this.setLogConfig(EngineConfig.getInstance().getLogConfig());
    }

    private void initCachManager() throws WfException {
        this.cacheMgr = new WfCacheManagerTxWapper(this);
        this.cacheMgr.init();
    }

    private void initWfLogger() {
        this.wfLogger = new WfLogger(this.storeManger);
    }

    private void logEngineCreationEvent() {
        if (this.wfLogger.checkLogLevel(LogTypeEnum.INFO)) {
            return;
        }
        try {
            this.wfLogger.addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CREATE, "engine init.", "");
        }
        catch (Throwable e) {
            logger.warn((Object)"WfLogger error.", e);
        }
    }

    private void initDefinitionMgr() {
        this.definitionMgr = new WfDefinitionMgr(this);
    }

    private void initPariticipantProvider() throws WfException {
        this.participantProvider = this.getPariticipantProvider();
    }

    private void initMessageManager() {
        if (this.wfMessageManager == null) {
            this.wfMessageManager = new WfMessageManager();
        }
    }

    private void initMessageSender() throws WfException {
        if (this.wfMessageSender == null) {
            this.wfMessageSender = new WfMessageSender(this);
        }
        this.wfMessageSender.init();
    }

    private void init() throws WfException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("workflow engine begin init, ais : " + this.getEngineAis() + ", solution : " + this.getEngineSolution()));
        }
        Mutex.init(this.context());
        this.initStoreManager();
        this.initContext();
        this.initLogConfig();
        this.initWfLogger();
        this.logEngineCreationEvent();
        this.initDefinitionMgr();
        this.initMessageManager();
        this.initMessageSender();
        this.initCommonEventRelation();
        this.initProcessServiceMgr();
        this.initCorrelationMatchMgr();
        WfEngine.initWfEventHandlers(this);
        this.initCachManager();
        this.initPariticipantProvider();
        this.initDumpBizAlterInfo();
        this.initMailApproveWorker();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("workflow engine end init, ais : " + this.getEngineAis() + ", solution : " + this.getEngineSolution()));
        }
    }

    private void initDumpBizAlterInfo() {
        DumpBizAlterInfo.enqueue(this.context());
    }

    private void initMailApproveWorker() {
        ORMServiceLocation loc = new ORMServiceLocation("license");
        if (loc.isLocal()) {
            MicroSoftGraphWorker dispatchTask = new MicroSoftGraphWorker(this.context);
            Thread t = new Thread(dispatchTask);
            t.setName("MicroSoftGraphWorker_" + this.context.getAIS());
            t.start();
        }
    }

    private void initCleaner() {
        ORMServiceLocation loc = new ORMServiceLocation("license");
        if (loc.isLocal()) {
            ProcessContextCleaner.enqueue(this.context());
        }
    }

    private void initProcessServiceMgr() throws WfException {
        this.processServiceMgr = new WfProcessServiceMgr(this);
    }

    private void initCorrelationMatchMgr() {
        this.correlationMatchMgr = new WfCorrelationMatchMgr(this);
    }

    private void initCommonEventRelation() {
        this.eventProducer = new WfEventProducer(this);
    }

    public static IFlowParser getFlowParser() {
        return parser;
    }

    public static String getFlowDescription(ProcessDef def) {
        Flow flow = WfEngine.getFlowParser().parse(def);
        StringBuffer sb = new StringBuffer();
        sb.append("\r\n\r\n<!--").append(flow.dumpDiagram()).append("-->");
        sb.append("\r\n\r\n<!--").append(flow.dumpMicroPrograms()).append("-->");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WfEngine getEngine(String key, Context ctx) throws WfException {
        WfEngine engine = null;
        if (engineMap.containsKey((Object)key)) {
            engine = (WfEngine)engineMap.get((Object)key);
            if (ctx != null) {
                engine.setContext(ctx);
            }
            if (1 != engine.getState()) {
                throw new WfEngineNotRunningException("WfEngine[" + key + "] is not running!");
            }
            return engine;
        }
        Class<WfEngine> clazz = WfEngine.class;
        synchronized (WfEngine.class) {
            ConcurrentHashMap concurrentHashMap = engineMap;
            synchronized (concurrentHashMap) {
                if (engineMap.containsKey((Object)key)) {
                    engine = (WfEngine)engineMap.get((Object)key);
                } else {
                    engine = new WfEngine(key);
                    engine.start();
                    engineMap.put((Object)key, (Object)engine);
                }
            }
            if (1 != engine.getState()) {
                throw new WfEngineNotRunningException("WfEngine[" + key + "] is not running!");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return engine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WfEngine getEnginenew(String key) throws WfException {
        WfEngine engine = null;
        if (engineMap.containsKey((Object)key)) {
            engine = (WfEngine)engineMap.get((Object)key);
            return engine;
        }
        Class<WfEngine> clazz = WfEngine.class;
        synchronized (WfEngine.class) {
            ConcurrentHashMap concurrentHashMap = engineMap;
            synchronized (concurrentHashMap) {
                if (engineMap.containsKey((Object)key)) {
                    engine = (WfEngine)engineMap.get((Object)key);
                } else {
                    engine = new WfEngine(key);
                    engine.start();
                    engineMap.put((Object)key, (Object)engine);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return engine;
        }
    }

    public static WfEngine getEngine(String ais, String solution) throws WfException {
        if (solution == null) {
            solution = "eas";
        }
        return WfEngine.getEngine(ais + "|" + solution);
    }

    public static WfEngine getEngine(String key) throws WfException {
        return WfEngine.getEngine(key, (Context)null);
    }

    public static WfEngine getEngine(Context ctx) throws WfException {
        String ais = ctx.getAIS();
        String solution = ctx.getSolution();
        if (solution == null) {
            solution = "eas";
        }
        String key = ais + "|" + solution;
        WfEngine engine = WfEngine.getEngine(key, ctx);
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exist(String ais, String solution) throws WfException {
        Class<WfEngine> clazz = WfEngine.class;
        synchronized (WfEngine.class) {
            ConcurrentHashMap concurrentHashMap = engineMap;
            synchronized (concurrentHashMap) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return engineMap.containsKey((Object)(ais + "|" + solution));
            }
        }
    }

    public Context getInitContext() {
        return this.initCtx;
    }

    public WfLogger getWfLogger() {
        return this.wfLogger;
    }

    public WfLogConfig getLogConfig() {
        return this.logConfig;
    }

    public void setLogConfig(WfLogConfig logConfig) {
        this.logConfig = logConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void clearCacheAll() throws WfException {
        if (engineMap == null || engineMap.size() <= 0) return;
        Class<WfEngine> clazz = WfEngine.class;
        synchronized (WfEngine.class) {
            ConcurrentHashMap concurrentHashMap = engineMap;
            synchronized (concurrentHashMap) {
                for (WfEngine engine : engineMap.values()) {
                    if (engine == null) continue;
                    engine.clearCache();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void clearCache() throws WfException {
        this.cacheMgr.cleanUp();
        this.buddy.operationPerformed("clearCache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPermissionProvider getPermissionProvider() {
        if (this.permissionProvider != null) {
            return this.permissionProvider;
        }
        WfEngine wfEngine = this;
        synchronized (wfEngine) {
            String permissionProviderClassName;
            if (this.permissionProvider == null && (permissionProviderClassName = EngineConfig.getInstance().getPermissionProvider()) != null) {
                try {
                    Class<?> permissionProviderClass = Class.forName(permissionProviderClassName);
                    this.permissionProvider = (IPermissionProvider)permissionProviderClass.newInstance();
                }
                catch (IllegalAccessException ex1) {
                    logger.warn((Object)("PraticipantProvider init error. Cause: " + ex1.getMessage()));
                    throw new IllegalArgumentException("not found PermissionProvider[" + permissionProviderClassName + "]!");
                }
                catch (InstantiationException ex1) {
                    logger.warn((Object)("PraticipantProvider init error. Cause: " + ex1.getMessage()));
                    throw new IllegalArgumentException("not found PermissionProvider[" + permissionProviderClassName + "]!");
                }
                catch (ClassNotFoundException ex1) {
                    logger.warn((Object)("PraticipantProvider init error. Cause: " + ex1.getMessage()));
                    throw new IllegalArgumentException("not found PermissionProvider[" + permissionProviderClassName + "]!");
                }
            }
            return this.permissionProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBotpProvider getBotpProvider() {
        if (this.botpProvider != null) {
            return this.botpProvider;
        }
        WfEngine wfEngine = this;
        synchronized (wfEngine) {
            String botpProviderClassName;
            if (this.botpProvider == null && (botpProviderClassName = EngineConfig.getInstance().getBotpProvider()) != null) {
                try {
                    Class<?> botpProviderClass = Class.forName(botpProviderClassName);
                    this.botpProvider = (IBotpProvider)botpProviderClass.newInstance();
                }
                catch (IllegalAccessException ex1) {
                    logger.warn((Object)("BotpProvider init error. Cause: " + ex1.getMessage()));
                    throw new IllegalArgumentException("not found BotpProvider[" + botpProviderClassName + "]!");
                }
                catch (InstantiationException ex1) {
                    logger.warn((Object)("BotpProvider init error. Cause: " + ex1.getMessage()));
                    throw new IllegalArgumentException("not found BotpProvider[" + botpProviderClassName + "]!");
                }
                catch (ClassNotFoundException ex1) {
                    logger.warn((Object)("BotpProvider init error. Cause: " + ex1.getMessage()));
                    throw new IllegalArgumentException("not found BotpProvider[" + botpProviderClassName + "]!");
                }
            }
            return this.botpProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkCalendarDayProvider getWorkCalendarDayProvider() {
        if (this.workCalendarDayProvider != null) {
            return this.workCalendarDayProvider;
        }
        WfEngine wfEngine = this;
        synchronized (wfEngine) {
            if (this.workCalendarDayProvider == null) {
                String workCalendarDayProviderClassName = EngineConfig.getInstance().getWorkCalendarDayProvider();
                if (workCalendarDayProviderClassName != null && workCalendarDayProviderClassName.length() != 0) {
                    try {
                        Class<?> workCalendarDayProviderClass = Class.forName(workCalendarDayProviderClassName);
                        this.workCalendarDayProvider = (IWorkCalendarDayProvider)workCalendarDayProviderClass.newInstance();
                    }
                    catch (IllegalAccessException ex1) {
                        logger.warn((Object)("WorkCalendarDayProvider init error. Cause: " + ex1.getMessage()));
                        throw new IllegalArgumentException("not found WorkCalendarDayProvider[" + workCalendarDayProviderClassName + "]!");
                    }
                    catch (InstantiationException ex1) {
                        logger.warn((Object)("WorkCalendarDayProvider init error. Cause: " + ex1.getMessage()));
                        throw new IllegalArgumentException("not found WorkCalendarDayProvider[" + workCalendarDayProviderClassName + "]!");
                    }
                    catch (ClassNotFoundException ex1) {
                        logger.warn((Object)("WorkCalendarDayProvider init error. Cause: " + ex1.getMessage()));
                        throw new IllegalArgumentException("not found WorkCalendarDayProvider[" + workCalendarDayProviderClassName + "]!");
                    }
                } else {
                    this.workCalendarDayProvider = WorkCalendarService.getInstance();
                }
            }
            return this.workCalendarDayProvider;
        }
    }

    public String getServerKey() {
        return EngineConfig.getInstance().getServerKey();
    }

    public String getEngineAis() {
        return this.wfAis;
    }

    public String getEngineKey() {
        return this.wfEngineKey;
    }

    public String getEngineSolution() {
        return this.wfSolution;
    }

    private String getMessageTitle(Locale local, String userID, WfBizEvent event) throws WfException {
        StringBuffer titlebuffer = new StringBuffer();
        titlebuffer.append("\u6267\u884c \u4e1a\u52a1\u529f\u80fd\uff1a[ ");
        FunctionObjectInfo functionInfo = FunctionHelper.getFunctionObjectInfo(this.context, event.getFuncName());
        String functionAlias = FunctionHelper.getFunctionAlias(functionInfo);
        titlebuffer.append(functionAlias != null ? functionAlias : event.getFuncName());
        titlebuffer.append(" ],  \u4e1a\u52a1\u64cd\u4f5c\uff1a[ ");
        String operationAlias = FunctionHelper.getFunctionOperationAlias(functionInfo, event.getOperationName());
        titlebuffer.append(operationAlias != null || !"".equals(operationAlias) ? operationAlias : event.getOperationName());
        titlebuffer.append(" ] . \u7531\u4e8e\u60a8\u7684\u7528\u6237\u6ca1\u6709\u7ed1\u5b9a\u4eba\u5458\uff0c\u65e0\u6cd5\u542f\u52a8\u6d41\u7a0b");
        titlebuffer.append("\n\u8c03\u8bd5\u4fe1\u606f\uff1a");
        titlebuffer.append(event.getFuncName() + " : " + event.getOperationName());
        return titlebuffer.toString();
    }

    public void acceptEventSupport(WfBizEvent event) throws WfException {
        try {
            this.acceptEvent(event);
        }
        catch (TransactionRollbackException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.warn((Object)t.getMessage(), t);
            if (!StringUtils.isEmpty((String)event.getAssignmentId())) {
                try {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("boId:" + event.getBoId()).append("\n");
                    buffer.append("assignId" + event.getAssignmentId()).append("\n");
                    WfAssignment assignment = this.getAssignment(event.getAssignmentId());
                    buffer.append("errorStackTrace" + StringUtils.stackToString((Throwable)t));
                    this.wfLogger.addWfProcessInstLog(LogTypeEnum.ERROR, ProcessInstEventEnum.COMMON, assignment.getMeta().getProcInstId(), buffer.toString());
                    this.eventService().raiseAssignmentEvent(AssignmentEvent.OnAssignmentFailed, assignment, null);
                }
                catch (Throwable t1) {
                    logger.warn((Object)t1.getMessage(), t1);
                }
            } else {
                this.wfLogger.addWfEngineLog(LogTypeEnum.ERROR, WfEngineEventEnum.ACCEPTEVENT, "create process inst error, boId:" + event.getBoId(), "create process inst error, boId:" + event.getBoId(), t);
            }
            if (t instanceof WfException) {
                throw (WfException)t;
            }
            throw new WfException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptEvent(WfBizEvent event) throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "acceptEvent", null);
        }
        try {
            long fulltime = System.currentTimeMillis();
            if (event.getAssignmentId() == null) {
                this.acceptCreateProcessInstEvent(event);
            } else {
                this.acceptAssignmentEvent(event);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("wfEngine.acceptEvent full cost: " + (System.currentTimeMillis() - fulltime)));
            }
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private void acceptCreateProcessInstEvent(WfBizEvent event) throws WfException {
        Person person;
        HashMap<String, String> boMap = new HashMap<String, String>(1);
        if (event.getBoId() != null && event.getBoId().length() > 0) {
            boMap.put(event.getBoId(), event.getBoId());
        }
        BOSUuid boid = BOSUuid.read((String)event.getBoId());
        String bosType = boid.getType().toString();
        String fullFuncName = event.getFuncName();
        String functionName = fullFuncName.substring(fullFuncName.lastIndexOf(".") + 1, fullFuncName.length());
        String packageName = fullFuncName.substring(0, fullFuncName.lastIndexOf("."));
        String actionName = event.getOperationName();
        String personId = null;
        personId = (String)event.getExtendProperty((Object)"sp_PersonId");
        if (StringUtil.isEmpty((String)personId)) {
            personId = event.getUserId();
        }
        if ((person = this.getPariticipantProvider().getPersonByUserId(this.context(), personId)) == null || person.getUserId() == null || person.getUserId().trim().length() == 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Can not start process,");
            buffer.append("because the user has no corresponding person! ");
            buffer.append("userId:");
            buffer.append(event.getUserId() + ",");
            buffer.append("boId:" + event.getBoId() + ",");
            buffer.append("fullFunctionName : ");
            buffer.append(fullFuncName + ",");
            buffer.append("action : ");
            buffer.append(actionName);
            String str = buffer.toString();
            logger.warn((Object)str);
            try {
                this.wfLogger.addWfEngineLog(LogTypeEnum.WARN, WfEngineEventEnum.CREATE, "", str);
            }
            catch (Throwable t) {
                logger.error((Object)"wflog error.", t);
            }
            return;
        }
        BizProcInfo matchedBizPorcInfo = null;
        BizProcInfo[] bizProcInfoArray = null;
        if (person.getUserId() != null && person.getEmployeeId() == null) {
            bizProcInfoArray = this.getBizProcFinder().findProcDef(person, PerformerType.USER, functionName, packageName, actionName);
        } else {
            ThreadCache.put("OBJECT_ID", event.getBoId());
            bizProcInfoArray = this.getBizProcFinder().findProcDef(person, PerformerType.EMPLOYEE, functionName, packageName, actionName);
        }
        if (bizProcInfoArray == null || bizProcInfoArray.length == 0) {
            if ("true".equals(event.getExtendProperty((Object)"CTRL_SHIFT_ALT"))) {
                throw new RuntimeException("\u627e\u4e0d\u5230\u5f53\u524d\u7528\u6237\u53ef\u53d1\u8d77\u7684\u6d41\u7a0b\uff0c\u8bf7\u68c0\u67e5\u5404\u6d41\u7a0b\u5b9a\u4e49\u7b2c\u4e00\u4e2a\u4eba\u5de5\u8282\u70b9\u7684\u53c2\u4e0e\u4eba\u548c\u4efb\u52a1\u3002");
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("\u627e\u4e0d\u5230\u5f53\u524d\u7528\u6237\u53ef\u53d1\u8d77\u7684\u6d41\u7a0b\uff0c\u8bf7\u68c0\u67e5\u5404\u6d41\u7a0b\u5b9a\u4e49\u7b2c\u4e00\u4e2a\u4eba\u5de5\u8282\u70b9\u7684\u53c2\u4e0e\u4eba\u548c\u4efb\u52a1\u3002");
            buffer.append("Can not start process, can't find matched processDef by person!");
            buffer.append("UserID:");
            buffer.append(event.getUserId());
            buffer.append(",");
            if (person.getEmployeeId() == null) {
                buffer.append("or because the user has no corresponding person! ");
            }
            buffer.append("boId:" + event.getBoId() + ",");
            buffer.append("fullFunctionName : ");
            buffer.append(fullFuncName + ",");
            buffer.append("action : ");
            buffer.append(actionName);
            try {
                this.wfLogger.addWfEngineLog(LogTypeEnum.WARN, WfEngineEventEnum.CREATE, buffer.toString(), buffer.toString());
            }
            catch (Throwable t) {
                logger.error((Object)"wflog error.", t);
            }
            return;
        }
        matchedBizPorcInfo = this.findMatchedBizProcInfo(event.getBoId(), bizProcInfoArray);
        if (matchedBizPorcInfo == null) {
            if ("true".equals(event.getExtendProperty((Object)"CTRL_SHIFT_ALT"))) {
                throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49\u7684\u542f\u52a8\u6761\u4ef6\u4e0e\u5355\u636e\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u5b9a\u4e49\u5f00\u59cb\u8282\u70b9\u7684\u51fa\u53e3\u8fde\u63a5\u4e0a\u7684\u6761\u4ef6\u3002");
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("\u6d41\u7a0b\u5b9a\u4e49\u7684\u542f\u52a8\u6761\u4ef6\u4e0e\u5355\u636e\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u5b9a\u4e49\u5f00\u59cb\u8282\u70b9\u7684\u51fa\u53e3\u8fde\u63a5\u4e0a\u7684\u6761\u4ef6\u3002");
            buffer.append("Can not start process,can't find matched processDef by condition!");
            buffer.append("UserID:");
            buffer.append(event.getUserId());
            buffer.append(",");
            buffer.append("boId:" + event.getBoId() + ",");
            buffer.append("fullFunctionName : ");
            buffer.append(fullFuncName + ",");
            buffer.append("action : ");
            buffer.append(actionName);
            try {
                this.wfLogger.addWfEngineLog(LogTypeEnum.WARN, WfEngineEventEnum.CREATE, buffer.toString(), buffer.toString());
            }
            catch (Throwable t) {
                logger.error((Object)"wflog error.", t);
            }
            return;
        }
        ProcessInstInfo[] infos = this.getProcessInstanceByHoldedObjectId(event.getBoId());
        if (infos != null) {
            for (int i = 0; i < infos.length; ++i) {
                if (!matchedBizPorcInfo.getProcDefId().equals(infos[i].getProcDefId()) || !infos[i].getState().startsWith("open.")) continue;
                if ("true".equals(event.getExtendProperty((Object)"CTRL_SHIFT_ALT"))) {
                    throw new RuntimeException("\u5f53\u524d\u5355\u636e\u5df2\u7ecf\u5728\u6d41\u7a0b\u4e2d\uff0c\u4e0d\u80fd\u89e6\u53d1\u591a\u4e2a\u6d41\u7a0b\u3002");
                }
                logger.error((Object)("bill {" + event.getBoId() + "} has triggered process instance of {" + infos[i].getProcDefId() + "}, procInstId=" + infos[i].getProcInstId()));
                StringBuffer buffer = new StringBuffer();
                buffer.append("\u5f53\u524d\u5355\u636e\u5df2\u7ecf\u5728\u6d41\u7a0b\u4e2d\uff0c\u4e0d\u80fd\u89e6\u53d1\u591a\u4e2a\u6d41\u7a0b\u3002");
                buffer.append("Can not start process,because another same procinst is running!");
                buffer.append("UserID:");
                buffer.append(event.getUserId() + ",");
                buffer.append("boId:" + event.getBoId() + ",");
                try {
                    this.wfLogger.addWfEngineLog(LogTypeEnum.WARN, WfEngineEventEnum.CREATE, matchedBizPorcInfo.getProcDefId(), false);
                }
                catch (Throwable t) {
                    logger.error((Object)"wflog error.", t);
                }
                return;
            }
        }
        try {
            WfRuntimeStat.incAssignCount();
            WfProcess process = this.createProcInst(event.getId(), event.getUserId(), matchedBizPorcInfo.getProcDefId(), matchedBizPorcInfo.getProcStartActDefId(), boMap, event.getParams(), event.getExtendProperties());
            String methodPK = (String)event.getExtendProperty((Object)"methodPK");
            if (methodPK != null) {
                String procInstId = process.getId();
                if (methodPK.contains(bosType)) {
                    methodPK = methodPK.replace(bosType, "");
                }
            }
            try {
                Map nextActs;
                Map extendProps = event.getExtendProperties();
                if (null != extendProps && extendProps.size() > 0 && (nextActs = (Map)extendProps.get("DesignateNextActivityPerformerWhenSubmit")) != null && nextActs.size() > 0) {
                    Context userCtx = (Context)extendProps.get("userCtx");
                    JSONObject jsonInfo = new JSONObject();
                    jsonInfo.put("nextActs", (Object)nextActs);
                    jsonInfo.put("assign", null);
                    jsonInfo.put("caller", (Object)new ObjectUuidPK(event.getUserId()));
                    jsonInfo.put("procinstId", (Object)process.getId());
                    jsonInfo.put("procDefHash", (Object)process.getData().getProcDefHashValue());
                    IObjectPK logPk = WorkflowLogUtil.beginLogByLocal(userCtx, WorkflowLogItem.TO_DO_LIST_NEXTACTS, jsonInfo);
                    WorkflowLogUtil.endLogByLocal(userCtx, logPk);
                }
            }
            catch (Exception e) {
                logger.error((Object)"DesignateNextActivityPerformerWhenSubmit.error:", (Throwable)e);
            }
        }
        catch (Throwable t) {
            if ("true".equals(event.getExtendProperty((Object)"CTRL_SHIFT_ALT"))) {
                throw new RuntimeException("\u521b\u5efa\u6d41\u7a0b\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + t.getMessage(), t);
            }
            try {
                if (!"true".equals(event.getExtendProperty((Object)"$HAS_SENT_ERROR_MSG$"))) {
                    event.putExtendProperty((Object)"$HAS_SENT_ERROR_MSG$", (Object)"true");
                    String procDefId = matchedBizPorcInfo.getProcDefId();
                    Locale l2 = new Locale("l2");
                    String procDefName = this.getProcessMgr(procDefId).getProcessDef().getName(l2);
                    ErrMessageSender.MessageContent content = new ErrMessageSender.MessageContent(l2, "\u521b\u5efa\u6d41\u7a0b\u5b9e\u4f8b\u5931\u8d25\uff01\u6d41\u7a0b\u540d\u79f0\uff1a" + procDefName, "\u6d41\u7a0b\u5b9a\u4e49ID\uff1a" + procDefId);
                    ErrMessageSender.send(this, event.getUserId(), new ErrMessageSender.MessageContent[]{content}, t);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (t instanceof WfException) {
                throw (WfException)t;
            }
            throw new WfException("createProcInst failed! procDefId=" + matchedBizPorcInfo.getProcDefId(), t);
        }
    }

    public void acceptAssignmentEvent(WfBizEvent event) throws WfException {
        long fulltime = System.currentTimeMillis();
        HashMap<String, String> boMap = new HashMap<String, String>(1);
        if (event.getBoId() != null && event.getBoId().length() > 0) {
            boMap.put(event.getBoId(), event.getBoId());
        }
        long time = System.currentTimeMillis();
        WfAssignment assign = this.getAssignment(event.getAssignmentId());
        if (assign.state().equals((Object)WfAssignmentState.COMPLETED) || assign.state().equals((Object)WfAssignmentState.CANCELED) || assign.state().equals((Object)WfAssignmentState.REJECTED)) {
            logger.warn((Object)("\u4efb\u52a1(" + assign.getId() + ")\u63d0\u4ea4\u6210\u529f\uff0c\u4f46\u56e0\u4e3a\u5df2\u88ab\u5904\u7406\u6216\u64a4\u6d88\u65e0\u6cd5\u6267\u884c\u3002"));
            return;
        }
        if (assign.getActInst().state().startsWith("closed")) {
            logger.warn((Object)("\u4efb\u52a1(" + assign.getId() + ")\u63d0\u4ea4\u6210\u529f\uff0c\u4f46\u56e0\u4e3a\u6d3b\u52a8\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u6267\u884c(" + assign.getActInstId() + ")\u3002"));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("acceptEvent(1) getAssignment() cost:" + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
        ProcessContext ctx = this.getProcessInst(assign.getProcInstId()).getProcessContext();
        if (event.getExtendProperties() != null) {
            Locale loacle;
            Map performers = (Map)event.getExtendProperties().get("DesignateNextActivityPerformerWhenSubmit");
            if (performers != null) {
                ctx.putDataFieldValues(performers);
            }
            if ((loacle = (Locale)event.getExtendProperty((Object)"lastRealLocale")) != null) {
                ctx.putDataFieldValue("lastRealLocale", loacle);
            }
        }
        try {
            this.executeAssignment(boMap, assign);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            if (e instanceof TransactionRollbackException) {
                throw (TransactionRollbackException)e;
            }
            if (e instanceof WfException) {
                throw (WfException)e;
            }
            throw new WfException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WfEngine.acceptEvent execute assignment total cost : " + (System.currentTimeMillis() - time) + "ms"));
        }
    }

    private BizProcInfo findMatchedBizProcInfo(String boID, BizProcInfo[] bizProcInfos) throws WfException {
        IObjectValue bizObject;
        try {
            bizObject = this.getBizObject(boID);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return this.findMatchedBizProcInfo(bizObject, bizProcInfos);
    }

    public BizProcInfo findMatchedBizProcInfo(IObjectValue bizObject, BizProcInfo[] bizProcInfos) throws WfException {
        for (BizProcInfo bizProcInfo : bizProcInfos) {
            String tStartCondition = bizProcInfo.getStartCondition();
            if (!StringUtils.isEmpty((String)tStartCondition)) {
                boolean tested = false;
                tested = "NOCONDTION".equals(tStartCondition) ? true : this.evalScript(bizObject, tStartCondition, null);
                if (tested) {
                    String orgRoleId;
                    boolean applierTest = false;
                    boolean orgTest = false;
                    String roleId = bizProcInfo.getStartRoleId();
                    if (!StringUtils.isEmpty((String)roleId)) {
                        boolean bInclude = bizProcInfo.getStartRoleInclude() == null || bizProcInfo.getStartRoleInclude().equalsIgnoreCase("Y");
                        String applierPropName = bizProcInfo.getApplierPropName();
                        try {
                            applierTest = bizProcInfo.getIsFromRole() != 0 ? WfRoleInvoke.getInstance().test(this.context, roleId, bizObject, applierPropName, bInclude) : WfRoleInvoke.getInstance().test4RoleGroupByApplier(this.context, roleId, bizObject, applierPropName, bInclude);
                        }
                        catch (Exception e) {
                            applierTest = false;
                            logger.error((Object)"\u8fde\u63a5\u5f27\u5de5\u4f5c\u6d41\u89d2\u8272\u6761\u4ef6\u5224\u65ad\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a", (Throwable)e);
                        }
                    }
                    if (!StringUtils.isEmpty((String)(orgRoleId = bizProcInfo.getOrgStartRoleId()))) {
                        boolean orgInclude = bizProcInfo.getOrgStartRoleInclude() == null || bizProcInfo.getOrgStartRoleInclude().equalsIgnoreCase("Y");
                        String orgPropName = bizProcInfo.getOrgPropName();
                        try {
                            orgTest = bizProcInfo.getOrgPropIsFromRole() != 0 ? WfRoleInvoke.getInstance().testByOrgProName(this.context, orgRoleId, bizObject, orgPropName, orgInclude) : WfRoleInvoke.getInstance().test4RoleGroupByOrgProName(this.context, orgRoleId, bizObject, orgPropName, orgInclude);
                        }
                        catch (Exception e) {
                            orgTest = false;
                            logger.error((Object)"\u8fde\u63a5\u5f27\u5de5\u4f5c\u6d41\u89d2\u8272\u6761\u4ef6\u5224\u65ad\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a", (Throwable)e);
                        }
                    }
                    if (!StringUtils.isEmpty((String)roleId) && !StringUtils.isEmpty((String)orgRoleId)) {
                        tested = applierTest && orgTest;
                    } else if (StringUtils.isEmpty((String)roleId) && StringUtils.isEmpty((String)orgRoleId)) {
                        tested = true;
                    } else {
                        boolean bl = tested = applierTest || orgTest;
                    }
                }
                if (tested) {
                    if (!this.wfLogger.checkLogLevel(LogTypeEnum.INFO)) {
                        this.wfLogger.addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.ACCEPTEVENT, "\u542f\u52a8\u6761\u4ef6\u6210\u7acb, \u6d41\u7a0b\u5b9a\u4e49Id\u4e3a" + bizProcInfo.getProcDefId(), "\u542f\u52a8\u6761\u4ef6\u6210\u7acb, \u6d41\u7a0b\u5b9a\u4e49Id\u4e3a" + bizProcInfo.getProcDefId());
                    }
                    return bizProcInfo;
                }
                if (this.wfLogger.checkLogLevel(LogTypeEnum.INFO)) continue;
                this.wfLogger.addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.ACCEPTEVENT, "\u542f\u52a8\u6761\u4ef6\u4e0d\u6210\u7acb, \u6d41\u7a0b\u5b9a\u4e49Id\u4e3a" + bizProcInfo.getProcDefId(), "\u542f\u52a8\u6761\u4ef6\u4e0d\u6210\u7acb, \u6d41\u7a0b\u5b9a\u4e49Id\u4e3a" + bizProcInfo.getProcDefId());
                continue;
            }
            WfProcessMgr wfProcessMgr = this.getProcessMgr(bizProcInfo.getProcDefId());
            if (!wfProcessMgr.getData().isEnable()) continue;
            ActivityDef startActivityDef = wfProcessMgr.getProcessDef().getActivityDef(bizProcInfo.getProcStartActDefId());
            TransitionCollection transitionCollection = startActivityDef.getIncomingTransitions();
            StartActivityDef start = wfProcessMgr.getProcessDef().getStartActivity();
            TransitionDef transitionDef = null;
            for (int j = 0; j < transitionCollection.size(); ++j) {
                TransitionDef tmp = transitionCollection.get(j);
                if (!tmp.getFrom().equals(start)) continue;
                transitionDef = tmp;
                break;
            }
            if (transitionDef == null) continue;
            if (ConditionType.CONDITION.equals((Object)transitionDef.getCondition().getConditionType())) {
                ConditionDef conditionDef = transitionDef.getCondition();
                ExpressionCollection expressionCollection = conditionDef.getXpressionList();
                boolean conditionIsEmpty = false;
                ExpressionDef express = null;
                if (expressionCollection == null || expressionCollection.size() == 0) {
                    conditionIsEmpty = true;
                } else {
                    express = expressionCollection.get(0);
                    if (express == null || StringUtils.isEmpty((String)express.toString())) {
                        conditionIsEmpty = true;
                    }
                }
                boolean tested = true;
                if (!conditionIsEmpty && express != null) {
                    tested = this.evalScript(bizObject, express.toString(), wfProcessMgr.getProcessDef());
                }
                if (tested) {
                    boolean applierTest = false;
                    boolean orgTest = false;
                    String roleId = conditionDef.getWfRoleId();
                    String applierPropertyName = conditionDef.getWfrAppl();
                    if (!StringUtils.isEmpty((String)roleId) && !StringUtils.isEmpty((String)applierPropertyName)) {
                        boolean bInclude = conditionDef.isIncludeRole();
                        try {
                            applierTest = bizProcInfo.getIsFromRole() != 0 ? WfRoleInvoke.getInstance().test(this.context, roleId, bizObject, applierPropertyName, bInclude) : WfRoleInvoke.getInstance().test4RoleGroupByApplier(this.context, roleId, bizObject, applierPropertyName, bInclude);
                        }
                        catch (Exception e) {
                            applierTest = false;
                            logger.error((Object)("\u8fde\u63a5\u5f27\u5de5\u4f5c\u6d41\u89d2\u8272\u6761\u4ef6\u5224\u65ad\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage()));
                        }
                    }
                    String orgRoleId = conditionDef.getOrgWfRoleId();
                    String orgPropName = conditionDef.getWFROrgAttribute();
                    if (!StringUtils.isEmpty((String)orgRoleId) && !StringUtils.isEmpty((String)orgPropName)) {
                        boolean orgInclude = conditionDef.isOrgIncludeRole();
                        try {
                            orgTest = bizProcInfo.getOrgPropIsFromRole() != 0 ? WfRoleInvoke.getInstance().testByOrgProName(this.context, orgRoleId, bizObject, orgPropName, orgInclude) : WfRoleInvoke.getInstance().test4RoleGroupByOrgProName(this.context, orgRoleId, bizObject, orgPropName, orgInclude);
                        }
                        catch (Exception e) {
                            orgTest = false;
                            logger.error((Object)("\u8fde\u63a5\u5f27\u5de5\u4f5c\u6d41\u89d2\u8272\u6761\u4ef6\u5224\u65ad\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage()));
                        }
                    }
                    if (!StringUtils.isEmpty((String)roleId) && !StringUtils.isEmpty((String)orgRoleId)) {
                        tested = applierTest && orgTest;
                    } else if (StringUtils.isEmpty((String)roleId) && StringUtils.isEmpty((String)orgRoleId)) {
                        tested = true;
                    } else {
                        boolean bl = tested = applierTest || orgTest;
                    }
                }
                if (tested) {
                    if (!this.wfLogger.checkLogLevel(LogTypeEnum.INFO)) {
                        this.wfLogger.addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.ACCEPTEVENT, "\u542f\u52a8\u6761\u4ef6\u6210\u7acb, \u6d41\u7a0b\u5b9a\u4e49Id\u4e3a" + bizProcInfo.getProcDefId(), "\u542f\u52a8\u6761\u4ef6\u6210\u7acb, \u6d41\u7a0b\u5b9a\u4e49Id\u4e3a" + bizProcInfo.getProcDefId());
                    }
                    return bizProcInfo;
                }
                if (this.wfLogger.checkLogLevel(LogTypeEnum.INFO)) continue;
                this.wfLogger.addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.ACCEPTEVENT, "\u542f\u52a8\u6761\u4ef6\u4e0d\u6210\u7acb, \u6d41\u7a0b\u5b9a\u4e49Id\u4e3a" + bizProcInfo.getProcDefId(), "\u542f\u52a8\u6761\u4ef6\u4e0d\u6210\u7acb, \u6d41\u7a0b\u5b9a\u4e49Id\u4e3a" + bizProcInfo.getProcDefId());
                continue;
            }
            return bizProcInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectValue getBizObject(String boID) throws SQLException, DataAccessException {
        IObjectValue iObjectValue;
        Connection cn = null;
        try {
            BOSUuid boUuid = BOSUuid.read((String)boID);
            cn = EJBFactory.getConnection((Context)this.context);
            iObjectValue = ORMappingDAO.getInstance((BOSObjectType)boUuid.getType(), (Context)this.context, (Connection)cn).getValue((IObjectPK)new ObjectUuidPK(boUuid));
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)cn);
        return iObjectValue;
    }

    private boolean evalScript(IObjectValue bizObject, String script, ProcessDef processDef) {
        Object rtnVal;
        assert (!StringUtils.isEmpty((String)script));
        Interpreter interpreter = new Interpreter(this.context());
        interpreter.setProperyExprOwnerNullIgore(true);
        try {
            HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>();
            if (processDef != null) {
                map.putAll(ScriptUtil.getInnerVariables(processDef));
            }
            map.put("__processTrigger", bizObject);
            rtnVal = interpreter.eval(script, map);
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
            return false;
        }
        if (rtnVal == null) {
            return false;
        }
        if (rtnVal instanceof Boolean) {
            return (Boolean)rtnVal;
        }
        if (rtnVal instanceof Number) {
            return ((Number)rtnVal).intValue() == 1;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trans(WfTransQueueEntry entry) throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "trans", null);
        }
        try {
            long time;
            block10: {
                time = System.currentTimeMillis();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("WfEngine.trans() : procInstId : " + entry.procInstId));
                }
                WfProcess procInst = this.getProcessInst(entry.procInstId);
                WfActivity fromActInst = this.getActivityInst(entry.fromActInstId);
                ProcessDef procDef = procInst.getDefinition();
                ActivityDef actDef = procDef.getActivityDef(entry.toActDefId.trim());
                if (actDef == null) {
                    throw new WfException("Fatal Error. can not transNext, actDef is null");
                }
                try {
                    procInst.getProcessContext().putDataFieldValue("$ISSUSPENDACTIVITYBYNOPERSON", "false");
                    procInst.transInternal(fromActInst, actDef, entry.toActInstGroup);
                }
                catch (WfException ex) {
                    if ("true".equals(procInst.getProcessContext().getDataFieldValue("$ISSUSPENDACTIVITYBYNOPERSON"))) break block10;
                    throw ex;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WfEngine.trans full cost:" + (System.currentTimeMillis() - time)));
            }
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    public Context context() {
        if (this.context == null) {
            return this.getContextInternal();
        }
        return this.context;
    }

    public Context getClonedContext() {
        try {
            return (Context)ObjectUtils.createCopy((Object)this.getContextInternal());
        }
        catch (Throwable e) {
            return this.getContextInternal();
        }
    }

    public void setContext(Context ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParticipantProvider getPariticipantProvider() throws WfException {
        if (this.participantProvider == null) {
            WfEngine wfEngine = this;
            synchronized (wfEngine) {
                if (this.participantProvider == null) {
                    this.participantProvider = ParticipantProviderFactory.getParticipantProvider(this);
                }
            }
        }
        return this.participantProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBizProcFinder getBizProcFinder() throws WfException {
        if (this.bizProcFinder == null) {
            WfEngine wfEngine = this;
            synchronized (wfEngine) {
                if (this.bizProcFinder == null) {
                    this.bizProcFinder = ProfileConfig.getInstance().logWfEngine ? (IBizProcFinder)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{IBizProcFinder.class}, (InvocationHandler)new ObjectProfileInterceptor((Object)new DefaultBizProcFinder(this))) : new DefaultBizProcFinder(this);
                }
            }
        }
        return this.bizProcFinder;
    }

    public void setParticipantProvider(IParticipantProvider provider) throws WfException {
        if (!EngineConfig.getInstance().isUT()) {
            throw new WfException("not supported!");
        }
        this.participantProvider = provider;
    }

    public ProcessInstInfo getProcessInstMeta(String procInstId) throws WfException {
        ProcessInstInfo rtnVal;
        ProcessStorer stoer = this.getStoreManager().getProcessStorer();
        try {
            rtnVal = stoer.getProcessInstance(procInstId);
        }
        catch (SQLException ex) {
            throw new WfException("can not get process instance meta from db.", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
        return rtnVal;
    }

    public ActivityInstInfo getActInstMetaById(String actInstId) throws WfException {
        ActivityStorer storer = this.getStoreManager().getActivityStorer();
        try {
            return storer.getInstance(actInstId);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    public ActivityInstInfo[] getActInstMetaArrayByProcInstId(String procInstId) throws WfException {
        ActivityStorer storer = this.getStoreManager().getActivityStorer();
        try {
            return storer.getInstanceListByProcInstId(procInstId, true);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    public ActivityInstInfo[] getActInstMetaByDefId(String actDefID, String procInstID, boolean queryHistory) throws WfException {
        ActivityStorer storer = this.getStoreManager().getActivityStorer();
        try {
            return storer.getInstance(actDefID, procInstID, queryHistory);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    public ProcessInstInfo[] getAllProcessInstances(int maxReturn, String state) throws WfException {
        ProcessStorer storer = this.getStoreManager().getProcessStorer();
        try {
            return storer.getAllProcessInstances(maxReturn, state);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    public ProcessInstInfo[] getProcessInstancesByProcDefId(String procDefId) throws WfException {
        ProcessStorer storer = this.getStoreManager().getProcessStorer();
        try {
            return storer.getProcessInstancesByProcDefId(procDefId);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    private String getParentInstId(String instId) throws WfException {
        String parentInstSQL = "SELECT FPARENTPROCINSTID from T_WFR_PROCINST where fprocinstid = ? ";
        Connection cn = null;
        PreparedStatement smt = null;
        ResultSet rs = null;
        try {
            cn = WfDbUtil.getConnection((Context)this.context());
            smt = cn.prepareStatement(parentInstSQL);
            smt.setString(1, instId);
            rs = smt.executeQuery();
            if (rs != null && rs.next()) {
                String string = rs.getString("FPARENTPROCINSTID");
                return string;
            }
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (smt != null) {
                    smt.close();
                }
                if (cn != null) {
                    cn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }

    public String getBizObjIdByProcessInstanceId(String instId) throws WfException {
        String bizObjId = this.innerGetBizObjIdByProcessInstanceId(instId);
        if (bizObjId == null || bizObjId.length() <= 0) {
            String parentInstId = this.getParentInstId(instId);
            for (int n = 0; !StringUtils.isEmpty((String)parentInstId) && n < 10 && StringUtils.isEmpty((String)(bizObjId = this.innerGetBizObjIdByProcessInstanceId(parentInstId))); ++n) {
                parentInstId = this.getParentInstId(parentInstId);
            }
        }
        return bizObjId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String innerGetBizObjIdByProcessInstanceId(String instId) throws WfException {
        String bizObjId;
        block18: {
            String temp;
            bizObjId = "";
            ArrayList<String> list = new ArrayList<String>();
            if (StringUtils.isEmpty((String)instId)) {
                throw new WfException("getBizObjIdByProcessInstanceId args instId can't be null");
            }
            try {
                Connection cn = WfDbUtil.getConnection((Context)this.context());
                Object[] values = new Object[]{instId};
                IRowSet rs = null;
                try {
                    BOSUuid id;
                    BOSObjectType type;
                    String sql = "select fbizObjId from T_WFR_ProcInstBizObj where fprocinstid= ? ";
                    rs = DbUtil.executeQuery((Context)this.context(), (String)sql, (Object[])values);
                    while (rs.next()) {
                        if (StringUtils.isEmpty((String)rs.getString(1)) || "63D30103".equals((type = (id = BOSUuid.read((String)rs.getString(1))).getType()).toString()) || "C7CEA331".equals(type.toString())) continue;
                        list.add(rs.getString(1));
                    }
                    if (list.size() == 0) {
                        sql = "select distinct fbizobjid from t_wfr_assign where fprocInstId= ? ";
                        rs = DbUtil.executeQuery((Context)this.context(), (String)sql, (Object[])values);
                        while (rs.next()) {
                            if (list.contains(rs.getString(1)) || StringUtils.isEmpty((String)rs.getString(1)) || "63D30103".equals((type = (id = BOSUuid.read((String)rs.getString(1))).getType()).toString()) || "C7CEA331".equals(type.toString())) continue;
                            list.add(rs.getString(1));
                        }
                    }
                    if (list.size() == 0) {
                        sql = "select distinct fbizobjid from t_wfr_assigndetail where fprocInstId= ? ";
                        rs = DbUtil.executeQuery((Context)this.context(), (String)sql, (Object[])values);
                        while (rs.next()) {
                            if (list.contains(rs.getString(1)) || StringUtils.isEmpty((String)rs.getString(1)) || "63D30103".equals((type = (id = BOSUuid.read((String)rs.getString(1))).getType()).toString()) || "C7CEA331".equals(type.toString())) continue;
                            list.add(rs.getString(1));
                        }
                    }
                    if (list.size() == 0) {
                        sql = "select distinct fbizobjid from t_wfr_assignhst where fprocInstId= ? ";
                        rs = DbUtil.executeQuery((Context)this.context(), (String)sql, (Object[])values);
                        while (rs.next()) {
                            if (list.contains(rs.getString(1)) || StringUtils.isEmpty((String)rs.getString(1)) || "63D30103".equals((type = (id = BOSUuid.read((String)rs.getString(1))).getType()).toString()) || "C7CEA331".equals(type.toString())) continue;
                            list.add(rs.getString(1));
                        }
                    }
                    if (list.size() == 0) {
                        sql = "select distinct frefid from T_WFR_ProcInstRef where fprocInstId= ? and ftype=1";
                        rs = DbUtil.executeQuery((Context)this.context(), (String)sql, (Object[])values);
                        while (rs.next()) {
                            if (list.contains(rs.getString(1)) || StringUtils.isEmpty((String)rs.getString(1)) || "63D30103".equals((type = (id = BOSUuid.read((String)rs.getString(1))).getType()).toString()) || "C7CEA331".equals(type.toString())) continue;
                            list.add(rs.getString(1));
                        }
                    }
                    if (list.size() == 0) {
                        sql = "select distinct frefid from T_WFR_ProcInstRefHst where fprocInstId= ? and ftype=1";
                        rs = DbUtil.executeQuery((Context)this.context(), (String)sql, (Object[])values);
                        while (rs.next()) {
                            if (list.contains(rs.getString(1)) || StringUtils.isEmpty((String)rs.getString(1)) || "63D30103".equals((type = (id = BOSUuid.read((String)rs.getString(1))).getType()).toString()) || "C7CEA331".equals(type.toString())) continue;
                            list.add(rs.getString(1));
                        }
                    }
                }
                finally {
                    cn.close();
                }
            }
            catch (Exception e) {
                throw new WfException("getBizObjIdByProcessInstanceId  Exception : " + e);
            }
            int i = 0;
            if (i >= list.size()) break block18;
            bizObjId = temp = (String)list.get(i);
        }
        return bizObjId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getProcessOwnersByProcessName(String processName) throws WfException {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isEmpty((String)processName)) {
            throw new WfException("getProcessOwnersByProcessName args processName can't be null");
        }
        try (Connection cn = WfDbUtil.getConnection((Context)this.context());){
            String sql = "select FUserId from T_WFD_WfDesignerPermission where FProcessFileName= ? ";
            Object[] values = new Object[]{processName};
            IRowSet rs = DbUtil.executeQuery((Context)this.context(), (String)sql, (Object[])values);
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            throw new WfException("getProcessOwnersByProcessName  Exception : " + e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getOpenedActivityByProcInstId(String procInstId) throws WfException {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isEmpty((String)procInstId)) {
            throw new WfException("getOpenedActivityByProcInstId args procInstId can't be null");
        }
        try (Connection cn = WfDbUtil.getConnection((Context)this.context());){
            String sql = "select factinstid from T_WFR_ActInst where fstate like 'open%' and FProcinstId= ? ";
            try (PreparedStatement smt = cn.prepareStatement(sql);){
                smt.setString(1, procInstId);
                ResultSet rs = smt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                smt = cn.prepareStatement(sql);
                sql = "select factinstid from T_WFR_ActInstHst where fstate like 'open%' and FProcinstId= ? ";
                smt.setString(1, procInstId);
                rs = smt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
            }
        }
        catch (Exception e) {
            throw new WfException("getOpenedActivityByProcInstId  Exception : " + e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProcessOwnersByUserId(String processName, ArrayList ownerIds) throws WfException {
        if (ownerIds == null) {
            throw new WfException("deleteProcessOwnersByUserId args ownerIds can't be null");
        }
        String userID = "";
        String sql = "";
        String temp = processName.substring(0, processName.lastIndexOf("."));
        String processPackage = temp.substring(0, temp.lastIndexOf("."));
        String processFileName = temp.substring(temp.lastIndexOf(".") + 1) + ".kdwf";
        String fuserId = "";
        int flockState = 1;
        String sql2 = "select FLockStatus,FUserId from t_wfd_processdef where FPackageName='" + processPackage + "' and FFileName='" + processFileName + "' and fprocdeftype<>'BACKGROUNDJOB'";
        String sql3 = "update t_wfd_processdef set fLockStatus=1 where FPackageName='" + processPackage + "' and FFileName='" + processFileName + "' and fprocdeftype<>'BACKGROUNDJOB'";
        if (ownerIds.size() > 0) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < ownerIds.size(); ++i) {
                buff.append("'" + (String)ownerIds.get(i) + "',");
            }
            userID = buff.toString();
            userID = userID.substring(0, userID.length() - 1);
            sql = "delete from T_WFD_WfDesignerPermission where FUserId not in(" + userID + ") and FProcessFileName='" + processName + "'";
        } else {
            sql = "delete from T_WFD_WfDesignerPermission where FProcessFileName='" + processName + "'";
        }
        try (Connection cn = WfDbUtil.getConnection((Context)this.context());
             Statement smt = cn.createStatement();){
            ResultSet rs1 = this.executeQuery(sql2, smt);
            while (rs1.next()) {
                flockState = rs1.getInt(1);
                fuserId = rs1.getString(2);
            }
            if (flockState == 0 && !ownerIds.contains(fuserId)) {
                WfEngine.executeUpdate(sql3, smt);
            }
            this.executeSql(sql, smt);
        }
        catch (Exception e) {
            throw new WfException("deleteProcessOwnersByUserId  Exception : " + e);
        }
    }

    private boolean executeSql(String sql, Statement smt) throws SQLException {
        return smt.execute(sql);
    }

    private static int executeUpdate(String sql3, Statement smt) throws SQLException {
        return smt.executeUpdate(sql3);
    }

    private ResultSet executeQuery(String sql, Statement smt) throws SQLException {
        return smt.executeQuery(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getProcessNamesByUserNumber(String userNumber) throws WfException {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isEmpty((String)userNumber)) {
            throw new WfException("getProcessNamesByUserNumber args userNumber can't be null");
        }
        try (Connection cn = WfDbUtil.getConnection((Context)this.context());
             Statement smt = cn.createStatement();){
            if (userNumber.equals("administrator")) {
                ResultSet rs = smt.executeQuery("select FPACKAGENAME,FFILENAME  from t_wfd_processdef ");
                while (true) {
                    if (!rs.next()) {
                        ArrayList<String> arrayList = list;
                        return arrayList;
                    }
                    list.add(rs.getString(1));
                }
            }
            String sql = "select FProcessFileName from T_WFD_WfDesignerPermission where FUserNumber='" + userNumber + "'";
            ResultSet rs1 = this.executeQuery(sql, smt);
            while (rs1.next()) {
                list.add(rs1.getString(1));
            }
            sql = "select FPACKAGENAME,FFILENAME  from t_wfd_processdef where fauthorid='" + userNumber + "'";
            ResultSet rs2 = this.executeQuery(sql, smt);
            while (rs2.next()) {
                list.add(rs2.getString(1) + "." + rs2.getString(2));
            }
            return list;
        }
        catch (Exception e) {
            throw new WfException("getProcessNamesByUserNumber  Exception : " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEmpowerment(ArrayList processes, ArrayList owners) throws WfException {
        if (processes == null || owners == null) {
            throw new WfException("processEmpowerment args processes or owners can't be null");
        }
        String sql = null;
        String process = null;
        String userID = null;
        String userNumber = null;
        try (Connection cn = WfDbUtil.getConnection((Context)this.context());
             Statement smt = cn.createStatement();){
            for (int i = 0; i < owners.size(); ++i) {
                userID = ((PersonAllInfo)owners.get(i)).getPerson().getUserId();
                userNumber = ((PersonAllInfo)owners.get(i)).getUserId();
                for (int j = 0; j < processes.size(); ++j) {
                    process = (String)processes.get(j);
                    sql = "select * from T_WFD_WfDesignerPermission where FProcessFileName='" + process + "' and FUserId='" + userID + "'";
                    ResultSet rs = this.executeQuery(sql, smt);
                    if (rs.next()) continue;
                    sql = "insert into T_WFD_WfDesignerPermission values('" + process + "','" + userID + "','" + userNumber + "',0)";
                    WfEngine.executeUpdate(sql, smt);
                }
            }
        }
        catch (Exception e) {
            throw new WfException("processEmpowerment  Exception : " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserNumberByUserId(String id) throws WfException {
        if (StringUtils.isEmpty((String)id)) {
            throw new WfException("getUserNumberByUserId args id can't be null");
        }
        String userNumber = null;
        try (Connection cn = WfDbUtil.getConnection((Context)this.context());
             Statement smt = cn.createStatement();){
            String sql = "select fnumber from t_pm_user where fid = '" + id + "'";
            ResultSet rs = this.executeQuery(sql, smt);
            while (rs.next()) {
                userNumber = rs.getString(1);
            }
        }
        catch (Exception e) {
            throw new WfException("getUserNumberByUserId  Exception : " + e);
        }
        return userNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessInstInfo[] getAllProcessInstancesByBizobjId(String bizObjID) throws WfException {
        if (StringUtils.isEmpty((String)bizObjID)) {
            throw new WfException("getAllProcessInstancesByBizobjId args bizObjID can't be null");
        }
        ArrayList<String> procinstIds = new ArrayList<String>();
        ProcessInstInfo[] infos = null;
        try {
            AssignCollection assignCollection;
            try (Connection cn = WfDbUtil.getConnection((Context)this.context());
                 Statement smt = cn.createStatement();){
                String sql = "select fprocinstid from t_wfr_procinstref where frefid='" + bizObjID + "' and ftype=1";
                ResultSet rs = this.executeQuery(sql, smt);
                while (rs.next()) {
                    procinstIds.add(rs.getString(1));
                }
                if (procinstIds.size() == 0) {
                    sql = "select fprocinstid from t_wfr_procinstrefhst where frefid='" + bizObjID + "' and ftype=1";
                    rs = this.executeQuery(sql, smt);
                    while (rs.next()) {
                        procinstIds.add(rs.getString(1));
                    }
                }
            }
            if (procinstIds.size() == 0 && (assignCollection = this.getStoreManager().getWorkItemStorer().getAllAssignInfoCollection("WHERE bizObjID ='" + bizObjID + "' ")) != null && assignCollection.size() > 0) {
                for (AssignInfo info : assignCollection) {
                    if (procinstIds.contains(info.getProcInstID().toString())) continue;
                    procinstIds.add(info.getProcInstID().toString());
                }
            }
            if (procinstIds.size() > 0) {
                String[] procInstIds = procinstIds.toArray(new String[0]);
                infos = this.getStoreManager().getProcessStorer().getProcessInstance(procInstIds, true);
            }
        }
        catch (Exception e) {
            throw new WfException("getAllProcessInstancesByBizobjId  Exception : " + e);
        }
        return infos;
    }

    public ProcessInstInfo[] getProcessInstancesByProcDefId(String procDefId, String[] selector) throws WfException {
        ProcessStorer storer = this.getStoreManager().getProcessStorer();
        try {
            return storer.getProcessInstancesByProcDefId(procDefId, selector);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    public ProcessInstInfo[] getProcessInstanceByHoldedObjectId(String bizObjId) throws WfException {
        ProcessStorer storer = this.getStoreManager().getProcessStorer();
        try {
            return storer.getProcessInstanceByHoldedObjectId(bizObjId);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    public void abortProcessByHoldedObjectId(String bizObjId) throws WfException {
        ProcessInstInfo[] procInstInfoArray = this.getProcessInstanceByHoldedObjectId(bizObjId);
        for (int i = 0; i < procInstInfoArray.length; ++i) {
            WfProcess procInst = this.getProcessInst(procInstInfoArray[i].getProcInstId());
            procInst.abort("exec method 'abortProcessByHoldedObjectId', bizObjId '" + bizObjId + "'");
        }
    }

    public ActivityInstInfo[] getActInstMetaArrayByProcInstIdAndActInstState(String procInstId, String actInstState) throws WfException {
        ActivityInstInfo[] allArray;
        ActivityStorer storer = this.getStoreManager().getActivityStorer();
        try {
            allArray = storer.getInstanceListByProcInstId(procInstId);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
        ArrayList<ActivityInstInfo> arrayList = new ArrayList<ActivityInstInfo>();
        for (int i = 0; i < allArray.length; ++i) {
            if (!allArray[i].getState().startsWith(actInstState)) continue;
            arrayList.add(allArray[i]);
        }
        ActivityInstInfo[] rtnArray = new ActivityInstInfo[arrayList.size()];
        arrayList.toArray(rtnArray);
        return rtnArray;
    }

    public ProcessInstInfo[] getProcessInstancesByParentProcInstId(String parentProcInstId) throws WfException {
        ProcessStorer storer = this.getStoreManager().getProcessStorer();
        try {
            return storer.getProcessInstancesByParentProcInstId(parentProcInstId);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    public WfProcess getProcessInst(String processInstId) throws WfException {
        return this.cacheMgr.getProcessInst(processInstId);
    }

    public AssignmentInfo[] getAssignmentByOwerId(String ownerId) throws WfException {
        WorkItemStorer storer = this.getStoreManager().getWorkItemStorer();
        try {
            return storer.getWorkItemListByOwnerId(ownerId);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (BOSException e) {
            throw new WfException("BOSException", (Throwable)e);
        }
    }

    public AssignmentInfo[] getAssignmentByActInstId(String actInstId) throws WfException {
        WorkItemStorer storer = this.getStoreManager().getWorkItemStorer();
        try {
            return storer.getWorkItemListByActInstId(actInstId);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (BOSException e) {
            throw new WfException("BOSException", (Throwable)e);
        }
    }

    public AssignmentInfo[] getAllAssignmentByActInstId(String actInstId) throws WfException {
        WorkItemStorer storer = this.getStoreManager().getWorkItemStorer();
        try {
            return storer.getWorkItemListByActInstId(actInstId, DataTypeEnum.ALL);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (BOSException e) {
            throw new WfException("BOSException", (Throwable)e);
        }
    }

    public AssignmentInfo[] getAssignmentByProcInstId(String procInstId) throws WfException {
        WorkItemStorer storer = this.getStoreManager().getWorkItemStorer();
        try {
            return storer.getWorkItemListByProcInstId(procInstId);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (BOSException e) {
            throw new WfException("BOSException", (Throwable)e);
        }
    }

    public AssignmentInfo[] getAssignmentAllByProcInstId(String procInstId) throws WfException {
        WorkItemStorer storer = this.getStoreManager().getWorkItemStorer();
        try {
            return storer.getWorkItemListByProcInstId(procInstId, DataTypeEnum.ALL);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (BOSException e) {
            throw new WfException("BOSException", (Throwable)e);
        }
    }

    public AssignmentInfo[] getWorkItemListByIds(String[] id, DataTypeEnum dataType) throws WfException {
        WorkItemStorer storer = this.getStoreManager().getWorkItemStorer();
        try {
            return storer.getWorkItemListByIds(id, dataType, null);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (BOSException e) {
            throw new WfException("BOSException", (Throwable)e);
        }
    }

    public AssignmentInfo[] getWorkItemListByIds(String[] id, DataTypeEnum dataType, String[] selectors) throws WfException {
        WorkItemStorer storer = this.getStoreManager().getWorkItemStorer();
        try {
            return storer.getWorkItemListByIds(id, dataType, selectors);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (BOSException e) {
            throw new WfException("BOSException", (Throwable)e);
        }
    }

    public AssignmentInfo[] getAssignmentByProcInstAndOwner(String procInstId, String ownerId, WfAssignmentState assignmentState) throws WfException {
        WorkItemStorer storer = this.getStoreManager().getWorkItemStorer();
        try {
            return storer.getWorkItemListByProcInstAndOwner(procInstId, ownerId, assignmentState);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (BOSException e) {
            throw new WfException("BOSException", (Throwable)e);
        }
    }

    public AssignmentInfo[] getAssignmentByProcInstAndOwner(String procInstId, String ownerId) throws WfException {
        WorkItemStorer storer = this.getStoreManager().getWorkItemStorer();
        try {
            return storer.getWorkItemListByProcInstAndOwner(procInstId, ownerId);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (BOSException e) {
            throw new WfException("BOSException", (Throwable)e);
        }
    }

    public Map<String, List<String>> getCurrentAssignIds(Context ctx, String userId, String[] billIdArr, String bizPackage, String bizFuncion, String bizOperation) throws Exception {
        WorkItemStorer storer = this.getStoreManager().getWorkItemStorer();
        try {
            return storer.getCurrentAssignIds(ctx, userId, billIdArr, bizPackage, bizFuncion, bizOperation);
        }
        catch (Exception e) {
            throw new Exception("Exception", e);
        }
    }

    public WfAssignment getAssignment(String assignId) throws WfException {
        return this.cacheMgr.getAssignment(assignId);
    }

    public AssignmentInfo getAssignmentInfo(String assignId, String[] selectors) throws WfException {
        try {
            return this.getStoreManager().getWorkItemStorer().getWorkItem(assignId, selectors);
        }
        catch (BOSException e) {
            logger.warn((Object)"get assignment info error.", (Throwable)e);
        }
        catch (SQLException e) {
            logger.warn((Object)"get assignment info error.", (Throwable)e);
        }
        return null;
    }

    public ProcessDef getProcessDef(String procDefHash) throws WfException {
        return this.cacheMgr.getProcessDef(procDefHash);
    }

    public Flow getFlow(String procDefHash) {
        return this.flowCache.getFlow(procDefHash);
    }

    public FlowContextLoader getFlowContextLoader() {
        return this.flowContextLoader;
    }

    public FlowProfileLoader getProfileLoader() {
        return this.profileLoader;
    }

    public WfActivity getActivityInst(String actInstId) throws WfException {
        return this.cacheMgr.getActivityInst(actInstId);
    }

    public WfProcessMgr getProcessMgr(String procDefId, int innerVersion) throws WfException {
        return this.cacheMgr.getProcessMgr(procDefId, innerVersion);
    }

    public WfProcessMgr getProcessMgr(String procDefId) throws WfException {
        return this.cacheMgr.getProcessMgr(procDefId);
    }

    public WfProcessMgr getProcessMgrByDocHash(String docHash) throws WfException {
        throw new WfException("TODO");
    }

    public WfDefinitionMgr getDefinitionMgr() throws WfException {
        return this.definitionMgr;
    }

    public StoreManager getStoreManager() {
        return this.storeManger;
    }

    public WfMessageManager getMessageManager() {
        return this.wfMessageManager;
    }

    public WfMessageSender getMessageSender() {
        return this.wfMessageSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void startAll() throws WfException {
        if (engineMap == null || engineMap.size() <= 0) return;
        Class<WfEngine> clazz = WfEngine.class;
        synchronized (WfEngine.class) {
            ConcurrentHashMap concurrentHashMap = engineMap;
            synchronized (concurrentHashMap) {
                for (WfEngine engine : engineMap.values()) {
                    if (engine == null) continue;
                    engine.start();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public synchronized void start() throws WfException {
        long startTime = System.currentTimeMillis();
        if (this.state == 1) {
            try {
                this.wfLogger.addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.START, "", "The engine [" + this.wfEngineKey + "] is running!");
            }
            catch (Throwable t) {
                logger.warn((Object)"wflog error.", t);
            }
            return;
        }
        this.wfLogger.start();
        WorkflowClusterConfig config = WorkflowClusterConfig.getInstance();
        if (config.isMasterSlaveType() && config.isMaster() || config.isGroupType() || config.isStandAloneType()) {
            this.initCleaner();
        }
        this.state = 1;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WfEngine Started : " + (System.currentTimeMillis() - startTime)));
        }
        this.buddy.operationPerformed("start");
        try {
            this.wfLogger.addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.START, "", "");
        }
        catch (Throwable t) {
            logger.error((Object)"wflog error.", t);
        }
    }

    public int getWorkerThreadCount() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void stopAll() throws WfException {
        if (engineMap != null && engineMap.size() > 0) {
            ConcurrentHashMap concurrentHashMap = engineMap;
            synchronized (concurrentHashMap) {
                for (WfEngine engine : engineMap.values()) {
                    if (engine == null) continue;
                    engine.stop();
                }
            }
        }
    }

    public synchronized void stop() throws WfException {
        if (this.state != 1) {
            return;
        }
        try {
            WorkflowClusterConfig config = WorkflowClusterConfig.getInstance();
            if (config.isMasterSlaveType() && config.isMaster() || config.isGroupType() || config.isStandAloneType()) {
                TimelinessProvider.getProvider(this.wfAis, this.wfSolution).shutdown();
            }
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
        }
        this.applicationRunState.clear();
        this.clearCache();
        this.wfLogger.stop();
        this.state = 0;
        this.logEngineStopEvent();
        this.buddy.operationPerformed("stop");
    }

    private void logEngineStopEvent() {
        try {
            String stack = StringUtils.stackToString((Exception)new Exception());
            this.wfLogger.addWfEngineLog(LogTypeEnum.FATAL, WfEngineEventEnum.STOP, "The engine(" + this.wfEngineKey + ") has stopped!", "The engine(" + this.wfEngineKey + ") has stopped! " + stack);
        }
        catch (Throwable t) {
            logger.warn((Object)"wflog error.", t);
        }
    }

    public synchronized void destroy() throws WfException {
        this.stop();
        this.cacheMgr.destroy();
        this.wfLogger.destroy();
        engineMap.remove((Object)this.getEngineKey());
        this.buddy.terminate();
    }

    public synchronized void restart() throws WfException {
        this.stop();
        this.start();
        this.buddy.operationPerformed("restart");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void restartAll() throws WfException {
        if (engineMap != null && engineMap.size() > 0) {
            ConcurrentHashMap concurrentHashMap = engineMap;
            synchronized (concurrentHashMap) {
                for (WfEngine engine : engineMap.values()) {
                    if (engine == null) continue;
                    engine.stop();
                    engine.start();
                }
            }
        }
    }

    public void handleEvent(WfEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("engine handle event " + event.getEventType()));
        }
        for (int i = 0; i < this.eventPolicies.size(); ++i) {
            WfEventPolicy eventPolicy = (WfEventPolicy)this.eventPolicies.get(i);
            eventPolicy.onEvent(event);
        }
    }

    public void sendEvent(WfEvent event) throws WfException {
        if (this.state == 0) {
            throw new WfException("Engine Not Runinng!");
        }
        this.wfMessageSender.sendEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventPolicy(WfEventPolicy eventpolicy) {
        ArrayList arrayList = this.eventPolicies;
        synchronized (arrayList) {
            boolean flag = true;
            for (int i = 0; i < this.eventPolicies.size(); ++i) {
                WfEventPolicy ep = (WfEventPolicy)this.eventPolicies.get(i);
                if (!eventpolicy.getId().equals(ep.getId())) continue;
                flag = false;
                break;
            }
            if (flag) {
                this.eventPolicies.add(eventpolicy);
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public AssignmentInfo checkAssignmentInfo(String businessObjId, String userId, String packageName, String functionName, String operation, String[] selectors) throws WfException {
        if (businessObjId == null) {
            return null;
        }
        LowTimer lowTimer = new LowTimer();
        BufferedAssignmentChecker checker = new BufferedAssignmentChecker(this.context);
        WfAssignment assignmentInCache = checker.checkAssignmentInCache(businessObjId, userId, packageName, functionName, operation);
        if (assignmentInCache != null) {
            if (this.getStoreManager().getWorkItemStorer().exist(assignmentInCache.getId())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("checkAssignmentInfo: found in cache. cost:" + lowTimer.msValue()));
                }
                return assignmentInCache.getMeta();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("checkAssignmentInfo: not found in cache. cost:" + lowTimer.msValue()));
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("checkAssignmentInCache. cost:" + lowTimer.msValue()));
        }
        AssignmentInfo[] rtnArray = null;
        try {
            rtnArray = this.getStoreManager().getWorkItemStorer().getActivedWorkItemListByBizInfo(businessObjId, userId, packageName, functionName, operation, selectors);
        }
        catch (SQLException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (BOSException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new WfException("BOSException", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n WfEngine.checkAssignmentInfo() cost:" + lowTimer.msValue() + "\n businessObjId: " + businessObjId + "\n userId: " + userId + "\n packageName :" + packageName + "\n functionName: " + functionName + "\n operation: " + operation + "\n ais: " + this.context().getAIS() + "\n solution: " + this.context().getSolution()));
        }
        if (rtnArray.length == 0) {
            return null;
        }
        return rtnArray[0];
    }

    public AssignmentInfo checkAssignmentInfo(String businessObjId, String userId) throws WfException {
        if (businessObjId == null) {
            return null;
        }
        BufferedAssignmentChecker checker = new BufferedAssignmentChecker(this.context);
        WfAssignment assignmentInCache = checker.checkAssignmentInCache(businessObjId, userId);
        if (assignmentInCache != null) {
            if (WfAssignmentState.ACCEPTED.equals((Object)assignmentInCache.getMeta().getState()) || WfAssignmentState.ASSIGNED.equals((Object)assignmentInCache.getMeta().getState())) {
                if (this.getStoreManager().getWorkItemStorer().exist(assignmentInCache.getId())) {
                    return assignmentInCache.getMeta();
                }
                return null;
            }
            return null;
        }
        AssignmentInfo[] rtnArray = null;
        try {
            rtnArray = this.getStoreManager().getWorkItemStorer().getActivedWorkItemListByBizInfo(businessObjId, userId, new String[0]);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException");
        }
        catch (BOSException e) {
            throw new WfException("BOSException", (Throwable)e);
        }
        if (rtnArray.length == 0) {
            return null;
        }
        return rtnArray[0];
    }

    public AssignmentInfo[] checkAssignmentInfos(String userId) throws WfException {
        AssignmentInfo[] rtnArray = null;
        try {
            rtnArray = this.getStoreManager().getWorkItemStorer().getActivedWorkItemListByBizInfo(userId, new String[]{"procInstID"});
        }
        catch (SQLException ex) {
            throw new WfException("SQLException");
        }
        catch (BOSException e) {
            throw new WfException("BOSException", (Throwable)e);
        }
        if (rtnArray.length == 0) {
            return null;
        }
        return rtnArray;
    }

    public AssignmentInfo[] checkAssignmentInfos(String businessObjId, String userId) throws WfException {
        if (businessObjId == null) {
            return null;
        }
        return this.checkAssignmentInfos(businessObjId, userId, null);
    }

    public AssignmentInfo[] checkAssignmentInfos(String businessObjId, String userId, String[] selector) throws WfException {
        if (businessObjId == null) {
            return null;
        }
        AssignmentInfo[] rtnArray = new AssignmentInfo[]{};
        try {
            rtnArray = this.getStoreManager().getWorkItemStorer().getActivedWorkItemListByBizInfo(businessObjId, userId, selector);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (BOSException e) {
            throw new WfException("BOSException", (Throwable)e);
        }
        return rtnArray;
    }

    public SubmitAssignResult[] submitAssignment(Map assignments, String userId) throws WfException {
        if (assignments == null || assignments.size() == 0 || userId == null || userId.length() == 0) {
            return new SubmitAssignResult[0];
        }
        ArrayList<SubmitAssignResult> results = new ArrayList<SubmitAssignResult>();
        for (Map.Entry entry : assignments.entrySet()) {
            String boId = (String)entry.getKey();
            AssignmentInfo assignment = entry.getValue() != null ? (AssignmentInfo)entry.getValue() : null;
            if (assignment == null) continue;
            HashMap<ObjectUuidPK, IObjectValue> boMap = new HashMap<ObjectUuidPK, IObjectValue>();
            boMap.put(FunctionHelper.createPKbyBoId(boId), FunctionHelper.createObjectValueByBoId(boId, this.context()));
            results.add(this.executeAssignment(boMap, assignment));
        }
        return results.size() > 0 ? this.listToArray(results) : new SubmitAssignResult[]{};
    }

    private SubmitAssignResult[] listToArray(List list) {
        Object[] objs = list.toArray();
        SubmitAssignResult[] rets = new SubmitAssignResult[list.size()];
        System.arraycopy(objs, 0, rets, 0, list.size());
        return rets;
    }

    public SubmitAssignResult virtualSubmitAssignment(String assignmentID) throws WfException {
        HashMap<ObjectUuidPK, IObjectValue> boMap = new HashMap<ObjectUuidPK, IObjectValue>();
        AssignmentInfo assignmentInfo = null;
        try {
            assignmentInfo = this.getStoreManager().getWorkItemStorer().getWorkItem(assignmentID);
            String bizObjIDs = assignmentInfo.getBizObjectIds();
            if (bizObjIDs != null && bizObjIDs.length() > 0) {
                String[] bizObjIDArray = StringUtils.split((String)bizObjIDs, (String)",");
                for (int i = 0; i <= bizObjIDArray.length - 1; ++i) {
                    String bizObjID = bizObjIDArray[i];
                    ObjectUuidPK pk = FunctionHelper.createPKbyBoId(bizObjID);
                    IObjectValue objectValue = FunctionHelper.createObjectValueByBoId(bizObjID, this.context());
                    boMap.put(pk, objectValue);
                }
            }
        }
        catch (SQLException e) {
            throw new WfException("SQLException", (Throwable)e);
        }
        catch (BOSException e) {
            throw new WfException("BOSException", (Throwable)e);
        }
        if (!this.wfLogger.checkLogLevel(LogTypeEnum.INFO)) {
            String procInstId = assignmentInfo.getProcInstId();
            Context ctx = this.context();
            String userId = ctx.getCaller().toString();
            String userNumber = WfLogUtils.getNumber(ctx, userId);
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("UserId=\"" + userId + "\"");
                buffer.append(";UserNumber=\"" + userNumber + "\"");
                String extendedDescription = buffer.toString();
                this.wfLogger.addWfProcessInstLog(LogTypeEnum.INFO, ProcessInstEventEnum.VIRTUALSUBMIT, procInstId, extendedDescription);
            }
            catch (Throwable e) {
                logger.warn((Object)"WfLogger error.", e);
            }
        }
        return this.executeAssignment(boMap, assignmentInfo);
    }

    public SubmitAssignResult submitAssignment(Map boMap, String userId, String packageName, String functionName, String actionName, AssignmentInfo assignmentInfo, BizProcInfo bizProcInfo) throws WfException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("begine server submitAssignment:" + System.currentTimeMillis()));
            }
            long startTime = System.currentTimeMillis();
            if (userId == null) {
                throw new IllegalArgumentException("userId");
            }
            long time = System.currentTimeMillis();
            Person person = this.getPariticipantProvider().getPersonByUserId(this.context(), userId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WfEngine.get person cost : " + (System.currentTimeMillis() - time) + "ms"));
            }
            if (person == null) {
                throw new WfException("invalid userId");
            }
            if (assignmentInfo == null) {
                time = System.currentTimeMillis();
                String bizObjId = null;
                Iterator iterator = boMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String item = iterator.next().toString();
                    if (item == null || item.length() == 0) continue;
                    if (bizObjId == null) {
                        bizObjId = item;
                        continue;
                    }
                    bizObjId = bizObjId + "," + item;
                }
                assignmentInfo = this.checkAssignmentInfo(bizObjId, userId, packageName, functionName, actionName, null);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("WfEngine.checkAssignmentInfo cost : " + (System.currentTimeMillis() - time) + "ms"));
                }
            }
            if (assignmentInfo == null) {
                BizProcInfo[] bizProcInfoArray = null;
                if (bizProcInfo == null) {
                    SubmitAssignResult rtnVal;
                    bizProcInfoArray = this.getBizProcFinder().findProcDef(person, PerformerType.EMPLOYEE, functionName, packageName, actionName);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("WfEngine.process find " + bizProcInfoArray.length + ", time :" + (System.currentTimeMillis() - time)));
                    }
                    if (bizProcInfoArray.length == 0) {
                        rtnVal = new SubmitAssignResult(false, bizProcInfoArray);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("WfEngine.submitAssignment total cost : " + (System.currentTimeMillis() - startTime) + "ms"));
                        }
                        return rtnVal;
                    }
                    if (bizProcInfoArray.length > 1) {
                        rtnVal = new SubmitAssignResult(false, bizProcInfoArray);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("WfEngine.submitAssignment total cost : " + (System.currentTimeMillis() - startTime) + "ms"));
                        }
                        return rtnVal;
                    }
                }
                if (!this.getProcessMgr(bizProcInfoArray[0].getProcDefId()).getData().isEnable()) {
                    return new SubmitAssignResult(false, null);
                }
                String eventId = BOSUuid.create((String)"WFBIZEVT").toString();
                this.createProcInst(eventId, userId, bizProcInfoArray[0].getProcDefId(), bizProcInfoArray[0].getProcStartActDefId(), boMap, null, null);
                SubmitAssignResult rtnVal = new SubmitAssignResult(true, null);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("WfEngine.submitAssignment total cost : " + (System.currentTimeMillis() - startTime) + "ms"));
                }
                return rtnVal;
            }
            return this.executeAssignment(boMap, assignmentInfo);
        }
        catch (WfException e) {
            logger.warn((Object)"submitAssignment", (Throwable)e);
            SubmitAssignResult rtnVal = new SubmitAssignResult(false, null);
            return rtnVal;
        }
    }

    public String createProcInst(String userId, String procDefId, String firstActDefId, String billId) throws WfException {
        HashMap<String, String> boMap = new HashMap<String, String>();
        boMap.put(billId, billId);
        WfProcess process = this.createProcInst(null, userId, procDefId, firstActDefId, boMap, null, new HashMap());
        return process.getId();
    }

    private ManpowerActivityDef getFirstManpowerActivityDef(ProcessDef processDef) throws WfException {
        StartActivityDef startDef = processDef.getStartActivity();
        for (TransitionDef transDef : startDef.getOutgoingTransitions()) {
            ActivityDef def = transDef.getTo();
            if (!(def instanceof ManpowerActivityDef)) continue;
            return (ManpowerActivityDef)def;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WfProcess createProcInst(String eventId, String userId, String procDefId, String firstActDefId, Map boMap, Object[] parameters, Map extendProperties) throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "createProcInst", null);
        }
        try {
            Person person = this.getPariticipantProvider().getPersonByUserId(this.context(), userId);
            WfProcessMgr procMgr = this.getProcessMgr(procDefId);
            WfProcess procInst = procMgr.createProcess(null, person);
            try {
                IObjectValue boValue = null;
                for (Object value : boMap.values()) {
                    String billId = value.toString();
                    boValue = this.getBizObject(billId);
                }
                ProcInstInfo procInstInfo = procInst.getProcessMeta().getMeta();
                procInstInfo.setControlUnitID(((CtrlUnitInfo)boValue.get("cu")).getId());
                SnapshotRecorder recorder = SnapshotRecorder.create();
                recorder.snapshoot((AbstractObjectValue)procInstInfo);
                recorder.recordSnapshots();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            procInst.innerStartAndCommitFirstActivity(eventId, firstActDefId, boMap, userId, this.context(), person, parameters, extendProperties);
            procMgr.processProcessTopic(procInst);
            this.cleanTempBizProcRelation(boMap);
            this.saveOption(this.context(), procInst, userId);
            WfProcess wfProcess = procInst;
            return wfProcess;
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private void saveOption(Context ctx, WfProcess procInst, String userId) {
        try {
            IOption Wfoption = OptionFactory.getLocalInstance((Context)ctx);
            IUser user = UserFactory.getLocalInstance((Context)ctx);
            OptionInfo opinfo = new OptionInfo();
            try {
                opinfo.setOption("\u63d0\u4ea4", new Locale("L1"));
                opinfo.setOption("\u63d0\u4ea4", new Locale("L2"));
                opinfo.setOption("\u63d0\u4ea4", new Locale("L3"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            opinfo.setOption(null);
            opinfo.setBillID(BOSUuid.read((String)procInst.getBizObjIds()[0].toString()));
            opinfo.setType(OptionType.submit);
            opinfo.setPersonID(BOSUuid.read((String)userId));
            opinfo.setNextHandlerPersonID(null);
            opinfo.setResult("\u63d0\u4ea4");
            opinfo.setAssignmentID(null);
            opinfo.setNextAssignid(null);
            opinfo.setCurrentAcinstID(null);
            opinfo.setActinstID(null);
            opinfo.setProcinstID(BOSUuid.read((String)procInst.getId()));
            UserInfo creater = user.getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)userId)));
            opinfo.setCreator(creater);
            opinfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            Wfoption.addnew(opinfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cleanTempBizProcRelation(Map boMap) throws WfException {
        String bizObjID = (String)boMap.keySet().iterator().next();
        this.getStoreManager().getProcessStorer().cleanTempBizProcRelation(bizObjID);
    }

    public ProcInstBizObjInfo getProcInstBizObjInfoByBoId(String boId) {
        return this.storeManger.getProcessStorer().getProcInstBizObjInfoByBoId(boId);
    }

    public SubmitAssignResult executeAssignment(Map boMap, AssignmentInfo assignmentInfo) throws WfException {
        try {
            if (!WfAssignExecutor.enqueue(this.context(), boMap, assignmentInfo)) {
                this.innerExecuteAssignment(boMap, assignmentInfo);
            }
            return new SubmitAssignResult(true, null);
        }
        catch (WfException error) {
            WfAssignment assignment = this.getAssignment(assignmentInfo.getAssignmentId());
            this.eventService().raiseAssignmentEvent(AssignmentEvent.OnAssignmentFailed, assignment, null);
            throw error;
        }
    }

    public void innerExecuteAssignment(Map boMap, AssignmentInfo assignmentInfo) throws WfException {
        this.executeAssignment(boMap, this.getAssignment(assignmentInfo.getAssignmentId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubmitAssignResult executeAssignment(Map boMap, WfAssignment assignment) throws WfException {
        WfRuntimeStat.incAssignCount();
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "executeAssignment", null);
        }
        try {
            SubmitAssignResult rtnVal;
            long time = System.currentTimeMillis();
            AssignmentInfo assignmentInfo = assignment.getMeta();
            this.calcAssignOutput(boMap, assignment);
            this.calcRelevantObjectOutput(assignment);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WfEngine.executeAssignment calcAssignOutput assignment cost : " + (System.currentTimeMillis() - time) + "ms"));
                time = System.currentTimeMillis();
            }
            if (WfAssignmentState.ASSIGNED.equals((Object)assignmentInfo.getState())) {
                // empty if block
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WfEngine.executeAssignment accept assignment cost : " + (System.currentTimeMillis() - time) + "ms"));
                time = System.currentTimeMillis();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WfEngine.holdBizObj cost : " + (System.currentTimeMillis() - time) + "ms"));
            }
            assignment.complete();
            ProcessDef procDef = this.getProcessDef(assignmentInfo.getProcDefHashValue());
            ActivityDef actDef = procDef.getActivityDef(assignmentInfo.getActDefId());
            try {
                this.getValueToOutput(actDef, assignmentInfo);
            }
            catch (Throwable e) {
                logger.warn((Object)"error when set process variable", e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("comlete assignment cost : " + (System.currentTimeMillis() - time) + "ms"));
                time = System.currentTimeMillis();
            }
            SubmitAssignResult submitAssignResult = rtnVal = new SubmitAssignResult(true, null);
            return submitAssignResult;
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private void calcAssignOutput(Map boMap, WfAssignment assignment) throws WfException {
        ActivityDef actDef;
        long time = System.currentTimeMillis();
        AssignmentInfo assignmentInfo = assignment.getMeta();
        WfProcess proc = this.getProcessInst(assignmentInfo.getProcInstId());
        ProcessContext proCtx = proc.getProcessContext();
        proCtx.putDataFieldValue(LAST_PROCESSED_ASSIGN, assignmentInfo.getAssignmentId());
        ExtendedAttributeDef ead = assignment.getActivity().getProcess().getDefinition().getExtendedAttributes().get("autoMergeApprove");
        if (ead != null && "true".equals(ead.getValue())) {
            ActivityDef actDef2 = assignment.getActivity().getDefinition();
            boolean billIsChanged = true;
            try {
                String functionName;
                ManpowerActivityDef manpowerActDef;
                String value = ParamManager.getParamValue((Context)this.getContextInternal(), null, (String)"IS_AUTOAPPROVEFORIMAGE");
                if ("true".equalsIgnoreCase(value) && actDef2 instanceof ManpowerActivityDef && (manpowerActDef = (ManpowerActivityDef)actDef2).getRelatedApplication() != null && manpowerActDef.getRelatedApplication().getFunction() != null && (functionName = manpowerActDef.getRelatedApplication().getFunction().getName()) != null && (functionName.contains("WsscCommonFunction") || functionName.contains("ImageSysBaseFunction"))) {
                    billIsChanged = false;
                }
            }
            catch (Exception value) {
                // empty catch block
            }
            if (actDef2 instanceof ManualDecisionActivityDef) {
                billIsChanged = false;
            } else if (actDef2 instanceof ApproveActivityDef) {
                String isAutoApproveAssign;
                ead = actDef2.getActivityHeader().getExtendedAttributes().get("customUIStatus");
                if (ead != null) {
                    String v = ead.getValue();
                    v = v == null ? "" : v.trim();
                    if (v.length() == 0 || "VIEW".equalsIgnoreCase(v) || "FINDVIEW".equalsIgnoreCase(v)) {
                        billIsChanged = false;
                    }
                } else {
                    billIsChanged = false;
                }
                String approveBillEdit = (String)proCtx.getDataFieldValue("$approveBillEdit" + assignment.getId());
                if (!StringUtil.isEmpty((String)approveBillEdit) && approveBillEdit.equalsIgnoreCase("false")) {
                    billIsChanged = false;
                }
                if (!StringUtil.isEmpty((String)(isAutoApproveAssign = (String)proCtx.getDataFieldValue("$AutoApproveState" + assignment.getId()))) && isAutoApproveAssign.equalsIgnoreCase("true")) {
                    billIsChanged = false;
                }
            }
            if (billIsChanged) {
                proCtx.putDataFieldValue("$billLastUpdatedTime", new Timestamp(System.currentTimeMillis()));
                proCtx.putDataFieldValue("$billLastUpdatedAssignId", assignmentInfo.getAssignmentId());
                proCtx.putDataFieldValue("$autoapprovepersonid", assignmentInfo.getUserId());
            }
        }
        if (proCtx.getDataFieldValue("$isKickBack") != null && "true".equalsIgnoreCase((String)proCtx.getDataFieldValue("$isKickBack"))) {
            proCtx.putDataFieldValue("$billLastUpdatedTime", new Date());
            proCtx.putDataFieldValue("$billLastUpdatedAssignId", null);
            proCtx.putDataFieldValue("$isKickBack", null);
        }
        proCtx.storeToDb();
        ProcessDef procDef = this.getProcessDef(assignmentInfo.getProcDefHashValue());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("calcAssignOutput (1) getProcDef() cost:" + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
        if (!((actDef = procDef.getActivityDef(assignmentInfo.getActDefId())) instanceof ManpowerActivityDef)) {
            throw new WfException("Fatal Error.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("calcAssignOutput (3) getAssib() cost:" + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
        ManpowerActivityDef manpowerActDef = (ManpowerActivityDef)actDef;
        String aplctnId = assignmentInfo.getApplicationDefId();
        ApplicationDef appDef = procDef.getApplicationDef(aplctnId);
        HashMap<String, FormalParameterDef> paramDefMap = new HashMap<String, FormalParameterDef>();
        Map paramValueMap = new HashMap();
        FormalParameterCollection formalParms = appDef.getFormalParameters();
        ActualParameterCollection actualParamCol = manpowerActDef.getActualParameters();
        HashMap boIdOrgIdMap = new HashMap();
        boIdOrgIdMap.putAll(boMap);
        if (actualParamCol != null && actualParamCol.size() > 0) {
            boolean hasOutParam = false;
            FormalParameterDef bizObjParamDef = null;
            for (int i = 0; i < formalParms.size(); ++i) {
                FormalParameterDef paramDef = formalParms.get(i);
                if (!paramDef.getMode().equals((Object)FormalParameterMode.OUT) && !paramDef.getMode().equals((Object)FormalParameterMode.INOUT) || paramDef.getBoId() == null || paramDef.getBoId().equals("")) continue;
                if (!paramDef.getDataType().equals(BasicType.BIZOBJ)) {
                    paramDefMap.put(paramDef.getID(), paramDef);
                    continue;
                }
                bizObjParamDef = paramDef;
                paramDefMap.put(paramDef.getID(), paramDef);
            }
            if (paramDefMap != null && paramDefMap.size() > 0) {
                try {
                    paramValueMap = ScriptUtil.evalPropertyExpr(paramDefMap, boMap, this.context(), assignment.getActInst().container().getProcessContext());
                }
                catch (BizObjectNotFoundException ex) {
                    WorkflowUtils.logProcessException(assignmentInfo.getProcInstId(), this, (WfException)((Object)ex), ProcessInstEventEnum.COMMON);
                    paramValueMap = null;
                }
                if (paramValueMap != null && paramValueMap.size() > 0) {
                    hasOutParam = true;
                } else {
                    logger.warn((Object)("paramDefMap not null, but paramValueMap is null.size:" + paramDefMap.size()));
                }
            }
            if (paramValueMap != null && paramValueMap.size() > 0 || bizObjParamDef != null) {
                hasOutParam = true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WfEngine.compute Out FormalParameter cost : " + (System.currentTimeMillis() - time) + "ms"));
                time = System.currentTimeMillis();
            }
            if (hasOutParam) {
                WfProcess procInst = this.getProcessInst(assignmentInfo.getProcInstId());
                WfActivity activity = assignment.getActInst();
                if (paramValueMap != null) {
                    if (activity.enableCountersign()) {
                        this.processCountersignOutput(paramDefMap, paramValueMap, actualParamCol, assignment, boMap, boIdOrgIdMap);
                    } else {
                        this.processAssignmentOutput(paramDefMap, paramValueMap, actualParamCol, procInst, boMap, boIdOrgIdMap);
                    }
                }
                if (bizObjParamDef != null) {
                    for (Object obj : boMap.keySet()) {
                        if (obj == null) continue;
                        String bizId = obj.toString();
                        String objectType = null;
                        try {
                            objectType = BOSUuid.getBOSObjectType((String)bizId, (boolean)true).toString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (objectType == null || !objectType.equals(bizObjParamDef.getBoId())) continue;
                        if (bizObjParamDef.getIndex() >= actualParamCol.size()) {
                            logger.error((Object)"\u6d41\u7a0b\u5b9a\u4e49\u590d\u5236\u8282\u70b9\u95ee\u9898\u9020\u6210\u4e0b\u6807\u8d8a\u754c\uff0c\u8fd0\u884c\u671f\u517c\u5bb9\u8be5\u95ee\u9898");
                            continue;
                        }
                        ActualParameterDef actualParam = actualParamCol.get(bizObjParamDef.getIndex());
                        if (!StringUtils.isEmpty((String)actualParam.getExpr())) {
                            String name = actualParam.getDataField().getName();
                            procInst.getProcessContext().putDataFieldValue(name, null);
                            procInst.getProcessContext().putDataFieldValue("$" + name + " .bizId$", bizId);
                        } else {
                            procInst.getProcessContext().putDataFieldValue(bizObjParamDef.getName(), null);
                            procInst.getProcessContext().putDataFieldValue("$" + bizObjParamDef.getName() + " .bizId$", bizId);
                        }
                        procInst.getProcessContext().storeToDb();
                        break;
                    }
                }
            }
        }
    }

    private void processAssignmentOutput(Map paramDefMap, Map paramValueMap, ActualParameterCollection actualParamCol, WfProcess procInst, Map boMap, Map boIdOrgIdMap) throws WfException {
        for (FormalParameterDef paramDef : paramDefMap.values()) {
            if (paramDef.getDataType().equals(BasicType.BIZOBJ)) continue;
            if (paramDef.getIndex() >= actualParamCol.size()) {
                logger.error((Object)"\u6d41\u7a0b\u5b9a\u4e49\u590d\u5236\u8282\u70b9\u95ee\u9898\u9020\u6210\u4e0b\u6807\u8d8a\u754c\uff0c\u8fd0\u884c\u671f\u517c\u5bb9\u8be5\u95ee\u9898");
                continue;
            }
            ActualParameterDef actualParam = (ActualParameterDef)actualParamCol.getObject(paramDef.getIndex());
            if (actualParam == null || actualParam.getDataField() == null) continue;
            String dataName = actualParam.getDataField().getName();
            Object paramValue = paramValueMap.get(paramDef.getID());
            if ((actualParam.getDataField().getDataType().equals(BasicType.BOID) || actualParam.getDataField().getDataType().equals(BasicType.PK)) && paramValue instanceof MultiApproveInfo) {
                logger.error((Object)("\u8be5\u6d41\u7a0b\u5ba1\u6279\u7ed3\u679c\u8f93\u51fa\u6709\u95ee\u9898\uff1adataName" + dataName + "----" + procInst.getId()));
                continue;
            }
            if (paramValue == null) {
                logger.warn((Object)("paramValue is null.dataName:" + dataName));
            }
            procInst.getProcessContext().putDataFieldValue(dataName, paramValue);
        }
        procInst.getProcessContext().storeToDb();
        Object orgMap = procInst.getProcessContext().getDataFieldValue(RuntimeSystemVariable.ORGMAP.getValue());
        for (Object boId : boMap.keySet()) {
            if (orgMap != null && ((Map)orgMap).size() > 0) {
                boIdOrgIdMap.put(boId.toString(), ((Map)orgMap).get(boId.toString()));
                continue;
            }
            boIdOrgIdMap.put(boId.toString(), "");
        }
        procInst.holdBizObj(boIdOrgIdMap);
    }

    private void processCountersignOutput(Map paramDefMap, Map paramValueMap, ActualParameterCollection actualParamCol, WfAssignment assignment, Map boMap, Map boIdOrgIdMap) throws WfException {
        WfActivity activity = assignment.getActInst();
        WfProcess procInst = activity.container();
        WfAssignment[] assignments = activity.getAssignmentsInState(WfAssignmentState.COMPLETED);
        double percent = activity.signByPercent();
        int[] passCounts = this.computeApproveResultCount(assignment);
        if (percent <= 0.0) {
            if (assignments.length == 0) {
                this.processAssignmentOutput(paramDefMap, paramValueMap, actualParamCol, procInst, boMap, boIdOrgIdMap);
            } else {
                boolean isBeforePass = this.computeApproveResult(assignment);
                if (isBeforePass) {
                    this.processAssignmentOutput(paramDefMap, paramValueMap, actualParamCol, procInst, boMap, boIdOrgIdMap);
                }
            }
        } else {
            boolean isPass;
            IObjectValue ov = null;
            for (Object value : paramValueMap.values()) {
                if (value == null || !value.getClass().getName().equals("com.kingdee.eas.base.multiapprove.MultiApproveInfo")) continue;
                ov = (IObjectValue)value;
                break;
            }
            if (!(isPass = Boolean.parseBoolean(ov.getString("isPass")))) {
                if (passCounts[1] == 0) {
                    this.processAssignmentOutput(paramDefMap, paramValueMap, actualParamCol, procInst, boMap, boIdOrgIdMap);
                }
            } else if (percent < 0.0) {
                if (passCounts[1] == 0) {
                    this.processAssignmentOutput(paramDefMap, paramValueMap, actualParamCol, procInst, boMap, boIdOrgIdMap);
                }
            } else {
                boolean signPass;
                int personCount = this.getAssignmentPersonCount(assignment.getActInst());
                double ratio = (double)(passCounts[0] + 1) / (double)personCount;
                boolean bl = signPass = ratio >= percent;
                if (signPass) {
                    this.processAssignmentOutput(paramDefMap, paramValueMap, actualParamCol, procInst, boMap, boIdOrgIdMap);
                }
            }
        }
    }

    private boolean isPass(Object object) throws WfException {
        try {
            Class<?> clazzApproveResult = Class.forName("com.kingdee.eas.base.multiapprove.ApproveResult");
            return EnumUtils.getEnum(clazzApproveResult, (String)"PASS").equals(object);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            throw new WfException((Throwable)e);
        }
    }

    private void calcRelevantObjectOutput(WfAssignment assignment) throws WfException {
        ProcessDef procDef = this.getProcessDef(assignment.getMeta().getProcDefHashValue());
        ActivityDef activityDef = assignment.getActInst().getDefinition();
        if (!(activityDef instanceof ApproveActivityDef)) {
            return;
        }
        String aplctnId = assignment.getMeta().getApplicationDefId();
        ApplicationDef appDef = procDef.getApplicationDef(aplctnId);
        FormalParameterCollection collection = appDef.getFormalParameters();
        ProcessContext processContext = assignment.getActInst().container().getProcessContext();
        HashMap<String, FormalParameterDef> paramDefMap = new HashMap<String, FormalParameterDef>();
        HashMap<Object, Object> boMap = new HashMap<Object, Object>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            FormalParameterDef def = collection.get(i);
            if (!def.isRelevantObjectOutput()) continue;
            paramDefMap.put(def.getID(), def);
            DataFieldDef dataFieldDef = procDef.getDataFieldDef(this.getRefObjOutputDatafieldID(appDef, def));
            String dataFieldName = dataFieldDef.getName();
            Object objID = processContext.getDataFieldValue(dataFieldName);
            if (boMap.get(objID) != null) continue;
            boMap.put(objID, objID);
        }
        if (paramDefMap.size() <= 0) {
            return;
        }
        Map paramValueMap = null;
        try {
            paramValueMap = ScriptUtil.evalPropertyExpr(paramDefMap, boMap, this.context, processContext);
        }
        catch (BizObjectNotFoundException ex) {
            WorkflowUtils.logProcessException(assignment.getProcInstId(), this, (WfException)((Object)ex), ProcessInstEventEnum.COMMON);
            paramValueMap = null;
        }
        if (paramValueMap != null) {
            ActualParameterCollection actualParamCol = ((ApproveActivityDef)activityDef).getActualParameters();
            WfProcess process = assignment.getActInst().container();
            for (FormalParameterDef paramDef : paramDefMap.values()) {
                if (paramDef.getIndex() >= actualParamCol.size()) {
                    logger.error((Object)"\u6d41\u7a0b\u5b9a\u4e49\u590d\u5236\u8282\u70b9\u95ee\u9898\u9020\u6210\u4e0b\u6807\u8d8a\u754c\uff0c\u8fd0\u884c\u671f\u517c\u5bb9\u8be5\u95ee\u9898");
                    continue;
                }
                ActualParameterDef actualParam = (ActualParameterDef)actualParamCol.getObject(paramDef.getIndex());
                String dataName = actualParam.getDataField().getName();
                Object paramValue = paramValueMap.get(paramDef.getID());
                if (paramValue == null) {
                    logger.warn((Object)("paramValue is null.dataName:" + dataName));
                }
                process.getProcessContext().setDataFieldValue(dataName, paramValue);
            }
            process.getProcessContext().storeToDb();
        }
    }

    private String getRefObjOutputDatafieldID(ApplicationDef appDef, FormalParameterDef def) {
        String datafieldId = "";
        if (appDef.getExtendedAttributes().get("RefBOIDDatafield") != null) {
            datafieldId = appDef.getExtendedAttributes().get("RefBOIDDatafield").getValue();
        }
        if (StringUtils.isEmpty((String)datafieldId)) {
            datafieldId = def.getBoId();
        }
        return datafieldId;
    }

    private int getAssignmentPersonCount(WfActivity actinst) throws WfException {
        HashSet<String> set = new HashSet<String>();
        for (WfAssignment a : actinst.assignments()) {
            BOSUuid uuid;
            String personId;
            if (WfAssignmentState.CANCELED.equals((Object)a.getAssignmentInfo().getState()) || set.contains(personId = (uuid = a.getAssignmentInfo().getAssignInfo().getPersonEmpID()) != null ? uuid.toString() : a.getAssignmentInfo().getAssignInfo().getPersonUserID().toString())) continue;
            set.add(personId);
        }
        return set.size();
    }

    private int[] computeApproveResultCount(WfAssignment assignment) throws WfException {
        WfActivity actinst = assignment.getActInst();
        WfAssignment[] assignments = actinst.getAssignmentsInState(WfAssignmentState.COMPLETED);
        if (assignments.length == 0) {
            return new int[]{0, 0};
        }
        String billID = assignment.getMeta().getBizObjectIds();
        HashSet<String> assignmentIDList = new HashSet<String>();
        int length = assignments.length;
        for (int i = 0; i < length; ++i) {
            assignmentIDList.add(assignments[i].getId());
        }
        int passCount = 0;
        int notPassCount = 0;
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.base.multiapprove.MultiapproveUtils");
            Class[] paramClassTypes = new Class[]{Context.class, String.class, Set.class};
            Class<?> clazzApproveResult = Class.forName("com.kingdee.eas.base.multiapprove.ApproveResult");
            Method method = clazz.getMethod("getCountersignResult", paramClassTypes);
            Object[][] countersignResult = (Object[][])method.invoke(clazz, this.context, billID, assignmentIDList);
            int length2 = countersignResult.length;
            for (int i = 0; i < length2; ++i) {
                boolean result = (Boolean)countersignResult[i][1];
                if (result) {
                    ++passCount;
                    continue;
                }
                ++notPassCount;
            }
            return new int[]{passCount, notPassCount};
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            Throwable t = e.getTargetException();
            if (t instanceof BOSException) {
                throw new WfException((Throwable)e);
            }
            throw new WfException(t);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    private boolean computeApproveResult(WfAssignment assignment) throws WfException {
        WfActivity actinst = assignment.getActInst();
        WfAssignment[] assignments = actinst.getAssignmentsInState(WfAssignmentState.COMPLETED);
        if (assignments.length == 0) {
            throw new IllegalArgumentException();
        }
        String billID = assignment.getMeta().getBizObjectIds();
        HashSet<String> assignmentIDList = new HashSet<String>();
        int length = assignments.length;
        for (int i = 0; i < length; ++i) {
            assignmentIDList.add(assignments[i].getId());
        }
        double percent = actinst.signByPercent();
        int[] counts = this.computeApproveResultCount(assignment);
        if (percent > 0.0) {
            HashSet<String> set = new HashSet<String>(3);
            for (WfAssignment a : actinst.assignments()) {
                String personId;
                if (WfAssignmentState.CANCELED.equals((Object)a.getAssignmentInfo().getState()) || set.contains(personId = a.getAssignmentInfo().getAssignInfo().getPersonEmpID().toString())) continue;
                set.add(personId);
            }
            int ratio = counts[0] / set.size();
            return (double)ratio >= percent;
        }
        return counts[1] <= 0;
    }

    public IWfCacheManager getCacheManager() {
        return this.cacheMgr;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ProcessInstInfo[] getProcessInstInfoByInitiator(String initiatorUserID) throws WfException {
        ProcessStorer storer = this.getStoreManager().getProcessStorer();
        try {
            ProcessInstInfo[] processInstInfoArray = storer.getProcessInstInfoByInitiator(initiatorUserID);
            return processInstInfoArray;
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    public synchronized void setProcessDefEnable(String userId, String procDefId, boolean enable) throws WfException {
        ProcessDef procDef = this.getProcessMgr(procDefId).getProcessDef();
        this.setProcessDefEnableInternal(userId, procDef, enable);
    }

    public synchronized void setProcessDefEnable(String userId, ProcessDef procDef, boolean enable) throws WfException {
        this.setProcessDefEnableInternal(userId, procDef, enable);
    }

    private void setProcessDefEnableInternal(String userId, ProcessDef procDef, boolean enable) throws WfException {
        try {
            ProcessStorer storer = this.getStoreManager().getProcessStorer();
            storer.setProcessDefEnable(procDef.getID(), enable);
            WfRoleUtils.updateProcessRoledata((Context)this.context(), (ProcessDef)procDef, (boolean)enable);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
        this.getDefinitionMgr().scheduleProcess(procDef, null, enable);
        this.cacheMgr.removeProcessDef(procDef.getHashValue());
        int lastVersion = this.getDefinitionMgr().getProcessDefLastVersionNumber(procDef.getID());
        this.getProcessMgr(procDef.getID(), lastVersion).getData().setEnable(enable);
        if (!this.wfLogger.checkLogLevel(LogTypeEnum.INFO)) {
            ProcessDefOperationEnum operation = enable ? ProcessDefOperationEnum.ENABLED : ProcessDefOperationEnum.DISABLED;
            try {
                this.wfLogger.addWfProcessDefLog(userId, LogTypeEnum.INFO, procDef.getID(), operation);
            }
            catch (Throwable t) {
                logger.warn((Object)"wflog error.", t);
            }
        }
    }

    public void unregistProcessBizObj(String bizObjId) throws WfException {
        try {
            this.getStoreManager().getProcessStorer().unregistProcessBizObj(bizObjId);
        }
        catch (DataAccessException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        catch (SQLException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    public boolean existBizEventInJob(Context ctx, String bizEventId) throws WfException {
        return WfBizEventHandler.existBizEventInJob(ctx, bizEventId);
    }

    public void putEventQueue(WfDirectCreateProcessEvent event) throws WfException {
        WfDirectCreateProcessEventHandler.enqueue(this.context, event);
    }

    public void putEventQueue(WfBizEvent event) throws WfException {
        long start = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WfEngine.put bizEventToQueue, BoId : " + event.getBoId()));
        }
        if (event.getAssignmentId() == null && "true".equals(event.getExtendProperty((Object)"CTRL_SHIFT_ALT"))) {
            this.acceptEvent(event);
            return;
        }
        if (event.getAssignmentId() == null) {
            WfBizEventHandler.enqueue(this.context, event);
        } else {
            WfAssignEventHandler.enqueue(this.context, event);
        }
        if (event.getAssignmentId() != null) {
            WfAssignment assignment = this.getAssignment(event.getAssignmentId());
            if (!event.getUserId().equals(assignment.getMeta().getUserId())) {
                throw new WfException("current user isn't required performer! currentUserId=" + event.getUserId() + ", requiredUserId=" + assignment.getMeta().getUserId());
            }
            if (WfAssignmentState.CANCELED.equals((Object)assignment.state()) || WfAssignmentState.COMPLETED.equals((Object)assignment.state()) || WfAssignmentState.REJECTED.equals((Object)assignment.state()) || WfAssignmentState.PROCESSING.equals((Object)assignment.state())) {
                throw new MissMatchParticipantException("can not process assignment[id:" + assignment.getId() + ", state:" + assignment.state().getValue() + "]");
            }
            assignment.processing();
            String billId = assignment.getMeta().getBizObjectIds();
            event.setBoundBoId(billId);
        }
        try {
            String thread = Thread.currentThread().getName();
            long end = System.currentTimeMillis();
            long consume = end - start;
            this.wfLogger.addAnalysisData(this.getEngineKey(), thread, "WfEngine.putEventQueue", "All", end, consume, "");
        }
        catch (Throwable e) {
            logger.warn((Object)"WfLogger error.", e);
        }
    }

    public void deleteProcInst(String procInstId) throws SQLException, WfException {
        WfProcess procInst = this.getProcessInst(procInstId);
        ProcessDef procDef = procInst.getDefinition();
        WfEngine.getEngine(this.context()).getProcessMgr(procDef.getID(), procInst.getData().getProcDefInnerVersion()).deleteProcessInst(procInstId);
    }

    public void deletePhysicsProcInst(String procInstId) throws SQLException, WfException {
        WfProcess procInst = this.getProcessInst(procInstId);
        ProcessDef procDef = procInst.getDefinition();
        WfEngine.getEngine(this.context()).getProcessMgr(procDef.getID(), procInst.getData().getProcDefInnerVersion()).deletePhysicsProcessInst(procInstId);
    }

    public void resetWorkerThread() throws WfException {
        this.buddy.operationPerformed("resetWorkerThread");
    }

    public static Set getEngineKeySet() {
        return engineMap.keySet();
    }

    private synchronized Context getContextInternal() {
        if (this.context == null) {
            String userName = "Administrator";
            String userId = "00000000-0000-0000-0000-00000000000013B7DE7F";
            Context ctx = new Context((IObjectPK)new ObjectUuidPK(userId), this.getEngineSolution(), this.getEngineAis(), this.getLocale());
            ctx.setUserName(userName);
            try {
                if (this.getCacheManager() == null) {
                    PermissionUtil.simulateLogin(ctx);
                } else {
                    this.getCacheManager().getUserServiceContext(userId + "," + userName, ctx);
                }
            }
            catch (BOSException e) {
                logger.warn((Object)"Can not load Context.", (Throwable)e);
                return null;
            }
            catch (Throwable e) {
                logger.warn((Object)"Can not load Context.", e);
                return null;
            }
            this.context = ctx;
        }
        return this.context;
    }

    public Context getNewContext() {
        String userName = "Administrator";
        String userId = "00000000-0000-0000-0000-00000000000013B7DE7F";
        Context ctx = new Context((IObjectPK)new ObjectUuidPK(userId), this.getEngineSolution(), this.getEngineAis(), this.getLocale());
        ctx.setUserName(userName);
        try {
            if (this.getCacheManager() == null) {
                PermissionUtil.simulateLogin(ctx);
            } else {
                this.getCacheManager().getUserServiceContext(userId + "," + userName, ctx);
            }
        }
        catch (BOSException e) {
            logger.warn((Object)"Can not load Context.", (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            logger.warn((Object)"Can not load Context.", e);
            return null;
        }
        return ctx;
    }

    public boolean isAssignmentInQueue(String assignmentId) throws WfException {
        WfAssignment assign = this.getAssignment(assignmentId);
        String mutex = Mutex.getMutex(this.context(), assign.getProcInstId());
        return Mutex.exists(this.context(), mutex);
    }

    public void batchTerminate(String[] procInstIds) throws WfException {
        try {
            this.getStoreManager().getProcessStorer().batchTerminate(procInstIds);
        }
        catch (SQLException ex) {
            throw new WfException((Throwable)ex);
        }
    }

    public void batchPhysicsDelete(String[] procInstIds) throws WfException {
        try {
            this.getStoreManager().getProcessStorer().batchPhysicsDelete(procInstIds);
        }
        catch (SQLException ex) {
            throw new WfException((Throwable)ex);
        }
    }

    private void getValueToOutput(ActivityDef activityDef, AssignmentInfo assignmentInfo) throws BOSException {
        if (activityDef instanceof ManpowerActivityDef) {
            WfProcess procInst = this.getProcessInst(assignmentInfo.getProcInstId());
            this.getValueToOutput(activityDef, assignmentInfo, procInst);
        }
    }

    public void getValueToOutput(ActivityDef activityDef, AssignmentInfo assignmentInfo, WfProcess procInst) throws BOSException, WfException {
        ManpowerActivityDef manpowerActDef = (ManpowerActivityDef)activityDef;
        ApplicationDef appDef = manpowerActDef.getRelatedApplication();
        ActualParameterCollection actualParamCol = manpowerActDef.getActualParameters();
        HashMap<String, FormalParameterDef> paramDefMapOutput = new HashMap<String, FormalParameterDef>();
        Map paramDefMapOutputVal = new HashMap();
        FormalParameterCollection formalParms = appDef.getFormalParameters();
        for (int i = 0; i < formalParms.size(); ++i) {
            FormalParameterDef paramDef = formalParms.get(i);
            if (!paramDef.getMode().equals((Object)FormalParameterMode.OUT) || paramDef.getBoId() != null && !paramDef.getBoId().equals("")) continue;
            paramDefMapOutput.put(paramDef.getID(), paramDef);
        }
        paramDefMapOutputVal = this.getValueForPrams(paramDefMapOutput, activityDef, assignmentInfo);
        for (FormalParameterDef paramDef : paramDefMapOutput.values()) {
            if (paramDef.getIndex() >= actualParamCol.size()) {
                logger.error((Object)"\u6d41\u7a0b\u5b9a\u4e49\u590d\u5236\u8282\u70b9\u95ee\u9898\u9020\u6210\u4e0b\u6807\u8d8a\u754c\uff0c\u8fd0\u884c\u671f\u517c\u5bb9\u8be5\u95ee\u9898");
                continue;
            }
            ActualParameterDef actualParam = (ActualParameterDef)actualParamCol.getObject(paramDef.getIndex());
            String dataName = actualParam.getDataField().getName();
            Object paramValue = paramDefMapOutputVal.get(paramDef.getID());
            if (paramValue instanceof List) {
                List list = (List)paramValue;
                Person[] obj = new Person[list.size()];
                if (actualParam.getDataField().isArray()) {
                    procInst.getProcessContext().setDataFieldValue(dataName, list.toArray(obj));
                    continue;
                }
                if (list != null && list.size() > 0) {
                    procInst.getProcessContext().setDataFieldValue(dataName, list.get(0));
                    continue;
                }
                procInst.getProcessContext().setDataFieldValue(dataName, null);
                continue;
            }
            procInst.getProcessContext().setDataFieldValue(dataName, paramValue);
        }
        if (paramDefMapOutput.size() > 0) {
            procInst.getProcessContext().storeToDb();
        }
    }

    private Map getValueForPrams(Map map, ActivityDef activityDef, AssignmentInfo assignmentInfo) throws BOSException {
        AssignmentInfo[] assigns = this.getAssignmentByActInstId(assignmentInfo.getActInstId());
        ArrayList<Person> performers = new ArrayList<Person>();
        Person curentPerson = this.getPariticipantProvider().getPersonByUserId(this.context(), assignmentInfo.getUserId());
        performers.add(curentPerson);
        for (AssignmentInfo assign : assigns) {
            if (assign == null || assign.getUserId() == null || !assign.getState().equals((Object)WfAssignmentState.COMPLETED)) continue;
            Person person = this.getPariticipantProvider().getPersonByUserId(this.context(), assign.getUserId());
            performers.add(person);
        }
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        for (FormalParameterDef paramDef : map.values()) {
            if (paramDef.getName() != null && paramDef.getName().equals("")) continue;
            if (paramDef.getName().equals("activityID")) {
                retVal.put(paramDef.getID(), activityDef.getID());
                continue;
            }
            if (paramDef.getName().equals("activityName")) {
                retVal.put(paramDef.getID(), activityDef.getName(new Locale("L2")));
                continue;
            }
            if (paramDef.getName().equals("activityInstID")) {
                retVal.put(paramDef.getID(), assignmentInfo.getActInstId());
                continue;
            }
            if (paramDef.getName().equals("processName")) {
                retVal.put(paramDef.getID(), assignmentInfo.getProcDefName(new Locale("L2")));
                continue;
            }
            if (paramDef.getName().equals("Performer")) {
                retVal.put(paramDef.getID(), performers);
                continue;
            }
            if (!paramDef.getName().equals("processInstID")) continue;
            retVal.put(paramDef.getID(), assignmentInfo.getProcInstId());
        }
        return retVal;
    }

    public boolean isRunning() {
        return this.state == 1;
    }

    public WfEventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(WfEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    public void setEventProcRelation(EventProcMetaInfo[] eventProcMetaInfos) throws WfException {
        if (eventProcMetaInfos == null || eventProcMetaInfos.length <= 0) {
            return;
        }
        try {
            EventStorer storer = this.getStoreManager().getEventStorer();
            storer.createEventProcRelation(eventProcMetaInfos);
        }
        catch (SQLException e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
        catch (DataAccessException e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
    }

    public WfProcessServiceMgr getProcessServiceMgr() {
        return this.processServiceMgr;
    }

    public WfCorrelationMatchMgr getCorrelationMatchMgr() {
        return this.correlationMatchMgr;
    }

    public long getUsedTime() {
        return this.usedTime;
    }

    public void increaseUsedTime(long time) {
        this.usedTime += time;
    }

    public int getNewProcessInstCount() {
        return this.newProcessInstCount;
    }

    public void increaseNewProcessInstCount() {
        ++this.newProcessInstCount;
    }

    public int getCompleteProcessInstCount() {
        return this.completeProcessInstCount;
    }

    public void increaseCompleteProcessInstCount() {
        ++this.completeProcessInstCount;
    }

    public int getWfQueueSize() {
        return -1;
    }

    public WfEventService eventService() {
        return this.eventSvc;
    }

    private static void initWfEventHandlers(WfEngine engine) {
        HashMap<String, String> sysEvents = new HashMap<String, String>();
        sysEvents.put("com.kingdee.eas.base.multiapprove.ext.app.AutoApproveForExecutor", ActivityEvent.OnActivitiyInit.getName());
        try {
            Document doc = Xml.load((String)"wf_events.xml");
            if (doc != null) {
                NodeList list = doc.getElementsByTagName("event");
                for (int i = 0; i < list.getLength(); ++i) {
                    String name = null;
                    try {
                        Node node = list.item(i);
                        NamedNodeMap attributes = node.getAttributes();
                        name = attributes.getNamedItem("name").getNodeValue();
                        String handler = attributes.getNamedItem("handler").getNodeValue();
                        if (sysEvents.containsKey(handler)) continue;
                        WfEngine.registerEventHandler(engine, name, handler);
                        continue;
                    }
                    catch (Throwable t) {
                        String message = "wf_events.xml got error.";
                        if (name != null) {
                            message = message + name;
                        }
                        logger.error((Object)message);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"load {wf_events.xml} failed!", (Throwable)e);
        }
        for (Map.Entry entry : sysEvents.entrySet()) {
            WfEngine.registerEventHandler(engine, (String)entry.getValue(), (String)entry.getKey());
        }
        ConfigurationItem root = Configuration.getInstance().getConfigItem("Workflow");
        if (root == null) {
            return;
        }
        ConfigurationItem events = root.getChild("events");
        if (events == null) {
            return;
        }
        List list = events.getChildren("event");
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ConfigurationItem item = (ConfigurationItem)list.get(i);
            Map event = item.getProperties();
            String name = (String)event.get("name");
            String className = (String)event.get("handler");
            WfEngine.registerEventHandler(engine, name, className);
        }
        WfEngine.registerEventHandler(engine, ProcessEvent.OnProcessAborted.getName(), "com.kingdee.eas.base.message.app.DynaAppend4ProcessHandler");
        WfEngine.registerEventHandler(engine, ProcessEvent.OnProcessComplete.getName(), "com.kingdee.eas.base.message.app.DynaAppend4ProcessHandler");
        WfEngine.registerEventHandler(engine, ProcessEvent.OnProcessTerminated.getName(), "com.kingdee.eas.base.message.app.DynaAppend4ProcessHandler");
    }

    private static void registerEventHandler(WfEngine engine, String event, String className) {
        Object handler = null;
        try {
            Class<?> cls = Class.forName(className);
            handler = cls.newInstance();
        }
        catch (Throwable e) {
            logger.warn((Object)("init activity event handler {" + className + "} failed!"), e);
            return;
        }
        boolean b = engine.eventService().registerEventHandler(event, handler);
        if (!b) {
            logger.warn((Object)("init activity event handler failed, {" + event + "}is an invalid event, or {" + className + "} is an invalid eventHandler!"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean selectProcessRecordForduplicateCommit(String bizObjID) {
        ResultSet res;
        boolean isRecord;
        PreparedStatement stmt;
        Connection cn;
        block4: {
            cn = null;
            stmt = null;
            isRecord = false;
            res = null;
            int outminute = EngineConfig.getInstance().getRecordTimeOut();
            Calendar c = Calendar.getInstance();
            c.add(12, -outminute);
            Timestamp createTime = new Timestamp(c.getTime().getTime());
            try {
                cn = WfDbUtil.getConnection((Context)this.context);
                String sql = "select FPROCINSTID from T_WFR_ProinstBizObjRelation where FBizObjID = ? and FCreatedTime > ?;";
                stmt = cn.prepareStatement(sql);
                stmt.setString(1, bizObjID);
                stmt.setTimestamp(2, createTime);
                res = stmt.executeQuery();
                if (!res.next()) break block4;
                isRecord = true;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"selectProcessRecordForduplicateCommit", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, stmt, (Connection)cn);
                    throw throwable;
                }
                SQLUtils.cleanup(res, (Statement)stmt, (Connection)cn);
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)stmt, (Connection)cn);
        return isRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putApplicationRunMark(String id, String text) {
        if (!EngineConfig.getInstance().isAutoTrimPriority()) {
            return;
        }
        HashMap hashMap = this.applicationRunState;
        synchronized (hashMap) {
            ApplicationRunState ars = null;
            if (this.applicationRunState.containsKey(id)) {
                ars = (ApplicationRunState)this.applicationRunState.get(id);
            } else {
                ars = new ApplicationRunState();
                ars.setActivityDefId(id);
                ars.setNum(0);
                ars.setText(text);
            }
            ars.setNum(ars.getNum() + 1);
            ars.setTime(System.currentTimeMillis());
            this.applicationRunState.put(id, ars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationRunMark(String id) {
        if (!EngineConfig.getInstance().isAutoTrimPriority()) {
            return;
        }
        HashMap hashMap = this.applicationRunState;
        synchronized (hashMap) {
            if (this.applicationRunState.containsKey(id)) {
                ApplicationRunState ars = (ApplicationRunState)this.applicationRunState.get(id);
                int n = ars.getNum() - 1;
                if (n <= 0) {
                    this.applicationRunState.remove(id);
                } else {
                    ars.setNum(n);
                    this.applicationRunState.put(id, ars);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int needAutoTrimPriority(String id) {
        if (!EngineConfig.getInstance().isAutoTrimPriority()) {
            return 0;
        }
        HashMap hashMap = this.applicationRunState;
        synchronized (hashMap) {
            if (!this.applicationRunState.containsKey(id)) {
                return 0;
            }
            ApplicationRunState ars = (ApplicationRunState)this.applicationRunState.get(id);
            if (ars.getNum() >= EngineConfig.getInstance().getAutoTrimPriorityLowerNum() && System.currentTimeMillis() - ars.getTime() >= EngineConfig.getInstance().getAutoTrimPriorityLowerTime()) {
                logger.info((Object)(ars.getText() + "[" + ars.getActivityDefId() + "] has more than " + EngineConfig.getInstance().getAutoTrimPriorityLowerNum() + " instances, and runned for a long time(more than " + EngineConfig.getInstance().getAutoTrimPriorityLowerTime() / 60000L + " minutes)"));
                return 1;
            }
            if (ars.getNum() >= EngineConfig.getInstance().getAutoTrimPriorityLowestNum() && System.currentTimeMillis() - ars.getTime() >= EngineConfig.getInstance().getAutoTrimPriorityLowestTime()) {
                logger.info((Object)(ars.getText() + "[" + ars.getActivityDefId() + "] has more than " + EngineConfig.getInstance().getAutoTrimPriorityLowestNum() + " instances, and runned for a long time(more than " + EngineConfig.getInstance().getAutoTrimPriorityLowestTime() / 60000L + " minutes)"));
                return 2;
            }
            return 0;
        }
    }

    public List getPersonsByProcessExecutor(String procInstId, String processExecutorType) throws WfException {
        WfProcess wfProcess = this.getProcessInst(procInstId);
        return wfProcess.getPersonsByProcessExecutor(processExecutorType);
    }

    public void acceptWfDirectCreateProcessEventSupport(WfDirectCreateProcessEvent event) throws WfException {
        try {
            this.acceptWfDirectCreateProcessEvent(event);
        }
        catch (TransactionRollbackException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.warn((Object)t.getMessage(), t);
            this.wfLogger.addWfEngineLog(LogTypeEnum.ERROR, WfEngineEventEnum.ACCEPTEVENT, "direct create process inst error, boId:" + event.getBoId(), "direct create process inst error, boId:" + event.getBoId(), t);
            if (t instanceof WfException) {
                throw (WfException)t;
            }
            throw new WfException(t);
        }
    }

    public void acceptWfDirectCreateProcessEvent(WfDirectCreateProcessEvent event) throws WfException {
        String procDefId = event.getProcDefId();
        WfProcessMgr processMgr = this.getProcessMgr(procDefId);
        if (processMgr == null) {
            throw new WfException("Can't find processDef with id:" + procDefId);
        }
        ProcessDef processDef = processMgr.getProcessDef();
        ManpowerActivityDef firstActDef = this.getFirstManpowerActivityDef(processDef);
        this.createProcInst(event.getUserId(), event.getProcDefId(), firstActDef.getID(), event.getBoId());
    }

    static {
        try {
            Class<?> cls = Class.forName(FLOW_PARSER);
            parser = (IFlowParser)cls.newInstance();
        }
        catch (Exception e) {
            parser = null;
            logger.error((Object)"{com.kingdee.bos.workflow.engine.parser.FlowParser}\u6ca1\u6709\u90e8\u7f72!", (Throwable)e);
        }
        engineMap = new ConcurrentHashMap();
    }
}

