/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.util.DCServiceHelper;
import org.apache.log4j.Logger;

public class WfEngineAdmin {
    private static final Logger logger = Logger.getLogger(WfEngineAdmin.class);

    private WfEngineAdmin() {
    }

    public static void initAll() throws WfException {
        String[][] dcInfos = DCServiceHelper.getDCInfos();
        int size = dcInfos.length;
        for (int i = 0; i < size; ++i) {
            String dataCenterName = dcInfos[i][0];
            String solutionName = dcInfos[i][1];
            try {
                WfEngine engine = WfEngine.getEngine(dataCenterName, solutionName);
                logger.info((Object)("BOS workflow service start successed! Server:" + engine.getServerKey() + ". AIS:" + dataCenterName + ". Solution:" + solutionName));
                continue;
            }
            catch (WfException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void startAll() throws WfException {
        WfEngine.startAll();
    }

    public static void stopAll() throws WfException {
        WfEngine.stopAll();
    }
}

