/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.service.job.core.ICoreJobHandler;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.util.Counter;

public class WfRuntimeStat {
    private static Counter assignCount = new Counter(300);
    private static Counter eventCount = new Counter(300);
    private static Counter runningTime = new Counter(300);
    private static Counter bizTime = new Counter(300);
    private static Counter errorCount = new Counter(300);
    private static Counter bizErrorCount = new Counter(300);
    private static Counter fatalErrorCount = new Counter(300);
    private static int currentRunningCount;
    private static int currentBizCount;
    private static final long MAX = 300L;

    public static synchronized long getAssignCount() {
        return assignCount.get();
    }

    public static synchronized int getCurrentRunningCount() {
        return currentRunningCount;
    }

    public static synchronized long getErrorCount() {
        return errorCount.get();
    }

    public static synchronized int getBizErrorCount() {
        return bizErrorCount.get();
    }

    public static synchronized int getFatalErrorCount() {
        return fatalErrorCount.get();
    }

    public static synchronized long getEventCount() {
        return eventCount.get();
    }

    public static synchronized int getCurrentBizCount() {
        return currentBizCount;
    }

    public static synchronized long getRunningTime() {
        return runningTime.get();
    }

    public static synchronized long getBizTime() {
        return bizTime.get();
    }

    public static synchronized void incAssignCount() {
        assignCount.inc(1);
    }

    public static synchronized void incCurrentRunningCount() {
        ++currentRunningCount;
    }

    public static synchronized void incCurrentBizCount() {
        ++currentBizCount;
    }

    public static synchronized void decCurrentRunningCount() {
        --currentRunningCount;
    }

    public static synchronized void decCurrentBizCount() {
        --currentBizCount;
    }

    public static synchronized void incErrorCount() {
        errorCount.inc(1);
    }

    public static synchronized void incFatalErrorCount() {
        fatalErrorCount.inc(1);
    }

    public static synchronized void incBizErrorCount() {
        bizErrorCount.inc(1);
    }

    public static synchronized void incEventCount() {
        eventCount.inc(1);
    }

    private static synchronized void incBizTime(int milliseconds) {
        bizTime.inc(milliseconds);
    }

    private static synchronized void incRunningTime(int milliseconds) {
        runningTime.inc(milliseconds);
    }

    static {
        WfRuntimeScanner handler = new WfRuntimeScanner();
        Job job = new Job(null, "WF-RUNTIME-STAT", (IJobHandler)handler, null, false, true, 1000000);
        JobManager.instance().add(job);
    }

    private static class WfRuntimeScanner
    implements IJobHandler,
    ICoreJobHandler {
        private static final long serialVersionUID = 1L;
        private Delay delay = new Delay(100L);
        private long lastTime = -1L;

        private WfRuntimeScanner() {
        }

        public Object execute(Job job) throws Exception {
            if (this.lastTime < 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            long now = System.currentTimeMillis();
            long diff = now - this.lastTime;
            int currentBizCount = WfRuntimeStat.getCurrentBizCount();
            int currentWfCount = WfRuntimeStat.getCurrentRunningCount();
            if (currentBizCount > 0 || diff > 300L) {
                WfRuntimeStat.incBizTime((int)diff);
            }
            if (currentWfCount > 0 || diff > 300L) {
                WfRuntimeStat.incRunningTime((int)diff);
            }
            this.lastTime = now;
            return this.delay;
        }
    }
}

