/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.app;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.service.CommonServiceManager;
import com.kingdee.bos.service.ServiceRef;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.application.Application;
import com.kingdee.bos.workflow.biz.FunctionHelper;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ApplicationType;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ExternalType;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.FunctionActivityDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.IApplicationActivity;
import com.kingdee.bos.workflow.define.JavaMethodDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.OtherSys;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ResponsibleCollection;
import com.kingdee.bos.workflow.define.ScriptFunction;
import com.kingdee.bos.workflow.define.ScriptFunctionUtil;
import com.kingdee.bos.workflow.define.ServiceActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.extended.BotpActivityDef;
import com.kingdee.bos.workflow.define.extended.OtherSysActivityDef;
import com.kingdee.bos.workflow.enactment.AsyncTaskHandler;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.app.AbstractApplicationManager;
import com.kingdee.bos.workflow.enactment.app.ApplicationMonitor;
import com.kingdee.bos.workflow.enactment.async.OtherSysUtil;
import com.kingdee.bos.workflow.enactment.async.RpaUtil;
import com.kingdee.bos.workflow.enactment.message.WfMessage;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.engine.core.runmonitor.MonitorContext;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.ProcessInstEventEnum;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.transaction.WfTxHelper;
import com.kingdee.bos.workflow.transaction.WfTxInvocationDesc;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.BotpUtils;
import com.kingdee.bos.workflow.util.EnactmentUtils;
import com.kingdee.bos.workflow.util.MethodDesc;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.bos.workflow.util.WorkflowUtils;
import com.kingdee.bos.workflow.wfdesigner.WfFunctionInfo;
import com.kingdee.bos.workflow.wfdesigner.service.IWorkFlowDefineService;
import com.kingdee.exception.FriendlyBOSException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;

public class DefaultApplicationManager
extends AbstractApplicationManager {
    private static Logger logger = Logger.getLogger(DefaultApplicationManager.class);
    private static HashSet applicationMonitorSet = new HashSet();

    public DefaultApplicationManager(WfActivity activityInst) {
        super(activityInst);
    }

    public static synchronized void addApplicationMonitor(ApplicationMonitor monitor) {
        applicationMonitorSet.add(monitor);
    }

    public static synchronized void removeApplicationMonitor(ApplicationMonitor monitor) {
        applicationMonitorSet.remove(monitor);
    }

    public static ArrayList getInvokeArgs(WfActivity activity, ActualParameterCollection actualParameters, FormalParameterCollection formalParameters, Map parameterMap, boolean isTransform) throws WfException {
        ArrayList args = new ArrayList();
        for (int i = 0; i < actualParameters.size(); ++i) {
            FormalParameterDef formalParameter;
            ActualParameterDef item = actualParameters.get(i);
            if (item.getIndex() >= formalParameters.size() || (formalParameter = formalParameters.get(item.getIndex())).getMode().equals((Object)FormalParameterMode.OUT)) continue;
            Object formalParamData = parameterMap.get(formalParameter.getID());
            if (isTransform) {
                formalParamData = DefaultApplicationManager.transParameterData(activity, item, formalParameter, formalParamData);
            }
            if (formalParamData == null && activity.getDefinition().getClass().toString().contains("com.kingdee.bos.workflow.define.ToolActivityDef")) {
                ToolActivityDef toolActivity = (ToolActivityDef)activity.getDefinition();
                String noTypeValue = (String)toolActivity.getToolActualsMap().get(formalParameter.getIndex());
                if (formalParameter.getDataType().equals(BasicType.INTEGER)) {
                    formalParamData = Integer.parseInt(noTypeValue);
                } else if (formalParameter.getDataType().equals(BasicType.STRING)) {
                    formalParamData = noTypeValue;
                } else if (formalParameter.getDataType().equals(BasicType.FLOAT)) {
                    formalParamData = Float.valueOf(Float.parseFloat(noTypeValue));
                } else if (formalParameter.getDataType().equals(BasicType.BOOLEAN)) {
                    formalParamData = Boolean.parseBoolean(noTypeValue);
                }
            }
            args.add(formalParamData);
        }
        return args;
    }

    public static Map getInvokeArgs(ArrayList argList, FormalParameterCollection formalParameters) {
        HashMap args = new HashMap();
        int index = 0;
        int n = formalParameters.size();
        for (int i = 0; i < n; ++i) {
            FormalParameterDef formalParam = formalParameters.get(i);
            if (index >= argList.size() || formalParam.getMode().equals((Object)FormalParameterMode.OUT) || formalParam.getID() == null) continue;
            args.put(formalParam.getName(), argList.get(index++));
        }
        return args;
    }

    public static Object transParameterData(WfActivity activity, ActualParameterDef item, FormalParameterDef formalParameter, Object formalParamData) throws WfException {
        if (formalParameter.getDataType().equals(BasicType.PK)) {
            if (formalParamData != null) {
                String boId = formalParamData.toString();
                Object temp = formalParamData;
                try {
                    formalParamData = FunctionHelper.createPKbyBoId(boId);
                }
                catch (Exception e) {
                    log.error((Object)("transParameterData " + boId), (Throwable)e);
                    if (formalParamData instanceof ObjectUuidPK) {
                        formalParamData = temp;
                    }
                    throw new WfException((Throwable)e);
                }
            }
        } else if (formalParameter.getDataType().equals(BasicType.OBJECTVALUE)) {
            if (formalParamData != null) {
                String boId = formalParamData.toString();
                Object temp = formalParamData;
                try {
                    formalParamData = FunctionHelper.createObjectValueByBoId(boId, activity.getWfEngine().context());
                }
                catch (Exception e) {
                    log.error((Object)("transParameterData " + boId), (Throwable)e);
                    if (formalParamData instanceof IObjectValue) {
                        formalParamData = temp;
                    }
                    throw new WfException((Throwable)e);
                }
            }
        } else if (formalParameter.getDataType().equals(BasicType.STRING)) {
            if (!(BasicType.STRING.equals((Object)item.getDataField().getDataType()) && formalParamData instanceof String || formalParamData == null)) {
                if (ExternalType.ENUM.equals((Object)item.getDataField().getDataType())) {
                    if (formalParamData instanceof StringEnum) {
                        String value = ((StringEnum)formalParamData).getValue();
                        formalParamData = value;
                    }
                } else {
                    formalParamData = formalParamData.toString();
                }
            }
        } else if (formalParameter.getDataType().equals(BasicType.INTEGER)) {
            if (ExternalType.ENUM.equals((Object)item.getDataField().getDataType()) && formalParamData != null && formalParamData instanceof IntEnum) {
                int value = ((IntEnum)formalParamData).getValue();
                formalParamData = new Integer(value);
            }
        } else if (formalParameter.getDataType().equals(BasicType.FLOAT)) {
            if (ExternalType.ENUM.equals((Object)item.getDataField().getDataType()) && formalParamData != null && formalParamData instanceof FloatEnum) {
                float value = ((FloatEnum)formalParamData).getValue();
                formalParamData = new Float(value);
            }
        } else if (formalParameter.getDataType().equals(BasicType.BOID)) {
            if (formalParamData instanceof ObjectUuidPK) {
                formalParamData = ((ObjectUuidPK)formalParamData).getKeyValue();
            } else if (formalParamData instanceof String) {
                formalParamData = BOSUuid.read((String)((String)formalParamData));
            }
        }
        return formalParamData;
    }

    public static Map getParameterMap(WfActivity activity, ProcessContext context, ActualParameterCollection actualParameters, FormalParameterCollection formalParameters, boolean idKey) {
        Iterator iter = actualParameters.iterator();
        HashMap parameterMap = new HashMap();
        ApplicationDef appDef = null;
        String key = null;
        if (activity.getDefinition() != null) {
            appDef = ((IApplicationActivity)activity.getDefinition()).getRelatedApplication();
        }
        if (appDef != null && appDef.getType().equals((Object)ApplicationType.SCRIPT)) {
            parameterMap = (HashMap)context.getDataCopy();
        } else {
            while (iter.hasNext()) {
                FormalParameterDef formalParameter;
                ActualParameterDef item = (ActualParameterDef)iter.next();
                if (item.getIndex() >= formalParameters.size() || !"IN".equals((formalParameter = formalParameters.get(item.getIndex())).getMode().getName())) continue;
                key = idKey ? formalParameter.getID() : formalParameter.getName();
                String name = item.getDataFieldName(activity.getDefinition());
                if (!StringUtils.isEmpty((String)item.getProp())) {
                    name = name + "." + item.getProp();
                }
                parameterMap.put(key, context.getDataFieldValue(name));
            }
        }
        return parameterMap;
    }

    public static Map getAssignmentArguments(WfEngine engine, String assignmentId, boolean isTransform) throws WfException {
        WfAssignment assignInst = engine.getAssignment(assignmentId);
        return DefaultApplicationManager.getAssignmentArguments(assignInst, isTransform);
    }

    public static Map getAssignmentArguments(WfAssignment assignInst, boolean isTransform) throws WfException {
        Map args = new HashMap();
        ManpowerActivityDef actDef = (ManpowerActivityDef)assignInst.getActInst().getDefinition();
        Map parameterMap = DefaultApplicationManager.getParameterMap(assignInst.getActInst(), assignInst.getActInst().container().getProcessContext(), actDef.getActualParameters(), actDef.getRelatedApplication().getFormalParameters(), true);
        ArrayList argList = DefaultApplicationManager.getInvokeArgs(assignInst.getActInst(), actDef.getActualParameters(), actDef.getRelatedApplication().getFormalParameters(), parameterMap, isTransform);
        args = DefaultApplicationManager.getInvokeArgs(argList, actDef.getRelatedApplication().getFormalParameters());
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeApplication(ApplicationDef application, ActualParameterCollection actualParameters) throws WfException {
        block25: {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().enter(this.getClass().getName(), "invokeApplication", null);
            }
            String operation = null;
            String proc_name = null;
            String instance_number = null;
            long startTime = System.currentTimeMillis();
            try {
                if (application == null) {
                    return;
                }
                FunctionDef function = application.getFunction();
                if (function != null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(function.getPackageName()).append('.').append(function.getName()).append('.').append(function.getOperation());
                    operation = sb.toString();
                }
                if (this.activityInst != null && this.activityInst.container() != null && this.activityInst.container().manager() != null && this.activityInst.container().manager().getData() != null && this.activityInst.container().getData() != null) {
                    proc_name = this.activityInst.container().manager().getData().getProcDefName(new Locale("l2"));
                    instance_number = this.activityInst.container().getData().getCode();
                }
                String text = proc_name + " - " + this.activityInst.getMeta().getActDefName(new Locale("l2"));
                MonitorContext.putValue("billHandler", text + "\u8282\u70b9");
                MonitorContext.putValue("actInstID", this.activityInst.getId());
                MonitorContext.putValue("procInstID", this.activityInst.getProcInstId());
                boolean flag = false;
                ProcessContext context = this.getProcessContext();
                try {
                    if (application.getType().equals((Object)ApplicationType.TOOL)) {
                        flag = true;
                        this.activityInst.getWfEngine().putApplicationRunMark(this.activityInst.getMeta().getActDefId(), text);
                        this.invokeTool(application, this.activityInst, context, actualParameters);
                        break block25;
                    }
                    if (application.getType().equals((Object)ApplicationType.SCRIPT)) {
                        flag = true;
                        this.activityInst.getWfEngine().putApplicationRunMark(this.activityInst.getMeta().getActDefId(), text);
                        this.invokeScript(application, this.activityInst, context, actualParameters);
                        break block25;
                    }
                    if (application.getType().equals((Object)ApplicationType.EXTERNALCLASS)) {
                        this.invokeExternalClass(application, this.activityInst, context, actualParameters);
                        break block25;
                    }
                    if (application.getType().equals((Object)ApplicationType.FUNCTION)) {
                        flag = true;
                        this.activityInst.getWfEngine().putApplicationRunMark(this.activityInst.getMeta().getActDefId(), text);
                        this.invokeFunction(application, this.activityInst, context, actualParameters);
                        break block25;
                    }
                    if (application.getType().equals((Object)ApplicationType.BOTP)) {
                        this.invokeBotpFunction(application, this.activityInst, context, actualParameters);
                        break block25;
                    }
                    if (application.getType().equals((Object)ApplicationType.SERVICE)) {
                        this.invokeService(application, this.activityInst, context, actualParameters);
                        break block25;
                    }
                    if (application.getType().equals((Object)ApplicationType.JAVA_METHOD)) {
                        flag = true;
                        this.activityInst.getWfEngine().putApplicationRunMark(this.activityInst.getMeta().getActDefId(), text);
                        this.invokeJavaMethod(application, this.activityInst, context, actualParameters);
                        break block25;
                    }
                    if (application.getType().equals((Object)ApplicationType.ASYNC_TASK)) {
                        this.invokeAsyncTask(application, this.activityInst, context, actualParameters);
                        break block25;
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("ApplicationType Error :");
                    buffer.append(application.getType().getName());
                    String message = buffer.toString();
                    throw new WfException(message);
                }
                finally {
                    try {
                        if (flag) {
                            this.activityInst.getWfEngine().removeApplicationRunMark(this.activityInst.getMeta().getActDefId());
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                if (ProfileConfig.getInstance().logWfEngine) {
                    ThreadProfileContext.getInstance().exit();
                }
            }
        }
    }

    private void sendErrorMsg(ApplicationDef application, WfActivity activity, Throwable e) throws WfException {
        if (this.isSendErrorMsg(activity)) {
            try {
                WfMessage message = new WfMessage();
                message.setActivity(activity);
                ProcessInstInfo processInstInfo = activity.container().getData();
                Locale[] locales = ApplicationUtil.getContextLocales((Context)activity.getWfEngine().context());
                for (int i = 0; i < locales.length; ++i) {
                    Locale locale = locales[i];
                    message.addSubject(this.getMessageSubject(activity, locale), locale);
                    message.addContent(this.getMessageBody(application, activity, e, locale), locale);
                    message.addInitiatorName(processInstInfo.getInitiatorName(locale), locale);
                }
                ProcessDef processDef = (ProcessDef)activity.getDefinition().getContainer();
                ResponsibleCollection responsibles = processDef.getProcessHeader().getResponsibles();
                String initiatorId = activity.container().getProcessMeta().getInitiatorId();
                for (int personIndex = 0; personIndex < responsibles.size(); ++personIndex) {
                    String personId = responsibles.get(personIndex).getID();
                    String userId = this.getUserIdByPersonId(personId, activity);
                    String receiver = this.wipeRepeatedUserId(userId + ";" + initiatorId);
                    message.sendNoTransaction(activity.getWfEngine().context(), receiver);
                }
            }
            catch (Throwable se) {
                log.warn((Object)"send error message error.", se);
            }
        }
    }

    private String wipeRepeatedUserId(String userId) {
        String[] userIds = userId.split(";");
        HashSet<String> set = new HashSet<String>();
        int n = userIds.length;
        for (int i = 0; i < n; ++i) {
            if (set.contains(userIds[i])) continue;
            set.add(userIds[i]);
        }
        StringBuffer receiver = new StringBuffer();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            receiver.append(i.next()).append(';');
        }
        return receiver.toString();
    }

    private String getUserIdByPersonId(String personId, WfActivity activity) throws WfException {
        StringBuffer userIdBuffer = new StringBuffer();
        IParticipantProvider IPersonProvider = activity.getWfEngine().getPariticipantProvider();
        Person[] persons = IPersonProvider.getPersonByEmployeeId(activity.getWfEngine().context(), personId);
        for (int i = 0; i < persons.length; ++i) {
            userIdBuffer.append(persons[i].getUserId());
            userIdBuffer.append(';');
        }
        userIdBuffer.delete(userIdBuffer.length() - 1, userIdBuffer.length());
        return userIdBuffer.toString();
    }

    private String getMessageSubject(WfActivity activity, Locale local) throws WfException {
        StringBuffer titlebuffer = new StringBuffer();
        titlebuffer.append(activity.container().getData().getProcDefName(local)).append(" - ").append(activity.container().getData().getCode()).append(" - ").append(activity.getDefinition().getName(local)).append(" - ");
        titlebuffer.append("\u7684\u5f02\u5e38\u4fe1\u606f\uff01");
        return titlebuffer.toString();
    }

    private boolean isSendErrorMsg(WfActivity activity) {
        boolean result = false;
        ExtendedAttributeDef autoErrorSendTag = activity.getDefinition().getActivityHeader().getExtendedAttributes().get("autoErrorSend");
        if (autoErrorSendTag != null && autoErrorSendTag.getValue().equalsIgnoreCase("true")) {
            return true;
        }
        return result;
    }

    private String getMessageBody(ApplicationDef application, WfActivity activity, Throwable e, Locale local) throws WfException {
        StringBuffer extendedDescription = new StringBuffer();
        FunctionDef functionDef = application.getFunction();
        if (functionDef == null) {
            extendedDescription.append("\u4efb\u52a1[").append(activity.getMeta().getActDefName(new Locale("L2"))).append("]\u6267\u884c\u4e2d\u53d1\u751f\u9519\u8bef").append('\n').append("\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a").append(e.getMessage());
        } else {
            extendedDescription.append("\u4efb\u52a1[").append(functionDef.getName()).append('-').append(functionDef.getOperation()).append("]\u6267\u884c\u4e2d\u53d1\u751f\u9519\u8bef").append('\n').append("\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a").append(e.getMessage());
        }
        return extendedDescription.toString();
    }

    private void executeToolExceptionLog(WfActivity activity, FunctionDef function, ArrayList invokeArgs, Throwable e) {
        try {
            WfLogger wfLogger = activity.getWfEngine().getWfLogger();
            StringBuffer buffer = new StringBuffer();
            buffer.append("Execute function error!\n");
            buffer.append("The detail is ");
            buffer.append("activityDefId=" + activity.getDefinition().getID());
            buffer.append(";functionName=");
            buffer.append(function.getName());
            buffer.append(";parameters:{");
            if (invokeArgs != null) {
                Object[] parameters = invokeArgs.toArray();
                for (int i = 0; i < parameters.length; ++i) {
                    buffer.append(i == 0 ? "" : ";");
                    buffer.append(parameters[i]);
                }
            }
            buffer.append('}');
            buffer.append(";statckTrace=");
            buffer.append(StringUtils.stackToString((Throwable)e));
            buffer.append('.');
            String message = buffer.toString();
            wfLogger.addWfProcessInstLog(LogTypeEnum.ERROR, ProcessInstEventEnum.RUNTOOLERROR, activity.container().getId(), message);
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeTool(ApplicationDef application, WfActivity activity, ProcessContext context, ActualParameterCollection actualParameters) throws WfException {
        long time = System.currentTimeMillis();
        FormalParameterCollection formalParameters = application.getFormalParameters();
        Map parameterMap = DefaultApplicationManager.getParameterMap(activity, context, actualParameters, formalParameters, true);
        FunctionDef functionDef = application.getFunction();
        ArrayList invokeArgs = DefaultApplicationManager.getInvokeArgs(activity, actualParameters, formalParameters, parameterMap, true);
        Context ctx = EnactmentUtils.getApplicationContext(activity);
        String actInstId = activity.getId();
        String actDefName = activity.getName();
        String procInstId = activity.getProcInstId();
        String procDefName = activity.getProcess().getName();
        String bizPackage = functionDef.getPackageName();
        String function = functionDef.getName();
        String bizOperation = functionDef.getOperation();
        Object returnObject = null;
        try {
            String info = "Invoking Automatic Function, procInstId=" + procInstId + ",actInstId=" + actInstId + "\nprocDefName=" + procDefName + ",actDefName=" + actDefName + "\nFunction:" + bizPackage + "." + function + ",Operation=" + bizOperation + "\nArguments:" + invokeArgs;
            log.info((Object)info);
            returnObject = this.needRollbackToolActivity(activity) ? FunctionHelper.invokeAutomatic(ctx, functionDef.getPackageName(), functionDef.getName(), functionDef.getOperation(), invokeArgs.toArray(), this.isHandEvent(activity)) : this.invokeAutomaticRequiresNew(ctx, functionDef, invokeArgs, this.isHandEvent(activity));
            String applicationName = "\u8282\u70b9\u540d\u79f0:" + actDefName + ",\u529f\u80fd:" + bizPackage + "." + bizOperation;
            MonitorContext.putValue("billHandler", applicationName);
            info = "Invoked Automatic Function, procInstId=" + procInstId + ",actInstId=" + actInstId + "\nReturn:" + returnObject;
            log.info((Object)info);
            this.setProcessContextForErrorMsg(activity, context);
            if (returnObject == null) return;
        }
        catch (Throwable e) {
            try {
                String info = "Invoked Automatic Function, procInstId=" + procInstId + ",actInstId=" + actInstId + "\nException:";
                log.error((Object)info, e);
                boolean existsNullParam = false;
                String paras = "parameters:{\r\n";
                if (invokeArgs != null) {
                    Object[] parameters = invokeArgs.toArray();
                    for (int i = 0; i < parameters.length; ++i) {
                        paras = paras + "[\u53c2\u6570\u503c\uff1a" + parameters[i];
                        if (parameters[i] != null) {
                            paras = paras + "\uff0c\u53c2\u6570\u7c7b\u578b\uff1a" + parameters[i].getClass().toString();
                        } else {
                            existsNullParam = true;
                        }
                        paras = paras + "]\r\n";
                    }
                }
                paras = paras + "}";
                String procDefId = activity.getDefinition().getContainer().getID();
                log.info((Object)("DefaultApplicationManager invokeTool error! PackageName:" + functionDef.getPackageName() + " FunctionName:" + functionDef.getName() + " Operation:" + functionDef.getOperation()));
                log.info((Object)("Datacenter:" + ctx.getAIS() + "; ProcessDef:" + procDefId + "; ActivityDef:" + activity.getDefinition().getID() + "; " + paras + "; Error Message:" + e.getMessage()), e);
                this.sendErrorMsg(application, activity, e);
                String actDefId = activity.getDefinition().getID();
                DefaultApplicationManager.setInvokeExceptionToContext(e, context, actDefId);
                if (this.needRollbackToolActivity(activity)) {
                    InvocationTargetException ite;
                    IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
                    FunctionObjectInfo functionObjectInfo = loader.getFunction((IMetaDataPK)new MetaDataPK(functionDef.getPackageName(), functionDef.getName()));
                    if (e instanceof FriendlyBOSException) {
                        FriendlyBOSException friendlyBOSException = (FriendlyBOSException)e;
                        WorkflowUtils.logProcessException(activity.getProcInstId(), activity.getWfEngine(), friendlyBOSException);
                    } else if (e instanceof InvocationTargetException && (ite = (InvocationTargetException)e).getTargetException() != null && ite.getTargetException() instanceof FriendlyBOSException) {
                        FriendlyBOSException friendlyBOSException = (FriendlyBOSException)ite.getTargetException();
                        WorkflowUtils.logProcessException(activity.getProcInstId(), activity.getWfEngine(), friendlyBOSException);
                    }
                    if (functionObjectInfo != null && functionObjectInfo.getOperation() != null) {
                        OperationCollection operationCollection = functionObjectInfo.getOperation();
                        OperationInfo operationInfo = null;
                        int size = operationCollection.size();
                        for (int i = 0; i < size; ++i) {
                            OperationInfo temp = operationCollection.get(i);
                            if (!functionDef.getOperation().equals(temp.getName())) continue;
                            operationInfo = temp;
                            break;
                        }
                        if (operationInfo != null) {
                            WfException wfException = new WfException("WFE_TOOL_invoke", null, e);
                            wfException.addArg(activity.getMeta().getActInstInfo().getActDefName()).addArg(functionObjectInfo.getAlias()).addArg(functionObjectInfo.getFullName()).addArg(operationInfo.getAlias()).addArg(operationInfo.getName());
                            wfException.setIgnoreCurentStrack(true);
                            wfException.setExMessage(paras);
                            ProcessInstEventEnum event = ProcessInstEventEnum.COMMON;
                            event = e.getMessage() != null && e.getMessage().contains("BOSFramework_invokeFunction_paramTypeNotMatched") ? ProcessInstEventEnum.TOOLARGTYPENOTMATCH : (existsNullParam ? ProcessInstEventEnum.TOOLARGISEMPTY : ProcessInstEventEnum.TOOLBIZFUNCTIONERROR);
                            WorkflowUtils.logProcessException(activity.getProcInstId(), activity.getWfEngine(), wfException, event);
                            throw wfException;
                        }
                        this.executeToolExceptionLog(activity, functionDef, invokeArgs, e);
                        throw new WfException(e, true);
                    }
                    this.executeToolExceptionLog(activity, functionDef, invokeArgs, e);
                    throw new WfException(e, true);
                }
                this.executeToolExceptionLog(activity, functionDef, invokeArgs, e);
                if (returnObject == null) return;
            }
            catch (Throwable throwable) {
                if (returnObject == null) throw throwable;
                this.writeOutputToContext(returnObject, actualParameters, formalParameters, ApplicationType.TOOL);
                throw throwable;
            }
            this.writeOutputToContext(returnObject, actualParameters, formalParameters, ApplicationType.TOOL);
            return;
        }
        this.writeOutputToContext(returnObject, actualParameters, formalParameters, ApplicationType.TOOL);
        return;
    }

    private boolean isHandEvent(WfActivity activity) {
        ExtendedAttributeDef isHandEvent = activity.getDefinition().getActivityHeader().getExtendedAttributes().get("isHandEvent");
        return isHandEvent != null && isHandEvent.getValue().equalsIgnoreCase("true");
    }

    private Object invokeAutomaticRequiresNew(Context ctx, FunctionDef functionDef, ArrayList invokeArgs, boolean isHandEvent) throws WfException {
        Class<FunctionHelper> classCaller = FunctionHelper.class;
        Object obj = null;
        String methodName = "invokeAutomatic";
        Class[] parameterTypes = new Class[]{Context.class, String.class, String.class, String.class, Object[].class, Boolean.TYPE};
        Object[] args = new Object[]{ctx, functionDef.getPackageName(), functionDef.getName(), functionDef.getOperation(), invokeArgs.toArray(), isHandEvent};
        MethodDesc methodDesc = new MethodDesc(classCaller, methodName, parameterTypes);
        WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, obj, args);
        return WfTxHelper.invokeRequiresNew(ctx, invocationDesc);
    }

    private Object invokeBotpTransformRequiresNew(WfActivity activity, Context ctx, String billId, String orgId, String srcBillType, String destBillType) throws WfException {
        Class<BotpUtils> classCaller = BotpUtils.class;
        Object obj = null;
        String methodName = "transform";
        Class[] parameterTypes = new Class[]{WfActivity.class, Context.class, String.class, String.class, String.class, String.class};
        Object[] args = new Object[]{activity, ctx, billId, orgId, srcBillType, destBillType};
        MethodDesc methodDesc = new MethodDesc(classCaller, methodName, parameterTypes);
        WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, obj, args);
        return WfTxHelper.invokeRequiresNew(ctx, invocationDesc);
    }

    private Object invokeBotpTransformByMappingIdRequiresNew(WfActivity activity, Context ctx, String billId, String srcBillType, String botpMappingId) throws WfException {
        Class<BotpUtils> classCaller = BotpUtils.class;
        Object obj = null;
        String methodName = "transformByMappingId";
        Class[] parameterTypes = new Class[]{WfActivity.class, Context.class, String.class, String.class, String.class};
        Object[] args = new Object[]{activity, ctx, billId, srcBillType, botpMappingId};
        MethodDesc methodDesc = new MethodDesc(classCaller, methodName, parameterTypes);
        WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, obj, args);
        return WfTxHelper.invokeRequiresNew(ctx, invocationDesc);
    }

    private Object invokeScriptRequiresNew(Context ctx, String script, WfActivity activity, Map parameters) throws WfException {
        Class<ScriptUtil> classCaller = ScriptUtil.class;
        Object obj = null;
        String methodName = "executeScript";
        Class[] parameterTypes = new Class[]{String.class, WfActivity.class, Map.class};
        Object[] args = new Object[]{script, activity, parameters};
        MethodDesc methodDesc = new MethodDesc(classCaller, methodName, parameterTypes);
        WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, obj, args);
        return WfTxHelper.invokeRequiresNew(ctx, invocationDesc);
    }

    private Object invokeScriptReturnValueRequiresNew(Context ctx, String script, WfActivity activity, Map parameters) throws WfException {
        Class<ScriptUtil> classCaller = ScriptUtil.class;
        Object obj = null;
        String methodName = "executeScript";
        Class[] parameterTypes = new Class[]{String.class, WfActivity.class, Map.class};
        Object[] args = new Object[]{script, activity, parameters};
        MethodDesc methodDesc = new MethodDesc(classCaller, methodName, parameterTypes);
        WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, obj, args);
        return WfTxHelper.invokeRequiresNew(ctx, invocationDesc);
    }

    private boolean needRollbackToolActivity(WfActivity activity) {
        if (activity != null && activity.getDefinition() instanceof ToolActivityDef) {
            return ((ToolActivityDef)activity.getDefinition()).isDefaultRollback();
        }
        return false;
    }

    private void invokeScript(ApplicationDef application, WfActivity activity, ProcessContext context, ActualParameterCollection actualParameters) throws WfException {
        FormalParameterCollection formalParameters = application.getFormalParameters();
        Map parameterMap = DefaultApplicationManager.getParameterMap(activity, context, actualParameters, formalParameters, true);
        String script = application.getScript().getScriptContent();
        Context ctx = EnactmentUtils.getApplicationContext(activity);
        try {
            if (this.needRollbackToolActivity(activity)) {
                ScriptUtil.executeScript(script, activity, parameterMap);
            } else {
                this.invokeScriptRequiresNew(ctx, script, activity, parameterMap);
            }
            activity.container().receiveResults(activity, parameterMap);
        }
        catch (Throwable e) {
            WfException ex = new WfException("WFE_SCRIPT_execute", null, e).addArg(activity.getMeta().getActInstInfo().getActDefName()).addArg("");
            ex.setIgnoreCurentStrack(true);
            WorkflowUtils.logProcessException(activity.getProcInstId(), activity.getWfEngine(), ex, ProcessInstEventEnum.EVALPOSTSCRIPTERROR);
            this.sendErrorMsg(application, activity, e);
            log.warn((Object)e.getMessage(), e);
            String actDefId = activity.getDefinition().getID();
            context = this.getProcessContext();
            DefaultApplicationManager.setInvokeExceptionToContext(e, context, actDefId);
            throw ex;
        }
    }

    private void invokeAsyncTask(ApplicationDef application, WfActivity activity, ProcessContext context, ActualParameterCollection actualParameters) throws WfException {
        FormalParameterCollection formalParameters = application.getFormalParameters();
        Map parameterMap = DefaultApplicationManager.getParameterMap(activity, context, actualParameters, formalParameters, false);
        boolean isReturn = this.isFunctionReturn(formalParameters);
        OtherSysActivityDef osActDef = (OtherSysActivityDef)activity.getDefinition();
        String apiId = osActDef.getApiId();
        if (apiId == null || "".equals(apiId)) {
            throw new WfException(activity.getDefinition().getName() + "\u7684\u4efb\u52a1ID\u4e3a\u7a7a");
        }
        Context ctx = EnactmentUtils.getApplicationContext(activity);
        String content = OtherSysUtil.getOtherSysContentByApiId(apiId, ctx);
        try {
            String address;
            OtherSys os = OtherSysUtil.parse(content);
            String script = os == null ? "" : os.getScript();
            String callMode = os == null ? "" : os.getCallMode();
            String string = address = os == null ? "" : os.getAddress();
            if (!"ysq".equalsIgnoreCase(callMode) && !"YSQDYNAMIC".equalsIgnoreCase(callMode)) {
                RpaUtil.addRpaParams(os, parameterMap, ctx);
            }
            AsyncTaskHandler handler = new AsyncTaskHandler(activity, activity.getProcInstId(), apiId, callMode, address, script, parameterMap, isReturn, os);
            String title = "~AsyncTask:" + activity.getId();
            Job job = new Job(activity.getContext(), title, (IJobHandler)handler, null, true, false);
            JobManager.instance().add(job);
        }
        catch (JDOMException e) {
            throw new WfException((Throwable)e);
        }
        catch (IOException e) {
            throw new WfException((Throwable)e);
        }
        catch (JSONException e) {
            throw new WfException((Throwable)e);
        }
    }

    private void invokeExternalClass(ApplicationDef application, WfActivity activity, ProcessContext context, ActualParameterCollection actualParameters) throws WfException {
        FormalParameterCollection formalParameters = application.getFormalParameters();
        Map parameterMap = DefaultApplicationManager.getParameterMap(activity, context, actualParameters, formalParameters, true);
        String className = application.getExternalClass().getClassName();
        if (className != null && className.length() > 0) {
            try {
                Object o = Class.forName(className).newInstance();
                if (o instanceof Application) {
                    ((Application)o).invoke(parameterMap);
                }
            }
            catch (Throwable e) {
                log.warn((Object)"Exceute External Class Error!", e);
            }
        }
        for (ActualParameterDef item : actualParameters) {
            FormalParameterDef formalParameter;
            if (item.getIndex() >= formalParameters.size() || (formalParameter = formalParameters.get(item.getIndex())).getMode().equals((Object)FormalParameterMode.IN)) continue;
            context.setDataFieldValue(formalParameter.getID(), parameterMap.get(formalParameter.getID()));
        }
        context.storeToDb();
    }

    private void invokeFunction(ApplicationDef application, WfActivity activity, ProcessContext context, ActualParameterCollection actualParameters) throws WfException {
        FormalParameterCollection formalParameters = application.getFormalParameters();
        Map parameterMap = DefaultApplicationManager.getParameterMap(activity, context, actualParameters, formalParameters, false);
        String script = ((FunctionActivityDef)activity.getDefinition()).getScript();
        boolean isReturn = this.isFunctionReturn(formalParameters);
        Context ctx = EnactmentUtils.getApplicationContext(activity);
        String scriptFunctionId = ((FunctionActivityDef)activity.getDefinition()).getScriptFunctionid();
        if (!StringUtils.isEmpty((String)scriptFunctionId)) {
            try {
                IWorkFlowDefineService service = (IWorkFlowDefineService)BOSObjectFactory.createBOSObject((Context)ctx, (String)"com.kingdee.bos.workflow.wfdesigner.service.WorkFlowDefineService");
                WfFunctionInfo tWfFunctionInfo = service.getWfFunctionInfoById(scriptFunctionId);
                ScriptFunction sf = ScriptFunctionUtil.parse((String)tWfFunctionInfo.getContent());
                script = sf.getScript();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
        }
        Object returnObject = null;
        try {
            if (!isReturn) {
                if (this.needRollbackToolActivity(activity)) {
                    ScriptUtil.executeScript(script, activity, parameterMap);
                } else {
                    this.invokeScriptRequiresNew(ctx, script, activity, parameterMap);
                }
                activity.container().receiveResults(activity, parameterMap);
            } else {
                returnObject = this.needRollbackToolActivity(activity) ? ScriptUtil.executeScriptReturnValue(script, activity, parameterMap) : this.invokeScriptReturnValueRequiresNew(ctx, script, activity, parameterMap);
                this.writeOutputToContext(returnObject, actualParameters, formalParameters, ApplicationType.FUNCTION);
            }
        }
        catch (Throwable e) {
            WfException ex = new WfException("WFE_SCRIPT_execute_function", null, e).addArg(activity.getMeta().getActInstInfo().getActDefName()).addArg("");
            ex.setIgnoreCurentStrack(true);
            WorkflowUtils.logProcessException(activity.getProcInstId(), activity.getWfEngine(), ex);
            this.sendErrorMsg(application, activity, e);
            log.warn((Object)e.getMessage(), e);
            String actDefId = activity.getDefinition().getID();
            context = this.getProcessContext();
            DefaultApplicationManager.setInvokeExceptionToContext(e, context, actDefId);
            throw ex;
        }
    }

    private void invokeBotpFunction(ApplicationDef application, WfActivity activity, ProcessContext context, ActualParameterCollection actualParameters) throws WfException {
        String botpId;
        FormalParameterCollection formalParameters = application.getFormalParameters();
        Map parameterMap = DefaultApplicationManager.getParameterMap(activity, context, actualParameters, formalParameters, false);
        parameterMap = this.convertParameter2String(parameterMap);
        BotpActivityDef actDef = (BotpActivityDef)activity.getDefinition();
        String botpMode = actDef.getBotpMode();
        String srcBillType = actDef.getSrcBillType();
        String tmpBotpId = botpId = actDef.getBotpId();
        boolean useVar = actDef.isUseVar();
        String destBillType = actDef.getDestBillType();
        String billId = (String)parameterMap.get("BillId");
        String orgId = (String)parameterMap.get("OrgId");
        String[] destBillIds = null;
        Context clonedContext = EnactmentUtils.getApplicationContext(activity);
        clonedContext.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        try {
            if (botpMode.equalsIgnoreCase("2")) {
                if (useVar) {
                    botpId = String.valueOf(context.getDataFieldValue(botpId));
                    tmpBotpId = tmpBotpId + "(" + botpId + ")";
                }
                destBillIds = this.needRollbackToolActivity(activity) ? BotpUtils.transformByMappingId(activity, clonedContext, billId, srcBillType, botpId) : (String[])this.invokeBotpTransformByMappingIdRequiresNew(activity, clonedContext, billId, srcBillType, botpId);
            } else if (botpMode.equalsIgnoreCase("1")) {
                destBillIds = this.needRollbackToolActivity(activity) ? BotpUtils.transform(activity, clonedContext, billId, orgId, srcBillType, destBillType) : (String[])this.invokeBotpTransformRequiresNew(activity, clonedContext, billId, orgId, srcBillType, destBillType);
            }
            Object returnValue = this.convertReturnValue(destBillIds, formalParameters, parameterMap);
            this.writeOutputToContext(returnValue, actualParameters, formalParameters, ApplicationType.BOTP);
        }
        catch (Throwable e) {
            WfException ex = new WfException("WFE_TOOL_invoke_botp", null, e).addArg(activity.getMeta().getActInstInfo().getActDefName()).addArg(botpMode.equalsIgnoreCase("2") ? "\u5229\u7528\u539f\u5355\u636e\u548c\u76ee\u6807\u5355\u636e\u6765\u81ea\u52a8\u5339\u914d\u8f6c\u6362\u89c4\u5219" : "BOTP\u8f6c\u6362\u89c4\u5219\u7684ID\u7684\u505a\u8f6c\u5316").addArg(actDef.getSrcBillName()).addArg(actDef.getSrcBillType()).addArg(actDef.getDestBillName()).addArg(actDef.getDestBillType()).addArg(actDef.getBotpMappingName()).addArg(tmpBotpId).addArg(orgId);
            ex.setIgnoreCurentStrack(true);
            WorkflowUtils.logProcessException(activity.getProcInstId(), activity.getWfEngine(), ex, ProcessInstEventEnum.BOTPEXECUTE);
            this.sendErrorMsg(application, activity, e);
            log.warn((Object)e.getMessage(), e);
            String actDefId = activity.getDefinition().getID();
            context = this.getProcessContext();
            DefaultApplicationManager.setInvokeExceptionToContext(e, context, actDefId);
            throw ex;
        }
        finally {
            clonedContext.put((Object)"disablePermissionForKScript", (Object)Boolean.FALSE);
        }
    }

    private Object convertReturnValue(String[] destBillIds, FormalParameterCollection formalParameters, Map parameterMap) {
        if (destBillIds == null || destBillIds.length <= 0) {
            return destBillIds;
        }
        if (formalParameters.size() <= 0) {
            return destBillIds;
        }
        Iterator iterator = formalParameters.iterator();
        FormalParameterDef outFormalparemeter = null;
        while (iterator.hasNext()) {
            FormalParameterDef def = (FormalParameterDef)iterator.next();
            if (!def.getMode().equals((Object)FormalParameterMode.OUT)) continue;
            outFormalparemeter = def;
            break;
        }
        if (outFormalparemeter != null) {
            boolean actParameterTypeIsString;
            DataType dataType = outFormalparemeter.getDataType();
            boolean bl = actParameterTypeIsString = parameterMap.get(outFormalparemeter.getName()) instanceof String || parameterMap.get(outFormalparemeter.getName()) instanceof String[];
            if (!BasicType.STRING.equals((Object)dataType) || !actParameterTypeIsString) {
                return this.transformUuidFromStringArray(destBillIds);
            }
        }
        return destBillIds;
    }

    private Object transformUuidFromStringArray(String[] destBillIds) {
        if (destBillIds == null || destBillIds.length <= 0) {
            return null;
        }
        BOSUuid[] uuids = new BOSUuid[destBillIds.length];
        for (int i = 0; i < destBillIds.length; ++i) {
            uuids[i] = BOSUuid.read((String)destBillIds[i]);
        }
        return uuids;
    }

    private Map convertParameter2String(Map parameterMap) {
        HashMap parameterValueMap = new HashMap();
        if (parameterMap == null || parameterMap.size() <= 0) {
            return parameterValueMap;
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value != null) {
                if (value instanceof String[]) {
                    String[] s = (String[])value;
                    if (s.length > 0 && s[0] != null) {
                        value = s[0];
                    }
                } else if (value instanceof BOSUuid) {
                    value = ((BOSUuid)value).toString();
                } else if (value instanceof BOSUuid[]) {
                    BOSUuid[] uuids = (BOSUuid[])value;
                    if (uuids.length > 0 && uuids[0] != null) {
                        value = uuids[0].toString();
                    }
                } else if (value instanceof StringEnum) {
                    value = ((StringEnum)value).getValue();
                } else if (value instanceof ObjectUuidPK) {
                    value = ((ObjectUuidPK)value).getKeyValue().toString();
                }
            }
            parameterValueMap.put(key, value);
        }
        return parameterValueMap;
    }

    private boolean isFunctionReturn(FormalParameterCollection formalParameters) {
        if (formalParameters == null || formalParameters.size() == 0) {
            return false;
        }
        boolean hasReturn = false;
        for (FormalParameterDef def : formalParameters) {
            if (def.getMode() == FormalParameterMode.IN) continue;
            hasReturn = true;
            break;
        }
        return hasReturn;
    }

    public static void setInvokeExceptionToContext(Throwable ex, ProcessContext context, String actDefId) {
        String nameKey = actDefId + "_exceptionName";
        String msgKey = actDefId + "_exceptionMessage";
        String onameKey = "_exceptionName";
        String omsgKey = "_exceptionMessage";
        if (ex.getCause() == null) {
            context.putDataFieldValue(nameKey, ex.getClass().getName());
            context.putDataFieldValue(msgKey, ex.getMessage());
            context.putDataFieldValue(onameKey, ex.getClass().getName());
            context.putDataFieldValue(omsgKey, ex.getMessage());
        } else if (ex.getCause().getCause() == null) {
            context.putDataFieldValue(nameKey, ex.getCause().getClass().getName());
            context.putDataFieldValue(msgKey, ex.getCause().getMessage());
            context.putDataFieldValue(onameKey, ex.getCause().getClass().getName());
            context.putDataFieldValue(omsgKey, ex.getCause().getMessage());
        } else if (ex.getCause().getCause().getCause() == null) {
            context.putDataFieldValue(nameKey, ex.getCause().getCause().getClass().getName());
            context.putDataFieldValue(msgKey, ex.getCause().getCause().getMessage());
            context.putDataFieldValue(onameKey, ex.getCause().getCause().getClass().getName());
            context.putDataFieldValue(omsgKey, ex.getCause().getCause().getMessage());
        } else {
            context.putDataFieldValue(nameKey, ex.getCause().getCause().getCause().getClass().getName());
            context.putDataFieldValue(msgKey, ex.getCause().getCause().getCause().getMessage());
            context.putDataFieldValue(onameKey, ex.getCause().getCause().getCause().getClass().getName());
            context.putDataFieldValue(omsgKey, ex.getCause().getCause().getCause().getMessage());
        }
    }

    private void invokeService(ApplicationDef application, WfActivity activity, ProcessContext context, ActualParameterCollection actualParameters) throws WfException {
        String serviceUri = ((ServiceActivityDef)activity.getDefinition()).getServiceUri();
        CommonServiceManager manager = CommonServiceManager.getInstance();
        ServiceRef serviceRef = manager.findService(serviceUri);
        if (serviceRef == null) {
            throw new WfException("WFE_SER_cannotFindService", context.getWfEngine().getLocale().getLanguage(), null).addArg(serviceUri);
        }
        int size = 0;
        if (serviceRef.getParams() != null) {
            size = serviceRef.getParams().size();
        }
        Object[] values = new Object[size];
        String rDFName = null;
        for (int i = 0; i < actualParameters.size(); ++i) {
            ActualParameterDef paramDef = actualParameters.get(i);
            int index = paramDef.getIndex();
            String name = paramDef.getDataField().getName();
            if (!StringUtils.isEmpty((String)paramDef.getProp())) {
                name = name + "." + paramDef.getProp();
            }
            if (index < size) {
                values[index] = context.getDataFieldValue(name);
                continue;
            }
            rDFName = paramDef.getDataField().getName();
        }
        try {
            Object returnValue = manager.execute(serviceRef, values);
            if (rDFName != null) {
                context.setDataFieldValue(rDFName, returnValue);
            }
        }
        catch (Exception e) {
            throw new WfException("WFE_SER_executeServiceError", context.getWfEngine().getLocale().getLanguage(), (Throwable)e, true).addArg(serviceRef.getUri());
        }
    }

    private void invokeJavaMethod(ApplicationDef application, WfActivity activity, ProcessContext context, ActualParameterCollection actualParameters) throws WfException {
        FormalParameterCollection formalParameters = application.getFormalParameters();
        Map parameterMap = DefaultApplicationManager.getParameterMap(activity, context, actualParameters, formalParameters, false);
        JavaMethodDef javaMethod = application.getJavaMethod();
        boolean isReturn = this.isFunctionReturn(formalParameters);
        Context ctx = EnactmentUtils.getApplicationContext(activity);
        StringBuffer script = new StringBuffer();
        if (isReturn) {
            script.append("return ");
        }
        if (javaMethod.isStatic()) {
            script.append(javaMethod.getClassName()).append(".");
        } else {
            script.append("new ").append(javaMethod.getClassName()).append("().");
        }
        script.append(javaMethod.getMethodName()).append("(");
        Iterator iter = actualParameters.iterator();
        boolean flag = false;
        while (iter.hasNext()) {
            FormalParameterDef def;
            ActualParameterDef item = (ActualParameterDef)iter.next();
            if (item.getIndex() >= formalParameters.size() || (def = formalParameters.get(item.getIndex())).getMode() == FormalParameterMode.OUT) continue;
            if (flag) {
                script.append(",");
            }
            script.append(def.getName());
            flag = true;
        }
        script.append(");");
        Object returnObject = null;
        try {
            if (!isReturn) {
                if (this.needRollbackToolActivity(activity)) {
                    ScriptUtil.executeScript(script.toString(), activity, parameterMap);
                } else {
                    this.invokeScriptRequiresNew(ctx, script.toString(), activity, parameterMap);
                }
                activity.container().receiveResults(activity, parameterMap);
            } else {
                returnObject = this.needRollbackToolActivity(activity) ? ScriptUtil.executeScriptReturnValue(script.toString(), activity, parameterMap) : this.invokeScriptReturnValueRequiresNew(ctx, script.toString(), activity, parameterMap);
                this.writeOutputToContext(returnObject, actualParameters, formalParameters, ApplicationType.JAVA_METHOD);
            }
        }
        catch (Throwable e) {
            WfException ex = new WfException("WFE_JAVA_METHOD_execute_function", null, e).addArg(activity.getMeta().getActInstInfo().getActDefName()).addArg("");
            ex.setIgnoreCurentStrack(true);
            WorkflowUtils.logProcessException(activity.getProcInstId(), activity.getWfEngine(), ex);
            this.sendErrorMsg(application, activity, e);
            log.warn((Object)e.getMessage(), e);
            String actDefId = activity.getDefinition().getID();
            context = this.getProcessContext();
            DefaultApplicationManager.setInvokeExceptionToContext(e, context, actDefId);
            throw ex;
        }
    }

    public void setProcessContextForErrorMsg(WfActivity activity, ProcessContext context) {
        Object omsgKeyObject;
        Object onameKeyObject;
        Object msgKeyObject;
        String actDefId = activity.getDefinition().getID();
        String nameKey = actDefId + "_exceptionName";
        String msgKey = actDefId + "_exceptionMessage";
        String onameKey = "_exceptionName";
        String omsgKey = "_exceptionMessage";
        Object nameKeyObject = context.getDataFieldValue(nameKey);
        if (nameKeyObject != null) {
            context.setDataFieldValue(nameKey, null);
        }
        if ((msgKeyObject = context.getDataFieldValue(msgKey)) != null) {
            context.setDataFieldValue(msgKey, null);
        }
        if ((onameKeyObject = context.getDataFieldValue(onameKey)) != null) {
            context.setDataFieldValue(onameKey, null);
        }
        if ((omsgKeyObject = context.getDataFieldValue(omsgKey)) != null) {
            context.setDataFieldValue(omsgKey, null);
        }
    }
}

