/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.async;

import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.workflow.define.OtherSys;
import com.kingdee.bos.workflow.enactment.async.OtherSysUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.util.app.ContextUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class RpaUtil {
    private static final String LOGIN_URL = ":9091/LoginByApp";
    private static final String CREATE_TASK_URL = "/ierp/kapi/app/rbmg/addTasksApiService?access_token={access_token}";
    private static final String LOGOUT_URL = "/ierp/api/logout.do";
    public static final String OPEN_API_LOGIN_URL = "/easportal/openapi/login?authPattern=BaseTrdLtpaToken&dcName={dataCenter}&isEncodePwd=1&language=l2&password={pwd}&user={userName}";
    public static final String OPEN_API_CALL_URL = "/easportal/openapi/api?token=";
    private static final String filePath = System.getProperty("EAS_INSTANCE_CONFIG_PATH") + "/portalConfig/LtpaToken.properties";

    public static String callRpa(String apiBaseUrl, Map params) throws Exception {
        JSONObject jsonParams = OtherSysUtil.mapToJson(params);
        String rpaToken = RpaUtil.getRpaToken(apiBaseUrl, jsonParams);
        String createTaskUrl = new String(CREATE_TASK_URL);
        createTaskUrl = createTaskUrl.replace("{access_token}", rpaToken);
        String resultValue = RpaUtil.createRpaTask(jsonParams.getString("apiBaseUrl") + createTaskUrl, jsonParams);
        return resultValue;
    }

    private static String getRpaToken(String apiBaseUrl, JSONObject jsonParams) throws Exception {
        String rpaToken = null;
        String resultValu = OtherSysUtil.jsonRequest(apiBaseUrl + LOGIN_URL, jsonParams.toString());
        if ("".equals(resultValu) || null == resultValu) {
            throw new Exception("\u83b7\u53d6rpa\u8ba4\u8bc1\u5931\u8d25\uff01");
        }
        JSONObject resultJson = new JSONObject(resultValu);
        JSONObject dataJson = resultJson.getJSONObject("data");
        rpaToken = dataJson.getString("access_token");
        return rpaToken;
    }

    private static String createRpaTask(String apiBaseUrl, JSONObject jsonParams) throws Exception {
        String resultValue = OtherSysUtil.jsonRequest(apiBaseUrl, jsonParams.toString());
        if ("".equals(resultValue) || null == resultValue) {
            throw new Exception("\u521b\u5efarpa\u4efb\u52a1\u5931\u8d25\uff01");
        }
        JSONObject resultJson = new JSONObject(resultValue);
        if (!"true".equals(resultJson.getString("success"))) {
            throw new Exception(resultJson.getString("message"));
        }
        return resultValue;
    }

    private static void logoutRpa(String apiBaseUrl, JSONObject jsonParams) throws Exception {
        OtherSysUtil.jsonRequest(apiBaseUrl + LOGOUT_URL, jsonParams.toString());
    }

    public static void addRpaParams(OtherSys os, Map parameterMap, Context ctx) throws JSONException {
        HashMap startParameterMap = new HashMap(parameterMap);
        parameterMap.put("apiBaseUrl", os.getApiBaseUrl());
        parameterMap.put("userId", os.getUserId());
        parameterMap.put("appId", os.getAppId());
        parameterMap.put("appSecret", os.getAppSecret());
        parameterMap.put("orgId", os.getOrgId());
        parameterMap.put("robotId", os.getRobotId());
        parameterMap.put("mac", os.getMac());
        parameterMap.put("runMethod", "0");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        parameterMap.put("userName", userInfo.getNumber());
        parameterMap.put("pwd", LtpaTokenManager.generate((String)userInfo.getNumber(), (String)filePath).toString());
        parameterMap.put("dataCenter", ctx.getAIS());
        JSONArray startJsonArray = new JSONArray();
        for (Map.Entry entry : startParameterMap.entrySet()) {
            if (null == entry.getValue()) continue;
            JSONObject json = new JSONObject();
            json.put("name", entry.getKey());
            json.put("type", (Object)"System.String");
            json.put("value", entry.getValue());
            startJsonArray.put((Object)json);
        }
        parameterMap.put("startParams", startJsonArray.toString());
    }

    public static void addCallBackParams(String taskId, Map parameterMap) throws UnknownHostException, JSONException {
        JSONArray startJsonArray = new JSONArray(parameterMap.get("startParams").toString());
        String easAddress = InetAddress.getLocalHost().getHostAddress();
        easAddress = "http://" + easAddress + ":";
        startJsonArray.put((Object)RpaUtil.setCallBackParams("easAddress", easAddress));
        String getEasTokenUrl = new String(OPEN_API_LOGIN_URL);
        String callBackUrl = new String(OPEN_API_CALL_URL);
        getEasTokenUrl = getEasTokenUrl.replace("{dataCenter}", parameterMap.get("dataCenter").toString());
        getEasTokenUrl = getEasTokenUrl.replace("{pwd}", parameterMap.get("pwd") == null ? "" : parameterMap.get("pwd").toString());
        getEasTokenUrl = getEasTokenUrl.replace("{userName}", parameterMap.get("userName").toString());
        startJsonArray.put((Object)RpaUtil.setCallBackParams("getEasTokenUrl", getEasTokenUrl));
        startJsonArray.put((Object)RpaUtil.setCallBackParams("callBackUrl", callBackUrl));
        JSONObject callBackJson = new JSONObject();
        callBackJson.put("api", (Object)"callBackEasWorkflow");
        JSONArray dataArray = new JSONArray().put((Object)taskId).put((Object)"{returnValue}");
        callBackJson.put("data", (Object)dataArray);
        startJsonArray.put((Object)RpaUtil.setCallBackParams("callBackParams", callBackJson.toString()));
        parameterMap.put("startParams", startJsonArray);
    }

    private static JSONObject setCallBackParams(String key, String value) throws JSONException {
        JSONObject openApiStratParamsJson = new JSONObject().put("name", (Object)key).put("type", (Object)"System.String").put("value", (Object)value);
        return openApiStratParamsJson;
    }

    public static void addCallBackParamsToCtx(String taskId, Map parameterMap, Context ctx) throws JSONException {
        ctx.put((Object)"otherSysTaskId", (Object)taskId);
        JSONArray startJsonArray = new JSONArray(parameterMap.get("startParams").toString());
        for (int i = 0; i < startJsonArray.length(); ++i) {
            JSONObject json = startJsonArray.getJSONObject(i);
            ctx.put((Object)json.getString("name"), (Object)json.getString("value"));
        }
    }
}

