/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cache;

import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.jcache.CacheLoader;
import com.kingdee.bos.jcache.ObjectRef;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.trace.WfMonitor;
import com.kingdee.bos.workflow.exception.WfCacheException;
import com.kingdee.util.LowTimer;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ActivityInstanceCacheLoader
implements com.kingdee.bos.cache.CacheLoader,
CacheLoader {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.cache.ActivityInstanceCacheLoader");
    private WfEngine engine;

    public ActivityInstanceCacheLoader(WfEngine engine) {
        this.engine = engine;
    }

    public Object load(Object argument) throws CacheException {
        try {
            return this.loadWfActivity((String)argument);
        }
        catch (Exception ex) {
            String str = "can not load activity instance from cache. actInstId is : '" + argument + "' at " + this.engine.context().getAIS();
            log.warn((Object)str, (Throwable)ex);
            throw new CacheException(str, (Throwable)ex);
        }
    }

    private WfActivity loadWfActivity(String actInstId) throws WfException {
        ActivityInstInfo meta;
        LowTimer lowTimer = new LowTimer();
        try {
            meta = this.engine.getStoreManager().getActivityStorer().getInstance(actInstId);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex, true);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e, true);
        }
        if (meta == null) {
            throw new WfCacheException("Activity is not exist." + actInstId);
        }
        WfActivity actInst = new WfActivity(this.engine, meta);
        WfMonitor.trace(actInst);
        if (log.isDebugEnabled()) {
            log.debug((Object)("ActivityInstanceCacheLoader load [" + actInstId + "] cost: " + lowTimer.msValue()));
        }
        return actInst;
    }

    public void cleanUp() {
    }

    public Object load(ObjectRef ref) throws Exception {
        return this.load(ref.name());
    }

    public void unload(ObjectRef ref, Object value) {
        log.info((Object)("cache item " + ref + " unload value " + value));
    }
}

