/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cache;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EffectRegion {
    private final Set effectObjects;

    private EffectRegion(BOSObjectType[] bosObjectTypes) {
        assert (bosObjectTypes != null);
        this.effectObjects = new HashSet();
        int size = bosObjectTypes.length;
        for (int i = 0; i < size; ++i) {
            this.effectObjects.add(bosObjectTypes[i]);
        }
    }

    public static EffectRegion create(BOSObjectType bosObjectTypes) {
        return new EffectRegion(new BOSObjectType[]{bosObjectTypes});
    }

    public static EffectRegion create(BOSObjectType[] bosObjectTypes) {
        return new EffectRegion(bosObjectTypes);
    }

    public String getName() {
        Object[] bosObjectTypes = this.sort();
        return StringUtils.arrayToString((Object[])bosObjectTypes, (String)"_");
    }

    private String[] sort() {
        Object[] bosObjectTypes = new String[this.effectObjects.size()];
        int i = 0;
        Iterator iterator = this.effectObjects.iterator();
        while (iterator.hasNext()) {
            bosObjectTypes[i] = iterator.next().toString();
            ++i;
        }
        Arrays.sort(bosObjectTypes);
        return bosObjectTypes;
    }

    public BOSObjectType[] getEffectObjects() {
        return this.effectObjects.toArray(new BOSObjectType[this.effectObjects.size()]);
    }

    public boolean isAffected(EffectRegion effectRegion) {
        for (BOSObjectType bosObjectType : this.effectObjects) {
            BOSObjectType[] bosObjectTypes = effectRegion.getEffectObjects();
            int size = bosObjectTypes.length;
            for (int i = 0; i < size; ++i) {
                if (!bosObjectType.equals((Object)bosObjectTypes[i])) continue;
                return true;
            }
        }
        return false;
    }
}

