/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cache;

import com.kingdee.bos.Context;
import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.jcache.Attributes;
import com.kingdee.bos.jcache.CacheEngine;
import com.kingdee.bos.jcache.Event;
import com.kingdee.bos.jcache.EventListener;
import com.kingdee.bos.jcache.Region;
import com.kingdee.bos.jcache.jgroups.JGroupsNotifier;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.BufferedAssignmentChecker;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.enactment.cache.ActivityInstanceCacheLoader;
import com.kingdee.bos.workflow.enactment.cache.EffectRegion;
import com.kingdee.bos.workflow.enactment.cache.GeneralObjectCacheLoader;
import com.kingdee.bos.workflow.enactment.cache.IWfCacheManager;
import com.kingdee.bos.workflow.enactment.cache.IdentifiableInvocationDesc;
import com.kingdee.bos.workflow.enactment.cache.InvocationCacheManager;
import com.kingdee.bos.workflow.enactment.cache.ProcessDefinitionCacheLoader;
import com.kingdee.bos.workflow.enactment.cache.ProcessInstanceCacheLoader;
import com.kingdee.bos.workflow.enactment.cache.ProcessMgrCacheLoader;
import com.kingdee.bos.workflow.enactment.cache.UserServiceContextCacheLoader;
import com.kingdee.bos.workflow.enactment.cache.WfAssignmentCacheLoader;
import com.kingdee.bos.workflow.enactment.cluster.WfClusterEventListener;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.bos.workflow.util.InvocationExecutor;
import com.kingdee.bos.workflow.util.LRUCapacityMap;
import com.kingdee.bos.workflow.util.WorkflowClusterConfig;
import com.kingdee.util.objbuddy.BuddyObjectFactory;
import com.kingdee.util.objbuddy.IBuddyObject;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfCacheManager
implements IWfCacheManager {
    private static final long serialVersionUID = -8780071997595523107L;
    public static final long TIMEOUT = 60000L;
    private final WfEngine engine;
    public final String PROCESS_INSTANCE_REGIONNAME;
    public final String PROCESS_DEFINITION_REGIONNAME;
    public final String PROCESS_MANAGER_REGIONNAME;
    public final String ACTIVITY_INSTANCE_REGIONNAME;
    public final String ASSIGNMENT_REGIONNAME;
    public final String WFROOT_REGIONNAME;
    public final String WORKFLOW_SUFIX = "_BOS_WORKFLOW";
    public final String USERSERVICECONTEXT_REGIONNAME;
    public final String CACHENAME_GENERAL_OBJECT;
    public final String CACHENAME_PARTICIPANT;
    public final String CACHENAME_BIZ_EVENT;
    public final String CACHENAME_TRANS_EVENT;
    Region wfRootRegion;
    Region procInstCache;
    Region actInstCache;
    Region procDefCache;
    Region procMgrCache;
    Region assignmentCache;
    Region userServiceContextCache;
    Region generalObjectCache;
    private InvocationCacheManager invocationCacheManager;
    private static boolean isJGroupsNotifierInited = false;
    private static final Logger logger = Logger.getLogger(WfCacheManager.class);
    private Map assignments4Check = Collections.synchronizedMap(new LRUCapacityMap(2000));
    private boolean isInited = false;
    private final IBuddyObject buddy;

    public WfCacheManager(WfEngine engine) {
        this.engine = engine;
        String key = this.engine.getEngineKey().toString();
        this.WFROOT_REGIONNAME = key + "_BOS_WORKFLOW";
        this.PROCESS_INSTANCE_REGIONNAME = "PROCESS_INSTANCE";
        this.PROCESS_DEFINITION_REGIONNAME = "PROCESS_DEFINITION";
        this.ACTIVITY_INSTANCE_REGIONNAME = "ACTIVITY_INSTANCE";
        this.PROCESS_MANAGER_REGIONNAME = "PROCESS_MANAGER";
        this.ASSIGNMENT_REGIONNAME = "ASSIGNMENT";
        this.USERSERVICECONTEXT_REGIONNAME = "USERSERVICECONTEXT";
        this.CACHENAME_GENERAL_OBJECT = "GENERALOBJECT";
        this.CACHENAME_PARTICIPANT = "PARTICIPANT";
        this.CACHENAME_BIZ_EVENT = "BIZ_EVENT";
        this.CACHENAME_TRANS_EVENT = "TRANS_EVENT";
        this.buddy = BuddyObjectFactory.getInstance((Object)this);
        try {
            this.buddy.initialize();
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
        }
    }

    @Override
    public WfProcess getProcessInst(String procInstId) {
        return (WfProcess)this.procInstCache.get((Object)procInstId);
    }

    @Override
    public WfAssignment getAssignment(String assignmentId) {
        return (WfAssignment)this.assignmentCache.get((Object)assignmentId);
    }

    @Override
    public ProcessDef getProcessDef(String procDefHash) {
        return (ProcessDef)this.procDefCache.get((Object)procDefHash);
    }

    @Override
    public WfActivity getActivityInst(String activityInstId) {
        return (WfActivity)this.actInstCache.get((Object)activityInstId);
    }

    @Override
    public WfProcessMgr getProcessMgr(String procDefId, int innerVersion) {
        String cacheId = procDefId + "," + innerVersion;
        return (WfProcessMgr)this.procMgrCache.get((Object)cacheId);
    }

    @Override
    public WfProcessMgr getProcessMgr(String procDefId) {
        try {
            int lastVersion = this.engine.getDefinitionMgr().getProcessDefLastVersionNumber(procDefId);
            String cacheId = procDefId + "," + lastVersion;
            return (WfProcessMgr)this.procMgrCache.get((Object)cacheId);
        }
        catch (WfException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void removeProcessMgr(String procDefId, int version) {
        String cacheId = procDefId + "," + version;
        this.procMgrCache.remove((Object)cacheId);
    }

    @Override
    public void addActivityInst(WfActivity actInst) {
        this.actInstCache.put((Object)actInst.getId(), (Object)actInst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initJGroupsNotifier() {
        if (isJGroupsNotifierInited) {
            return;
        }
        Class<WfCacheManager> clazz = WfCacheManager.class;
        synchronized (WfCacheManager.class) {
            if (!isJGroupsNotifierInited) {
                try {
                    String clusterName = WorkflowClusterConfig.getInstance().getClusterName();
                    CacheEngine.cacheAttributes.setString((Object)"jgroupsProtocolStack", WorkflowClusterConfig.getInstance().getProtocol());
                    CacheEngine.cacheAttributes.setString((Object)"notifierChannel", clusterName);
                    if (WorkflowClusterConfig.getInstance().isGroupType()) {
                        JGroupsNotifier.initDistributeCache();
                        CacheEngine.addEventListener((EventListener)new WfClusterEventListener(this.engine));
                    }
                    isJGroupsNotifierInited = true;
                    logger.info((Object)("Distribute Cache for " + clusterName + " started!"));
                }
                catch (Exception e) {
                    logger.warn((Object)"init Distribute Cache error", (Throwable)e);
                    isJGroupsNotifierInited = false;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void init() throws WfException {
        if (this.isInited) {
            return;
        }
        this.initJGroupsNotifier();
        if (!isJGroupsNotifierInited) {
            throw new WfException("Distribute Cache cannot init!");
        }
        Attributes wfRootAttr = new Attributes();
        wfRootAttr.setBoolean((Object)"distributed", WorkflowClusterConfig.getInstance().isGroupType());
        wfRootAttr.setValue((Object)"objectHandlerClass", (Object)Attributes.IDLE_TIMEOUT_TO_WEAK);
        this.wfRootRegion = CacheEngine.getRegion((Object)this.WFROOT_REGIONNAME);
        if (this.wfRootRegion == null) {
            this.wfRootRegion = CacheEngine.createRegion((Object)this.WFROOT_REGIONNAME, (Attributes)wfRootAttr);
        } else {
            logger.warn((Object)("region[" + this.WFROOT_REGIONNAME + "] is exist!"));
        }
        ProcessInstanceCacheLoader procInstCacheLoader = new ProcessInstanceCacheLoader(this.engine);
        Attributes attrsProcInst = new Attributes(wfRootAttr);
        attrsProcInst.setValue((Object)"cacheLoader", (Object)procInstCacheLoader);
        attrsProcInst.setLong((Object)"timeout", 1800000L);
        attrsProcInst.setValue((Object)"objectHandlerClass", (Object)Attributes.IDLE_TIMEOUT_TO_WEAK);
        this.procInstCache = this.wfRootRegion.getRegion((Object)this.PROCESS_INSTANCE_REGIONNAME, true, attrsProcInst);
        ActivityInstanceCacheLoader actInstCacheLoader = new ActivityInstanceCacheLoader(this.engine);
        Attributes attrsActIns = new Attributes(wfRootAttr);
        attrsActIns.setValue((Object)"cacheLoader", (Object)actInstCacheLoader);
        attrsActIns.setLong((Object)"timeout", 600000L);
        attrsActIns.setValue((Object)"objectHandlerClass", (Object)Attributes.IDLE_TIMEOUT_TO_WEAK);
        this.actInstCache = this.wfRootRegion.getRegion((Object)this.ACTIVITY_INSTANCE_REGIONNAME, true, attrsActIns);
        ProcessDefinitionCacheLoader procDefCacheLoader = new ProcessDefinitionCacheLoader(this.engine);
        Attributes attrsProcDef = new Attributes(wfRootAttr);
        attrsProcDef.setValue((Object)"cacheLoader", (Object)procDefCacheLoader);
        attrsProcDef.setLong((Object)"timeout", 86400000L);
        attrsProcDef.setValue((Object)"objectHandlerClass", (Object)Attributes.IDLE_TIMEOUT_TO_WEAK);
        this.procDefCache = this.wfRootRegion.getRegion((Object)this.PROCESS_DEFINITION_REGIONNAME, true, attrsProcDef);
        ProcessMgrCacheLoader procMgrCacheLoader = new ProcessMgrCacheLoader(this.engine);
        Attributes attrsProcMgr = new Attributes(wfRootAttr);
        attrsProcMgr.setValue((Object)"cacheLoader", (Object)procMgrCacheLoader);
        attrsProcMgr.setLong((Object)"timeout", 86400000L);
        attrsProcMgr.setValue((Object)"objectHandlerClass", (Object)Attributes.IDLE_TIMEOUT_TO_WEAK);
        this.procMgrCache = this.wfRootRegion.getRegion((Object)this.PROCESS_MANAGER_REGIONNAME, true, attrsProcMgr);
        this.initAssignmentRegion(wfRootAttr);
        UserServiceContextCacheLoader userServiceContextCacheLoader = new UserServiceContextCacheLoader(this.engine);
        Attributes attrsUserServiceContext = new Attributes(wfRootAttr);
        attrsUserServiceContext.setValue((Object)"cacheLoader", (Object)userServiceContextCacheLoader);
        attrsUserServiceContext.setLong((Object)"timeout", 43200000L);
        attrsUserServiceContext.setValue((Object)"objectHandlerClass", (Object)Attributes.IDLE_TIMEOUT_TO_WEAK);
        this.userServiceContextCache = this.wfRootRegion.getRegion((Object)this.USERSERVICECONTEXT_REGIONNAME, true, attrsUserServiceContext);
        GeneralObjectCacheLoader generalObjectCacheLoader = new GeneralObjectCacheLoader();
        Attributes generalObjectContext = new Attributes(wfRootAttr);
        generalObjectContext.setValue((Object)"cacheLoader", (Object)generalObjectCacheLoader);
        generalObjectContext.setBoolean((Object)"autoLoad", false);
        generalObjectContext.setBoolean((Object)"distributed", false);
        generalObjectContext.setLong((Object)"timeout", 3600000L);
        generalObjectContext.setValue((Object)"objectHandlerClass", (Object)Attributes.IDLE_TIMEOUT_TO_WEAK);
        this.generalObjectCache = this.wfRootRegion.getRegion((Object)this.CACHENAME_GENERAL_OBJECT, true, generalObjectContext);
        this.invocationCacheManager = new InvocationCacheManager(this.wfRootRegion);
        this.isInited = true;
        this.buddy.operationPerformed("init");
    }

    private void initAssignmentRegion(Attributes parentAttributes) {
        WfAssignmentCacheLoader assignmentCacheLoader = new WfAssignmentCacheLoader(this.engine);
        Attributes attrsAssignment = new Attributes(parentAttributes);
        attrsAssignment.setValue((Object)"cacheLoader", (Object)assignmentCacheLoader);
        attrsAssignment.setLong((Object)"timeout", 600000L);
        attrsAssignment.setValue((Object)"objectHandlerClass", (Object)Attributes.IDLE_TIMEOUT_TO_WEAK);
        this.assignmentCache = this.wfRootRegion.getRegion((Object)this.ASSIGNMENT_REGIONNAME, true, attrsAssignment);
        if (BufferedAssignmentChecker.enable(this.engine.context())) {
            this.assignmentCache.addEventListener(new EventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEvent(Event event) {
                    if (201 == event.id) {
                        Object[] objects = (Object[])event.parameter;
                        WfAssignment oldAssignment = (WfAssignment)objects[0];
                        WfAssignment newAssignment = (WfAssignment)objects[1];
                        if (oldAssignment == null && newAssignment != null) {
                            WfCacheManager.this.assignments4Check.put(BufferedAssignmentChecker.getFullIdentifier(newAssignment.getMeta().getAssignInfo()), newAssignment);
                            WfCacheManager.this.assignments4Check.put(BufferedAssignmentChecker.getSimpleIdentifier(newAssignment.getMeta().getAssignInfo()), newAssignment);
                        } else if ((oldAssignment == null || newAssignment == null) && oldAssignment != null && newAssignment == null) {
                            Map map = WfCacheManager.this.assignments4Check;
                            synchronized (map) {
                                Iterator iterator = WfCacheManager.this.assignments4Check.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    Map.Entry entry = iterator.next();
                                    if (!entry.getValue().equals(oldAssignment)) continue;
                                    iterator.remove();
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void cleanUp() throws WfException {
        this.buddy.operationPerformed("cleanUp");
    }

    @Override
    public void removeProcessDef(String procDefHashVal) {
        this.procDefCache.discard((Object)procDefHashVal, true);
    }

    @Override
    public void removeProcessInst(String processInstId) {
        this.procInstCache.discard((Object)processInstId, true);
    }

    @Override
    public void removeProcRefInsts(String procInstID) {
        try {
            IWfCacheManager cacheManager = this.engine.getCacheManager();
            WfProcess process = cacheManager.getProcessInst(procInstID);
            List activities = process.activities();
            int size = activities.size();
            for (int i = 0; i < size; ++i) {
                WfActivity activity = (WfActivity)activities.get(i);
                List assignments = activity.assignments();
                int size1 = assignments.size();
                for (int j = 0; j < size1; ++j) {
                    WfAssignment assignment = (WfAssignment)assignments.get(j);
                    cacheManager.removeAssignment(assignment.getId());
                }
                cacheManager.removeActivityInst(activity.getId());
            }
            cacheManager.removeProcessInst(procInstID);
        }
        catch (WfException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void removeActivityInst(String activityInstId) {
        this.actInstCache.discard((Object)activityInstId, true);
    }

    @Override
    public void removeAssignment(String assignmentId) {
        this.assignmentCache.discard((Object)assignmentId, true);
    }

    @Override
    public Map getCacheProperty() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Context getUserServiceContext(String user, Context ctx) {
        return (Context)this.userServiceContextCache.get((Object)user);
    }

    @Override
    public void addProcInst(WfProcess procInst) {
        this.procInstCache.put((Object)procInst.getId(), (Object)procInst);
    }

    @Override
    public void addAssignment(WfAssignment assignment) {
        this.assignmentCache.put((Object)assignment.getId(), (Object)assignment);
    }

    @Override
    public Object getGeneralObject(Object key) {
        return this.generalObjectCache.get(key);
    }

    @Override
    public void putGeneralObject(Object key, Object value) {
        this.generalObjectCache.put(key, value);
    }

    @Override
    public void cleanParticipantCache() {
        this.generalObjectCache.removeAll();
    }

    @Override
    public void notifyActivityChange(String activityID) {
        this.actInstCache.notifyChange((Object)activityID);
    }

    @Override
    public void notifyAssignmentChange(String assignmentID) {
        this.assignmentCache.notifyChange((Object)assignmentID);
    }

    @Override
    public void notifyProcessInstChange(String processInstID) {
        this.procInstCache.notifyChange((Object)processInstID);
    }

    @Override
    public Object getInvocationResult(IdentifiableInvocationDesc invocationDesc) {
        if (EngineConfig.getInstance().isEnableMethodLevelCache()) {
            return this.invocationCacheManager.get(invocationDesc);
        }
        try {
            return InvocationExecutor.execute(invocationDesc);
        }
        catch (WfException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void removeInvocationResult(EffectRegion removedMethodEffectRegion) {
        if (EngineConfig.getInstance().isEnableMethodLevelCache()) {
            this.invocationCacheManager.remove(removedMethodEffectRegion);
        }
    }

    @Override
    public String getName() {
        return this.engine.getEngineKey() + "_WfCacheManager";
    }

    @Override
    public WfAssignment getCachedAssignment(String key) {
        return (WfAssignment)this.assignments4Check.get(key);
    }

    @Override
    public void destroy() {
        CacheEngine.deleteRegion((Object)this.WFROOT_REGIONNAME);
        this.isInited = false;
    }

    @Override
    public int size() {
        int total = 0;
        total += this.wfRootRegion.size();
        total += this.procInstCache.size();
        total += this.actInstCache.size();
        total += this.procDefCache.size();
        total += this.procMgrCache.size();
        total += this.assignmentCache.size();
        total += this.userServiceContextCache.size();
        total += this.generalObjectCache.size();
        return total += this.invocationCacheManager.size();
    }

    @Override
    public void activityInstExpired(String actInstId) {
    }

    @Override
    public void assignmentExpired(String assignId) {
    }

    @Override
    public void processInstExpired(String procInstId) {
    }

    @Override
    public BOSObjectType[] getRelatedEntityTypes(String procdefID) {
        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0");
    }
}

