/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cache;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.enactment.cache.EffectRegion;
import com.kingdee.bos.workflow.enactment.cache.IWfCacheManager;
import com.kingdee.bos.workflow.enactment.cache.IdentifiableInvocationDesc;
import com.kingdee.bos.workflow.transaction.WfTxContext;
import com.kingdee.util.profile.ObjectProfileInterceptor;
import com.kingdee.util.profile.ProfileConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;

public class WfCacheManagerTxWapper
implements IWfCacheManager {
    private static final long serialVersionUID = -5191778303072362486L;
    private static final String DEFAULT_CACHE = "com.kingdee.bos.workflow.engine.adapter.WfCache";
    private final WfEngine engine;
    private final IWfCacheManager cacheManagerImpl;

    public WfCacheManagerTxWapper(WfEngine engine) {
        this.engine = engine;
        this.cacheManagerImpl = this.createCacheManagerImpl();
    }

    @Override
    public String getName() {
        return this.cacheManagerImpl.getName();
    }

    private IWfCacheManager createCacheManagerImpl() {
        IWfCacheManager _cacheManagerImpl = null;
        try {
            Class<?> cacheClass = Class.forName(DEFAULT_CACHE);
            Constructor<?> constructor = cacheClass.getConstructor(WfEngine.class);
            _cacheManagerImpl = (IWfCacheManager)constructor.newInstance(this.engine);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (ProfileConfig.getInstance().logWfEngine) {
            return (IWfCacheManager)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{IWfCacheManager.class}, (InvocationHandler)new ObjectProfileInterceptor((Object)_cacheManagerImpl));
        }
        return _cacheManagerImpl;
    }

    @Override
    public void addActivityInst(WfActivity actInst) {
        this.cacheManagerImpl.addActivityInst(actInst);
        this.registerTxActInst(actInst);
    }

    @Override
    public void cleanUp() throws WfException {
        this.cacheManagerImpl.cleanUp();
    }

    @Override
    public WfActivity getActivityInst(String activityInstId) {
        WfActivity activityInst = this.cacheManagerImpl.getActivityInst(activityInstId);
        if (activityInst != null) {
            this.registerTxActInst(activityInst);
        }
        return activityInst;
    }

    @Override
    public WfAssignment getAssignment(String assignmentId) {
        WfAssignment assignment = this.cacheManagerImpl.getAssignment(assignmentId);
        if (assignment != null) {
            this.registerTxAssginInst(assignment);
        }
        return assignment;
    }

    @Override
    public Map getCacheProperty() {
        return this.cacheManagerImpl.getCacheProperty();
    }

    @Override
    public ProcessDef getProcessDef(String procDefHash) {
        return this.cacheManagerImpl.getProcessDef(procDefHash);
    }

    @Override
    public WfProcess getProcessInst(String procInstId) {
        this.registerTxProcInst(procInstId);
        WfProcess processInst = this.cacheManagerImpl.getProcessInst(procInstId);
        return processInst;
    }

    @Override
    public WfProcessMgr getProcessMgr(String procDefId, int innerVersion) {
        return this.cacheManagerImpl.getProcessMgr(procDefId, innerVersion);
    }

    @Override
    public WfProcessMgr getProcessMgr(String procDefId) {
        return this.cacheManagerImpl.getProcessMgr(procDefId);
    }

    @Override
    public Context getUserServiceContext(String user, Context ctx) {
        return this.cacheManagerImpl.getUserServiceContext(user, ctx);
    }

    @Override
    public void init() throws WfException {
        this.cacheManagerImpl.init();
    }

    @Override
    public void removeActivityInst(String activityInstId) {
        this.cacheManagerImpl.removeActivityInst(activityInstId);
    }

    @Override
    public void removeAssignment(String assignmentId) {
        this.cacheManagerImpl.removeAssignment(assignmentId);
    }

    @Override
    public void removeProcessDef(String procDefHashVal) {
        this.cacheManagerImpl.removeProcessDef(procDefHashVal);
    }

    @Override
    public void removeProcessInst(String processInstId) {
        this.cacheManagerImpl.removeProcessInst(processInstId);
    }

    private void registerTxProcInst(String procInstId) {
        WfTxContext wfCtx = WfTxContext.current();
        if (wfCtx == null) {
            return;
        }
        wfCtx.getTxProcessMgr().addTxProcessID(procInstId);
    }

    private void registerTxActInst(WfActivity actInst) {
        WfTxContext wfCtx = WfTxContext.current();
        if (wfCtx == null) {
            return;
        }
        wfCtx.getTxActivityMgr().addTxActivityID(actInst.getId());
        wfCtx.getTxProcessMgr().addTxProcessID(actInst.getProcInstId());
    }

    private void registerTxAssginInst(WfAssignment assginInst) {
        WfTxContext wfCtx = WfTxContext.current();
        if (wfCtx == null) {
            return;
        }
        wfCtx.getTxAssignmentMgr().addTxAssignmentID(assginInst.getId());
        wfCtx.getTxActivityMgr().addTxActivityID(assginInst.getActInstId());
        wfCtx.getTxProcessMgr().addTxProcessID(assginInst.getProcInstId());
    }

    @Override
    public void addAssignment(WfAssignment assignment) {
        this.cacheManagerImpl.addAssignment(assignment);
        this.registerTxAssginInst(assignment);
    }

    @Override
    public void addProcInst(WfProcess procInst) {
        this.cacheManagerImpl.addProcInst(procInst);
        this.registerTxProcInst(procInst.getId());
    }

    @Override
    public Object getGeneralObject(Object key) {
        return this.cacheManagerImpl.getGeneralObject(key);
    }

    @Override
    public void putGeneralObject(Object key, Object value) {
        if (value != null) {
            this.cacheManagerImpl.putGeneralObject(key, value);
        }
    }

    @Override
    public void notifyActivityChange(String activityID) {
        this.cacheManagerImpl.notifyActivityChange(activityID);
    }

    @Override
    public void notifyAssignmentChange(String assignmentID) {
        this.cacheManagerImpl.notifyAssignmentChange(assignmentID);
    }

    @Override
    public void notifyProcessInstChange(String processInstID) {
        this.cacheManagerImpl.notifyProcessInstChange(processInstID);
    }

    @Override
    public Object getInvocationResult(IdentifiableInvocationDesc invocationDesc) {
        return this.cacheManagerImpl.getInvocationResult(invocationDesc);
    }

    @Override
    public void removeInvocationResult(EffectRegion methodEffectRegion) {
        this.cacheManagerImpl.removeInvocationResult(methodEffectRegion);
    }

    @Override
    public WfAssignment getCachedAssignment(String key) {
        return this.cacheManagerImpl.getCachedAssignment(key);
    }

    @Override
    public void destroy() {
        this.cacheManagerImpl.destroy();
    }

    @Override
    public void cleanParticipantCache() {
        this.cacheManagerImpl.cleanParticipantCache();
    }

    @Override
    public void removeProcRefInsts(String procInstID) {
        this.cacheManagerImpl.removeProcRefInsts(procInstID);
    }

    @Override
    public void removeProcessMgr(String procDefId, int version) {
        this.cacheManagerImpl.removeProcessMgr(procDefId, version);
    }

    @Override
    public int size() {
        return this.cacheManagerImpl.size();
    }

    @Override
    public void activityInstExpired(String actInstId) {
        this.cacheManagerImpl.activityInstExpired(actInstId);
    }

    @Override
    public void assignmentExpired(String assignId) {
        this.cacheManagerImpl.assignmentExpired(assignId);
    }

    @Override
    public void processInstExpired(String procInstId) {
        this.cacheManagerImpl.processInstExpired(procInstId);
    }

    @Override
    public BOSObjectType[] getRelatedEntityTypes(String procdefID) {
        return this.cacheManagerImpl.getRelatedEntityTypes(procdefID);
    }
}

