/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.extend.jump;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.extend.jump.IJumpController;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.bos.workflow.engine.core.thread.FlowJump;
import com.kingdee.bos.workflow.metas.IOption;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.OptionFactory;
import com.kingdee.bos.workflow.metas.OptionInfo;
import com.kingdee.bos.workflow.metas.OptionType;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.service.IWfDefineService;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.WfDbUtil;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class JumpController
extends AbstractBOSObject
implements IJumpController {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.extend.jump.JumpController");

    public static JumpController getService(Context ctx) {
        return new JumpController(ctx);
    }

    public JumpController() {
        this.registerInterface(IWfDefineService.class, this);
    }

    public JumpController(Context ctx) {
        super(ctx);
        this.registerInterface(IWfDefineService.class, this);
    }

    public BOSObjectType getType() {
        return BOSObjectType.create((String)"PROCJUMP");
    }

    private WfLogger getWfLogger() throws WfException {
        return WfEngine.getEngine(this.getContext()).getWfLogger();
    }

    private boolean tojumpTo(String procInstId, Connection cn) {
        try {
            String sql = "select count(*) num from t_wfr_runtime where fprocinstid=?";
            PreparedStatement stmt = cn.prepareStatement(sql);
            stmt.setString(1, procInstId);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getInt("num") <= 0) continue;
                sql = "delete from t_wfr_runtime where fprocinstid=?";
                PreparedStatement ps = cn.prepareStatement(sql);
                ps.setString(1, procInstId);
                ps.executeUpdate();
                ps.close();
                stmt.close();
                return true;
            }
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Connection getConnection() throws SQLException {
        return WfDbUtil.getConnection((Context)this.getContext());
    }

    @Override
    public void jump(String procInstId, ActivityDef activityDef, String option) throws WfException {
        String desc;
        StringBuffer buffer;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                buffer = new StringBuffer();
                buffer.append("Service:JumpController Method:jump  been called.").append("\n");
                buffer.append("parameters:").append("\n");
                buffer.append("procInstId:" + procInstId).append("\n");
                buffer.append("activityDefId:" + activityDef.getID());
                desc = buffer.toString();
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (!this.canJump(procInstId, activityDef)) {
            if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
                try {
                    buffer = new StringBuffer();
                    buffer.append("Service:JumpController Method:jump  execute error").append("\n");
                    buffer.append("error reason:can not jump to that activity, procInstId:" + procInstId + ",activityDefId:" + activityDef.getID()).append("\n");
                    buffer.append("parameters:").append("\n");
                    buffer.append("procInstId:" + procInstId).append("\n");
                    buffer.append("activityDefId:" + activityDef.getID());
                    desc = buffer.toString();
                    this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
                }
                catch (Exception e) {
                    log.warn((Object)"error", (Throwable)e);
                }
            }
            throw new WfException("can not jump to that activity, procInstId:" + procInstId + ",activityDefId:" + activityDef.getID());
        }
        this.innerJump(procInstId, activityDef.getID(), option);
    }

    protected void jump(WfEngine engine, WfProcess wfProcess, WfActivity fromActInst, ActivityDef toActDef) throws WfException {
        if (fromActInst == null) {
            throw new IllegalArgumentException("fromActInst is null");
        }
        if (toActDef == null) {
            throw new IllegalArgumentException("toActDef is null");
        }
        if (!wfProcess.state().startsWith(WfState.RUNNING.getValue())) {
            throw new WfException("Fatal Error.WfProcess not running. WfProcess id :" + wfProcess.getId());
        }
        throw new WfException("not support");
    }

    @Override
    public List getJumpTargetActivitys(String procInstId) throws WfException {
        ArrayList<ActivityDef> rtnList = new ArrayList<ActivityDef>();
        WfEngine engine = WfEngine.getEngine(this.getContext());
        WfProcess wfProc = engine.getProcessInst(procInstId);
        String procHashValue = wfProc.getData().getProcDefHashValue();
        ProcessDef procDef = engine.getProcessDef(procHashValue);
        ActivityCollection actCol = procDef.getActivitys();
        int n = actCol.size();
        for (int i = 0; i < n; ++i) {
            if (!this.canJump(procInstId, actCol.get(i))) continue;
            rtnList.add(actCol.get(i));
        }
        return rtnList;
    }

    @Override
    public boolean canJump(String procInstId, ActivityDef actDef) throws WfException {
        return !(actDef instanceof StartActivityDef);
    }

    @Override
    public void innerJump(String procInstId, String actDefId, String option) throws WfException {
        WfEngine engine = WfEngine.getEngine(this.getContext());
        WfProcess wfProcess = engine.getProcessInst(procInstId);
        ActivityDef activityDef = wfProcess.getDefinition().getActivityDef(actDefId);
        if (wfProcess.getProcessContext().isPvmMode()) {
            FlowJump.enqueue(this.getContext(), procInstId, actDefId, option);
            return;
        }
        ActivityInstInfo[] actInsts = engine.getActInstMetaArrayByProcInstIdAndActInstState(procInstId, WfState.OPEN.getValue());
        if (actInsts != null && actInsts.length > 0 && actInsts[0] != null) {
            if (actInsts.length == 1) {
                WfActivity curActivity = engine.getActivityInst(actInsts[0].getActInstId());
                wfProcess.transWithoutVerify(curActivity, activityDef);
                curActivity.terminateWithoutTrans();
            } else {
                int n = actInsts.length;
                for (int i = 1; i < n; ++i) {
                    WfActivity activity = engine.getActivityInst(actInsts[i].getActInstId());
                    activity.terminateWithoutTrans();
                }
                WfActivity curActivity = engine.getActivityInst(actInsts[0].getActInstId());
                wfProcess.transWithoutVerify(curActivity, activityDef);
                curActivity.terminateWithoutTrans();
            }
        }
    }

    private boolean isEqualTo(String actDefId, String option) {
        if (!option.contains("&&")) {
            return true;
        }
        String[] arr = option.split("&&");
        if (arr.length != 2) {
            return true;
        }
        return arr[1].equals(actDefId);
    }

    public void pvmJump(String actDefId, WfProcess process, String option) throws WfException {
        ActivityDef from;
        process.getProcessContext().putDataFieldValue("$billLastUpdatedTime", new Date());
        process.getProcessContext().putDataFieldValue("$billLastUpdatedAssignId", null);
        ActivityDef activityDef = process.getDefinition().getActivityDef(actDefId);
        HashSet<String> fromIds = new HashSet<String>();
        LinkedList<ActivityDef> list = new LinkedList<ActivityDef>();
        list.add(activityDef);
        block0: while (list.size() > 0) {
            activityDef = (ActivityDef)list.remove(0);
            for (TransitionDef transDef : activityDef.getIncomingTransitions()) {
                from = transDef.getFrom();
                if (from == null || from.getID() == null || fromIds.contains(from.getID()) || !this.isEqualTo(from.getID(), option)) continue;
                fromIds.add(from.getID());
                list.add(from);
                continue block0;
            }
        }
        FlowContext runtime = process.getProcessContext().loadFlowContext();
        List executions = runtime.getRootExecution().getChildren();
        from = null;
        ExecutionImpl e = null;
        int length = executions.size();
        for (int i = length - 1; i >= 0; --i) {
            String nodeId;
            ExecutionImpl currentNode = (ExecutionImpl)executions.get(i);
            if (!currentNode.isClosed()) {
                currentNode.terminate();
            }
            if (!currentNode.isStarted()) continue;
            e = currentNode;
            if (from != null || !(currentNode.getDefine() instanceof NodeImpl) || !fromIds.contains(nodeId = ((NodeImpl)currentNode.getDefine()).getId())) continue;
            from = currentNode;
        }
        if (from == null) {
            from = e;
        }
        if (from != null) {
            this.jump(actDefId, process, runtime, (Execution)from, option);
        } else {
            Node[] nodes = new Node[]{runtime.getFlow().getNode(actDefId)};
            runtime.getService().setStartNodes(nodes);
            Util.clearOmitFirstActivityFlag(runtime);
            this.run(process, runtime);
        }
    }

    private void run(WfProcess process, FlowContext runtime) throws WfException {
        try {
            runtime.resume();
            process.getProcessContext().setFlowContext(runtime);
        }
        catch (Exception e1) {
            if (e1 instanceof WfException) {
                throw (WfException)((Object)e1);
            }
            throw new WfException(e1.getMessage(), (Throwable)e1);
        }
    }

    public void jump(String toActDefId, WfProcess process, FlowContext runtime, Execution from, String option) throws WfException {
        if (option.contains("&&")) {
            option = option.split("&&")[0];
        }
        Util.jump(from, new String[]{toActDefId});
        String actinstid = from.getId();
        AssignmentInfo[] assign = WfEngine.getEngine(this.getContext()).getAssignmentByActInstId(actinstid);
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.getContext());
            String hash = svc.getProcessInstInfo(assign[0].getProcInstId()).getProcDefHashValue();
            ProcessDef def = svc.getProcessDefByDefineHashValue(hash);
            ActivityDef actDef = def.getActivityDef(toActDefId);
            this.addOptionInfo(runtime, assign, option, actDef);
            ActivityDef fromDef = def.getActivityDef(assign[0].getActDefId());
            if (fromDef instanceof ApproveActivityDef) {
                ApproveActivityDef approveDef = (ApproveActivityDef)fromDef;
                if (option.endsWith("kickback") && !this.isSetBackRepeat(process, actinstid, approveDef)) {
                    String key = toActDefId + "#RETURN_TARGET";
                    runtime.setProperty(key, from.getDefine().getId());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        this.run(process, runtime);
    }

    private boolean isSetBackRepeat(WfProcess process, String actinstid, ApproveActivityDef approveDef) {
        boolean isSetBackRepeat = approveDef.isBackRepeatProcDef();
        try {
            ProcessContext processContext = process.getProcessContext();
            String key = actinstid + "#isBackRepeatProcDef";
            Object val = processContext.getDataFieldValue(key);
            if (val != null) {
                isSetBackRepeat = (Boolean)val;
            }
        }
        catch (WfException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return isSetBackRepeat;
    }

    private void addOptionInfo(FlowContext runtime, AssignmentInfo[] assign, String optionval, ActivityDef actDef) throws Exception {
        Context ctx = this.getContext();
        List executions = runtime.getRootExecution().getChildren();
        String actinstid = "";
        String callID = ctx.getCaller().toString();
        if (executions.size() > 0) {
            Execution ex = (Execution)executions.get(executions.size() - 1);
            actinstid = ex.getId().toString();
            IOption option = OptionFactory.getLocalInstance((Context)ctx);
            OptionInfo opinfo = new OptionInfo();
            AssignmentInfo assigninfo = assign[0];
            boolean isMatch = false;
            for (int i = 0; i < assign.length; ++i) {
                String userID = assign[i].getAssignInfo().getPersonUserID().toString();
                if (!userID.equals(callID)) continue;
                assigninfo = assign[i];
                isMatch = true;
                break;
            }
            if (!StringUtils.isEmpty((String)actinstid)) {
                opinfo.setActinstID(BOSUuid.read((String)actinstid));
            }
            if (!StringUtils.isEmpty((String)assigninfo.getAssignmentId()) && isMatch) {
                opinfo.setAssignmentID(BOSUuid.read((String)assigninfo.getAssignmentId()));
            }
            if (!StringUtils.isEmpty((String)assigninfo.getBizObjectIds())) {
                opinfo.setBillID(BOSUuid.read((String)assigninfo.getBizObjectIds()));
            }
            if (!StringUtils.isEmpty((String)assigninfo.getActInstId())) {
                opinfo.setCurrentAcinstID(BOSUuid.read((String)assigninfo.getActInstId()));
            }
            opinfo.setProcinstID(BOSUuid.read((String)assigninfo.getProcInstId()));
            if (!StringUtils.isEmpty((String)assigninfo.getEmployeeId())) {
                if (isMatch) {
                    opinfo.setPersonID(BOSUuid.read((String)assigninfo.getEmployeeId()));
                } else {
                    String personID;
                    String sql = "SELECT FPERSONID  FROM t_pm_user where FID =?";
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{callID});
                    if (rowSet.next() && !StringUtils.isEmpty((String)(personID = rowSet.getString("FPERSONID")))) {
                        opinfo.setPersonID(BOSUuid.read((String)rowSet.getString("FPERSONID")));
                    }
                }
            }
            String optionStr = optionval.replace("kickback", "").replace("jumpto", "");
            Locale locale = FlowJump.getLocale();
            String kickback = " reject to ";
            String jumpto = " jump to ";
            String node = " node ";
            if (locale != null && "l2".equalsIgnoreCase(locale.toString())) {
                kickback = "\u6253\u56de\u5230";
                jumpto = "\u8df3\u8f6c\u5230";
                node = "\u8282\u70b9";
            } else if (locale != null && "l3".equalsIgnoreCase(locale.toString())) {
                kickback = "\u6253\u56de\u5230";
                jumpto = "\u8df3\u8f49\u5230";
                node = "\u7bc0\u9ede";
            }
            String nodeName = actDef.getName(locale);
            String result = "";
            if (optionval.endsWith("kickback")) {
                opinfo.setType(OptionType.kickBack);
                result = kickback + "\u3010" + nodeName + "\u3011" + node;
            } else {
                opinfo.setType(OptionType.jumpTo);
                result = jumpto + "\u3010" + nodeName + "\u3011" + node;
            }
            opinfo.setResult(result);
            opinfo.setOption(optionStr);
            option.addnew(opinfo);
        }
    }
}

