/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.message;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.AssignmentMessage;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.enhanced.EMessage;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.message.WfMessageCounter;
import com.kingdee.bos.workflow.enactment.message.WfMessageSender;
import com.kingdee.bos.workflow.enactment.message.WfMessageUtil;
import com.kingdee.bos.workflow.message.IWfMessage;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.wfdesigner.WfBizType;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WfMessage
implements IWfMessage {
    private static final long serialVersionUID = 7710264092980016512L;
    private static final Logger logger = Logger.getLogger(WfMessage.class);
    private Message message = MessageFactory.newMessage();
    private String domain = "kingdee.workflow";
    private String sender = "WfAdmin";
    private String sourceId = null;
    private String function = null;
    private String receiver = null;
    private String solution = null;
    private String operation = null;
    private String bizPackage = null;
    private String initiatorId = null;
    private String processDefId = null;
    private String processInstId = null;
    private String activityDefId = null;
    private String activityInstId = null;
    private String databaseCenter = null;
    private String processDefHashValue = null;
    private WfBizType actBizType = null;
    private int type = 0;
    private int bizType = 0;
    private int priority = 10;
    private int sourceStatus = 0;
    private String orgId = null;
    private String orgType = null;
    private int contentType = 1;
    private String sourceIDs;
    private Boolean isParamSuspend = false;

    public void setContext(Context ctx) {
        this.databaseCenter = ctx.getAIS();
        this.solution = ctx.getSolution();
    }

    public void setActivity(WfActivity activity) throws WfException {
        ManpowerActivityDef actDef;
        ApplicationDef app;
        this.setContext(activity.getWfEngine().context());
        ProcessInstInfo info = activity.container().getData();
        this.actBizType = activity.getDefinition().getBizType();
        this.initiatorId = info.getInitiatorId();
        this.processDefId = info.getProcDefId();
        this.processInstId = info.getProcInstId();
        this.activityDefId = activity.getDefinition().getID();
        this.activityInstId = activity.getId();
        this.processDefHashValue = info.getProcDefHashValue();
        int p = activity.getDefinition().getActivityHeader().getpriority();
        p = p == -2 || p == -3 ? 0 : (p == -1 || p == 0 || p == 1 ? 10 : (p == 2 || p == 3 || p == 4 || p == 5 ? 20 : 10));
        this.priority = p;
        Locale[] locales = ApplicationUtil.getContextLocales((Context)activity.getWfEngine().context());
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            String initor = info.getInitiatorName(locale);
            this.message.setLocaleStringHeader("initiatorName", initor == null ? "" : initor, locale);
        }
        if (activity.getDefinition() instanceof ManpowerActivityDef && (app = (actDef = (ManpowerActivityDef)activity.getDefinition()).getRelatedApplication()) != null && app.getFunction() != null) {
            String functionName = app.getFunction().getName();
            this.operation = functionName + "." + app.getFunction().getOperation();
            this.bizPackage = app.getFunction().getPackageName();
            this.function = app.getFunction().getName();
        }
    }

    public void setContent(WfActivity activity, AssignmentMessage amsg) throws WfException {
        this.setContent(activity, amsg, false);
    }

    public void setContent(WfActivity activity, AssignmentMessage amsg, boolean isMail) throws WfException {
        this.setActivity(activity);
        Locale[] locales = ApplicationUtil.getContextLocales((Context)activity.getWfEngine().context());
        boolean isMailSameAsMessage = true;
        if (isMail && !amsg.isMailSameAsMessage()) {
            isMailSameAsMessage = false;
        }
        Locale l2 = new Locale("l2");
        String extendParam = amsg.getExtendParam(l2);
        extendParam = WfMessageUtil.parseMessage(extendParam, activity, l2);
        this.message.setStringHeader("category", amsg.getCategory());
        this.message.setStringHeader("extendParam", extendParam);
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            String title = "";
            String body = "";
            if (isMailSameAsMessage) {
                title = amsg.getTitle(locale);
                body = amsg.getBody(locale);
            } else {
                title = amsg.getMailTitle(locale);
                body = amsg.getMailBody(locale);
            }
            title = WfMessageUtil.parseMessage(title, activity, locale);
            body = WfMessageUtil.parseMessage(body, activity, locale);
            this.message.setLocaleStringHeader("title", title, locale);
            this.message.setLocaleStringHeader("body", body, locale);
        }
        if (amsg.isShowWfImg()) {
            Object billId;
            this.sourceIDs = "|" + activity.container().getId();
            String billKey = amsg.getBillIdKey();
            if (billKey != null && (billId = activity.container().getProcessContext().getDataFieldValue(billKey)) != null) {
                this.sourceIDs = this.sourceIDs + "|" + billId;
                if (!StringUtils.isEmpty((String)amsg.getBillState())) {
                    this.sourceIDs = this.sourceIDs + "|" + amsg.getBillState();
                }
            }
        }
    }

    public void setSourceIds(String sourceIds) {
        this.sourceIDs = sourceIds;
    }

    public void setContent(WfActivity activity, EMessage emsg) throws WfException {
        Locale[] locales = ApplicationUtil.getContextLocales((Context)activity.getWfEngine().context());
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            String body = WfMessageUtil.parseMessage(emsg.getContent(locale), activity, locale);
            this.message.setLocaleStringHeader("body", body, locale);
        }
        int type = emsg.getType();
        if ((type & 0) != 0) {
            this.contentType |= 1;
        }
        if ((type & 4) != 0) {
            this.contentType |= 2;
        }
        if (emsg.isEnable()) {
            this.contentType |= 4;
        }
    }

    private void setStringHeader(String name, String value) {
        if (!StringUtils.isEmpty((String)value)) {
            this.message.setStringHeader(name, value);
        }
    }

    public void sendNoTransaction(Context ctx, String receiver) {
        this.receiver = receiver;
        this.fillMessage();
        WfMessageSender.sendMessageWithoutTransaction(ctx, this.message);
        WfMessageCounter.increase(this.databaseCenter, this.solution, 1 + WfMessageCounter.charCount(receiver, ';'));
    }

    public void send(String receiver) {
        this.receiver = receiver;
        this.fillMessage();
        WfMessageSender.sendMessage(this.message);
        WfMessageCounter.increase(this.databaseCenter, this.solution, 1 + WfMessageCounter.charCount(receiver, ';'));
    }

    public void fillMessage() {
        if (!StringUtils.isEmpty((String)this.domain)) {
            this.message.setDomian(this.domain);
        }
        this.message.setIntHeader("bizType", this.bizType);
        this.message.setIntHeader("priority", this.priority);
        this.message.setIntHeader("sourceStatus", this.sourceStatus);
        this.setStringHeader("sender", this.sender);
        this.setStringHeader("receiver", this.receiver);
        this.setStringHeader("solution", this.solution);
        this.setStringHeader("function", this.function);
        this.setStringHeader("operation", this.operation);
        this.setStringHeader("bizPackage", this.bizPackage);
        if (this.actBizType != null) {
            this.setStringHeader("actBizTypeNumber", this.actBizType.getNumber());
            this.setStringHeader("actBizTypeName", this.actBizType.getName());
            this.setStringHeader("actBizTypeId", this.actBizType.getId());
        }
        this.setStringHeader("initiatorId", this.initiatorId);
        this.setStringHeader("ProcessDefId", this.processDefId);
        this.setStringHeader("ProcessInstId", this.processInstId);
        this.setStringHeader("activityDefId", this.activityDefId);
        this.setStringHeader("activityInstId", this.activityInstId);
        this.setStringHeader("databaseCenter", this.databaseCenter);
        this.setStringHeader("processDefHashValue", this.processDefHashValue);
        this.setStringHeader("orgId", this.orgId);
        this.setStringHeader("orgType", this.orgType);
        this.setStringHeader("sourceID", this.sourceId);
        this.setStringHeader("sourceIDs", this.sourceIDs);
        this.setStringHeader("isParamSuspend", String.valueOf(this.isParamSuspend));
        if (this.contentType == 0) {
            logger.warn((Object)"\u6d88\u606f\u7c7b\u578b\u6709\u8bef,\u88ab\u8bbe\u7f6e\u4e3a\u4e0d\u53d1\u9001\u4efb\u4f55\u6d88\u606f");
        }
        if ((this.contentType & 2) != 0) {
            this.message.setBooleanHeader("isSendEmail", true);
        }
        if ((this.contentType & 4) != 0) {
            this.message.setBooleanHeader("isSendMobile", true);
        }
        if ((this.contentType & 1) != 0) {
            this.message.setBooleanHeader("isSendCommon", true);
        }
    }

    public String getActivityDefId() {
        return this.activityDefId;
    }

    public void setActivityDefId(String activityDefId) {
        this.activityDefId = activityDefId;
    }

    public String getActivityInstId() {
        return this.activityInstId;
    }

    public void setActivityInstId(String activityInstId) {
        this.activityInstId = activityInstId;
    }

    public String getBizPackage() {
        return this.bizPackage;
    }

    public void setBizPackage(String bizPackage) {
        this.bizPackage = bizPackage;
    }

    public int getBizType() {
        return this.bizType;
    }

    public void setBizType(int bizType) {
        this.bizType = bizType;
    }

    public String getDatabaseCenter() {
        return this.databaseCenter;
    }

    public void setDatabaseCenter(String databaseCenter) {
        this.databaseCenter = databaseCenter;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }

    public void setInitiatorId(String initiatorId) {
        this.initiatorId = initiatorId;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getProcessDefHashValue() {
        return this.processDefHashValue;
    }

    public void setProcessDefHashValue(String processDefHashValue) {
        this.processDefHashValue = processDefHashValue;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    public String getProcessInstId() {
        return this.processInstId;
    }

    public void setProcessInstId(String processInstId) {
        this.processInstId = processInstId;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public int getSourceStatus() {
        return this.sourceStatus;
    }

    public void setSourceStatus(int sourceStatus) {
        this.sourceStatus = sourceStatus;
    }

    public Message getMessage() {
        return this.message;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public void addSubject(String title, Locale locale) {
        this.message.setLocaleStringHeader("title", title == null ? "" : title, locale);
    }

    public String getSubject() {
        Locale locale = new Locale("L2");
        return this.message.getLocaleStringHeader("title", locale);
    }

    public String getContent() {
        Locale locale = new Locale("L2");
        return this.message.getLocaleStringHeader("body", locale);
    }

    public void addContent(String body, Locale locale) {
        this.message.setLocaleStringHeader("body", body == null ? "" : body, locale);
    }

    public void addInitiatorName(String name, Locale locale) {
        this.message.setLocaleStringHeader("initiatorName", name == null ? "" : name, locale);
    }

    public void setContentType(int type) {
        this.contentType = type;
    }

    public int getContentType() {
        return this.contentType;
    }

    public WfBizType getActBizType() {
        return this.actBizType;
    }

    public void setActBizType(WfBizType actBizType) {
        this.actBizType = actBizType;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOrgType() {
        return this.orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    public Boolean getIsParamSuspend() {
        return this.isParamSuspend;
    }

    public void setIsParamSuspend(Boolean isParamSuspend) {
        this.isParamSuspend = isParamSuspend;
    }
}

