/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;

public class ActInstResume
extends WfJobHandler {
    private static final long serialVersionUID = 8758629117890135779L;
    private String actInstId;
    private String procInstId;

    public ActInstResume(String actInstId, String procInstId, String userId) {
        super(userId);
        this.actInstId = actInstId;
        this.procInstId = procInstId;
    }

    public static void enqueue(Context ctx, String procInstId, String actInstId) throws AlreadyInProcessQueueException {
        String title = "~" + actInstId + ":Resume";
        String jobId = Mutex.getMutex(ctx, procInstId);
        JobDispatcher.dispatch(jobId, ctx, title, new ActInstResume(actInstId, procInstId, ctx.getCaller().toString()), false, WfPriority.MEDIUM);
    }

    @Override
    protected String getProcInstId() {
        return this.procInstId;
    }

    @Override
    protected boolean requiresTran() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Context ctx) throws Exception {
        WfEngine engine = WfEngine.getEngine(ctx);
        WfProcess process = engine.getProcessInst(this.procInstId);
        FlowContext runtime = process.getProcessContext().loadFlowContext();
        try {
            Execution current = runtime.getExecution(this.actInstId);
            if (current != null) {
                runtime.resume(this.actInstId);
            } else {
                Exception error = new Exception("\u6d3b\u52a8\u5b9e\u4f8b(" + this.actInstId + ")\u4e0d\u5b58\u5728\uff01");
                this.saveLog(error, ctx, this.procInstId);
            }
        }
        finally {
            super.commitMgrAndRuntimeTx(process, runtime);
        }
    }
}

