/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.extend.jump.JumpController;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import java.util.Locale;

public class FlowJump
extends WfJobHandler {
    private static final long serialVersionUID = -3149519947280565253L;
    private String procInstId;
    private String actDefId;
    private String option;
    private Locale locale;
    private static ThreadLocal<Locale> localeThreadLocal = new ThreadLocal();

    public static void enqueue(Context ctx, String procInstId, String actDefId, String option) throws AlreadyInProcessQueueException {
        String jobId = Mutex.getMutex(ctx, procInstId);
        String title = "~" + procInstId + ":jump";
        JobDispatcher.dispatch(jobId, ctx, title, new FlowJump(procInstId, actDefId, option, ctx.getCaller().toString(), ctx.getLocale()), true, WfPriority.HIGHEST);
    }

    private FlowJump(String procInstId, String actDefId, String option, String userId, Locale locale) {
        super(userId);
        this.procInstId = procInstId;
        this.actDefId = actDefId;
        this.option = option;
        this.locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Context ctx) throws Exception {
        WfEngine engine = WfEngine.getEngine(ctx);
        engine.getCacheManager().processInstExpired(this.procInstId);
        WfProcess process = engine.getProcessInst(this.procInstId);
        FlowContext runtime = process.getProcessContext().loadFlowContext();
        localeThreadLocal.set(this.locale);
        try {
            if (process.isClosed() || runtime.isClosed()) {
                return;
            }
            new JumpController(ctx).pvmJump(this.actDefId, process, this.option);
        }
        catch (Exception error) {
            this.saveLog(error, ctx, this.procInstId);
        }
        finally {
            localeThreadLocal.set(null);
            super.commitMgrAndRuntimeTx(process, runtime);
        }
    }

    @Override
    protected boolean requiresTran() {
        return false;
    }

    @Override
    protected String getProcInstId() {
        return this.procInstId;
    }

    public static Locale getLocale() {
        return localeThreadLocal.get();
    }
}

