/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.FlowProfileLoader;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;

public class FlowSignaler
extends WfJobHandler {
    private static final long serialVersionUID = -3149519947280565253L;
    private String actInstId;
    private String procInstId;

    public static void enqueue(Context ctx, String procInstId, String actInstId) throws AlreadyInProcessQueueException {
        String title = "~" + actInstId + ":Signal";
        String jobId = Mutex.getMutex(ctx, procInstId);
        JobDispatcher.dispatch(jobId, ctx, title, new FlowSignaler(procInstId, actInstId, ctx.getCaller().toString()), false, WfPriority.MEDIUM);
    }

    private FlowSignaler(String procInstId, String actInstId, String userId) {
        super(userId);
        this.actInstId = actInstId;
        this.procInstId = procInstId;
    }

    @Override
    public void run(Context ctx) throws Exception {
        WfEngine engine = WfEngine.getEngine(ctx);
        engine.getCacheManager().processInstExpired(this.procInstId);
        WfProcess process = engine.getProcessInst(this.procInstId);
        FlowContext runtime = process.getProcessContext().loadFlowContext();
        Execution current = runtime.getExecution(this.actInstId);
        if (current != null) {
            this.executeFlow(ctx, process, runtime, current);
        } else {
            Exception error = new Exception("\u6d3b\u52a8\u5b9e\u4f8b(" + this.actInstId + ")\u4e0d\u5b58\u5728\uff01");
            this.saveLog(error, ctx, this.procInstId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeFlow(Context ctx, WfProcess process, FlowContext runtime, Execution<?> current) throws Exception {
        try {
            if (process.state().equals("open.not_running.suspended")) {
                runtime.resume();
            }
            if (current.isBeforePartiallyCompleted()) {
                runtime.signal(this.actInstId);
            }
            if ((current = runtime.getExecution(this.actInstId)) != null && !current.isClosed()) {
                runtime.signal(this.actInstId);
            } else {
                FlowProfileLoader profile = new FlowProfileLoader(ctx);
                profile.insert(this.procInstId, this.actInstId, "\u6d3b\u52a8(" + this.actInstId + ")\u72b6\u6001\u5f02\u5e38\uff0c\u6ca1\u6709\u89e6\u53d1\u6d41\u7a0b\u7ee7\u7eed\u6267\u884c\uff01");
            }
            Util.setLastSignal(runtime, null);
        }
        catch (Throwable error) {
            this.saveLog(error, ctx, this.procInstId);
        }
        finally {
            super.commitMgrAndRuntimeTx(process, runtime);
        }
    }

    @Override
    protected String getProcInstId() {
        return this.procInstId;
    }

    @Override
    protected boolean requiresTran() {
        return false;
    }
}

