/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ConditionType;
import com.kingdee.bos.workflow.define.ExpressionCollection;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ScriptDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.service.ormrpc.struct.WfProcessImageUtil;
import com.kingdee.bos.workflow.util.EnactmentUtils;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfConditionTestService {
    private static final Logger logger = Logger.getLogger(WfConditionTestService.class);
    private Context ctx;

    public WfConditionTestService(Context ctx) {
        this.ctx = ctx;
    }

    public List getProcessConditionList(String procinstId) throws WfException {
        ArrayList result = new ArrayList();
        WfEngine engine = this.getWfEngine();
        WfProcess wfProcess = engine.getProcessInst(procinstId);
        ProcessDef procDef = wfProcess.getDefinition();
        ActivityCollection activities = procDef.getActivitys();
        Map activeNames = WfProcessImageUtil.rename((ProcessDef)procDef, (Locale)this.ctx.getLocale());
        for (int i = 0; i < activities.size(); ++i) {
            ActivityDef actdef = activities.get(i);
            String actName = (String)activeNames.get(actdef.getID());
            if (actdef instanceof StartActivityDef) continue;
            if (actdef instanceof ManpowerActivityDef) {
                ManpowerActivityDef manActDef = (ManpowerActivityDef)actdef;
                ParticipantCollection participants = manActDef.getParticipants();
                for (ParticipantDef participant : participants) {
                    ScriptDef scriptdef;
                    String participantName = participant.getName();
                    String refScriptId = participant.getScriptRef();
                    if (StringUtils.isEmpty((String)refScriptId) || (scriptdef = procDef.getScripts().get(refScriptId)) == null || scriptdef.getScriptContent() == null) continue;
                    String scriptContent = scriptdef.getScriptContent();
                    HashMap<String, String> conditionInfo = new HashMap<String, String>();
                    conditionInfo.put("type", "\u6761\u4ef6\u53c2\u4e0e\u4eba");
                    conditionInfo.put("description", actName + "--" + participantName);
                    conditionInfo.put("conditionExpression", scriptContent);
                    result.add(conditionInfo);
                }
            }
            TransitionCollection transitions = actdef.getOutgoingTransitions();
            for (TransitionDef transitionDef : transitions) {
                String exprStr;
                ExpressionCollection expressions;
                ActivityDef toAct = transitionDef.getTo();
                String toActName = (String)activeNames.get(toAct.getID());
                if (!ConditionType.CONDITION.equals((Object)transitionDef.getCondition().getConditionType()) || (expressions = transitionDef.getCondition().getXpressionList()) == null || expressions.size() <= 0 || (exprStr = expressions.get(0).getExpressionStr()) == null || "".equals(exprStr)) continue;
                HashMap<String, String> conditionInfo = new HashMap<String, String>();
                conditionInfo.put("type", "\u8f6c\u79fb");
                conditionInfo.put("description", actName + "-->" + toActName);
                conditionInfo.put("conditionExpression", exprStr);
                result.add(conditionInfo);
            }
        }
        return result;
    }

    public boolean doProcessConditionTest(String procinstId, String expr) throws WfException {
        WfProcess procInst = this.getWfEngine().getProcessInst(procinstId);
        ProcessDef procDef = procInst.getDefinition();
        Interpreter interpreter = new Interpreter(EnactmentUtils.cloneContext(this.getWfEngine().context()));
        Map datamap = procInst.getProcContextDataCopy();
        datamap.putAll(ScriptUtil.getInnerVariables(procDef));
        try {
            Object result = interpreter.evalExpr(expr, datamap);
            if (result == null) {
                return false;
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof Number) {
                return ((Number)result).intValue() == 1;
            }
        }
        catch (Throwable e) {
            logger.error((Object)("\u6761\u4ef6\u53c2\u4e0e\u4eba\u811a\u672c\u89e3\u6790 \u65f6 \u51fa\u73b0\u9519\u8bef \u811a\u672c\uff1a" + expr), e);
        }
        return false;
    }

    public List getProcessStartConditionList(String procdefId) throws Exception {
        String sql = "select p.FMD5HASH  from t_wfr_procdef p  where p.FPROCDEFID=?  and  p.finnerversion in (SELECT max(finnerversion) FROM t_wfr_procdef t WHERE t.fprocdefId = p.fprocdefId) ";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{procdefId});
        String fmd5hash = null;
        if (rs.next()) {
            fmd5hash = rs.getString("FMD5HASH");
        }
        if (fmd5hash == null || "".equals(fmd5hash)) {
            return null;
        }
        ArrayList result = new ArrayList();
        WfEngine engine = this.getWfEngine();
        ProcessDef procDef = engine.getProcessDef(fmd5hash);
        StartActivityDef startAct = procDef.getStartActivity();
        TransitionCollection transitions = startAct.getOutgoingTransitions();
        for (TransitionDef transitionDef : transitions) {
            String exprStr;
            ExpressionCollection expressions;
            if (!ConditionType.CONDITION.equals((Object)transitionDef.getCondition().getConditionType()) || (expressions = transitionDef.getCondition().getXpressionList()) == null || expressions.size() <= 0 || (exprStr = expressions.get(0).getExpressionStr()) == null || "".equals(exprStr)) continue;
            HashMap<String, String> conditionInfo = new HashMap<String, String>();
            conditionInfo.put("type", "\u8f6c\u79fb");
            conditionInfo.put("description", startAct.getName(this.ctx.getLocale()) + "-->" + transitionDef.getTo().getName(this.ctx.getLocale()));
            conditionInfo.put("conditionExpression", exprStr);
            result.add(conditionInfo);
        }
        return result;
    }

    public boolean doProcessStartConditionTest(String objId, String expr) throws WfException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        IObjectValue bo = ScriptUtil.getBizObject(this.ctx, objId, selectors);
        HashMap<String, IObjectValue> data = new HashMap<String, IObjectValue>();
        data.put("__processTrigger", bo);
        Interpreter interpreter = new Interpreter(EnactmentUtils.cloneContext(this.getWfEngine().context()));
        interpreter.setProperyExprOwnerNullIgore(true);
        try {
            Object result = interpreter.evalExpr(expr, data);
            if (result == null) {
                return false;
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof Number) {
                return ((Number)result).intValue() == 1;
            }
        }
        catch (Throwable e) {
            logger.error((Object)("\u6761\u4ef6\u53c2\u4e0e\u4eba\u811a\u672c\u89e3\u6790 \u65f6 \u51fa\u73b0\u9519\u8bef \u811a\u672c\uff1a" + expr), e);
        }
        return false;
    }

    private WfEngine getWfEngine() throws WfException {
        WfEngine engine = WfEngine.getEngine(this.ctx);
        engine.setLocale(this.ctx.getLocale());
        engine.setContext(this.ctx);
        return engine;
    }
}

