/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.procdiagram.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.WebBillManpowerActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.BotpActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.define.extended.OtherSysActivityDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiaActivityState;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiaActivityType;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProcDiagramUtil {
    protected static final Logger logger = Logger.getLogger(ProcDiagramUtil.class);
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final int MAX_COUNT = 1000;

    public static boolean isBackTransition(TransitionDef transitionDef, Flow flow) {
        String description = transitionDef.getDescription();
        if (transitionDef.getFrom() == null || transitionDef.getTo() == null) {
            return false;
        }
        String transitionPatch = transitionDef.getFrom().getID() + "->" + transitionDef.getTo().getID();
        Set backTranSet = (Set)flow.getAttribute("BACKTRANSET");
        if (backTranSet == null || backTranSet.isEmpty()) {
            backTranSet = flow.getGraph().getBackwardEdges();
            flow.setAttribute("BACKTRANSET", (Object)backTranSet);
        }
        return backTranSet.contains(transitionPatch);
    }

    public static DiaActivityType getDiaActType(ActivityDef activityDef, ActivityInstInfo tActivityInstInfo) {
        DiaActivityType diaActvityType = DiaActivityType.OTHERNODE;
        diaActvityType = activityDef instanceof StartActivityDef ? DiaActivityType.STARTNODE : (activityDef instanceof ApproveActivityDef ? DiaActivityType.APPROVENODE : (activityDef instanceof ManualDecisionActivityDef ? DiaActivityType.MANUALDECISIONNODE : (activityDef instanceof WebBillManpowerActivityDef || ManpowerActivityDef.class.equals(activityDef.getClass()) ? DiaActivityType.MANPOWERNODE : (activityDef instanceof EndActivityDef ? DiaActivityType.ENDNODENODE : (activityDef instanceof SubflowActivityDef ? DiaActivityType.SUBFLOWNODE : (activityDef instanceof BotpActivityDef ? DiaActivityType.BOTPNODE : (activityDef instanceof RouterActivityDef ? DiaActivityType.ROUTERNODE : (activityDef instanceof OtherSysActivityDef ? DiaActivityType.OTHERSYSNODE : (activityDef instanceof MessageActivityDef ? DiaActivityType.MESSAGENODE : DiaActivityType.TOOLNODE)))))))));
        if (tActivityInstInfo != null && tActivityInstInfo.getParentActInstId() != null) {
            diaActvityType = DiaActivityType.APPENDNODE;
        }
        return diaActvityType;
    }

    public static DiaActivityState getAiaActState(ActivityInstInfo tActivityInstInfo, ActivityDef activityDef, WfProcess process, Context ctx) {
        if (tActivityInstInfo == null) {
            if (activityDef instanceof EndActivityDef && process != null) {
                if (ProcDiagramUtil.isAbort(process)) {
                    return DiaActivityState.NOTSTARTABORT;
                }
                if (ProcDiagramUtil.isSusPend(process)) {
                    return DiaActivityState.NOTSTARTSUSPEND;
                }
            }
            return DiaActivityState.NOTSTART;
        }
        String state = tActivityInstInfo.getState();
        boolean isInit = tActivityInstInfo.getInited();
        if (!isInit) {
            if (state.startsWith("closed")) {
                return DiaActivityState.CLOSENOEXECUTION;
            }
            return DiaActivityState.NOTINITI;
        }
        if (state.startsWith("open")) {
            if (state.equals("open.not_running.suspended") || state.equals("open.not_running.blocked")) {
                return DiaActivityState.RUNNINGSUSPEND;
            }
            return DiaActivityState.RUNNING;
        }
        if (state.startsWith("closed")) {
            if ("closed.terminated".equals(state)) {
                if (ProcDiagramUtil.ActStateIsBack(tActivityInstInfo, ctx)) {
                    return DiaActivityState.CLOSEBACK;
                }
                return DiaActivityState.CLOSEJUMP;
            }
            if ("closed.completed".equals(state) && ProcDiagramUtil.ActStateIsRollBack(tActivityInstInfo, ctx)) {
                return DiaActivityState.ROLLBACK;
            }
            return DiaActivityState.CLOSE;
        }
        return DiaActivityState.NOTSTART;
    }

    private static boolean ActStateIsBack(ActivityInstInfo activityInstInfo, Context ctx) {
        String actinstId = activityInstInfo.getActInstId();
        String sql = "select * from t_bas_option where FCURRENTACINSTID=? and ftype=0";
        boolean isBack = false;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{actinstId});
            if (rowSet.next()) {
                isBack = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return isBack;
    }

    private static boolean ActStateIsRollBack(ActivityInstInfo activityInstInfo, Context ctx) {
        String actinstId = activityInstInfo.getActInstId();
        String sql = "select * from t_bas_option where FCURRENTACINSTID=? and ftype=10";
        boolean isRollBack = false;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{actinstId});
            if (rowSet.next()) {
                isRollBack = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return isRollBack;
    }

    public static boolean isAbort(WfProcess process) {
        String state = process.getProcessMeta().getState();
        return "closed.aborted".equals(state);
    }

    public static boolean isSusPend(WfProcess process) {
        String state = process.getProcessMeta().getState();
        return "open.not_running.suspended".equals(state);
    }

    public static String dataFormat(Date date) {
        if (date == null) {
            return "";
        }
        return sdf.format(date);
    }

    public static String getProcDefHash(String procinstId, String procDefId, Context ctx) throws BOSException {
        String tProcDefHash = "";
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        tProcDefHash = StringUtils.isEmpty((String)procinstId) ? service.getProcessDefInfo(procDefId).getMd5HashValue() : service.getProcessInstInfo(procinstId).getProcDefHashValue();
        return tProcDefHash;
    }

    public static Map getProcessPropMap(ProcessDef procDef, WfEngine wfEngine, IObjectValue bizBillObject) throws WfException {
        HashMap<String, IObjectValue> boMap = new HashMap<String, IObjectValue>();
        Context ctx = wfEngine.context();
        ManpowerActivityDef manpowerActivityDef = (ManpowerActivityDef)procDef.getStartupActivities().get(0);
        BOSObjectType bosType = new BOSObjectType(procDef.getBillBostype());
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(bosType);
        boMap.put(entity.getName(), bizBillObject);
        return ProcDiagramUtil.getProcessPropMapInner(manpowerActivityDef, ctx, boMap, bizBillObject);
    }

    private static Map getProcessPropMapInner(ManpowerActivityDef manpowerActDef, Context ctx, Map boMap, IObjectValue bizBillObject) {
        ApplicationDef appDef = manpowerActDef.getRelatedApplication();
        HashMap<String, FormalParameterDef> paramDefMap = new HashMap<String, FormalParameterDef>();
        Map paramValueMap = new HashMap();
        FormalParameterCollection formalParms = appDef.getFormalParameters();
        ActualParameterCollection actualParamCol = manpowerActDef.getActualParameters();
        FormalParameterDef bizObjParamDef = null;
        for (int i = 0; i < formalParms.size(); ++i) {
            FormalParameterDef paramDef = formalParms.get(i);
            if (!paramDef.getMode().equals((Object)FormalParameterMode.OUT) && !paramDef.getMode().equals((Object)FormalParameterMode.INOUT) || paramDef.getBoId() == null || paramDef.getBoId().equals("")) continue;
            if (!paramDef.getDataType().equals(BasicType.BIZOBJ)) {
                paramDefMap.put(paramDef.getID(), paramDef);
                continue;
            }
            bizObjParamDef = paramDef;
            boMap.put(paramDef.getName(), bizBillObject);
            paramDefMap.put(paramDef.getID(), paramDef);
        }
        try {
            paramValueMap = ScriptUtil.evalPropertyExpr(paramDefMap, boMap, ctx, null);
        }
        catch (WfException e) {
            e.printStackTrace();
        }
        for (FormalParameterDef paramDef : paramDefMap.values()) {
            ActualParameterDef actualParam;
            DataFieldDef dataField;
            if (paramDef.getDataType().equals(BasicType.BIZOBJ) || paramDef.getIndex() >= actualParamCol.size() || (dataField = (actualParam = (ActualParameterDef)actualParamCol.getObject(paramDef.getIndex())).getDataField()) == null) continue;
            String dataName = dataField.getName();
            Object paramValue = paramValueMap.get(paramDef.getID());
            boMap.put(dataName, paramValue);
        }
        return boMap;
    }
}

