/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.DevolveDenialException;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityEvent;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.message.WfMessageUtil;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.engine.core.thread.ActInstResume;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.DataTypeEnum;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ActivityControlService;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.IAssignmentControlService;
import com.kingdee.bos.workflow.service.ormrpc.ConfigLoader;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.store.WorkItemStorer;
import com.kingdee.bos.workflow.util.WorkflowLogUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AssignmentControlService
extends AbstractBOSObject
implements IAssignmentControlService {
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WFASTCLS");
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.service.AssignmentControlService");

    public static IAssignmentControlService getService(Context ctx) {
        return new AssignmentControlService(ctx);
    }

    private WfLogger getWfLogger() throws WfException {
        return EngineUtil.getEngine(this.getContext()).getWfLogger();
    }

    public AssignmentControlService(Context ctx) {
        super(ctx);
        this.registerInterface(IAssignmentControlService.class, (Object)this);
    }

    public void acceptAssignment(String assignmentId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:AssignmentControlService Method:acceptAssignment been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: assignmentId=\"");
                buffer.append(assignmentId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfAssignment assignment = wfEngine.getAssignment(assignmentId);
        assignment.accept();
    }

    public String[] acceptAssignments(String[] assignmentIds) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:AssignmentControlService Method:acceptAssignment been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: assignmentId=\"");
                if (assignmentIds != null) {
                    for (int i = 0; i < assignmentIds.length; ++i) {
                        buffer.append(assignmentIds[i]).append(';');
                    }
                }
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        ArrayList<String> rtnList = new ArrayList<String>();
        int n = assignmentIds.length;
        for (int i = 0; i < n; ++i) {
            try {
                this.acceptAssignment(assignmentIds[i]);
                continue;
            }
            catch (WfException ex) {
                log.warn((Object)"error", (Throwable)ex);
                rtnList.add(assignmentIds[i]);
            }
        }
        return rtnList.toArray(new String[0]);
    }

    public void rejectAssignment(String assignmentId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:AssignmentControlService Method:rejectAssignment been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: assignmentId=\"");
                buffer.append(assignmentId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfAssignment assignment = wfEngine.getAssignment(assignmentId);
        assignment.reject();
    }

    public void cancelAssignment(String assignmentId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:AssignmentControlService Method:cancelAssignment been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: assignmentId=\"");
                buffer.append(assignmentId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfAssignment assignment = wfEngine.getAssignment(assignmentId);
        assignment.cancel();
    }

    public void completeAssignment(String assignmentId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:AssignmentControlService Method:completeAssignment been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: assignmentId=\"");
                buffer.append(assignmentId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfAssignment assignment = wfEngine.getAssignment(assignmentId);
        assignment.complete();
    }

    public AssignmentInfo forwardAssignment(String assignmentId, String destUserId) throws WfException {
        return this.forwardAssignment(assignmentId, destUserId, (Map)null, true);
    }

    public AssignmentInfo forwardAssignment(String assignmentId, String destUserId, Map forwardMsg) throws WfException {
        return this.forwardAssignment(assignmentId, destUserId, forwardMsg, true);
    }

    public AssignmentInfo forwardAssignment(String assignmentId, String destUserId, Map forwardMsg, boolean checkConstraint) throws WfException {
        String sourceAssignId;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:AssignmentControlService Method:forwardAssignment been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: assignmentId=\"");
                buffer.append(assignmentId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (assignmentId == null || destUserId == null || assignmentId.trim().length() == 0 || destUserId.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfAssignment assignment = wfEngine.getAssignment(assignmentId);
        Person[] newPersons = wfEngine.getPariticipantProvider().getPersonsByUserId(wfEngine.context(), destUserId);
        ManpowerActivityDef mad = (ManpowerActivityDef)assignment.getActInst().getDefinition();
        String devolveMode = mad.getDevolveMode();
        if ("cascaded".equals(devolveMode)) {
            devolveMode = ConfigLoader.getConfig4Server().getConfig("assignment.devolve.mode", null);
        }
        if ("none".equals(devolveMode)) {
            throw new DevolveDenialException();
        }
        if ("one-off".equals(devolveMode) && (sourceAssignId = assignment.getAssignmentInfo().getSourceAssignId()) != null) {
            AssignmentInfo[] assigns = wfEngine.getWorkItemListByIds(new String[]{sourceAssignId}, DataTypeEnum.RUNTIME);
            if (newPersons.length > 0 && assigns.length > 0 && !assigns[0].getEmployeeId().equals(newPersons[0].getEmployeeId())) {
                throw new DevolveDenialException();
            }
        }
        HashMap<String, AssignmentInfo> receivers = new HashMap<String, AssignmentInfo>();
        AssignmentInfo retVal = null;
        WfAssignment[] assignments = assignment.getActInst().getAssignmentsInState(WfAssignmentState.ASSIGNED);
        block5: for (Person person : newPersons) {
            if (StringUtils.isEmpty((String)person.getEmployeeId())) continue;
            boolean hasSame = false;
            for (int j = 0; j < assignments.length; ++j) {
                if (!person.getUserId().equals(assignments[j].getMeta().getUserId())) continue;
                hasSame = true;
                break;
            }
            if (hasSame) {
                if (WfAssignmentState.CANCELED.equals((Object)assignment.state())) break;
                assignment.cancel();
                break;
            }
            String newAssignID = assignment.forward(person, forwardMsg, checkConstraint);
            WfAssignment newAssign = wfEngine.getAssignment(newAssignID);
            retVal = newAssign.getAssignmentInfo();
            receivers.put(retVal.getEmployeeId(), retVal);
            try {
                IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.getContext());
                AssignmentInfo assign = svc.getAssignmentById(assignmentId);
                String option = "";
                if (forwardMsg == null) continue;
                for (Map.Entry entry : forwardMsg.entrySet()) {
                    String value = entry.getValue().toString();
                    if (value.indexOf("\n") <= 0) continue;
                    option = value.split("\n")[0];
                    continue block5;
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cancelAllAssignments(assignment, wfEngine);
        if (receivers.size() > 0) {
            WfActivity act = wfEngine.getActivityInst(retVal.getActInstId());
            WfMessageUtil.sendAssignMessage(act, receivers.values());
            if (act != null) {
                wfEngine.eventService().raiseActivityEvent(ActivityEvent.OnForwarded, act, null);
            }
        }
        return retVal;
    }

    public Map forwardAssignment(String[] assignmentIds, String destUserId) throws WfException {
        return this.forwardAssignment(assignmentIds, destUserId, (Map)null, true);
    }

    public Map forwardAssignment(String[] assignmentIds, String destUserId, Map forwardMsg) throws WfException {
        if (assignmentIds == null || destUserId == null || assignmentIds.length == 0 || destUserId.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        HashMap<String, AssignmentInfo> result = new HashMap<String, AssignmentInfo>();
        for (int i = 0; i <= assignmentIds.length - 1; ++i) {
            String assignmentId = assignmentIds[i];
            try {
                AssignmentInfo assignment = this.forwardAssignment(assignmentId, destUserId, forwardMsg, true);
                result.put(assignmentId, assignment);
                continue;
            }
            catch (Throwable e) {
                if (e instanceof DevolveDenialException) {
                    throw (DevolveDenialException)e;
                }
                log.warn((Object)e.getMessage(), e);
                result.put(assignmentId, null);
            }
        }
        return result;
    }

    public void reassignToPerson(String actInstId, String[] userIdArray) throws WfException {
        WfAssignment assign;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:AssignmentControlService Method:reassignToPerson been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: actInstId=\"");
                buffer.append(actInstId);
                buffer.append('\"');
                buffer.append(" userIdArray=\"");
                buffer.append(StringUtils.arrayToString((Object[])userIdArray, (String)","));
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (actInstId == null) {
            throw new IllegalArgumentException("actInstId is null.");
        }
        if (userIdArray == null) {
            throw new IllegalArgumentException("userIdArray is null.");
        }
        if (userIdArray.length == 0) {
            throw new IllegalArgumentException("userIdArray.length is 0.");
        }
        WfActivity actInst = EngineUtil.getEngine(this.getContext()).getActivityInst(actInstId);
        if (actInst == null) {
            throw new WfException("illegal actInst id.");
        }
        if ("closed.completed".equals(actInst.getMeta().getState()) || "closed.terminated".equals(actInst.getMeta().getState()) || "closed.aborted".equals(actInst.getMeta().getState())) {
            throw new WfException("\u5f53\u524d\u8282\u70b9\u5df2\u5b8c\u6210");
        }
        List assignments = actInst.getAssignments();
        if (assignments.size() == 1 && (assign = (WfAssignment)assignments.get(0)).state() == WfAssignmentState.PROCESSING) {
            throw new WfException("\u5f53\u524d\u8282\u70b9\u4efb\u52a1\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u6682\u65e0\u6cd5\u6307\u5b9a\u5176\u4ed6\u804c\u5458");
        }
        actInst.reAssign(userIdArray, false);
        String state = actInst.getMeta().getState();
        if (state.equals("open.not_running.suspended") || state.equals("open.not_running.blocked")) {
            String wfState = actInst.getProcess().getInstanceInfo().getState();
            if (wfState.equals("open.not_running.suspended") || wfState.equals("open.not_running.blocked")) {
                ActivityControlService.getService(this.getContext()).resumeActInst(actInstId);
            } else {
                ActInstResume.enqueue(this.getContext(), actInst.getProcInstId(), actInstId);
            }
        }
    }

    public void addAssignToActivity(String actInstId, String[] userIdArray) throws WfException {
        WfAssignment assign;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:AssignmentControlService Method:reassignToPerson been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: actInstId=\"");
                buffer.append(actInstId);
                buffer.append('\"');
                buffer.append(" userIdArray=\"");
                buffer.append(StringUtils.arrayToString((Object[])userIdArray, (String)","));
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (actInstId == null) {
            throw new IllegalArgumentException("actInstId is null.");
        }
        if (userIdArray == null) {
            throw new IllegalArgumentException("userIdArray is null.");
        }
        if (userIdArray.length == 0) {
            throw new IllegalArgumentException("userIdArray.length is 0.");
        }
        WfActivity actInst = EngineUtil.getEngine(this.getContext()).getActivityInst(actInstId);
        if (actInst == null) {
            throw new WfException("illegal actInst id.");
        }
        if ("closed.completed".equals(actInst.getMeta().getState()) || "closed.terminated".equals(actInst.getMeta().getState()) || "closed.aborted".equals(actInst.getMeta().getState())) {
            throw new WfException("\u589e\u52a0\u6267\u884c\u4eba\u62a5\u9519\u539f\u56e0\uff1a\u8be5\u8282\u70b9\u4efb\u52a1\u5df2\u7ecf\u5b8c\u6210\u4e86\uff0c\u4e0d\u80fd\u589e\u52a0\u6267\u884c\u4eba");
        }
        List assignments = actInst.getAssignments();
        if (assignments.size() == 1 && (assign = (WfAssignment)assignments.get(0)).state() == WfAssignmentState.PROCESSING) {
            throw new WfException("\u5f53\u524d\u8282\u70b9\u4efb\u52a1\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u6682\u65e0\u6cd5\u6307\u5b9a\u5176\u4ed6\u804c\u5458");
        }
        actInst.reAssign(userIdArray, true);
        String state = actInst.getMeta().getState();
        if (state.equals("open.not_running.suspended") || state.equals("open.not_running.blocked")) {
            String wfState = actInst.getProcess().getInstanceInfo().getState();
            if (wfState.equals("open.not_running.suspended") || wfState.equals("open.not_running.blocked")) {
                ActivityControlService.getService(this.getContext()).resumeActInst(actInstId);
            } else {
                ActInstResume.enqueue(this.getContext(), actInst.getProcInstId(), actInstId);
            }
        }
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public boolean canNextPerson(String assignmentId) throws WfException {
        ActivityDef actDef;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:AssignmentControlService Method:canNextPerson been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: assignmentId=\"");
                buffer.append(assignmentId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if ((actDef = EngineUtil.getEngine(this.getContext()).getAssignment(assignmentId).getActInst().getDefinition()) instanceof ManpowerActivityDef) {
            return ((ManpowerActivityDef)actDef).canSpecifyNextActivityPerformer();
        }
        return false;
    }

    public void assignCountersign(String initiateAssignmentID, String[] userIdArray) throws WfException {
        this.assignCountersign(initiateAssignmentID, userIdArray, null);
    }

    public void assignCountersign(String initiateAssignmentID, String[] userIdArray, Map extendMsg) throws WfException {
        WfAssignment assignment;
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfActivity actInst = wfEngine.getActivityInst((assignment = wfEngine.getAssignment(initiateAssignmentID)).getActInstId());
        if (actInst == null) {
            throw new WfException("illegal actInst id.");
        }
        actInst.assignCountersign(initiateAssignmentID, userIdArray, extendMsg, true);
        wfEngine.eventService().raiseActivityEvent(ActivityEvent.OnAssignCountersign, actInst, null);
    }

    public AssignmentInfo devolve(String assignmentId, String destUserId, Map extendMsg) throws WfException {
        IObjectPK logPk = null;
        if (assignmentId == null || assignmentId.length() <= 0) {
            throw new IllegalArgumentException();
        }
        if (destUserId == null || destUserId.length() <= 0) {
            throw new IllegalArgumentException();
        }
        WfEngine engine = EngineUtil.getEngine(this.getContext());
        WfAssignment assignment = engine.getAssignment(assignmentId);
        WfActivity wfActivity = assignment.getActInst();
        String type = "";
        if (extendMsg != null && extendMsg.size() >= 0 && extendMsg.containsKey("forwardType") && "backdele".equals(type = extendMsg.get("forwardType").toString())) {
            logPk = WorkflowLogUtil.beginLogByLocal(this.getContext(), WorkflowLogItem.ENTRUST_WITHDRAW, assignment.getAssignmentInfo().getSubject(this.getContext().getLocale()));
        }
        if (!"backdele".equals(type)) {
            ManpowerActivityDef mad = (ManpowerActivityDef)wfActivity.getDefinition();
            if ("none".equals(mad.getDevolveMode())) {
                return null;
            }
            if ("one-off".equals(mad.getDevolveMode()) && assignment.getAssignmentInfo().getSourceAssignId() != null) {
                return null;
            }
        }
        HashSet assignUserIDs = new HashSet();
        List assignments = wfActivity.assignments();
        Person tempNewPerson = engine.getPariticipantProvider().getPersonByUserId(engine.context(), destUserId);
        ArrayList<Person> targetPersons = new ArrayList<Person>();
        String sourceUserID = assignment.getMeta().getAssignInfo().getPersonUserID().toString();
        if (!sourceUserID.equals(tempNewPerson.getUserId())) {
            targetPersons.add(tempNewPerson);
        }
        AssignmentInfo retVal = null;
        HashMap<String, AssignmentInfo> receivers = new HashMap<String, AssignmentInfo>();
        int size = targetPersons.size();
        for (int i = 0; i < size; ++i) {
            Person newPerson = (Person)targetPersons.get(i);
            String newAssignID = assignment.devolve(newPerson, extendMsg);
            WfAssignment newAssign = engine.getAssignment(newAssignID);
            retVal = newAssign.getMeta();
            receivers.put(retVal.getEmployeeId(), retVal);
            if (!"backdele".equals(type)) continue;
            WfProcess proc = engine.getProcessInst(newAssign.getProcInstId());
            proc.getProcessContext().putDataFieldValue("backdele" + sourceUserID + "$" + newAssignID, true);
        }
        this.cancelAllAssignments(assignment, engine);
        if (receivers.size() > 0) {
            WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
            WfActivity act = wfEngine.getActivityInst(retVal.getActInstId());
            WfMessageUtil.sendAssignMessage(act, receivers.values());
            if (act != null) {
                wfEngine.eventService().raiseActivityEvent(ActivityEvent.OnDevolved, act, null);
            }
        }
        WorkflowLogUtil.endLogByLocal(this.getContext(), logPk);
        return retVal;
    }

    public AssignmentInfo devolve(String assignmentId, String destUserId) throws WfException {
        return this.devolve(assignmentId, destUserId, null);
    }

    public AssignCollection getAssignInfoCollection(String oql) throws WfException {
        try {
            Context context = this.getContext();
            WfEngine engine = WfEngine.getEngine(context);
            WorkItemStorer storer = engine.getStoreManager().getWorkItemStorer();
            return storer.getAssignInfoCollection(oql);
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public AssignCollection getUncompleteAssignments(String userID) throws WfException {
        Context context = this.getContext();
        WfEngine engine = WfEngine.getEngine(context);
        WorkItemStorer storer = engine.getStoreManager().getWorkItemStorer();
        return storer.getUncompleteAssignments(userID);
    }

    public void devolveAssignments(String[] assignmentIDs, String destUserID, Map extendMsg) throws WfException {
        int size = assignmentIDs.length;
        for (int i = 0; i < size; ++i) {
            this.devolve(assignmentIDs[i], destUserID, extendMsg);
        }
    }

    public Map forwardAssignment(String[] assignmentIds, String destUserId, Map forwardMsg, boolean checkConstraint) throws WfException {
        assert (assignmentIds != null && assignmentIds.length > 0 && !StringUtils.isEmpty((String)destUserId));
        HashMap<String, AssignmentInfo> result = new HashMap<String, AssignmentInfo>();
        int count = 0;
        for (int i = 0; i <= assignmentIds.length - 1; ++i) {
            String assignmentId = assignmentIds[i];
            try {
                AssignmentInfo assignment = this.forwardAssignment(assignmentId, destUserId, forwardMsg, checkConstraint);
                result.put(assignmentId, assignment);
                ++count;
                continue;
            }
            catch (Throwable e) {
                log.warn((Object)e.getMessage(), e);
                result.put(assignmentId, null);
            }
        }
        log.info((Object)("=========Forward Assignment Count:" + count));
        return result;
    }

    public Map getActionAssignmentMapping(String userID, String[] bizObjectIDs, IMetaDataPK uiObjPK) throws WfException {
        HashMap<String, AssignmentInfo[]> retVal = new HashMap<String, AssignmentInfo[]>();
        try {
            FunctionObjectCollection functions = MetaDataLoaderFactory.getMetaDataLoader((Context)this.getContext()).getFunctions();
            int size = functions.size();
            for (int i = 0; i < size; ++i) {
                FunctionObjectInfo function = functions.get(i);
                OperationCollection operations = function.getOperation();
                int size1 = operations.size();
                for (int j = 0; j < size1; ++j) {
                    String actionName;
                    UIObjectInfo uiObject;
                    OperationInfo operation = operations.get(j);
                    if (operation.getUiActionRef() == null || operation.getUiActionRef().getUIObjectRef() == null || !(uiObject = operation.getUiActionRef().getUIObjectRef()).getFullName().equals(uiObjPK.getFullName()) || StringUtils.isEmpty((String)(actionName = operation.getUiActionRef().getActionRefName()))) continue;
                    EntityViewInfo entityViewInfo = new EntityViewInfo();
                    entityViewInfo.getSelector().add(new SelectorItemInfo("bizObjID"));
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("bizObjID", new HashSet<String>(Arrays.asList(bizObjectIDs)), CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("personUserID", (Object)userID));
                    filterInfo.getFilterItems().add(new FilterItemInfo("bizPackage", (Object)function.getPackage()));
                    filterInfo.getFilterItems().add(new FilterItemInfo("bizFunction", (Object)function.getName()));
                    filterInfo.getFilterItems().add(new FilterItemInfo("bizOperation", (Object)operation.getName()));
                    entityViewInfo.setFilter(filterInfo);
                    AssignmentInfo[] assignments = WfEngine.getEngine(this.getContext()).getStoreManager().getWorkItemStorer().getActivedAssignmentInfoArray(entityViewInfo.toString());
                    if (assignments == null || assignments.length <= 0) continue;
                    retVal.put(actionName, assignments);
                }
            }
        }
        catch (BOSException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        catch (SQLException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        return retVal;
    }

    private void cancelAllAssignments(WfAssignment assignment, WfEngine engine) throws WfException {
        String actInstId = assignment.getActInstId();
        String assignId = assignment.getId();
        String personId = assignment.getMeta().getEmployeeId();
        if (StringUtils.isEmpty((String)personId)) {
            return;
        }
        AssignmentInfo[] assignments = engine.getAssignmentByActInstId(actInstId);
        for (int i = 0; i < assignments.length; ++i) {
            AssignmentInfo tmp = assignments[i];
            if (tmp == null || assignId.equals(tmp.getAssignmentId()) || !personId.equals(tmp.getEmployeeId()) || WfAssignmentState.CANCELED.equals((Object)tmp.getState())) continue;
            WfAssignment ass = engine.getAssignment(tmp.getAssignmentId());
            ass.cancel(false);
        }
    }

    public void processingAssignment(String assignmentID) throws WfException {
        WfEngine wfEngine = WfEngine.getEngine(this.getContext());
        wfEngine.getAssignment(assignmentID).processing();
    }

    public void removeAssignByBillId(Set billIds, Set assignIds) throws WfException {
        Object[] deleteIDList;
        StringBuffer qrySQL = null;
        IRowSet rs = null;
        WfEngine engine = WfEngine.getEngine(this.getContext());
        WorkItemStorer storer = engine.getStoreManager().getWorkItemStorer();
        if (null == assignIds) {
            assignIds = new HashSet<String>();
        }
        if (null != billIds && (deleteIDList = billIds.toArray()).length > 0) {
            try {
                int i;
                String inBillids = "";
                qrySQL = new StringBuffer();
                inBillids = "'" + deleteIDList[0] + "'";
                for (i = 1; i < deleteIDList.length; ++i) {
                    inBillids = inBillids + ",'" + deleteIDList[i] + "'";
                }
                qrySQL.append("select fassignid from t_wfr_assign  where fbizobjid in (").append(inBillids).append(")");
                rs = DbUtil.executeQueryNoTx((Context)this.getContext(), (String)qrySQL.toString());
                while (rs.next()) {
                    assignIds.add(rs.getString("fassignid"));
                }
                if (assignIds.size() == 0) {
                    qrySQL = new StringBuffer();
                    qrySQL.append("select fprocinstid from t_wfr_procinstref where ftype=1 and frefid in (").append(inBillids).append(")");
                    rs = DbUtil.executeQueryNoTx((Context)this.getContext(), (String)qrySQL.toString());
                    qrySQL = new StringBuffer();
                    qrySQL.append("select fassignid from t_wfr_assign where fprocinstid in (");
                    i = 0;
                    while (rs.next()) {
                        if (i == 0) {
                            qrySQL.append("'");
                        } else {
                            qrySQL.append(",'");
                        }
                        qrySQL.append(rs.getString("fprocinstid") + "'");
                        ++i;
                    }
                    qrySQL.append(")");
                    rs = DbUtil.executeQueryNoTx((Context)this.getContext(), (String)qrySQL.toString());
                    while (rs.next()) {
                        assignIds.add(rs.getString("fassignid"));
                    }
                }
            }
            catch (SQLException e) {
                log.error((Object)("sql\u6267\u884c\u5f02\u5e38" + e));
            }
            catch (WfException e) {
                log.error((Object)("\u6e05\u9664\u5220\u9664\u5355\u636e\u7684\u5f85\u529e\u4efb\u52a1\u5f02\u5e38\uff1a" + (Object)((Object)e)));
            }
            catch (BOSException e) {
                log.error((Object)("\u6267\u884csql\u67e5\u8be2\u9519\u8bef" + (Object)((Object)e)));
            }
        }
        storer.dumpTx(assignIds);
    }

    public boolean createRollBackAssign(String assignmentID) throws WfException {
        WfAssignment assign;
        WfEngine wfEngine = WfEngine.getEngine(this.getContext());
        WfActivity actInst = wfEngine.getActivityInst((assign = wfEngine.getAssignment(assignmentID)).getActInstId());
        if (actInst.state().equals("open.not_running.not_started") && actInst.enableCountersign()) {
            AssignmentInfo assignment = assign.getAssignmentInfo();
            Person person = new Person();
            Locale l1 = new Locale("l1");
            Locale l2 = new Locale("l2");
            Locale l3 = new Locale("l3");
            person.setEmployeeId(assignment.getEmployeeId());
            person.setEmployeeName(l1, assignment.getEmployeeName(l1));
            person.setEmployeeName(l2, assignment.getEmployeeName(l2));
            person.setEmployeeName(l3, assignment.getEmployeeName(l3));
            person.setUserId(assignment.getUserId());
            person.setUserName(l1, assignment.getUserName(l1));
            person.setUserName(l2, assignment.getUserName(l2));
            person.setUserName(l3, assignment.getUserName(l3));
            actInst.createAssignment(person, true);
            return true;
        }
        return false;
    }
}

