/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service.ormrpc;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.thread.WfDaemonMgr;
import com.kingdee.bos.workflow.enactment.trace.WfMonitor;
import com.kingdee.bos.workflow.service.ormrpc.IWfMonitorService;
import com.kingdee.bos.workflow.util.WfDoctor;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class WfMonitorService
extends AbstractBOSObject
implements IWfMonitorService {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.service.ormrpc.WfMonitorService");

    public WfMonitorService() {
        super.registerInterface(IWfMonitorService.class, (Object)this);
    }

    public WfMonitorService(Context ctx) {
        super(ctx);
        if (log.isDebugEnabled() && ctx.getAIS() == null) {
            log.error((Object)new Throwable());
        }
        super.registerInterface(IWfMonitorService.class, (Object)this);
    }

    public BOSObjectType getType() {
        return IWfMonitorService.BOSTYPE;
    }

    private WfEngine getWfEngine() throws WfException {
        Context ctx = this.getContext();
        WfEngine engine = WfEngine.getEngine(ctx);
        engine.setLocale(ctx.getLocale());
        engine.setContext(ctx);
        return engine;
    }

    public Object evalScript(String script) throws WfException {
        Object rtnVal;
        Context bosCtx = this.getContext();
        Interpreter interpreter = new Interpreter(bosCtx);
        HashMap<String, WfEngine> ctx = new HashMap<String, WfEngine>();
        WfEngine engine = this.getWfEngine();
        interpreter.setSynchronizedCallMethod(true);
        ctx.put("engine", engine);
        try {
            rtnVal = interpreter.eval(script, ctx);
        }
        catch (InterpreterException e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
        catch (ParserException e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
        return rtnVal;
    }

    public String getTraceReport() throws WfException {
        return WfMonitor.getTraceReport();
    }

    public void gc() throws WfException {
        System.gc();
    }

    public void startDaemonThread() throws WfException {
        WfDaemonMgr.startDaemonThread();
    }

    public void resetDaemonThread() throws WfException {
        WfDaemonMgr.resetDaemonThread();
    }

    public void stopDaemonThread() throws WfException {
        WfDaemonMgr.stopDaemonThread();
    }

    public String getWorkflowReport(boolean viewEnvReport, boolean viewBasicReport, boolean viewThreadReport, boolean viewQueueReport, String bizObjectID) throws WfException {
        WfDoctor wfDoctor = new WfDoctor(WfEngine.getEngine(this.getContext()));
        wfDoctor.setViewEnvironmentReport(viewEnvReport);
        wfDoctor.setViewBasicReport(viewBasicReport);
        wfDoctor.setViewThreadReport(viewThreadReport);
        wfDoctor.setViewQueueReport(viewQueueReport);
        wfDoctor.setBizObjID(bizObjectID);
        return wfDoctor.generateOverviewReport();
    }
}

