/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.ProcInstInfo;
import com.kingdee.bos.workflow.store.AssignmentBatchPersistence;
import com.kingdee.bos.workflow.store.MutexStorer;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.store.StoreManager;
import com.kingdee.bos.workflow.store.listener.AbstractDataProvider;
import com.kingdee.bos.workflow.store.util.StoreUtil;
import com.kingdee.bos.workflow.transaction.IBatchPersistence;
import com.kingdee.bos.workflow.transaction.WfMutexInfo;
import com.kingdee.bos.workflow.transaction.WfMutexState;
import com.kingdee.bos.workflow.util.WorkflowClusterConfig;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ProcessBatchPersistence
extends AbstractDataProvider
implements IBatchPersistence {
    private static final Logger logger = Logger.getLogger(AssignmentBatchPersistence.class);
    private static final BOSObjectType bosObjectType = new ProcInstInfo().getBOSType();

    public ProcessBatchPersistence(Context ctx) {
        super(ctx);
    }

    private void createMutexes(List processInsts) throws WfException {
        WfEngine wfEngine = WfEngine.getEngine(this.innerContext);
        StoreManager storeManager = wfEngine.getStoreManager();
        MutexStorer mutexStorer = storeManager.getMutexStorer();
        int size = processInsts.size();
        WfMutexInfo[] wfMutexInfos = new WfMutexInfo[size];
        for (int i = 0; i < size; ++i) {
            ProcInstInfo procInstInfo = (ProcInstInfo)processInsts.get(i);
            wfMutexInfos[i] = new WfMutexInfo();
            wfMutexInfos[i].setObjectID(procInstInfo.getProcInstID().toString());
            wfMutexInfos[i].setServerKey(wfEngine.getServerKey());
            wfMutexInfos[i].setState(WfMutexState.FREE);
        }
        try {
            mutexStorer.addNewBatch(wfMutexInfos);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    private void removeMutexes(List processInsts) throws WfException {
        WfEngine wfEngine = WfEngine.getEngine(this.innerContext);
        StoreManager storeManager = wfEngine.getStoreManager();
        MutexStorer mutexStorer = storeManager.getMutexStorer();
        int size = processInsts.size();
        ArrayList<String> listProcessIDs = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            ProcInstInfo procInstInfo = (ProcInstInfo)processInsts.get(i);
            if (!procInstInfo.getState().getValue().startsWith("closed")) continue;
            listProcessIDs.add(procInstInfo.getProcInstID().toString());
        }
        try {
            String[] processIDs = listProcessIDs.toArray(new String[listProcessIDs.size()]);
            mutexStorer.deleteBatch(processIDs);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    @Override
    public void executeBatch(List newObjects, List changedObjects) throws WfException {
        LowTimer lowTimer = new LowTimer();
        Connection cn = null;
        try {
            if (newObjects != null && !newObjects.isEmpty()) {
                WfEngine wfEngine = WfEngine.getEngine(this.innerContext);
                StoreManager storeManager = wfEngine.getStoreManager();
                ProcessStorer processStorer = storeManager.getProcessStorer();
                processStorer.addNewProcInstBatch(newObjects);
                if (WorkflowClusterConfig.getInstance().isGroupType()) {
                    this.createMutexes(newObjects);
                }
            }
            if (changedObjects != null && changedObjects.size() > 0) {
                cn = this.getConnection();
                IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)bosObjectType, (Context)this.innerContext, (Connection)cn);
                int size = changedObjects.size();
                for (int i = 0; i < size; ++i) {
                    IObjectValue objectValue = (IObjectValue)changedObjects.get(i);
                    ObjectUuidPK pk = new ObjectUuidPK(objectValue.getBOSUuid(objectValue.getPKField()));
                    dao.updateBatch((IObjectPK)pk, objectValue);
                }
                dao.executeBatch();
                if (WorkflowClusterConfig.getInstance().isGroupType()) {
                    this.removeMutexes(changedObjects);
                }
                if (this.isEnableListen()) {
                    String procInstId = null;
                    if (changedObjects != null && changedObjects.size() > 0) {
                        AssignInfo info = (AssignInfo)changedObjects.get(0);
                        procInstId = StoreUtil.getProcInstIdByAssign(info.getAssignID().toString(), this.innerContext);
                        this.notifyDataChangedByProcInstId(procInstId, "executeBatch", new Class[]{List.class, List.class}, new Object[]{null, changedObjects});
                    }
                }
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(cn);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ProcessBatchPersistence.executeBatch:" + lowTimer.msValue()));
        }
    }

    @Override
    public BOSObjectType getBOSObjectType() {
        return bosObjectType;
    }
}

