/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.transaction;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.AssignmentWorkerManager;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.cache.IWfCacheManager;
import com.kingdee.bos.workflow.enactment.message.AssignListenerFactory;
import com.kingdee.bos.workflow.message.AssignmentCreationEvent;
import com.kingdee.bos.workflow.message.IAssignmentListener;
import com.kingdee.bos.workflow.store.WorkItemStorer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TxAssignmentMgr {
    private final Set dumpAssignmentIDs;
    private final Set txAssignmentIDs;
    private final List assignmentCreationEvents;
    private final Set assignIdSet4Lucene;
    private final Context context;

    public TxAssignmentMgr(Context context) {
        this.context = context;
        this.txAssignmentIDs = new HashSet();
        this.dumpAssignmentIDs = new HashSet();
        this.assignmentCreationEvents = new ArrayList();
        this.assignIdSet4Lucene = new HashSet();
    }

    public void addTxAssignmentID(String assignmentId) {
        this.txAssignmentIDs.add(assignmentId);
    }

    public Set getTxAssignmentIDs() {
        return this.txAssignmentIDs;
    }

    public void addDumpAssignmentID(String assignmentID) {
        this.dumpAssignmentIDs.add(assignmentID);
        this.assignIdSet4Lucene.add(assignmentID);
    }

    public Set getDumpAssignmentIDs() {
        return this.dumpAssignmentIDs;
    }

    public List getAssignmentCreationEvents() {
        return this.assignmentCreationEvents;
    }

    public Set getassignIdSet4Lucene() {
        return this.assignIdSet4Lucene;
    }

    public void addAssignmentCreationEvent(AssignmentCreationEvent assignmentCreationEvent) {
        this.assignmentCreationEvents.add(assignmentCreationEvent);
        this.assignIdSet4Lucene.add(assignmentCreationEvent.assignmentId);
    }

    public void notfiyCacheChange() throws WfException {
        WfEngine engine = WfEngine.getEngine(this.context);
        IWfCacheManager cacheManager = engine.getCacheManager();
        for (String assignmentID : this.txAssignmentIDs) {
            cacheManager.notifyAssignmentChange(assignmentID);
        }
    }

    public void removeFromCache() throws WfException {
        WfEngine engine = WfEngine.getEngine(this.context);
        IWfCacheManager cacheManager = engine.getCacheManager();
        for (String assignmentID : this.txAssignmentIDs) {
            cacheManager.removeAssignment(assignmentID);
        }
    }

    public void fireAssignmentCreationEvent() throws WfException {
        IAssignmentListener listener = AssignListenerFactory.getListener();
        if (listener != null && this.assignmentCreationEvents.size() > 0) {
            AssignmentCreationEvent[] eventArray = this.assignmentCreationEvents.toArray(new AssignmentCreationEvent[this.assignmentCreationEvents.size()]);
            this.assignmentCreationEvents.clear();
            AssignmentWorkerManager.getInstance(this.context).fireCreateAssignmentEvent(eventArray);
        }
    }

    public void dumpAssignments() throws WfException {
        if (!this.dumpAssignmentIDs.isEmpty()) {
            WfEngine engine = WfEngine.getEngine(this.context);
            WorkItemStorer storer = engine.getStoreManager().getWorkItemStorer();
            storer.dumpTx(this.dumpAssignmentIDs);
            this.dumpAssignmentIDs.clear();
        }
    }
}

