/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.transaction;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.transaction.WfMutexHelper;
import com.kingdee.bos.workflow.transaction.WfMutexInfo;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class WfMutexMgr {
    private final LinkedHashMap mutexes;
    private final WfEngine engine;

    public WfMutexMgr(Context context) throws WfException {
        this.engine = WfEngine.getEngine(context);
        this.mutexes = new LinkedHashMap();
    }

    public synchronized WfMutexInfo tryAcquireMutex(String objectID) throws WfException {
        WfMutexInfo mutexInfo = null;
        if (this.mutexes.containsKey(objectID)) {
            mutexInfo = (WfMutexInfo)this.mutexes.get(objectID);
        } else {
            mutexInfo = WfMutexHelper.tryAcquire(this.engine, objectID);
            if (mutexInfo != null) {
                this.mutexes.put(objectID, mutexInfo);
            }
        }
        return mutexInfo;
    }

    public synchronized WfMutexInfo[] tryAcquireMutexes(String[] objectIDs) throws WfException {
        ArrayList<WfMutexInfo> list = new ArrayList<WfMutexInfo>();
        int size = objectIDs.length;
        for (int i = 0; i < size; ++i) {
            WfMutexInfo mutexInfo = this.tryAcquireMutex(objectIDs[i]);
            if (mutexInfo == null) continue;
            list.add(mutexInfo);
        }
        return list.toArray(new WfMutexInfo[list.size()]);
    }

    public synchronized void releaseMutexes() throws WfException {
        for (WfMutexInfo info : this.mutexes.values()) {
            WfMutexHelper.release(this.engine, info);
        }
    }
}

