/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.transaction;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.transaction.IWfTxInvokeHandler;
import com.kingdee.bos.workflow.transaction.WfTxInvocationDesc;
import com.kingdee.bos.workflow.util.InvocationExecutor;
import org.apache.log4j.Logger;

public class WfTxInvoker {
    private static final Logger logger = Logger.getLogger(WfTxInvoker.class);
    private final WfTxInvocationDesc invocationDesc;
    private IWfTxInvokeHandler handler = null;

    public WfTxInvoker(WfTxInvocationDesc invocationDesc) {
        this.invocationDesc = invocationDesc;
    }

    public void setTxInvokeHandler(IWfTxInvokeHandler handler) {
        this.handler = handler;
    }

    public Object invoke() throws WfException {
        Object retVal = null;
        boolean success = false;
        try {
            if (this.handler != null) {
                this.handler.invokeBefore();
            }
            retVal = InvocationExecutor.execute(this.invocationDesc);
            if (this.handler != null) {
                this.handler.invokeAfter();
            }
            success = true;
        }
        catch (WfException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (this.handler != null) {
                this.handler.invokeFinally(success);
            }
        }
        return retVal;
    }
}

