/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.event.CommonEventDefineUtils;
import com.kingdee.bos.workflow.metas.ActivityTypeEnum;
import com.kingdee.bos.workflow.metas.EventProcMetaInfo;
import com.kingdee.bos.workflow.metas.EventTypeEnum;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommonEventUtils {
    private static final Logger logger = Logger.getLogger(CommonEventUtils.class);

    public static EventProcMetaInfo constructEventProcMetaInfo(EventActivityDef eventActivityDef, ManpowerActivityDef manActDef) throws WfException {
        if (eventActivityDef == null) {
            throw new WfException("constructEventProcMetaInfo args eventWaitActivityDef is null");
        }
        EventProcMetaInfo info = CommonEventUtils.fillInfo(eventActivityDef, EventTypeEnum.PROCESSTRIGGER);
        if (manActDef != null) {
            info.setActDefId(BOSUuid.read((String)manActDef.getID()));
            info.setActType(ActivityTypeEnum.MANPOWERACTIVITY);
        } else {
            info.setActDefId(BOSUuid.read((String)eventActivityDef.getID()));
            info.setActType(ActivityTypeEnum.EVENTACTIVITY);
        }
        info.setFilterRule(eventActivityDef.getFilterRule());
        return info;
    }

    public static EventProcMetaInfo constructEventProcMetaInfo(WfActivity activity, EventActivityDef eventActivityDef) throws WfException {
        if (activity == null || eventActivityDef == null) {
            throw new WfException("constructEventProcMetaInfo args WfActivity and eventActivityDef can't be null");
        }
        EventProcMetaInfo info = CommonEventUtils.fillInfo(eventActivityDef, EventTypeEnum.ACTIVITYTRIGGER);
        info.setActDefId(BOSUuid.read((String)eventActivityDef.getID()));
        info.setActType(ActivityTypeEnum.EVENTACTIVITY);
        info.setProcInstId(BOSUuid.read((String)activity.getProcInstId()));
        info.setActInstId(BOSUuid.read((String)activity.getId()));
        return info;
    }

    private static EventProcMetaInfo fillInfo(EventActivityDef eventActivityDef, EventTypeEnum eventType) {
        ProcessDef processDef = (ProcessDef)eventActivityDef.getContainer();
        EventProcMetaInfo info = new EventProcMetaInfo();
        info.setEventProcId(BOSUuid.create((BOSObjectType)WfBOSObjectTypeUtil.EVENTPROCMETABOT));
        info.setProcDefId(BOSUuid.read((String)processDef.getID()));
        info.setProcPriority(processDef.getProcessHeader().getPriority());
        info.setEventDefId(BOSUuid.read((String)eventActivityDef.getEventId()));
        info.setEventDefType(eventActivityDef.getEventType().getValue());
        info.setEventName(eventActivityDef.getEventName());
        info.setEventType(eventType);
        info.setFilterRule(eventActivityDef.getFilterRule());
        return info;
    }

    public static EventActivityDef getBindingEventActDef(ActivityDef activityDef, String eventActDef) {
        if (activityDef == null || StringUtils.isEmpty((String)eventActDef)) {
            return null;
        }
        return (EventActivityDef)((ProcessDef)activityDef.getContainer()).getActivityDef(eventActDef);
    }

    public static EventProcMetaInfo constructManActBindingEventProcMetaInfo(WfActivity activity, EventActivityDef def) throws WfException {
        if (activity == null || def == null) {
            throw new WfException("constructEventProcMetaInfo args can't be null");
        }
        EventProcMetaInfo info = CommonEventUtils.fillInfo(def, EventTypeEnum.ACTIVITYTRIGGER);
        info.setActDefId(BOSUuid.read((String)def.getID()));
        info.setActType(ActivityTypeEnum.MANPOWERACTIVITY);
        info.setProcInstId(BOSUuid.read((String)activity.getProcInstId()));
        info.setActInstId(BOSUuid.read((String)activity.getId()));
        return info;
    }

    public static EventProcMetaInfo[] getMatchedEventProcMetaInfo(ICommonEvent event, WfEngine engine) throws WfException {
        if (event == null || engine == null) {
            throw new WfException("args is null");
        }
        EventProcMetaInfo[] eventProcMetaInfos = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append("where (eventName='" + event.getName() + "')");
        try {
            eventProcMetaInfos = engine.getStoreManager().getEventStorer().getEventProcMetaInfos(buffer.toString());
        }
        catch (Exception e) {
            throw new WfException((Throwable)e);
        }
        return eventProcMetaInfos;
    }

    public static void loggingToEngineLog(WfEngine wfEngine, String description, String longDescription) {
        if (wfEngine == null || StringUtils.isEmpty((String)description)) {
            return;
        }
        WfLogger wfLogger = wfEngine.getWfLogger();
        wfLogger.addWfEngineLog(LogTypeEnum.WARN, WfEngineEventEnum.ACCEPTEVENT, description, longDescription);
    }

    public static Person getPersonFromEvent(ICommonEvent event, WfEngine wfEngine) throws WfException {
        if (event == null) {
            return null;
        }
        String userId = event.getContextDataValue("userId");
        if (!StringUtils.isEmpty((String)userId)) {
            Person initiator = wfEngine.getPariticipantProvider().getPersonByUserId(wfEngine.context(), userId);
            if (initiator != null) {
                return initiator;
            }
        } else {
            String adminName = "Administrator";
            String adminId = "00000000-0000-0000-0000-00000000000013B7DE7F";
            Person p = new Person();
            p.setUserId(adminId);
            p.setEmployeeId(adminId);
            p.setUserName(new Locale("l2"), adminName);
            p.setEmployeeName(new Locale("l2"), adminName);
            return p;
        }
        return null;
    }

    public static ActivityDef getActDefByEventActivated(ProcessDef procDef, ICommonEvent event) throws WfException {
        if (procDef == null || event == null) {
            throw new WfException("CommonEventUtils.getActDefByEventActivated args is null");
        }
        StartActivityDef startPointDef = procDef.getStartActivity();
        ActivityCollection postActDefList = startPointDef.getPostActivities();
        if (postActDefList.size() > 0) {
            for (int i = 0; i < postActDefList.size(); ++i) {
                ActivityDef activityDef = postActDefList.get(i);
                if (activityDef instanceof ManpowerActivityDef) {
                    EventActivityDef eventActivityDef;
                    ManpowerActivityDef def = (ManpowerActivityDef)activityDef;
                    if (StringUtils.isEmpty((String)def.getRefEventActDefId()) || (eventActivityDef = (EventActivityDef)procDef.getActivityDef(def.getRefEventActDefId())) == null || !event.getName().equalsIgnoreCase(eventActivityDef.getEventName())) continue;
                    return activityDef;
                }
                if (!(activityDef instanceof EventActivityDef)) continue;
                EventActivityDef eventActivityDef = (EventActivityDef)activityDef;
                if (!event.getName().equalsIgnoreCase(eventActivityDef.getEventName())) continue;
                return activityDef;
            }
        }
        return null;
    }

    public static void outputEventContentToContext(ActivityDef eventActDef, ICommonEvent event, ProcessContext processContext) throws WfException {
        if (eventActDef == null || event == null || processContext == null) {
            throw new WfException("CommonEventUtils.outputEventContextToContext args is null");
        }
        FormalParameterCollection formalParameterCollection = null;
        ActualParameterCollection actualParameterCollection = null;
        if (eventActDef instanceof ManpowerActivityDef) {
            formalParameterCollection = ((ManpowerActivityDef)eventActDef).getRelatedApplication().getFormalParameters();
            actualParameterCollection = ((ManpowerActivityDef)eventActDef).getActualParameters();
        } else if (eventActDef instanceof EventActivityDef) {
            formalParameterCollection = ((EventActivityDef)eventActDef).getRelatedApplication().getFormalParameters();
            actualParameterCollection = ((EventActivityDef)eventActDef).getActualParameters();
        }
        if (formalParameterCollection == null || actualParameterCollection == null) {
            return;
        }
        HashMap<FormalParameterDef, String> formalParameterDatafiledMap = new HashMap<FormalParameterDef, String>();
        for (int i = 0; i < formalParameterCollection.size(); ++i) {
            ActualParameterDef actualParameterDef;
            DataFieldDef datafiled;
            FormalParameterMode mode = formalParameterCollection.get(i).getMode();
            if (mode != FormalParameterMode.OUT && mode != FormalParameterMode.INOUT || formalParameterCollection.get(i).getIndex() >= actualParameterCollection.size() || (datafiled = (actualParameterDef = actualParameterCollection.get(formalParameterCollection.get(i).getIndex())).getDataField()) == null || StringUtils.isEmpty((String)datafiled.getName())) continue;
            formalParameterDatafiledMap.put(formalParameterCollection.get(i), datafiled.getName());
        }
        for (Map.Entry entry : formalParameterDatafiledMap.entrySet()) {
            FormalParameterDef formalParameterDef = (FormalParameterDef)entry.getKey();
            Object value = CommonEventUtils.computeFormalParameterValue(formalParameterDef, event);
            processContext.setDataFieldValue((String)entry.getValue(), value);
        }
        processContext.storeToDb();
    }

    public static Object computeFormalParameterValue(FormalParameterDef formalParameterDef, ICommonEvent event) throws WfException {
        if (event == null || formalParameterDef == null) {
            throw new WfException("CommonEventUtils.computeFormalParameterValue args is null");
        }
        Object result = null;
        if (formalParameterDef == null || event == null) {
            return result;
        }
        if ("\u57fa\u672c\u5c5e\u6027".equalsIgnoreCase(formalParameterDef.getType())) {
            String attributeName = formalParameterDef.getName();
            if (StringUtils.isEmpty((String)attributeName)) {
                return result;
            }
            attributeName = attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1, attributeName.length());
            String methodName = "get" + attributeName;
            Class<?> c = event.getClass();
            try {
                Method m = c.getMethod(methodName, new Class[0]);
                result = m.invoke((Object)event, new Object[0]);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        } else {
            result = event.getExtendedDataValue(formalParameterDef.getName());
        }
        return result;
    }

    public static ApplicationDef getApplicationDef(EventActivityDef relatedActivityDef) throws WfException {
        return CommonEventDefineUtils.getApplicationDef((EventActivityDef)relatedActivityDef);
    }
}

