/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.EntityRefInfo;
import com.kingdee.bos.config.IMetadataRef;
import com.kingdee.bos.config.MetadataRefCollection;
import com.kingdee.bos.config.MetadataRefDetailInfo;
import com.kingdee.bos.config.MetadataRefFactory;
import com.kingdee.bos.config.MetadataRefInfo;
import com.kingdee.bos.config.ModuleEnum;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetadataRefUtil {
    private static final Logger logger = Logger.getLogger(MetadataRefUtil.class);

    public static void handleMetadataRef(ProcessDef procDef, int innverVersion, WfEngine engine) throws WfException {
        IMetadataRef metadataRef;
        if (procDef == null || innverVersion < 0 || engine == null) {
            return;
        }
        try {
            metadataRef = MetadataRefFactory.getLocalInstance((Context)engine.context());
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
        if (innverVersion > 0) {
            String objectKey = procDef.getID() + "_" + innverVersion;
            MetadataRefUtil.deleteMetadataRefByObjectKey(metadataRef, objectKey);
            MetadataRefUtil.clearOldRefData(metadataRef, procDef.getID(), engine);
        }
        MetadataRefUtil.registerEntityRefs(metadataRef, MetadataRefUtil.findDynamicFieldsRefByProcess(procDef, innverVersion));
    }

    private static void registerEntityRefs(IMetadataRef metadataRef, EntityRefInfo[] refs) throws WfException {
        if (metadataRef != null && refs != null && refs.length > 0) {
            for (int i = 0; i < refs.length; ++i) {
                try {
                    metadataRef.registerEntityRef(refs[i]);
                    continue;
                }
                catch (BOSException e) {
                    throw new WfException((Throwable)e);
                }
            }
        }
    }

    private static void clearOldRefData(IMetadataRef metadateRef, String procDefId, WfEngine engine) throws WfException {
        MetadataRefCollection metadataRefCol;
        if (StringUtils.isEmpty((String)procDefId) || engine == null) {
            return;
        }
        try {
            metadataRefCol = metadateRef.getCollection("where objectKey like '" + procDefId + "_%' and module = '" + "workFlow" + "'");
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
        ProcessInstInfo[] processInstInfos = null;
        ProcessInstInfo[] runtimeProcessInstInfos = null;
        try {
            processInstInfos = engine.getProcessInstancesByProcDefId(procDefId);
        }
        catch (WfException e1) {
            logger.error((Object)("getProcessInstancesByProcDefId error" + (Object)((Object)e1)));
        }
        if (processInstInfos != null && processInstInfos.length > 0) {
            runtimeProcessInstInfos = MetadataRefUtil.getRuntimeProcessInstInfo(processInstInfos);
        }
        if (runtimeProcessInstInfos == null || metadataRefCol == null || runtimeProcessInstInfos.length <= 0) {
            return;
        }
        for (int i = 0; i < metadataRefCol.size(); ++i) {
            String procVersion;
            MetadataRefInfo metadataRef = metadataRefCol.get(i);
            String objectKey = metadataRef.getObjectKey();
            if (StringUtils.isEmpty((String)objectKey) || objectKey.indexOf("_") <= -1 || MetadataRefUtil.checkRuntimeProcessExistByVersion(runtimeProcessInstInfos, procVersion = objectKey.substring(objectKey.indexOf("_") + 1, objectKey.length()))) continue;
            MetadataRefUtil.deleteMetadataRefByObjectKey(metadateRef, objectKey);
        }
    }

    private static void deleteMetadataRefByObjectKey(IMetadataRef metadateRef, String objectKey) throws WfException {
        try {
            metadateRef.delete("where objectKey = '" + objectKey + "'");
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
    }

    private static boolean checkRuntimeProcessExistByVersion(ProcessInstInfo[] runtimeProcessInstInfos, String procVersion) {
        boolean result = false;
        for (int i = 0; i < runtimeProcessInstInfos.length; ++i) {
            if (runtimeProcessInstInfos[i].getProcDefInnerVersion() != Integer.parseInt(procVersion)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static ProcessInstInfo[] getRuntimeProcessInstInfo(ProcessInstInfo[] processInstInfos) {
        ArrayList<ProcessInstInfo> result = new ArrayList<ProcessInstInfo>();
        for (int i = 0; i < processInstInfos.length; ++i) {
            if (!processInstInfos[i].getState().equalsIgnoreCase("open.running")) continue;
            result.add(processInstInfos[i]);
        }
        return result.toArray(new ProcessInstInfo[0]);
    }

    private static EntityRefInfo[] findDynamicFieldsRefByProcess(ProcessDef procDef, int innversion) {
        HashMap map = new HashMap();
        ActivityCollection actCol = procDef.getActivitys(ActivityType.MANPOWER);
        for (int i = 0; i < actCol.size(); ++i) {
            ManpowerActivityDef actDef = (ManpowerActivityDef)actCol.get(i);
            FormalParameterCollection formalParameterCollection = actDef.getRelatedApplication().getFormalParameters();
            for (int j = 0; j < formalParameterCollection.size(); ++j) {
                FormalParameterDef formalParameterDef = formalParameterCollection.get(j);
                if (formalParameterDef.getMode().equals((Object)FormalParameterMode.IN) || StringUtils.isEmpty((String)formalParameterDef.getBoId()) || StringUtils.isEmpty((String)formalParameterDef.getBoName()) || StringUtils.isEmpty((String)formalParameterDef.getPropertyName()) || !"true".equalsIgnoreCase(formalParameterDef.getPropertyIsDynamic())) continue;
                MetadataRefUtil.constructRefObject(map, actDef, formalParameterDef, innversion);
            }
        }
        return map.values().toArray(new EntityRefInfo[0]);
    }

    private static void constructRefObject(Map map, ManpowerActivityDef actDef, FormalParameterDef formalParameterDef, int innversion) {
        ProcessDef procDef = (ProcessDef)actDef.getContainer();
        String boName = formalParameterDef.getBoName();
        if (map.get(boName) != null) {
            EntityRefInfo metaRef = (EntityRefInfo)map.get(boName);
            String flowDescription = metaRef.getDescription();
            ((EntityRefInfo)map.get(boName)).getDetails().add(MetadataRefUtil.constructRefDetail((MetadataRefInfo)metaRef, actDef, formalParameterDef, flowDescription));
        } else {
            EntityRefInfo ref = new EntityRefInfo();
            ref.setModule(ModuleEnum.WORKFLOW);
            ref.setMetaDataPK(boName);
            String objectKey = procDef.getID() + "_" + innversion;
            ref.setObjectKey(objectKey);
            String description = "\u4e1a\u52a1\u6d41\u7a0b\uff1a" + procDef.getName(new Locale("l2")) + "\u5f15\u7528\u4e86\u5b9e\u4f53( " + formalParameterDef.getBoAlies(new Locale("l2")) + "-" + boName + ") ";
            ref.setDescription(description);
            ref.getDetails().add(MetadataRefUtil.constructRefDetail((MetadataRefInfo)ref, actDef, formalParameterDef, description));
            map.put(boName, ref);
        }
    }

    private static MetadataRefDetailInfo constructRefDetail(MetadataRefInfo parent, ManpowerActivityDef actDef, FormalParameterDef formalParameterDef, String flowDescription) {
        String propertyName = formalParameterDef.getPropertyName();
        MetadataRefDetailInfo refDetail = new MetadataRefDetailInfo();
        refDetail.setParent(parent);
        refDetail.setCanDelete(false);
        refDetail.setKey(propertyName);
        refDetail.setObjectKey(actDef.getID());
        String description = flowDescription != null ? flowDescription : " \u6d3b\u52a8 :" + actDef.getName(new Locale("l2")) + "\u5f15\u7528\u4e86\u5b57\u6bb5( " + formalParameterDef.getPropertyAlies() + "-" + propertyName + " )";
        refDetail.setDescription(description);
        return refDetail;
    }

    public static void clearRedundancyRef() {
    }
}

