/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataFieldCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.engine.core.ThreadCache;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;

public class WfBizObjUtils {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.util.WfBizObjUtils");

    public static Object getDataFieldValueInMap(Map data, String name, Context context) {
        if (data == null || name == null) {
            return null;
        }
        String[] str = name.split("[.]", 2);
        String prop = "";
        if (!data.containsKey(name) && str.length == 2 && data.containsKey(str[0])) {
            name = str[0];
            prop = str[1];
        }
        if (data == null || !data.containsKey(name)) {
            if (log.isDebugEnabled()) {
                log.warn((Object)("wf datafield [" + name + "] not found,return null!"));
            }
            return null;
        }
        Object rtn = data.get(name);
        if (rtn instanceof IObjectValue && !StringUtils.isEmpty((String)prop)) {
            try {
                rtn = ScriptUtil.evalObjectProperty(prop, rtn, context);
            }
            catch (WfException e) {
                log.warn((Object)("wf datafield [" + name + "." + prop + "] not found,return null!"));
                rtn = null;
            }
        }
        return rtn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IObjectValue createEmptyBizObj(String billid, Context ctx) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(billid);
        EntityObjectInfo bo = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)BOSUuid.read((String)billid).getType());
        IObjectValue model = Utils.newObjectValueInstance((EntityObjectInfo)bo);
        String[] keyFields = pk.getKeyFields();
        PropertyCollection keyProperties = bo.getLogicalKey().getKeyPropertys();
        int keyCount = keyProperties.size();
        if (keyCount != keyFields.length) {
            throw new InvalidDAOMetaDataException("wf PK fields count is not equal to the entity logicalkeys count");
        }
        if (keyFields.length == 1) {
            if (keyFields[0] == null || keyFields[0].trim().length() == 0) {
                model.put(keyProperties.get(0).getName(), pk.getKeyValue(keyProperties.get(0).getName()));
                return model;
            } else {
                if (!keyFields[0].equalsIgnoreCase(keyProperties.get(0).getName())) throw new InvalidDAOMetaDataException("wf PK field name conflicted with logicalkey name.logicalkey name:" + keyProperties.get(0).getName());
                model.put(keyFields[0], pk.getKeyValue(keyFields[0]));
            }
            return model;
        } else {
            for (int i = 0; i < keyFields.length; ++i) {
                String keyField = keyFields[i];
                boolean findProperty = false;
                for (int j = 0; j < keyCount; ++j) {
                    String keyProperty = keyProperties.get(j).getName();
                    if (!keyField.equalsIgnoreCase(keyProperty)) continue;
                    model.put(keyField, pk.getKeyValue(keyField));
                    findProperty = true;
                }
                if (findProperty) continue;
                throw new InvalidDAOMetaDataException("wf PK field name conflicted with logicalkey name. PK field name:" + keyField);
            }
        }
        return model;
    }

    public static IObjectValue getBizObj(ProcessDef processDef, String bizObjPropName, String billId, Context ctx) {
        return WfBizObjUtils.getBizObj(processDef, bizObjPropName, billId, ctx, false);
    }

    public static IObjectValue getBizObj(ProcessDef processDef, String bizObjPropName, String billId, Context ctx, boolean isMulti) {
        SelectorItemCollection selectors = new SelectorItemCollection();
        String bosType = BOSUuid.read((String)billId).getType().toString();
        if ("63D30103".equals(bosType)) {
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("isPass"));
            selectors.add(new SelectorItemInfo("opinion"));
            selectors.add(new SelectorItemInfo("handlerOpinion"));
            selectors.add(new SelectorItemInfo("multiHandleOpinion"));
            selectors.add(new SelectorItemInfo("creator.id"));
            selectors.add(new SelectorItemInfo("creator.number"));
            selectors.add(new SelectorItemInfo("createTime"));
            selectors.add(new SelectorItemInfo("creator.name"));
        } else {
            Map map = processDef.getAllBizObjInProcess();
            if (!map.containsKey(bizObjPropName)) {
                return null;
            }
            List list = (List)map.get(bizObjPropName);
            if (list == null) {
                return null;
            }
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                selectors.add(new SelectorItemInfo(list.get(i).toString()));
            }
        }
        IObjectValue boValue = null;
        try {
            Object o = ThreadCache.get(billId);
            if (o == null || isMulti) {
                boValue = ScriptUtil.getBizObject(ctx, billId, selectors, true);
                if (!isMulti) {
                    ThreadCache.put(billId, boValue);
                }
            } else {
                boValue = (IObjectValue)o;
            }
        }
        catch (Throwable e) {
            boValue = null;
            log.warn((Object)("WfBizObjUtils ORMappingDAO.getValue Error. " + e.getMessage()));
        }
        return boValue;
    }

    public static String replaceBizObjValue(ProcessContext processCtx, ProcessDef processDef, DataFieldCollection dc, String content) {
        return WfBizObjUtils.replaceBizObjValue(processCtx, processDef, dc, content, null);
    }

    public static String replaceBizObjValue(ProcessContext processCtx, ProcessDef processDef, DataFieldCollection dc, String content, Context ctx) {
        if (!StringUtils.isEmpty((String)content) && content.indexOf("@@") >= 0) {
            int len2 = dc.size();
            for (int i = 0; i < len2; ++i) {
                String name;
                DataFieldDef dfd = dc.get(i);
                if (!dfd.getDataType().equals(BasicType.BIZOBJ) && !dfd.getDataType().equals(BasicType.APPROVERESULT) || (name = dfd.getName()) == null || name.trim().equals("")) continue;
                int ci = 0;
                while ((ci = content.indexOf("@@" + name)) >= 0) {
                    char c;
                    int len = content.length();
                    int ii = ci + 2;
                    while ((c = content.charAt(ii)) <= '\u00ff' && (Character.isJavaIdentifierPart(c) || c == '.') && ++ii != len) {
                    }
                    String temp = content.substring(ci + 2, ii);
                    log.debug((Object)("get bizObj value: $" + temp + "$"));
                    Object obj = processCtx.getDataFieldValue(temp, ctx);
                    String str = "";
                    if (obj != null) {
                        str = obj.toString();
                    }
                    if (str == null) {
                        str = "";
                    }
                    log.debug((Object)("get bizObj value: $" + temp + "$ success. Value: " + str));
                    if (str.length() > 200 && name.equals(temp)) {
                        log.debug((Object)("get bizObj value: $" + temp + "$ value to long, get 'id' instead. "));
                        String temp2 = temp + ".id";
                        obj = processCtx.getDataFieldValue(temp, ctx);
                        str = obj != null ? obj.toString() : str.substring(0, 200) + "...";
                        log.debug((Object)("get bizObj value: $" + temp2 + "$ success. Value: " + str));
                    }
                    content = content.replaceFirst("@@" + temp, Matcher.quoteReplacement(str));
                }
            }
        }
        return content;
    }

    public static String replaceBizObjValue(Map processCtx, ProcessDef processDef, DataFieldCollection dc, String content) {
        return WfBizObjUtils.replaceBizObjValue(processCtx, processDef, dc, content, null);
    }

    public static String replaceBizObjValue(Map processCtx, ProcessDef processDef, DataFieldCollection dc, String content, Context ctx) {
        if (!StringUtils.isEmpty((String)content) && content.indexOf("@@") >= 0) {
            int len2 = dc.size();
            for (int i = 0; i < len2; ++i) {
                DataFieldDef dfd = dc.get(i);
                if (!dfd.getDataType().equals(BasicType.BIZOBJ) && !dfd.getDataType().equals(BasicType.APPROVERESULT)) continue;
                String name = dfd.getName();
                int ci = 0;
                while ((ci = content.indexOf("@@" + name)) >= 0) {
                    char c;
                    int len = content.length();
                    int ii = ci + 2;
                    while ((c = content.charAt(ii)) <= '\u00ff' && (Character.isJavaIdentifierPart(c) || c == '.') && ++ii != len) {
                    }
                    String temp = content.substring(ci + 2, ii);
                    log.debug((Object)("wf get bizObj value: $" + temp + "$"));
                    String[] strs = temp.split("[.]", 2);
                    String prop = null;
                    if (strs.length == 2) {
                        prop = strs[1];
                    }
                    try {
                        Object bizobj = processCtx.get(name);
                        Object obj = ScriptUtil.evalObjectProperty(prop, bizobj, ctx);
                        String str = "";
                        if (obj != null) {
                            str = obj.toString();
                        }
                        log.debug((Object)("get bizObj value: $" + temp + "$ success. Value: " + str));
                        if (str.length() > 200 && name.equals(temp)) {
                            log.debug((Object)("get bizObj value: $" + temp + "$ value to long, get 'id' instead. "));
                            prop = "id";
                            obj = ScriptUtil.evalObjectProperty(prop, bizobj, ctx);
                            str = "";
                            str = obj != null ? obj.toString() : str.substring(0, 200) + "...";
                            log.debug((Object)("get bizObj value: $" + name + ".id$ success. Value: " + str));
                        }
                        content = content.replaceFirst("@@" + temp, Matcher.quoteReplacement(str));
                    }
                    catch (Exception ex) {
                        log.info((Object)("get bizObj value: $" + temp + "$ error. Cause by : " + ex.getMessage()));
                        content = content.replaceFirst("@@" + temp, "");
                    }
                }
            }
        }
        return content;
    }
}

