/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.wfdesigner.service;

import com.kingdee.bos.workflow.define.ScriptFunctionUtil;
import com.kingdee.bos.workflow.wfdesigner.OtherSysInfo;
import com.kingdee.bos.workflow.wfdesigner.OtherSysPackageInfo;
import com.kingdee.bos.workflow.wfdesigner.service.DBOperationBridge;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OtherSysStorer {
    private DBOperationBridge bridge;
    private Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.wfdesigner.service.OtherSysStorer");

    OtherSysStorer(DBOperationBridge bridge) {
        this.bridge = bridge;
    }

    public Connection getConnection() throws SQLException {
        return this.bridge.getConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getOtherSysPackageRoot() throws SQLException {
        String sql = "SELECT FID,FNAME,FCONTENT,FIsEdit FROM T_WFR_OTHERSYSINVOKERPACKAGE WHERE FPARENTID = ? OR FPARENTID IS NULL ORDER BY FNAME";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<OtherSysPackageInfo> rts = new ArrayList<OtherSysPackageInfo>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, "");
            rs = stmt.executeQuery();
            while (rs.next()) {
                OtherSysPackageInfo info = new OtherSysPackageInfo();
                info.setId(rs.getString(1));
                info.setName(rs.getString(2));
                info.setContent(rs.getString(3));
                info.setIsEdit(rs.getString(4));
                info.setParentId("");
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getChildrenByPackageId(String id) throws SQLException {
        OtherSysPackageInfo info;
        String sql1 = "SELECT FID,FNAME,FCONTENT,FIsEdit FROM T_WFR_OTHERSYSINVOKERPACKAGE WHERE FPARENTID = ? ORDER BY FNAME";
        String sql2 = "SELECT FID,FNAME,FCONTENT,FLASTUPDATE FROM T_WFR_OTHERSYSINVOKER WHERE FPACKAGEID = ? ORDER BY FNAME";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<OtherSysPackageInfo> rts = new ArrayList<OtherSysPackageInfo>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql1);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info = new OtherSysPackageInfo();
                info.setId(rs.getString(1));
                info.setName(rs.getString(2));
                info.setContent(rs.getString(3));
                info.setIsEdit(rs.getString(4));
                info.setParentId(id);
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql2);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info = new OtherSysInfo();
                info.setId(rs.getString(1));
                info.setName(rs.getString(2));
                info.setContent(rs.getString(3));
                info.setLastUpdate(rs.getTimestamp(4));
                info.setPackageId(id);
                rts.add(info);
            }
            return rts;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                DBOperationBridge.cleanup(rs, stmt, conn);
            }
            catch (SQLException ex) {
                this.log.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OtherSysPackageInfo getOtherSysPackageInfoById(String id) throws SQLException {
        String sql = "SELECT FID,FNAME,FCONTENT,FPARENTID,FIsEdit FROM T_WFR_OTHERSYSINVOKERPACKAGE WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        OtherSysPackageInfo info = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                info = new OtherSysPackageInfo();
                info.setId(rs.getString(1));
                info.setName(rs.getString(2));
                info.setContent(rs.getString(3));
                info.setParentId(rs.getString(4));
                info.setIsEdit(rs.getString(5));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return info;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OtherSysInfo getOtherSysInfoById(String id) throws SQLException {
        String sql = "SELECT FID,FNAME,FCONTENT,FLASTUPDATE,FPACKAGEID,FLastUpdateUserId,FLastUpdateUserName FROM T_WFR_OTHERSYSINVOKER WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        OtherSysInfo info = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info = new OtherSysInfo();
                info.setId(rs.getString("FID"));
                info.setName(rs.getString("FNAME"));
                info.setContent(rs.getString("FCONTENT"));
                info.setLastUpdate(rs.getTimestamp("FLASTUPDATE"));
                info.setPackageId(rs.getString("FPACKAGEID"));
                info.setLastUpdateUserId(rs.getString("FLastUpdateUserId"));
                info.setLastUpdateUserName(rs.getString("FLastUpdateUserName"));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return info;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public List getPerformerChildrenByPackageId(String id) throws SQLException {
        List rts = this.getChildrenByPackageId(id);
        ArrayList<Object> performerFun = new ArrayList<Object>();
        for (Object o : rts) {
            if (o instanceof OtherSysInfo) {
                String content = ((OtherSysInfo)o).getContent();
                if (!this.funRetType(content)) continue;
                performerFun.add((OtherSysInfo)o);
                continue;
            }
            performerFun.add(o);
        }
        return performerFun;
    }

    private boolean funRetType(String funcontent) {
        try {
            String returnType = ScriptFunctionUtil.parse((String)funcontent).getReturnType().toString();
            if ("PERFORMER".equals(returnType)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<OtherSysInfo> getOtherSysInfoByIds(String[] ids) throws SQLException {
        String sql = "SELECT FID,FNAME,FCONTENT,FLASTUPDATE,FPACKAGEID,FLastUpdateUserId,FLastUpdateUserName  FROM T_WFR_OTHERSYSINVOKER WHERE FID in (";
        for (int i = 0; i < ids.length; ++i) {
            if (i == ids.length - 1) {
                sql = sql + "? ) ORDER BY FNAME";
                break;
            }
            sql = sql + "?,";
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<OtherSysInfo> rts = new ArrayList<OtherSysInfo>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            for (int i = 0; i < ids.length; ++i) {
                stmt.setString(i + 1, ids[i]);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                OtherSysInfo info = new OtherSysInfo();
                info.setId(rs.getString("FID"));
                info.setName(rs.getString("FNAME"));
                info.setLastUpdate(rs.getTimestamp("FLASTUPDATE"));
                info.setContent(rs.getString("FCONTENT"));
                info.setPackageId(rs.getString("FPACKAGEID"));
                info.setLastUpdateUserId(rs.getString("FLastUpdateUserId"));
                info.setLastUpdateUserName(rs.getString("FLastUpdateUserName"));
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<OtherSysInfo> getOtherSysInfoByPackageId(String id) throws SQLException {
        String sql = "SELECT FID,FNAME,FLASTUPDATE,FPACKAGEID,FLastUpdateUserId,FLastUpdateUserName FROM T_WFR_OTHERSYSINVOKER WHERE FPACKAGEID = ? ORDER BY FLASTUPDATE DESC";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<OtherSysInfo> rts = new ArrayList<OtherSysInfo>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                OtherSysInfo info = new OtherSysInfo();
                info.setId(rs.getString("FID"));
                info.setName(rs.getString("FNAME"));
                info.setLastUpdate(rs.getTimestamp("FLASTUPDATE"));
                info.setPackageId(rs.getString("FPACKAGEID"));
                info.setLastUpdateUserId(rs.getString("FLastUpdateUserId"));
                info.setLastUpdateUserName(rs.getString("FLastUpdateUserName"));
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<OtherSysPackageInfo> getOtherSysPackageInfoByPid(String id) throws SQLException {
        String sql = "SELECT FID,FNAME,FCONTENT,FIsEdit FROM T_WFR_OTHERSYSINVOKERPACKAGE WHERE FPARENTID = ? ORDER BY FNAME";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<OtherSysPackageInfo> rts = new ArrayList<OtherSysPackageInfo>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                OtherSysPackageInfo info = new OtherSysPackageInfo();
                info.setId(rs.getString("FID"));
                info.setName(rs.getString("FNAME"));
                info.setContent(rs.getString("FCONTENT"));
                info.setIsEdit(rs.getString("FIsEdit"));
                info.setParentId(id);
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OtherSysInfo getOtherSysInfoByName(String name) throws SQLException {
        String sql = "SELECT FID,FNAME,FCONTENT,FLASTUPDATE,FPACKAGEID,FLastUpdateUserId,FLastUpdateUserName FROM T_WFR_OTHERSYSINVOKER WHERE FNAME = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        OtherSysInfo info = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, name);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info = new OtherSysInfo();
                info.setId(rs.getString("FID"));
                info.setName(rs.getString("FNAME"));
                info.setContent(rs.getString("FCONTENT"));
                info.setLastUpdate(rs.getTimestamp("FLASTUPDATE"));
                info.setPackageId(rs.getString("FPACKAGEID"));
                info.setLastUpdateUserId(rs.getString("FLastUpdateUserId"));
                info.setLastUpdateUserName(rs.getString("FLastUpdateUserName"));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return info;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getAllOtherSysInfo() throws SQLException {
        OtherSysPackageInfo info;
        String sql1 = "SELECT FID,FNAME,FCONTENT,FIsEdit,FPARENTID FROM T_WFR_OTHERSYSINVOKERPACKAGE ORDER BY FNAME";
        String sql2 = "SELECT FID,FNAME,FCONTENT,FLASTUPDATE,FPACKAGEID FROM T_WFR_OTHERSYSINVOKER ORDER BY FNAME";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashMap<String, Object> rts = new HashMap<String, Object>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql1);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info = new OtherSysPackageInfo();
                info.setId(rs.getString(1));
                info.setName(rs.getString(2));
                info.setContent(rs.getString(3));
                info.setIsEdit(rs.getString(4));
                info.setParentId(rs.getString(5));
                rts.put(info.getId(), info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql2);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info = new OtherSysInfo();
                info.setId(rs.getString(1));
                info.setName(rs.getString(2));
                info.setContent(rs.getString(3));
                info.setLastUpdate(rs.getTimestamp(4));
                info.setPackageId(rs.getString(5));
                rts.put(info.getId(), info);
            }
            return rts;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                DBOperationBridge.cleanup(rs, stmt, conn);
            }
            catch (SQLException ex) {
                this.log.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }
}

