/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.wfdesigner.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.exception.FatalInterruptException;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.participant.PositionInfo;
import com.kingdee.bos.workflow.security.IPermissionProvider;
import com.kingdee.bos.workflow.util.PermissionUtil;
import com.kingdee.util.StringUtils;
import java.util.List;

public class ParticipantHelperUtil {
    public static PositionInfo[] getPositionArrayByEmployeeId(IParticipantProvider _provider, Context context, String employeeId) throws WfException {
        return _provider.getPositionArrayByEmployeeId(context, employeeId);
    }

    public static void getPersonByOrgMember(List persons, IParticipantProvider _provider, Context context, ParticipantDef participantDef) throws WfException {
        Person[] personArray = _provider.getOrgMember(context, participantDef.getParticipantValue());
        for (int i = 0; i < personArray.length; ++i) {
            persons.add(personArray[i]);
        }
    }

    public static void getPersonByOrgAllMember(List persons, IParticipantProvider _provider, Context context, ParticipantDef participantDef) throws WfException {
        Person[] personArray;
        try {
            personArray = _provider.getOrgAllMember(context, participantDef.getParticipantValue());
        }
        catch (WfParticipantException e) {
            throw new WfException((Throwable)e);
        }
        for (int i = 0; i < personArray.length; ++i) {
            persons.add(personArray[i]);
        }
    }

    public static void getPersonByPosition(List persons, IParticipantProvider _provider, Context context, ParticipantDef participantDef) throws WfException {
        Person[] personArray = _provider.getPositionHolders(context, participantDef.getParticipantValue());
        for (int i = 0; i < personArray.length; ++i) {
            persons.add(personArray[i]);
        }
    }

    public static void getPersonByPrincipal(List persons, IParticipantProvider _provider, Context context, ParticipantDef participantDef) throws WfException {
        Person[] personArray;
        try {
            personArray = _provider.getOrgPrincipal(context, participantDef.getParticipantValue());
        }
        catch (WfParticipantException e) {
            throw new WfException((Throwable)e);
        }
        for (int i = 0; i < personArray.length; ++i) {
            persons.add(personArray[i]);
        }
    }

    public static void getPersonByOrgPermissionOwner(List persons, IParticipantProvider _provider, IPermissionProvider permissionProvider, Context context, ActivityDef activityDef, ParticipantDef participantDef) throws WfException {
        String orgId = participantDef.getParticipantValue();
        PermissionItemCollection permItems = new PermissionItemCollection();
        try {
            ExtendedAttributeCollection extendedAttributeCollection = participantDef.getExtendedAttributes();
            ExtendedAttributeDef extendedAttributeDef = extendedAttributeCollection.get("permissionItem");
            if (extendedAttributeDef != null && !StringUtils.isEmpty((String)extendedAttributeDef.getValue())) {
                String permItemName = extendedAttributeDef.getValue();
                PermissionItemInfo permissionItemInfo = new PermissionItemInfo();
                permissionItemInfo.setName(permItemName);
                permItems.add(permissionItemInfo);
            } else if (activityDef instanceof ManpowerActivityDef) {
                FunctionDef funcDef = null;
                ManpowerActivityDef manpowerDef = (ManpowerActivityDef)activityDef;
                ApplicationDef appDef = manpowerDef.getRelatedApplication();
                if (appDef != null) {
                    funcDef = appDef.getFunction();
                }
                if (funcDef != null) {
                    String packageName = funcDef.getPackageName();
                    String operation = funcDef.getOperation();
                    String funcName = funcDef.getName();
                    permItems = PermissionUtil.getPermissionItemCollection(context, packageName, funcName, operation);
                }
            }
            if (permItems.size() > 0) {
                String[] userIds = permissionProvider.getPermissionOwners(context, 1, orgId, permItems);
                for (int i = 0; i < userIds.length; ++i) {
                    persons.add(_provider.getPersonByUserId(context, userIds[i]));
                }
            }
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
    }

    public static void getOrgAllMember(List persons, IParticipantProvider _provider, Context context, ParticipantDef participantDef) throws WfException {
        Person[] personArray;
        try {
            personArray = _provider.getOrgAllMember(context, participantDef.getParticipantValue());
        }
        catch (WfParticipantException e) {
            throw new WfException((Throwable)e);
        }
        for (int i = 0; i < personArray.length; ++i) {
            persons.add(personArray[i]);
        }
    }

    public static void getPersonByGroup(List persons, IParticipantProvider _provider, Context context, ParticipantDef participantDef) throws WfException {
        Person[] personArray;
        try {
            personArray = _provider.getPersonsFromGroup(context, participantDef.getParticipantValue());
        }
        catch (WfParticipantException e) {
            throw new WfException((Throwable)e);
        }
        for (int i = 0; i < personArray.length; ++i) {
            persons.add(personArray[i]);
        }
    }

    public static void getPersonByOrgJob(List persons, IParticipantProvider _provider, Context context, ParticipantDef participantDef) throws WfException {
        String orgID = null;
        if (participantDef.getPerformDatafieldId() == null) {
            orgID = participantDef.getOrgID();
        }
        Person[] personArray = new Person[]{};
        try {
            personArray = _provider.getAdminOrgUnitJobHolders(context, orgID, participantDef.getParticipantValue());
        }
        catch (Throwable e) {
            throw new FatalInterruptException("ParticipantProvider getOrgAllMember error!", e);
        }
        for (int i = 0; i < personArray.length; ++i) {
            persons.add(personArray[i]);
        }
    }
}

