/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.wfdesigner.service;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.wfdesigner.WorkFlowProcessInfo;
import com.kingdee.bos.workflow.wfdesigner.service.DBOperationBridge;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProcessStorer {
    private DBOperationBridge bridge;
    private Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.wfdesigner.service.ProcessStorer");
    private Connection conn = null;
    Locale l2 = new Locale("l2");

    ProcessStorer(DBOperationBridge bridge) {
        this.bridge = bridge;
    }

    public Connection getConnection() throws SQLException {
        this.conn = this.bridge.getConnection();
        return this.conn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkFlowProcessInfo checkoutFileByPackageAndName(String pkgName, String fileName) throws SQLException {
        WorkFlowProcessInfo workFlowProcessInfo;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            String sql = "SELECT fversion,flockstatus,fuserid,fprocessid FROM T_WFD_PROCESSDEF WHERE FPACKAGENAME = ?  AND FPROCDEFTYPE = '" + ProcessType.NORMAL.getName() + "' AND FFILENAME = ? ";
            stmt = this.prepareStatement(conn, sql);
            stmt.setString(1, pkgName);
            stmt.setString(2, fileName);
            rs = stmt.executeQuery();
            WorkFlowProcessInfo info = new WorkFlowProcessInfo();
            while (rs.next()) {
                info.setVersion(rs.getString(1));
                info.setStatus(rs.getInt(2));
                info.setUserID(rs.getString(3));
                info.setProcessId(rs.getString(4));
            }
            workFlowProcessInfo = info;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return workFlowProcessInfo;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkFlowProcessInfo getFileByPackageAndName(String pkgName, String fileName) throws SQLException {
        WorkFlowProcessInfo workFlowProcessInfo;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        WorkFlowProcessInfo info = new WorkFlowProcessInfo();
        try {
            conn = this.getConnection();
            String sql = "SELECT FPROCESSID,FCODE,FNAME,FDESCRIPTION,FPROCESSXML,FCREATETIME,FAUTHORID,FPUBLISHSTATUS,FVERSION,FVALIDFROM,FVALIDTO,FSYSTEMVERSION,FPACKAGENAME,FFILENAME,FLockStatus,FUserId,FPROCDEFTYPE,FICONNAME,FCHILDPROCESS FROM T_WFD_PROCESSDEF WHERE FPACKAGENAME = ?  AND FPROCDEFTYPE = '" + ProcessType.NORMAL.getName() + "' AND FFILENAME = ? ";
            stmt = this.prepareStatement(conn, sql);
            stmt.setString(1, pkgName);
            stmt.setString(2, fileName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info.setProcessId(rs.getString(1));
                info.setProcessCode(rs.getString(2));
                info.setProcessName(rs.getString(3));
                info.setProcessDescription(rs.getString(4));
                info.setProcessXml(rs.getString(5));
                info.setCreateTime(new java.util.Date(rs.getDate(6).getTime()));
                info.setAuthorId(rs.getString(7));
                info.setPublishStatus(rs.getInt(8) > 0);
                info.setVersion(rs.getString(9));
                info.setValidFrom(new java.util.Date(rs.getDate(10).getTime()));
                info.setValidTo(new java.util.Date(rs.getDate(11).getTime()));
                info.setSystemVersion(rs.getString(12));
                info.setPackageName(rs.getString(13));
                info.setFileName(rs.getString(14));
                info.setStatus(rs.getInt(15));
                info.setUserID(rs.getString(16));
                info.setType(rs.getString(17));
                info.setIconPath(rs.getString(18));
                info.setChildProcessIds(rs.getString(19));
            }
            workFlowProcessInfo = info;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return workFlowProcessInfo;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getAllProcessDef() throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<WorkFlowProcessInfo> al = new ArrayList<WorkFlowProcessInfo>();
        try {
            conn = this.getConnection();
            String sql = "SELECT fprocessid,fpackagename,ffilename,flockstatus,fuserid,ficonname,Fchildprocess FROM T_WFD_PROCESSDEF WHERE FPROCDEFTYPE = '" + ProcessType.NORMAL.getName() + "'";
            stmt = this.prepareStatement(conn, sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                WorkFlowProcessInfo info = new WorkFlowProcessInfo();
                info.setProcessId(rs.getString(1));
                info.setPackageName(rs.getString(2));
                info.setFileName(rs.getString(3));
                info.setStatus(rs.getInt(4));
                info.setUserID(rs.getString(5));
                info.setIconPath(rs.getString(6));
                info.setChildProcessIds(rs.getString(7));
                al.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return al;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getPackageInfoList() throws SQLException {
        ArrayList<String> packageInfoList = new ArrayList<String>();
        String sql = "SELECT * FROM T_META_PACKAGE";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                packageInfoList.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return packageInfoList;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public WorkFlowProcessInfo getProcessDef(String processDefId) throws SQLException {
        return this.get(processDefId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void checkOutProcessById(String id, String user, int status) throws SQLException {
        String sql = "UPDATE T_WFD_PROCESSDEF SET FLockStatus = ?, FUSERID = '" + user + "' WHERE FPROCESSID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        conn = this.getConnection();
        stmt = this.prepareStatement(conn, sql);
        stmt.setInt(1, status);
        stmt.setString(2, id);
        stmt.executeUpdate();
        try {
            DBOperationBridge.cleanup(stmt, conn);
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (SQLException e) {
            try {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
                throw throwable;
            }
            try {
                DBOperationBridge.cleanup(stmt, conn);
            }
            catch (SQLException ex) {
                this.log.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exsits(String id) throws SQLException {
        boolean existsFlag = false;
        String sql = "SELECT FPROCESSID FROM T_WFD_PROCESSDEF WHERE FPROCESSID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                existsFlag = true;
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return existsFlag;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public boolean existsProcessDef(String processDefId) throws SQLException {
        return this.exsits(processDefId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(WorkFlowProcessInfo info) throws SQLException {
        String sql = "INSERT INTO T_WFD_PROCESSDEF (FPROCESSID, FCODE, FNAME, FDESCRIPTION, FPROCESSXML, FCREATETIME, FAUTHORID,FPUBLISHSTATUS,FVERSION,FVALIDFROM,FVALIDTO,FSYSTEMVERSION,FPACKAGENAME,FFILENAME,FLOCKSTATUS,FUSERID,FPROCDEFTYPE,FICONNAME,FCHILDPROCESS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sql);
            stmt.setString(1, info.getProcessId());
            stmt.setString(2, info.getProcessCode());
            stmt.setString(3, info.getProcessName());
            stmt.setString(4, info.getProcessDescription());
            stmt.setString(5, info.getProcessXml());
            stmt.setDate(6, new Date(info.getCreateTime().getTime()));
            stmt.setString(7, info.getAuthorId());
            stmt.setInt(8, info.isPublishStatus() ? 1 : 0);
            stmt.setString(9, info.getVersion());
            stmt.setDate(10, new Date(info.getValidFrom().getTime()));
            stmt.setDate(11, new Date(info.getValidTo().getTime()));
            stmt.setString(12, info.getSystemVersion());
            stmt.setString(13, info.getPackageName());
            stmt.setString(14, info.getFileName());
            stmt.setInt(15, info.getStatus());
            stmt.setString(16, info.getUserID());
            stmt.setString(17, info.getType());
            stmt.setString(18, info.getIconPath());
            stmt.setString(19, info.getChildProcessIds());
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public void update(WorkFlowProcessInfo info) throws SQLException {
        String sql = "";
        Connection conn = null;
        Statement stmt = null;
        try {
            sql = "UPDATE T_WFD_PROCESSDEF SET FCODE = ?, FNAME = ?, FDESCRIPTION = ?, FPROCESSXML = ?, FCREATETIME = ?, FAUTHORID = ?, FPUBLISHSTATUS = ?, FVERSION = ?, FVALIDFROM = ?,FVALIDTO = ?,FSYSTEMVERSION = ?,FPACKAGENAME = ?,FFILENAME = ? ,FLOCKSTATUS = ?,FUSERID=?,FPROCDEFTYPE=?,FICONNAME=?,FChildProcess=? WHERE FPROCESSID = ? ";
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sql);
            stmt.setString(1, info.getProcessCode());
            stmt.setString(2, info.getProcessName());
            stmt.setString(3, info.getProcessDescription());
            stmt.setString(4, info.getProcessXml());
            stmt.setDate(5, new Date(System.currentTimeMillis()));
            stmt.setString(6, info.getAuthorId());
            stmt.setInt(7, info.isPublishStatus() ? 1 : 0);
            stmt.setString(8, info.getVersion());
            if (info.getValidFrom() != null) {
                stmt.setDate(9, new Date(info.getValidFrom().getTime()));
            } else {
                stmt.setDate(9, new Date(System.currentTimeMillis()));
            }
            if (info.getValidTo() != null) {
                stmt.setDate(10, new Date(info.getValidTo().getTime()));
            } else {
                stmt.setDate(10, new Date(System.currentTimeMillis()));
            }
            stmt.setString(11, info.getSystemVersion());
            stmt.setString(12, info.getPackageName());
            stmt.setString(13, info.getFileName());
            stmt.setInt(14, info.getStatus());
            stmt.setString(15, info.getUserID());
            stmt.setString(16, info.getType());
            stmt.setString(17, info.getIconPath());
            stmt.setString(18, info.getChildProcessIds());
            stmt.setString(19, info.getProcessId());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                stmt.close();
                conn.close();
            }
            catch (SQLException e1) {
                this.log.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    public void updatePackage(WorkFlowProcessInfo info, String table) throws SQLException {
        this.log.info((Object)("table name is :" + table));
        String sql = "";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            if (table == null || table.equals("")) {
                return;
            }
            if (table.equals("T_WFR_ProcDef")) {
                sql = "UPDATE " + table + " SET FPACKAGENAME = ? WHERE FPROCDEFID = ? ";
            } else if (table.equals("T_WFD_PROCESSDEF")) {
                sql = "UPDATE " + table + " SET FPACKAGENAME = ? WHERE FPROCESSID = ? ";
            } else {
                return;
            }
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sql);
            stmt.setString(1, info.getPackageName());
            stmt.setString(2, info.getProcessId());
            stmt.executeUpdate();
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup(stmt, conn);
        }
    }

    public void updatePackage(List list, String table) throws SQLException {
        if (list == null || list.size() < 1) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("table name is :" + table + "  ,list size is:" + list.size()));
        }
        String sql = "";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            if (table == null || table.equals("")) {
                return;
            }
            if (table.equals("T_WFR_ProcDef")) {
                sql = "UPDATE " + table + " SET FPACKAGENAME = ? WHERE FPROCDEFID = ? ";
            } else if (table.equals("T_WFD_PROCESSDEF")) {
                sql = "UPDATE " + table + " SET FPACKAGENAME = ? WHERE FPROCESSID = ? ";
            } else {
                return;
            }
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sql);
            for (WorkFlowProcessInfo info : list) {
                stmt.clearParameters();
                stmt.setString(1, info.getPackageName());
                stmt.setString(2, info.getProcessId());
                stmt.addBatch();
            }
            stmt.executeBatch();
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup(stmt, conn);
        }
    }

    public ArrayList getRunProcessDef() throws SQLException {
        return this.getRunProcessDef(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getRunProcessDef(String[] types) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<WorkFlowProcessInfo> al = new ArrayList<WorkFlowProcessInfo>();
        try {
            conn = this.getConnection();
            StringBuffer sql = new StringBuffer("SELECT fprocdefid,fpackagename FROM T_WFR_ProcDef");
            if (types != null) {
                StringBuffer whereStr = new StringBuffer(" WHERE ");
                int len = types.length;
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        whereStr.append(" OR ");
                    }
                    whereStr.append("FPROCDEFTYPE = '").append(types[i].toUpperCase()).append('\'');
                }
                sql.append(whereStr.toString());
            }
            stmt = conn.prepareStatement(sql.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                WorkFlowProcessInfo info = new WorkFlowProcessInfo();
                info.setProcessId(rs.getString(1));
                info.setPackageName(rs.getString(2));
                al.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return al;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public void updateFileName(String pkgName, String oldFileName, String newFileName) throws SQLException {
        String sql = " UPDATE T_WFD_PROCESSDEF SET FFILENAME = '" + newFileName + "' WHERE fpackagename = '" + pkgName + "' AND  ffilename= '" + oldFileName + "'";
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sql);
            stmt.execute();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                stmt.close();
                conn.close();
            }
            catch (SQLException e1) {
                this.log.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLocked(String id) throws SQLException {
        boolean b = false;
        String sql = "SELECT FLOCKSTATUS FROM T_WFD_PROCESSDEF WHERE FPROCESSID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                int status = rs.getInt(1);
                if (status != 1) continue;
                b = true;
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return b;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkFlowProcessInfo checkoutByPackageAndName(String pkgName, String fileName, ProcessType type) throws SQLException {
        WorkFlowProcessInfo workFlowProcessInfo;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            String sql = "SELECT fversion,flockstatus,fuserid,fprocessid FROM T_WFD_PROCESSDEF WHERE FPACKAGENAME = ?  AND FPROCDEFTYPE = '" + type.getName() + "' AND FFILENAME = ? ";
            stmt = this.prepareStatement(conn, sql);
            stmt.setString(1, pkgName);
            stmt.setString(2, fileName);
            rs = stmt.executeQuery();
            WorkFlowProcessInfo info = new WorkFlowProcessInfo();
            while (rs.next()) {
                info.setStatus(rs.getInt(2));
                info.setUserID(rs.getString(3));
                info.setProcessId(rs.getString(4));
            }
            workFlowProcessInfo = info;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return workFlowProcessInfo;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkFlowProcessInfo getByPackageAndName(String pkgName, String fileName, ProcessType type) throws SQLException {
        WorkFlowProcessInfo workFlowProcessInfo;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        WorkFlowProcessInfo info = new WorkFlowProcessInfo();
        try {
            conn = this.getConnection();
            String partSQL = type == null ? " AND ( FPROCDEFTYPE = '" + ProcessType.NORMAL.getName() + "' OR FPROCDEFTYPE = '" + ProcessType.MICRO.getName() + "' ) " : " AND FPROCDEFTYPE = '" + type.getName() + "' ";
            String sql = "SELECT FPROCESSID,FCODE,FNAME,FDESCRIPTION,FPROCESSXML,FCREATETIME,FAUTHORID,FPUBLISHSTATUS,FVERSION,FVALIDFROM,FVALIDTO,FSYSTEMVERSION,FPACKAGENAME,FFILENAME,FLockStatus,FUserId,FPROCDEFTYPE,FICONNAME,FCHILDPROCESS FROM T_WFD_PROCESSDEF WHERE FPACKAGENAME = ? " + partSQL + " AND FFILENAME = ? ";
            stmt = this.prepareStatement(conn, sql);
            stmt.setString(1, pkgName);
            stmt.setString(2, fileName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info.setProcessId(rs.getString(1));
                info.setProcessCode(rs.getString(2));
                info.setProcessName(rs.getString(3));
                info.setProcessDescription(rs.getString(4));
                info.setProcessXml(rs.getString(5));
                info.setCreateTime(new java.util.Date(rs.getDate(6).getTime()));
                info.setAuthorId(rs.getString(7));
                info.setPublishStatus(rs.getInt(8) > 0);
                info.setVersion(rs.getString(9));
                info.setValidFrom(new java.util.Date(rs.getDate(10).getTime()));
                info.setValidTo(new java.util.Date(rs.getDate(11).getTime()));
                info.setSystemVersion(rs.getString(12));
                info.setPackageName(rs.getString(13));
                info.setFileName(rs.getString(14));
                info.setStatus(rs.getInt(15));
                info.setUserID(rs.getString(16));
                info.setType(rs.getString(17));
                info.setIconPath(rs.getString(18));
                info.setChildProcessIds(rs.getString(19));
            }
            workFlowProcessInfo = info;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return workFlowProcessInfo;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getAll(ProcessType type) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<WorkFlowProcessInfo> al = new ArrayList<WorkFlowProcessInfo>();
        try {
            conn = this.getConnection();
            String sql = "SELECT fprocessid,fpackagename,ffilename,flockstatus,fuserid,ficonname,Fchildprocess FROM T_WFD_PROCESSDEF WHERE FPROCDEFTYPE = '" + type.getName() + "'";
            stmt = this.prepareStatement(conn, sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                WorkFlowProcessInfo info = new WorkFlowProcessInfo();
                info.setProcessId(rs.getString(1));
                info.setPackageName(rs.getString(2));
                info.setFileName(rs.getString(3));
                info.setStatus(rs.getInt(4));
                info.setUserID(rs.getString(5));
                info.setIconPath(rs.getString(6));
                info.setChildProcessIds(rs.getString(7));
                al.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return al;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void checkOutById(String id, String user, int status, ProcessType type) throws SQLException {
        String sql = "UPDATE T_WFD_PROCESSDEF SET FLockStatus = ?, FUSERID = '" + user + "' WHERE FPROCESSID = ? AND FPROCDEFTYPE=?";
        Connection conn = null;
        PreparedStatement stmt = null;
        conn = this.getConnection();
        stmt = this.prepareStatement(conn, sql);
        stmt.setInt(1, status);
        stmt.setString(2, id);
        stmt.setString(3, type.getName());
        stmt.executeUpdate();
        try {
            DBOperationBridge.cleanup(stmt, conn);
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (SQLException e) {
            try {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
                throw throwable;
            }
            try {
                DBOperationBridge.cleanup(stmt, conn);
            }
            catch (SQLException ex) {
                this.log.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String delete(String pkgName, String fileName) throws SQLException {
        String string;
        String selectSQL = "SELECT FPROCESSID FROM T_WFD_PROCESSDEF WHERE fpackagename = ?  AND ffilename = ?";
        String deleteSQL = "DELETE T_WFD_PROCESSDEF WHERE fpackagename = ?  AND ffilename = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String procDefId = null;
        try {
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, selectSQL);
            stmt.setString(1, pkgName);
            stmt.setString(2, fileName);
            rs = stmt.executeQuery();
            if (rs.next()) {
                procDefId = rs.getString("FPROCESSID");
            }
            stmt = this.prepareStatement(conn, deleteSQL);
            stmt.setString(1, pkgName);
            stmt.setString(2, fileName);
            stmt.execute();
            string = procDefId;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return string;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public void updateFileName(String pkgName, String oldFileName, String newFileName, ProcessType type) throws SQLException {
        WorkFlowProcessInfo info = this.getFileByPackageAndName(pkgName, oldFileName);
        ProcessDef procDef = null;
        String kpdl = info.getProcessXml();
        if (kpdl != null && kpdl.trim().length() > 0) {
            try {
                String temp = newFileName;
                if (newFileName.indexOf(46) != -1) {
                    temp = newFileName.substring(0, newFileName.lastIndexOf(46));
                }
                procDef = KpdlParser.parseKpdl((String)kpdl);
                procDef.setName(this.l2, temp);
                info.setProcessName(procDef.getName(this.l2));
                info.setProcessXml(procDef.toXml());
                this.update(info);
            }
            catch (WfKpdlParseException e) {
                this.log.error((Object)"updateFileName()", (Throwable)e);
            }
            catch (WfException e) {
                this.log.error((Object)"updateFileName()", (Throwable)e);
            }
        }
        String sql = " UPDATE T_WFD_PROCESSDEF SET FFILENAME = '" + newFileName + "' WHERE fpackagename = '" + pkgName + "' AND  ffilename= '" + oldFileName + "' AND FPROCDEFTYPE = ? ";
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sql);
            stmt.setString(1, type.getName());
            stmt.execute();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                stmt.close();
                conn.close();
            }
            catch (SQLException e1) {
                this.log.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    public void updateFileName(String processDefID, String newFileName, ProcessType type) throws SQLException {
        String sql = " UPDATE T_WFD_PROCESSDEF SET FFILENAME = ? WHERE fprocessid =? AND FPROCDEFTYPE = ? ";
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sql);
            stmt.setString(1, newFileName);
            stmt.setString(2, processDefID);
            stmt.setString(3, type.getName());
            stmt.execute();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                stmt.close();
                conn.close();
            }
            catch (SQLException e1) {
                this.log.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkFlowProcessInfo get(String id) throws SQLException {
        WorkFlowProcessInfo info = new WorkFlowProcessInfo();
        String sql = "SELECT FPROCESSID,FCODE,FNAME,FDESCRIPTION,FPROCESSXML,FCREATETIME,FAUTHORID,FPUBLISHSTATUS,FVERSION,FVALIDFROM,FVALIDTO,FSYSTEMVERSION,FPACKAGENAME,FFILENAME,FLockStatus,FUserId,FPROCDEFTYPE,FICONNAME,FCHILDPROCESS FROM T_WFD_PROCESSDEF WHERE FPROCESSID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                info.setProcessId(rs.getString(1));
                info.setProcessCode(rs.getString(2));
                info.setProcessName(rs.getString(3));
                info.setProcessDescription(rs.getString(4));
                info.setProcessXml(rs.getString(5));
                info.setCreateTime(new java.util.Date(rs.getDate(6).getTime()));
                info.setAuthorId(rs.getString(7));
                info.setPublishStatus(rs.getInt(8) > 0);
                info.setVersion(rs.getString(9));
                info.setValidFrom(new java.util.Date(rs.getDate(10).getTime()));
                info.setValidTo(new java.util.Date(rs.getDate(11).getTime()));
                info.setSystemVersion(rs.getString(12));
                info.setPackageName(rs.getString(13));
                info.setFileName(rs.getString(14));
                info.setStatus(rs.getInt(15));
                info.setUserID(rs.getString(16));
                info.setType(rs.getString(17));
                info.setIconPath(rs.getString(18));
                info.setChildProcessIds(rs.getString(19));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return info;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getAllTypeProcess() throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<WorkFlowProcessInfo> al = new ArrayList<WorkFlowProcessInfo>();
        try {
            conn = this.getConnection();
            String sql = "SELECT fprocessid,fpackagename,ffilename,flockstatus,fuserid,ficonname,Fchildprocess,Fprocdeftype FROM T_WFD_PROCESSDEF";
            stmt = this.prepareStatement(conn, sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                WorkFlowProcessInfo info = new WorkFlowProcessInfo();
                info.setProcessId(rs.getString(1));
                info.setPackageName(rs.getString(2));
                info.setFileName(rs.getString(3));
                info.setStatus(rs.getInt(4));
                info.setUserID(rs.getString(5));
                info.setIconPath(rs.getString(6));
                info.setChildProcessIds(rs.getString(7));
                info.setType(rs.getString(8));
                al.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return al;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }
}

