/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.wfdesigner.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.service.CommonServiceManager;
import com.kingdee.bos.service.ServiceParam;
import com.kingdee.bos.service.ServiceRef;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.bos.workflow.dynui.DynUIPackageDef;
import com.kingdee.bos.workflow.dynui.approve.ApproveUIDef;
import com.kingdee.bos.workflow.metas.EventTypeEnum;
import com.kingdee.bos.workflow.metas.IProcImportDef;
import com.kingdee.bos.workflow.metas.ProcImportDefFactory;
import com.kingdee.bos.workflow.util.JavaMethodUtil;
import com.kingdee.bos.workflow.wfdesigner.OtherSysInfo;
import com.kingdee.bos.workflow.wfdesigner.OtherSysPackageInfo;
import com.kingdee.bos.workflow.wfdesigner.WfBizType;
import com.kingdee.bos.workflow.wfdesigner.WfFunctionInfo;
import com.kingdee.bos.workflow.wfdesigner.WfFunctionPackageInfo;
import com.kingdee.bos.workflow.wfdesigner.WfServiceParam;
import com.kingdee.bos.workflow.wfdesigner.WfServiceRef;
import com.kingdee.bos.workflow.wfdesigner.WorkFlowProcessInfo;
import com.kingdee.bos.workflow.wfdesigner.service.DBOperationBridge;
import com.kingdee.bos.workflow.wfdesigner.service.IWorkFlowDefineService;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class WorkFlowDefineService
extends AbstractBOSObject
implements IWorkFlowDefineService {
    public WorkFlowDefineService() {
        super.registerInterface(IWorkFlowDefineService.class, (Object)this);
    }

    public WorkFlowDefineService(Context ctx) {
        super(ctx);
        super.registerInterface(IWorkFlowDefineService.class, (Object)this);
    }

    public BOSObjectType getType() {
        return IWorkFlowDefineService.BOSTYPE;
    }

    public WorkFlowProcessInfo getFileByPackageAndName(String pkgName, String fileName) throws SQLException {
        DBOperationBridge bridge = this.getBridge();
        WorkFlowProcessInfo info = bridge.getProcessStorer().getFileByPackageAndName(pkgName, fileName);
        return info;
    }

    public DBOperationBridge getBridge() {
        return new DBOperationBridge(this);
    }

    public WorkFlowProcessInfo getProcessDef(String processDefId) throws SQLException {
        DBOperationBridge bridge = this.getBridge();
        WorkFlowProcessInfo info = bridge.getProcessStorer().getProcessDef(processDefId);
        return info;
    }

    public ArrayList getAllProcessDef() throws SQLException {
        DBOperationBridge bridge = this.getBridge();
        ArrayList list = bridge.getProcessStorer().getAllProcessDef();
        return list;
    }

    public void checkOutProcessById(String id, String user, int status) throws SQLException {
        DBOperationBridge bridge = this.getBridge();
        bridge.getProcessStorer().checkOutProcessById(id, user, status);
    }

    public WorkFlowProcessInfo checkoutFileByPackageAndName(String pkgName, String fileName) throws SQLException {
        DBOperationBridge bridge = this.getBridge();
        WorkFlowProcessInfo info = bridge.getProcessStorer().checkoutFileByPackageAndName(pkgName, fileName);
        return info;
    }

    public boolean existsProcessDef(String processDefId) throws SQLException {
        DBOperationBridge bridge = this.getBridge();
        boolean exist = bridge.getProcessStorer().existsProcessDef(processDefId);
        return exist;
    }

    public void insert(WorkFlowProcessInfo info) throws SQLException {
        DBOperationBridge bridge = this.getBridge();
        bridge.getProcessStorer().insert(info);
    }

    public void update(WorkFlowProcessInfo info) throws SQLException {
        DBOperationBridge bridge = this.getBridge();
        bridge.getProcessStorer().update(info);
    }

    public void updatePackage(WorkFlowProcessInfo info, String table) throws SQLException {
        DBOperationBridge bridge = this.getBridge();
        bridge.getProcessStorer().updatePackage(info, table);
    }

    public void updatePackage(List list, String table) throws SQLException {
        DBOperationBridge bridge = this.getBridge();
        bridge.getProcessStorer().updatePackage(list, table);
    }

    public ArrayList getRunProcessDef() throws WfException {
        try {
            return this.getBridge().getProcessStorer().getRunProcessDef();
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public ArrayList getRunProcessDef(String[] types) throws WfException {
        try {
            return this.getBridge().getProcessStorer().getRunProcessDef(types);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public void updateFileName(String pkgName, String oldFileName, String newFileName) throws SQLException {
        DBOperationBridge bridge = this.getBridge();
        bridge.getProcessStorer().updateFileName(pkgName, oldFileName, newFileName);
    }

    public boolean isLocked(String id) throws SQLException {
        DBOperationBridge bridge = this.getBridge();
        boolean b = bridge.getProcessStorer().isLocked(id);
        return b;
    }

    public Context getContext() {
        return super.getContext();
    }

    public WorkFlowProcessInfo getTemplate(String processDefId) throws WfException {
        return this.get(processDefId);
    }

    public ArrayList getAllTemplate() throws WfException {
        return this.getAll(ProcessType.TEMPLET);
    }

    public void checkOutTemplateById(String id, String user, int status) throws WfException {
        this.checkOutById(id, user, status, ProcessType.TEMPLET);
    }

    public void deleteTemplate(String pkgName, String fileName) throws WfException {
        this.delete(pkgName, fileName);
    }

    public void updateTemplateFileName(String pkgName, String oldFileName, String newFileName) throws WfException {
        this.updateFileName(pkgName, oldFileName, newFileName, ProcessType.TEMPLET);
    }

    public WorkFlowProcessInfo getTemplateByPackageAndName(String pkgName, String fileName) throws WfException {
        return this.getByPackageAndName(pkgName, fileName, ProcessType.TEMPLET);
    }

    public WorkFlowProcessInfo checkoutTemplateByPackageAndName(String pkgName, String fileName) throws WfException {
        return this.checkoutByPackageAndName(pkgName, fileName, ProcessType.TEMPLET);
    }

    public WorkFlowProcessInfo get(String processDefId) throws WfException {
        try {
            return this.getBridge().getProcessStorer().get(processDefId);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public ArrayList getAll(ProcessType type) throws WfException {
        try {
            return this.getBridge().getProcessStorer().getAll(type);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public void checkOutById(String id, String user, int status, ProcessType type) throws WfException {
        try {
            this.getBridge().getProcessStorer().checkOutById(id, user, status, type);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public String delete(String pkgName, String fileName) throws WfException {
        try {
            String procDefId = this.getBridge().getProcessStorer().delete(pkgName, fileName);
            this.clearEventProcRelation(procDefId);
            if (!StringUtils.isEmpty((String)procDefId)) {
                IProcImportDef procImportDef = ProcImportDefFactory.getLocalInstance((Context)this.getContext());
                procImportDef.delete("WHERE procDefId = '" + procDefId + "' ");
            }
            return procDefId;
        }
        catch (Exception e) {
            throw new WfException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearEventProcRelation(String processDefId) throws WfException {
        try {
            if (StringUtils.isEmpty((String)processDefId)) {
                return;
            }
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = this.getBridge().getConnection();
                String sql = "DELETE FROM T_WFR_EventProcMeta WHERE (FProcDefId = ? and FEventType = ?)";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, processDefId);
                stmt.setString(2, EventTypeEnum.PROCESSTRIGGER.getValue());
                stmt.executeUpdate();
            }
            finally {
                stmt.close();
                conn.close();
            }
        }
        catch (SQLException ex) {
            throw new WfException(ex.getMessage(), (Throwable)ex, true);
        }
    }

    public boolean exists(String processDefId) throws WfException {
        try {
            return this.getBridge().getProcessStorer().exsits(processDefId);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public void updateFileName(String pkgName, String oldFileName, String newFileName, ProcessType type) throws WfException {
        try {
            this.getBridge().getProcessStorer().updateFileName(pkgName, oldFileName, newFileName, type);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public WorkFlowProcessInfo getByPackageAndName(String pkgName, String fileName, ProcessType type) throws WfException {
        try {
            return this.getBridge().getProcessStorer().getByPackageAndName(pkgName, fileName, type);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public WorkFlowProcessInfo checkoutByPackageAndName(String pkgName, String fileName, ProcessType type) throws WfException {
        try {
            return this.getBridge().getProcessStorer().checkoutByPackageAndName(pkgName, fileName, type);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public WfBizType[] getWfBizTypes() throws Exception {
        Class<?> cls = Class.forName("com.kingdee.bos.workflow.report.WfBizTypesInfoUtil");
        Method method = cls.getMethod("getWfBizTypes", Context.class);
        Object obj = method.invoke(null, this.getContext());
        return (WfBizType[])obj;
    }

    public WfServiceRef[] getServiceRefs(String type) throws Exception {
        try {
            List list;
            CommonServiceManager serviceManager = CommonServiceManager.getInstance();
            if (!serviceManager.isInited()) {
                serviceManager.init();
            }
            if ((list = serviceManager.list(type)) == null) {
                return new WfServiceRef[0];
            }
            WfServiceRef[] refs = new WfServiceRef[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ServiceRef ref = (ServiceRef)list.get(i);
                refs[i] = this.convertServiceRef(ref);
            }
            return refs;
        }
        catch (Exception ex) {
            throw new WfException("WFD_SER_001", null, (Throwable)ex);
        }
    }

    public WfServiceRef findServiceRef(String uri) throws Exception {
        ServiceRef ref;
        CommonServiceManager serviceManager = CommonServiceManager.getInstance();
        if (!serviceManager.isInited()) {
            serviceManager.init();
        }
        if ((ref = serviceManager.findService(uri)) == null) {
            return null;
        }
        return this.convertServiceRef(ref);
    }

    private WfServiceRef convertServiceRef(ServiceRef ref) {
        ServiceParam orParam;
        WfServiceRef wfRef = new WfServiceRef();
        wfRef.setName(ref.getName());
        wfRef.setPath(ref.getPath());
        wfRef.setDescription(ref.getDescription());
        wfRef.setType(ref.getType());
        List oParams = ref.getParams();
        if (oParams != null) {
            ArrayList<WfServiceParam> params = new ArrayList<WfServiceParam>(oParams.size());
            for (int pi = 0; pi < oParams.size(); ++pi) {
                ServiceParam oParam = (ServiceParam)oParams.get(pi);
                WfServiceParam param = new WfServiceParam(oParam.getName(), oParam.getType(), oParam.getDescription());
                params.add(param);
            }
            wfRef.setParams(params);
        }
        if ((orParam = ref.getReturnParam()) != null) {
            WfServiceParam rParam = new WfServiceParam(orParam.getName(), orParam.getType(), orParam.getDescription());
            wfRef.setReturnParam(rParam);
        }
        return wfRef;
    }

    public ArrayList getAllTypeProcess() throws WfException {
        try {
            return this.getBridge().getProcessStorer().getAllTypeProcess();
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public String addWfFunctionInfo(WfFunctionInfo info) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().addWfFunctionInfo(info);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean addWfFunctionInfo(List<WfFunctionInfo> infos) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().addWfFunctionInfo(infos);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public String addWfFunPackage(WfFunctionPackageInfo info) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().addWfFunPackage(info);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean delWfFunctionInfo(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().delWfFunctionInfo(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean delWfFunctionPackage(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().delWfFunctionPackage(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean modWfFunctionInfo(WfFunctionInfo info) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            CustomCacheService cacheService = new CustomCacheService("workflow.personFunction");
            cacheService.remove(info.getId());
            return bridge.getFunctionStorer().modWfFunctionInfo(info);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean modWfFunctionPackage(WfFunctionPackageInfo info) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().modWfFunctionPackage(info);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean modWfFunctionPackage(String id, String name) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().modWfFunctionPackage(id, name);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List getWfFunctionPackageRoot() throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            List list = bridge.getFunctionStorer().getWfFunctionPackageRoot();
            if (list.size() == 0) {
                WfFunctionPackageInfo info = new WfFunctionPackageInfo();
                info.setName("\u51fd\u6570\u5e93");
                info.setContent("\u51fd\u6570\u5e93");
                info.setParentId("");
                this.addWfFunPackage(info);
                list = bridge.getFunctionStorer().getWfFunctionPackageRoot();
            }
            return list;
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List<WfFunctionInfo> getWfFunctionInfoByIds(String[] ids) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().getWfFunctionInfoByIds(ids);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List<WfFunctionInfo> getWfFunctionInfoByPackageId(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().getWfFunctionInfoByPackageId(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List<WfFunctionPackageInfo> getWfFunctionPackageInfoByPid(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().getWfFunctionPackageInfoByPid(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List getChildrenByPackageId(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().getChildrenByPackageId(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List getPerformerChildrenByPackageId(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().getPerformerChildrenByPackageId(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public WfFunctionPackageInfo getWfFunctionPackageInfoById(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().getWfFunctionPackageInfoById(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public WfFunctionInfo getWfFunctionInfoById(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().getWfFunctionInfoById(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List getOtherSysPackageRoot() throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            List list = bridge.getOtherSysStorer().getOtherSysPackageRoot();
            return list;
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List<OtherSysInfo> getOtherSysInfoByIds(String[] ids) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getOtherSysStorer().getOtherSysInfoByIds(ids);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List<OtherSysInfo> getOtherSysInfoByPackageId(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getOtherSysStorer().getOtherSysInfoByPackageId(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List<OtherSysPackageInfo> getOtherSysPackageInfoByPid(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getOtherSysStorer().getOtherSysPackageInfoByPid(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List getChildrenByPackageIdForOtherSys(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getOtherSysStorer().getChildrenByPackageId(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public OtherSysPackageInfo getOtherSysPackageInfoById(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getOtherSysStorer().getOtherSysPackageInfoById(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public OtherSysInfo getOtherSysInfoById(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getOtherSysStorer().getOtherSysInfoById(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public OtherSysInfo getOtherSysInfoByName(String name) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getOtherSysStorer().getOtherSysInfoByName(name);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public Map<String, Object> getAllOtherSysInfo() throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getOtherSysStorer().getAllOtherSysInfo();
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean delWfFunctionInfos(String[] ids) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().delWfFunctionInfos(ids);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean delWfFunctionPackages(String[] ids) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getFunctionStorer().delWfFunctionPackages(ids);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List getJavaClassInfo(String className) {
        ArrayList<String[]> rtn = null;
        try {
            Class<?> cls = Class.forName(className);
            Method[] methods = cls.getMethods();
            if (methods.length > 0) {
                rtn = new ArrayList<String[]>();
            }
            for (int i = 0; i < methods.length; ++i) {
                String[] s = new String[3];
                String str = "";
                if (Modifier.isStatic(methods[i].getModifiers())) {
                    str = str + "static ";
                }
                str = str + methods[i].getReturnType().getName();
                str = str + " ";
                str = str + methods[i].getName();
                str = str + "(";
                str = str + JavaMethodUtil.classArray2String2((Class[])methods[i].getParameterTypes());
                s[0] = str = str + ")";
                s[1] = JavaMethodUtil.classArray2String((Class[])methods[i].getParameterTypes());
                s[2] = methods[i].getName();
                rtn.add(s);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return rtn;
    }

    public String addDynUIApproveDef(ApproveUIDef info) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getDynUIStorer().addDynUIApproveDef(info);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public String addDynUIPackage(DynUIPackageDef info) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getDynUIStorer().addDynUIPackage(info);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean delDynUIApproveDef(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getDynUIStorer().delDynUIApproveDef(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean delDynUIApproveDefs(String[] ids) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getDynUIStorer().delDynUIApproveDefs(ids);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean delDynUIPackage(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getDynUIStorer().delDynUIPackage(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean delDynUIPackage(String[] ids) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getDynUIStorer().delDynUIPackage(ids);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public ApproveUIDef getApproveUIDefById(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getDynUIStorer().getApproveUIDefById(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List getApproveUIDefByPackageId(String packageId) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getDynUIStorer().getApproveUIDefByPackageId(packageId);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List getDynUIPackageRoot() throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getDynUIStorer().getDynUIPackageRoot();
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List getSubDynUIPackageByPackageId(String id) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getDynUIStorer().getSubDynUIPackageByPackageId(id);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean modDynUIPackage(DynUIPackageDef info) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getDynUIStorer().modDynUIPackage(info);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean modDynUIApproveDef(ApproveUIDef info) throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getDynUIStorer().modDynUIApproveDef(info);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public List getAllApproveUIDef() throws WfException {
        DBOperationBridge bridge = this.getBridge();
        try {
            return bridge.getDynUIStorer().getAllApproveUIDef();
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public String getAllApproveUIXml() throws WfException {
        String str = "";
        List list = this.getAllApproveUIDef();
        Element root = new Element("Root");
        if (list != null) {
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                Element ele = new Element("userDefinedUI");
                ApproveUIDef approveUIDef = (ApproveUIDef)list.get(i);
                ele.setAttribute("Alias", approveUIDef.getTitle());
                ele.setAttribute("Type", "DYN_WEB");
                ele.setAttribute("ApproveClass", "/dynApproveUI.jsf");
                ele.setAttribute("ApproveUIKey", approveUIDef.getId());
                ele.setAttribute("ApproveImage", "assets/images/designer/multiapprove_dynweb.jpg");
                ele.setAttribute("ApproveDesc", approveUIDef.getDesc());
                root.addContent((Content)ele);
            }
        }
        str = WorkFlowDefineService.ElementToXml(root);
        return str;
    }

    private static String ElementToXml(Element element) {
        if (element != null) {
            Document XMLDoc = new Document(element);
            XMLOutputter xml = new XMLOutputter();
            xml.setFormat(xml.getFormat().setLineSeparator(""));
            xml.setFormat(xml.getFormat().setIndent("  "));
            return xml.outputString(XMLDoc);
        }
        return null;
    }

    public void updateFileName(String processDefID, String newFileName, ProcessType type) throws WfException {
        try {
            this.getBridge().getProcessStorer().updateFileName(processDefID, newFileName, type);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }
}

