/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.adapter;

import com.kingdee.bos.Context;
import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.microflow.MicroFlowEngine;
import com.kingdee.bos.service.job.core.ICoreJobHandler;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfExecutionObject;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.enactment.cache.ActivityInstanceCacheLoader;
import com.kingdee.bos.workflow.enactment.cache.EffectRegion;
import com.kingdee.bos.workflow.enactment.cache.IWfCacheManager;
import com.kingdee.bos.workflow.enactment.cache.IdentifiableInvocationDesc;
import com.kingdee.bos.workflow.enactment.cache.ProcBostypeLoader;
import com.kingdee.bos.workflow.enactment.cache.ProcessDefinitionCacheLoader;
import com.kingdee.bos.workflow.enactment.cache.ProcessInstanceCacheLoader;
import com.kingdee.bos.workflow.enactment.cache.ProcessMgrCacheLoader;
import com.kingdee.bos.workflow.enactment.cache.UserServiceContextCacheLoader;
import com.kingdee.bos.workflow.enactment.cache.WfAssignmentCacheLoader;
import com.kingdee.bos.workflow.engine.adapter.GroupMessageQueue;
import com.kingdee.bos.workflow.engine.adapter.MemcacheAdapter;
import com.kingdee.bos.workflow.engine.core.ThreadCache;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.bos.workflow.util.InvocationDesc;
import com.kingdee.bos.workflow.util.InvocationExecutor;
import com.kingdee.cbos.process.vm.utils.cache.Cache;
import com.kingdee.cbos.process.vm.utils.cache.CacheManager;
import com.kingdee.cbos.process.vm.utils.cache.GroupCache;
import com.kingdee.cbos.process.vm.utils.cache.LocalCache;
import com.kingdee.cbos.process.vm.utils.cache.SmartCache;
import com.kingdee.cbos.process.vm.utils.group.MessageQueue;
import com.kingdee.util.ObjectUtils;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfCache
implements IWfCacheManager {
    private static final Logger logger = Logger.getLogger(WfCache.class);
    public static final int CACHE_TIMEOUT = 1800;
    private static final int PROCESS_DEF_CACHE_SIZE;
    private static final int EXECUTION_CACHE_SIZE = 1000;
    private static final int OBJ_CACHE_SIZE = 5000;
    private static final int CONTEXT_CACHE_SIZE = 200;
    private static final int PROC_BOSTYPE_CACHE_SIZE = 5000;
    private static final String MARK = "PROCMGR";
    private static final String ASSIGN;
    private static final String ACTIVITY;
    private static final String PROCESS;
    private static final long serialVersionUID = -6258831645764502048L;
    private volatile boolean inited = false;
    private transient WfEngine engine;
    private transient Cache<String, WfExecutionObject> executionCache;
    private transient ProcessInstanceCacheLoader processLoader;
    private transient ActivityInstanceCacheLoader activityLoader;
    private transient WfAssignmentCacheLoader assignLoader;
    private transient Cache<String, Object> objCache;
    private transient Cache<String, ProcessDef> processDefCache;
    private transient ProcessDefinitionCacheLoader processDefLoader;
    private transient Cache<String, Context> contextCache;
    private transient UserServiceContextCacheLoader contextLoader;
    private transient Cache<String, WfProcessMgr> processMgrCache;
    private transient ProcessMgrCacheLoader processMgrLoader;
    private transient Cache<String, BOSObjectType[]> procBostypeCache;
    private transient ProcBostypeLoader procBostypeLoader;
    private transient Cache<String, Object> invocationCacheManager;

    public WfCache(WfEngine engine) {
        this.engine = engine;
    }

    public void addActivityInst(WfActivity actInst) {
        String key = actInst.getId();
        if (!ThreadCache.put((String)key, (Object)actInst)) {
            this.executionCache.put((Object)key, (Object)actInst);
        }
    }

    public void addAssignment(WfAssignment assignment) {
        String key = assignment.getId();
        if (!ThreadCache.put((String)key, (Object)assignment)) {
            this.executionCache.put((Object)key, (Object)assignment);
        }
    }

    public void addProcInst(WfProcess procInst) {
        String key = procInst.getId();
        if (!ThreadCache.put((String)key, (Object)procInst)) {
            this.executionCache.put((Object)key, (Object)procInst);
        }
    }

    public void cleanParticipantCache() {
        this.objCache.clear();
    }

    public void cleanUp() throws WfException {
        this.clear();
    }

    public void destroy() {
        this.clear();
    }

    private void clear() {
        this.executionCache.clear();
        this.processDefCache.clear();
        this.contextCache.clear();
        this.processMgrCache.clear();
        this.objCache.clear();
        this.procBostypeCache.clear();
        this.invocationCacheManager.clear();
    }

    public WfActivity getActivityInst(String activityInstId) {
        Object o = ThreadCache.get((String)activityInstId);
        if (o == null) {
            o = this.executionCache.get((Object)activityInstId);
            ThreadCache.put((String)activityInstId, (Object)o);
        }
        return (WfActivity)o;
    }

    public WfProcess getProcessInst(String procInstId) {
        Object o = ThreadCache.get((String)procInstId);
        if (o == null) {
            o = this.executionCache.get((Object)procInstId);
            ThreadCache.put((String)procInstId, (Object)o);
        }
        return (WfProcess)o;
    }

    public WfAssignment getAssignment(String assignmentId) {
        Object o = ThreadCache.get((String)assignmentId);
        if (o == null) {
            o = this.executionCache.get((Object)assignmentId);
            ThreadCache.put((String)assignmentId, (Object)o);
        }
        return (WfAssignment)o;
    }

    public Map getCacheProperty() {
        return null;
    }

    public WfAssignment getCachedAssignment(String key) {
        return null;
    }

    public Object getGeneralObject(Object key) {
        return this.objCache.get((Object)key.toString());
    }

    public Object getInvocationResult(IdentifiableInvocationDesc invocationDesc) {
        if (EngineConfig.getInstance().isEnableMethodLevelCache()) {
            String key = invocationDesc.toString();
            Object v = this.invocationCacheManager.get((Object)key);
            if (v == null) {
                v = this.executeInvocation(invocationDesc);
                this.invocationCacheManager.put((Object)key, v);
            }
            try {
                if (!this.useMemcache()) {
                    v = ObjectUtils.createCopy((Object)v);
                }
            }
            catch (Throwable e) {
                logger.warn((Object)e.getMessage(), e);
            }
            return v;
        }
        return this.executeInvocation(invocationDesc);
    }

    private Object executeInvocation(IdentifiableInvocationDesc invocationDesc) {
        try {
            Object value = InvocationExecutor.execute((InvocationDesc)invocationDesc);
            return value;
        }
        catch (WfException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getName() {
        return "WF-GLOBAL-CACHE";
    }

    public ProcessDef getProcessDef(String procDefHash) {
        Object o = ThreadCache.get((String)procDefHash);
        if (o == null) {
            o = this.processDefCache.get((Object)procDefHash);
            ThreadCache.put((String)procDefHash, (Object)o);
        }
        return (ProcessDef)o;
    }

    public WfProcessMgr getProcessMgr(String procDefId, int innerVersion) {
        String key = procDefId + "," + innerVersion;
        Object o = ThreadCache.get((String)key);
        if (o == null) {
            o = this.processMgrCache.get((Object)key);
            ThreadCache.put((String)key, (Object)o);
        }
        return (WfProcessMgr)o;
    }

    public WfProcessMgr getProcessMgrByDocHash(String procDefHash) {
        Object o = ThreadCache.get((String)(procDefHash + MARK));
        if (o == null) {
            o = this.processMgrCache.get((Object)procDefHash);
            ThreadCache.put((String)(procDefHash + MARK), (Object)o);
        }
        return (WfProcessMgr)o;
    }

    public WfProcessMgr getProcessMgr(String procDefId) {
        try {
            int lastVersion = this.engine.getDefinitionMgr().getProcessDefLastVersionNumber(procDefId);
            return this.getProcessMgr(procDefId, lastVersion);
        }
        catch (WfException e) {
            throw new CacheException(e.getMessage(), (Throwable)e);
        }
    }

    public Context getUserServiceContext(String user, Context ctx) {
        return (Context)this.contextCache.get((Object)user);
    }

    public void init() throws WfException {
        if (this.inited) {
            return;
        }
        this.initExecutionCache();
        this.initObjCache();
        this.initProcessDefCache();
        this.initContextCache();
        this.initProcessMgrCache();
        this.initInvocationCache();
        this.initProcBostypeCache();
        this.inited = true;
    }

    private void initInvocationCache() {
        String suffix = this.engine.context().getAIS() + "-INVOKE";
        if (this.useMemcache()) {
            this.invocationCacheManager = new MemcacheAdapter<Object>(suffix);
        } else {
            LocalCache cache = new LocalCache(WfCache.class, 1000, 1800);
            this.invocationCacheManager = new GroupCache(suffix, (Cache)cache);
        }
    }

    private void initProcessMgrCache() {
        this.processMgrLoader = new ProcessMgrCacheLoader(this.engine);
        SmartCache.Loader<String, WfProcessMgr> loader = new SmartCache.Loader<String, WfProcessMgr>(){

            public WfProcessMgr load(String id) {
                return (WfProcessMgr)WfCache.this.processMgrLoader.load((Object)id);
            }
        };
        String suffix = this.engine.context().getAIS() + "_WF-DEF-MGR";
        GroupCache cache = this.useMemcache() ? new MemcacheAdapter(suffix) : new GroupCache(suffix, (Cache)new LocalCache(WfCache.class, 1));
        this.processMgrCache = new SmartCache((Cache)cache, (SmartCache.Loader)loader);
    }

    private void initProcBostypeCache() {
        this.procBostypeLoader = new ProcBostypeLoader(this.engine.context());
        SmartCache.Loader<String, BOSObjectType[]> loader = new SmartCache.Loader<String, BOSObjectType[]>(){

            public BOSObjectType[] load(String id) {
                try {
                    return WfCache.this.procBostypeLoader.getRelatedEntityTypes(id);
                }
                catch (WfException e) {
                    throw new RuntimeException("access proc bostype failed! procdefid=" + id, e);
                }
            }
        };
        String suffix = this.engine.context().getAIS() + "_PROC-BOSTYPE";
        GroupCache cache = this.useMemcache() ? new MemcacheAdapter(suffix) : new GroupCache(suffix, (Cache)new LocalCache(WfCache.class, 5000));
        this.procBostypeCache = new SmartCache((Cache)cache, (SmartCache.Loader)loader);
    }

    private void initContextCache() {
        this.contextLoader = new UserServiceContextCacheLoader(this.engine);
        SmartCache.Loader<String, Context> loader = new SmartCache.Loader<String, Context>(){

            public Context load(String id) {
                return (Context)WfCache.this.contextLoader.load((Object)id);
            }
        };
        String suffix = this.engine.context().getAIS() + "_WF-CTX";
        GroupCache cache = this.useMemcache() ? new MemcacheAdapter(suffix) : new GroupCache(suffix, (Cache)new LocalCache(WfCache.class, 200, 1800));
        this.contextCache = new SmartCache((Cache)cache, (SmartCache.Loader)loader);
    }

    private void initProcessDefCache() {
        this.processDefLoader = new ProcessDefinitionCacheLoader(this.engine);
        SmartCache.Loader<String, ProcessDef> loader = new SmartCache.Loader<String, ProcessDef>(){

            public ProcessDef load(String id) {
                return (ProcessDef)WfCache.this.processDefLoader.load((Object)id);
            }
        };
        Object cache = this.useMemcache() ? new MemcacheAdapter(this.engine.context().getAIS() + "_WF-DEFINE") : new LocalCache(WfCache.class, PROCESS_DEF_CACHE_SIZE);
        this.processDefCache = new SmartCache((Cache)cache, (SmartCache.Loader)loader);
    }

    private void initObjCache() {
        String suffix = this.engine.context().getAIS() + "_WF-GENERAL-OBJ";
        if (this.useMemcache()) {
            this.objCache = new MemcacheAdapter<Object>(suffix);
        } else {
            LocalCache cache = new LocalCache(WfCache.class, 5000);
            this.objCache = new GroupCache(suffix, (Cache)cache);
        }
    }

    private void initExecutionCache() {
        this.assignLoader = new WfAssignmentCacheLoader(this.engine);
        this.activityLoader = new ActivityInstanceCacheLoader(this.engine);
        this.processLoader = new ProcessInstanceCacheLoader(this.engine);
        SmartCache.Loader<String, WfExecutionObject> loader = new SmartCache.Loader<String, WfExecutionObject>(){

            public WfExecutionObject load(String id) {
                if (id.endsWith(ASSIGN)) {
                    return (WfExecutionObject)WfCache.this.assignLoader.load((Object)id);
                }
                if (id.endsWith(ACTIVITY)) {
                    return (WfExecutionObject)WfCache.this.activityLoader.load((Object)id);
                }
                if (id.endsWith(PROCESS)) {
                    return (WfExecutionObject)WfCache.this.processLoader.load((Object)id);
                }
                throw new RuntimeException("{" + id + "}\u975e\u6cd5\u53c2\u6570!");
            }
        };
        String suffix = this.engine.context().getAIS() + "_WF";
        GroupCache cache = this.useMemcache() ? new MemcacheAdapter(suffix) : new GroupCache(suffix, (Cache)new LocalCache(WfCache.class.getName(), 1000, 1800));
        this.executionCache = new SmartCache(cache, (SmartCache.Loader)loader);
    }

    private boolean useMemcache() {
        return false;
    }

    public void putGeneralObject(Object key, Object value) {
        this.objCache.put((Object)key.toString(), value);
    }

    public void removeActivityInst(String activityInstId) {
        this.executionCache.remove((Object)activityInstId);
    }

    public void removeAssignment(String assignmentId) {
        this.executionCache.remove((Object)assignmentId);
    }

    public void removeInvocationResult(EffectRegion removedMethodEffectRegion) {
        if (EngineConfig.getInstance().isEnableMethodLevelCache()) {
            this.invocationCacheManager.clear();
        }
        this.procBostypeCache.clear();
        MicroFlowEngine.getEngine(this.engine.context()).clearCache();
    }

    public void removeProcRefInsts(String procInstID) {
        try {
            IWfCacheManager cacheManager = this.engine.getCacheManager();
            WfProcess process = cacheManager.getProcessInst(procInstID);
            List activities = process.activities();
            int size = activities.size();
            for (int i = 0; i < size; ++i) {
                WfActivity activity = (WfActivity)activities.get(i);
                List assignments = activity.assignments();
                int size1 = assignments.size();
                for (int j = 0; j < size1; ++j) {
                    WfAssignment assignment = (WfAssignment)assignments.get(j);
                    cacheManager.removeAssignment(assignment.getId());
                }
                cacheManager.removeActivityInst(activity.getId());
            }
            cacheManager.removeProcessInst(procInstID);
        }
        catch (WfException wfException) {
            // empty catch block
        }
    }

    public void removeProcessDef(String procDefHashVal) {
        this.processDefCache.remove((Object)procDefHashVal);
    }

    public void removeProcessInst(String processInstId) {
        this.executionCache.remove((Object)processInstId);
    }

    public void removeProcessMgr(String procDefId, int version) {
        try {
            this.processMgrCache.remove((Object)(procDefId + "," + version));
            ProcessDefInfo procDefInfo = this.engine.getDefinitionMgr().getProcessDefInfo(procDefId, version);
            String procHash = procDefInfo.getMd5HashValue();
            this.processMgrCache.remove((Object)(procHash + MARK));
        }
        catch (WfException wfException) {
            // empty catch block
        }
    }

    public int size() {
        return -1;
    }

    public void notifyActivityChange(String activityID) {
    }

    public void notifyAssignmentChange(String assignmentID) {
    }

    public void notifyProcessInstChange(String processInstID) {
    }

    public void activityInstExpired(String actInstId) {
        this.executionCache.remove((Object)actInstId);
    }

    public void assignmentExpired(String assignId) {
        this.executionCache.remove((Object)assignId);
    }

    public void processInstExpired(String procInstId) {
        this.executionCache.remove((Object)procInstId);
    }

    public BOSObjectType[] getRelatedEntityTypes(String procdefID) {
        return (BOSObjectType[])this.procBostypeCache.get((Object)procdefID);
    }

    static {
        ASSIGN = WfBOSObjectTypeUtil.ASSIGNMENTBOT.toString();
        ACTIVITY = WfBOSObjectTypeUtil.ACTIVITYINSTBOT.toString();
        PROCESS = WfBOSObjectTypeUtil.PROCESSINSTBOT.toString();
        PROCESS_DEF_CACHE_SIZE = EngineConfig.getInstance().getProDefCacheSize();
        MessageQueue.RECEIVER.set((Object)new GroupMessageQueue(-500000));
        MessageQueue.SENDER.set((Object)new GroupMessageQueue(-1000000));
        Timeout handler = new Timeout();
        Job job = new Job(null, (IJobHandler)handler, null, false);
        JobManager.instance().add(job);
    }

    private static class Timeout
    implements ICoreJobHandler,
    IJobHandler {
        private static final long serialVersionUID = 4752494613994055163L;

        private Timeout() {
        }

        public Object execute(Job job) throws Exception {
            CacheManager.shrink();
            return new Delay(10);
        }
    }
}

