/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.application;

import com.kingdee.bos.BOSException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.dydeploy.web.application.ComponentUtil;
import com.kingdee.shr.dydeploy.web.util.AppUtil;
import com.kingdee.shr.dydeploy.web.util.Constants;
import com.kingdee.shr.dydeploy.web.util.LoggerUtil;
import com.kingdee.shr.dydeploy.web.util.PatchUtil;
import com.kingdee.shr.dydeploy.web.util.ZIPUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class ApplicationUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.dydeploy.web.controller.AppOperateController");

    public static void uninstallApp(String basePath, String appId, boolean needExcuteSql) throws Exception {
        logger = LoggerUtil.getLoggerByAppId(appId);
        ApplicationUtil.checkUnzipApp(basePath, appId);
        List<String> components = ApplicationUtil.getComponents(Constants.getAppsPath(basePath) + "/bak/" + appId + ".zip");
        if (needExcuteSql) {
            Constants.setOPSTATUS(SHRWebResource.getString((String)"com.kingdee.shr.dydeploy.DydeployResourse", (String)"exe_unin_script") + "...");
            logger.info((Object)("[" + appId + "-uninstall]begin executing uninstall script"));
            for (String component : components) {
                try {
                    ComponentUtil.uninstallComponentSql(basePath, appId, component);
                }
                catch (Exception e) {
                    logger.info((Object)("execute uninstall sql error:" + component + " " + e.getMessage()));
                }
            }
            logger.info((Object)("[" + SHRCheck.vaildLog((String)appId) + "-uninstall]complete executing uninstall script"));
        }
        Constants.setOPSTATUS(SHRWebResource.getString((String)"com.kingdee.shr.dydeploy.DydeployResourse", (String)"del_app_files") + "...");
        for (String component : components) {
            ComponentUtil.deleteComponent(basePath, appId, component);
        }
        AppUtil.delDir(Constants.getAppsPath(basePath) + "/bak/" + appId + ".zip");
        logger.info((Object)("[" + SHRCheck.vaildLog((String)appId) + "-uninstall]removed app unzip files"));
    }

    private static void checkUnzipApp(String basePath, String appId) throws Exception {
        logger = LoggerUtil.getLoggerByAppId(appId);
        File appFile = new File(SHRCheck.checkFilePath((String)(Constants.getAppsPath(basePath) + "/bak/" + appId + ".zip")));
        if (!(appFile.exists() || appFile.isDirectory() || appFile.isDirectory())) {
            ZIPUtil.unZip(appId, Constants.getAppsPath(basePath) + "/" + appFile.getName(), Constants.getAppsPath(basePath) + "/bak/" + appFile.getName());
            List<String> components = ApplicationUtil.getComponents(Constants.getAppsPath(basePath) + "/bak/" + appFile.getName());
            for (String component : components) {
                ComponentUtil.unZipComponent(basePath, appId, component);
            }
        }
    }

    public static void installApp(String basePath, String appId, boolean needExcuteSql, boolean needCheckInstallAble) throws Exception {
        if (needCheckInstallAble) {
            ApplicationUtil.checkCanInstall(basePath, appId);
        }
        ApplicationUtil.installApp(basePath, appId, needExcuteSql);
    }

    public static void installApp(String basePath, String appId, boolean needExcuteSql) throws Exception {
        Constants.setOPSTATUS(SHRWebResource.getString((String)"com.kingdee.shr.dydeploy.DydeployResourse", (String)"copy_app_files") + "...");
        logger = LoggerUtil.getLoggerByAppId(appId);
        String zipPath = Constants.getAppsPath(basePath) + "/" + appId + ".zip";
        ApplicationUtil.checkUnzipApp(basePath, appId);
        logger.info((Object)("[" + SHRCheck.vaildLog((String)appId) + "-install]begin copying files"));
        List<String> components = ApplicationUtil.getComponents(Constants.getAppsPath(basePath) + "/bak/" + appId + ".zip");
        for (String component : components) {
            ComponentUtil.copyComponentFile(basePath, appId, component);
            logger.info((Object)("[" + component + "- component install]complete copying files"));
        }
        logger.info((Object)("[" + SHRCheck.vaildLog((String)appId) + "-install]complete copying files"));
        if (needExcuteSql) {
            ApplicationUtil.executeSqlScript(basePath, appId, components);
        }
    }

    public static void executeSqlScript(String basePath, String appId, List<String> components) throws Exception {
        Constants.setOPSTATUS(SHRWebResource.getString((String)"com.kingdee.shr.dydeploy.DydeployResourse", (String)"exe_install_script") + "...");
        logger.info((Object)("[" + SHRCheck.vaildLog((String)appId) + "-install]begin executing data script"));
        for (String component : components) {
            ComponentUtil.installComponentSql(basePath, appId, component);
            logger.info((Object)("[" + component + "- component install]complete executing data script"));
        }
        logger.info((Object)("[" + SHRCheck.vaildLog((String)appId) + "-install]complete executing data script"));
    }

    private static void checkCanInstall(String basePath, String appId) throws BOSException {
        logger = LoggerUtil.getLoggerByAppId(appId);
        try {
            String dependentPTM = ApplicationUtil.getDependantPTM(Constants.getAppsPath(basePath) + "/" + appId + ".zip");
            String result = PatchUtil.checkAPPCanInstall(dependentPTM);
            if (!"sucess".equals(result)) {
                logger.error((Object)("[ checkCanInstall error ]" + result));
                throw new BOSException(result);
            }
        }
        catch (IOException e) {
            logger.info((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDependantPTM(String applicationPath) throws IOException {
        String dependentPTM = "";
        ZipFile zipFile = null;
        FileOutputStream outStream = null;
        InputStream inputStream = null;
        Object file = null;
        ZipEntry zipEntry = null;
        try {
            zipFile = new ZipFile(applicationPath, "UTF-8");
            zipEntry = zipFile.getEntry("app.xml");
            inputStream = zipFile.getInputStream(zipEntry);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(inputStream);
            Element e_root = doc.getRootElement();
            List ptm = e_root.getChildren("dependentPTM");
            if (ptm != null && ptm.size() > 0) {
                dependentPTM = ((Element)ptm.get(0)).getTextNormalize();
            }
            zipFile.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getCause());
            String string = dependentPTM;
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
        return dependentPTM;
    }

    public static List<String> getComponents(String applicationPath) throws Exception {
        String fileName = applicationPath + "/components.xml";
        File inputXml = new File(SHRCheck.checkFilePath((String)fileName));
        ArrayList<String> components = new ArrayList<String>();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(inputXml);
        Element e_root = doc.getRootElement();
        List componentList = e_root.getChildren("componentList");
        if (componentList != null && componentList.size() > 0) {
            List jarList = ((Element)componentList.get(0)).getChildren("jar");
            for (Element e : jarList) {
                components.add(e.getAttributeValue("name"));
            }
        }
        return components;
    }
}

