/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.application;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.dydeploy.web.dep.DepRunner;
import com.kingdee.shr.dydeploy.web.executeSql.ScriptRunner;
import com.kingdee.shr.dydeploy.web.util.AppUtil;
import com.kingdee.shr.dydeploy.web.util.Constants;
import com.kingdee.shr.dydeploy.web.util.LoggerUtil;
import com.kingdee.shr.dydeploy.web.util.ZIPUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ComponentUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.dydeploy.web.controller.AppOperateController");

    public static void deleteComponent(String basePath, String appId, String component) {
        logger = LoggerUtil.getLoggerByAppId(appId);
        AppUtil.delDir(Constants.getApps_webPath(basePath) + "/" + component);
        logger.info((Object)("[" + appId + "-uninstall]removed web files"));
        AppUtil.delDir(Constants.getApps_jarPath(basePath) + "/" + component);
        logger.info((Object)("[" + appId + "-uninstall]removed jar files"));
        AppUtil.delDir(Constants.getApps_ftlPath(basePath) + "/" + component);
        logger.info((Object)("[" + appId + "-uninstall]removed ftl files"));
    }

    public static void unZipComponent(String basePath, String appId, String component) throws Exception {
        logger = LoggerUtil.getLoggerByAppId(appId);
        String appFileName = Constants.getAppsPath(basePath) + "/bak/" + appId + ".zip";
        ZIPUtil.unZip(appId, appFileName + "/components/" + component + ".zip", appFileName + "/components/bak/" + component + ".zip");
    }

    public static void copyComponentFile(String basePath, String appId, String component) throws Exception {
        logger = LoggerUtil.getLoggerByAppId(appId);
        String componentUnZipPath = Constants.getAppsPath(basePath) + "/bak/" + appId + ".zip/components/bak/" + component + ".zip";
        File zipFile = new File(SHRCheck.checkFilePath((String)componentUnZipPath));
        if (!zipFile.exists()) {
            return;
        }
        String Apps_jar = basePath + "lib/addon/" + component;
        String Apps_web = basePath + "deploy/easweb.ear/shr_web.war/addon/" + component;
        String Apps_ftl = basePath + "deploy/easweb.ear/shr_web.war/WEB-INF/freemarker/" + component;
        new File(SHRCheck.checkFilePath((String)Apps_web)).mkdirs();
        new File(SHRCheck.checkFilePath((String)Apps_jar)).mkdirs();
        File dir = new File(SHRCheck.checkFilePath((String)componentUnZipPath));
        File[] file = dir.listFiles();
        if (file == null) {
            return;
        }
        for (int i = 0; i < file.length; ++i) {
            if (file[i] == null) continue;
            String fileName = file[i].getName();
            String sourceDir = null;
            String targetDir = null;
            if (file[i].isDirectory() && ("web".equals(fileName) || "data".equals(fileName)) || "lib".equals(fileName) || "ftl".equals(fileName)) {
                sourceDir = componentUnZipPath + File.separator + fileName;
                targetDir = "ftl".equals(fileName) ? Apps_ftl : ("lib".equals(fileName) ? Apps_jar + File.separator + fileName : Apps_web + File.separator + fileName);
                ComponentUtil.copyDirectiory(sourceDir, targetDir);
                continue;
            }
            targetDir = Apps_web + "/" + fileName;
            File targetDir2 = new File(SHRCheck.checkFilePath((String)Apps_web));
            if (!targetDir2.exists()) {
                targetDir2.mkdirs();
            }
            if (!file[i].isFile()) continue;
            ComponentUtil.copyFile(file[i], new File(SHRCheck.checkFilePath((String)targetDir)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            int len;
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                ((BufferedOutputStream)outBuff).write(b, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
        }
        finally {
            if (inBuff != null) {
                inBuff.close();
            }
            if (outBuff != null) {
                outBuff.close();
            }
        }
    }

    public static void copyDirectiory(String sourceDir, String targetDir) throws IOException {
        new File(SHRCheck.checkFilePath((String)targetDir)).mkdirs();
        File[] file = new File(SHRCheck.checkFilePath((String)sourceDir)).listFiles();
        if (file == null) {
            return;
        }
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isFile()) {
                File sourceFile = file[i];
                File targetFile = new File(SHRCheck.checkFilePath((String)(new File(SHRCheck.checkFilePath((String)targetDir)).getAbsolutePath() + File.separator + file[i].getName())));
                ComponentUtil.copyFile(sourceFile, targetFile);
            }
            if (!file[i].isDirectory()) continue;
            String dir1 = sourceDir + "/" + file[i].getName();
            String dir2 = targetDir + "/" + file[i].getName();
            ComponentUtil.copyDirectiory(dir1, dir2);
        }
    }

    public static void installComponentSql(String basePath, String appId, String component) throws Exception {
        logger = LoggerUtil.getLoggerByAppId(appId);
        ScriptRunner.run(basePath, appId, component, 1);
        logger.info((Object)("[" + component + "- component install]complete executing data script"));
    }

    public static void installDep(String basePath, String appId, String component) throws Exception {
        logger = LoggerUtil.getLoggerByAppId(appId);
        DepRunner.install(Constants.getAppsPath(basePath), appId, component);
        logger.info((Object)("[" + component + "- component install]complete install dep"));
    }

    public static void uninstallComponentSql(String basePath, String appId, String component) throws Exception {
        logger = LoggerUtil.getLoggerByAppId(appId);
        ScriptRunner.run(basePath, appId, component, 0);
        logger.info((Object)("[" + component + "- component uninstall]complete executing data script"));
    }

    public static void uninstallDep(String basePath, String appId, String component) throws Exception {
        logger = LoggerUtil.getLoggerByAppId(appId);
        DepRunner.uninstall(Constants.getAppsPath(basePath), appId, component);
        logger.info((Object)("[" + component + "- component uninstall]complete install dep"));
    }
}

