/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.dydeploy.web.executeSql.AdminException;
import com.kingdee.shr.dydeploy.web.executeSql.CompositeSqlProvider;
import com.kingdee.shr.dydeploy.web.executeSql.DBException;
import com.kingdee.shr.dydeploy.web.executeSql.DBSQLException;
import com.kingdee.shr.dydeploy.web.executeSql.DBSQLProviderException;
import com.kingdee.shr.dydeploy.web.executeSql.DataCenterInfo;
import com.kingdee.shr.dydeploy.web.executeSql.DatabaseManager;
import com.kingdee.shr.dydeploy.web.executeSql.DatabaseVO;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSqlInputStreamExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.DomainException;
import com.kingdee.shr.dydeploy.web.executeSql.EASSqlScriptFileAccess;
import com.kingdee.shr.dydeploy.web.executeSql.ExceptionUtils;
import com.kingdee.shr.dydeploy.web.executeSql.ExecuteScriptFileParser;
import com.kingdee.shr.dydeploy.web.executeSql.ExecuteScriptOnDCEvent;
import com.kingdee.shr.dydeploy.web.executeSql.IDatabase;
import com.kingdee.shr.dydeploy.web.executeSql.KSQLInputStreamExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.KSQLProvider;
import com.kingdee.shr.dydeploy.web.executeSql.MultiSqlProvider;
import com.kingdee.shr.dydeploy.web.executeSql.ObjectCloneUtils;
import com.kingdee.shr.dydeploy.web.executeSql.ScriptInfo;
import com.kingdee.shr.dydeploy.web.executeSql.SqlProvider;
import com.kingdee.shr.dydeploy.web.executeSql.StringUtils;
import com.kingdee.shr.dydeploy.web.executeSql.XmlSqlFileExecutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class DataCenterServiceImpl {
    private static final Logger logger = Logger.getLogger(DataCenterServiceImpl.class);
    private Document dcDocument;
    private long dcLastModified = 0L;
    private String defaultUpgradeScriptPath = "/server/properties/upgradescript";
    public static final String dataFilePrefix = "EAS_D";
    public static final String tempFilePrefix = "EAS_T";
    public static final String PROP_isPutOnReadCommittedSnapshot = "isPutOnReadCommittedSnapshot";
    private final String tempSpaceSize = "50";
    private final String versionSql = "select * from t_sys_datacenter where fid=?";
    private final String insertVersionSql = "insert into t_sys_datacenter(fid,fmajor,fminor,fbuild,fbim,flastupgradetime) values(?,?,?,?,?,?)";
    private final String updateVersionSql = "update t_sys_datacenter set fmajor=?,fminor=?,fbuild=?,fbim=?,flastupgradetime=? where fid=?";
    private final String createNoLogTableSpaceSql = "CREATE TABLESPACE \"{0}\" NOLOGGING DATAFILE ''{1}/{0}.dbf'' SIZE {2}M AUTOEXTEND ON NEXT 5M MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO";
    private final String createTempTableSpaceSql = "CREATE TEMPORARY TABLESPACE \"{0}\" TEMPFILE ''{1}/{0}.dbf'' SIZE {2}M AUTOEXTEND ON NEXT 5M MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL UNIFORM SIZE 5M";
    private final String createTableSpaceSql = "CREATE TABLESPACE \"{0}\" LOGGING DATAFILE ''{1}/{0}.ora'' SIZE {2}M AUTOEXTEND ON NEXT 5M MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO";
    private final String umlimitSql = "ALTER PROFILE DEFAULT LIMIT PASSWORD_LIFE_TIME UNLIMITED";
    private final String grantAuthorSql = "Grant create session,create table,create procedure,create sequence,create trigger,create view,SELECT ANY DICTIONARY,CREATE MATERIALIZED VIEW,alter profile to {0}";
    private final String grantResourceSql = "GRANT UNLIMITED TABLESPACE TO {0}";
    private boolean ignoreCheckDBSupport = "true".equalsIgnoreCase(System.getProperty("ignoreCheckDBSupport", "false"));

    public void executeSqlScriptFile(DataCenterInfo dcInfo, ArrayList scriptList) {
        DatabaseVO db = dcInfo.getDefaultDatabase();
        IDatabase dbEngine = DatabaseManager.getDBEngine(db);
        try {
            new ExecuteScriptOnDCEvent(2, 0, dcInfo.getDcNumber());
            ArrayList<XmlSqlFileExecutor> curSQLProviderList = new ArrayList<XmlSqlFileExecutor>();
            for (int i = 0; i < scriptList.size(); ++i) {
                ScriptInfo info = (ScriptInfo)scriptList.get(i);
                FileInputStream inputStream = null;
                MultiSqlProvider provider = null;
                KSQLProvider kqlprovider = new KSQLProvider();
                if (info.scriptFilePath.toLowerCase(Locale.ENGLISH).endsWith("xml")) {
                    EASSqlScriptFileAccess fileAccess = new EASSqlScriptFileAccess(info.scriptFilePath);
                    provider = new XmlSqlFileExecutor(fileAccess, info.scriptFilePath, db, info.charset, kqlprovider);
                } else if (info.dialect.booleanValue()) {
                    inputStream = new FileInputStream(SHRCheck.checkFilePath((String)info.scriptFilePath));
                    provider = new DefaultSqlInputStreamExecutor(info.scriptFilePath, inputStream, info.scriptSplit, info.charset);
                } else {
                    inputStream = new FileInputStream(SHRCheck.checkFilePath((String)info.scriptFilePath));
                    provider = new KSQLInputStreamExecutor(info.scriptFilePath, inputStream, info.scriptSplit, db, info.charset, kqlprovider);
                }
                curSQLProviderList.add((XmlSqlFileExecutor)provider);
            }
            dbEngine.execute(new ExecuteCustomerScriptProvider(curSQLProviderList));
            StringBuffer exp = new StringBuffer();
            DBSQLProviderException tempEx = null;
            for (int i = 0; i < curSQLProviderList.size(); ++i) {
                DBSQLProviderException providerException;
                ArrayList list = null;
                if (XmlSqlFileExecutor.class.isInstance(curSQLProviderList.get(i))) {
                    list = ((XmlSqlFileExecutor)curSQLProviderList.get(i)).getExceptions();
                } else if (DefaultSqlInputStreamExecutor.class.isInstance(curSQLProviderList.get(i))) {
                    list = ((DefaultSqlInputStreamExecutor)curSQLProviderList.get(i)).getExceptions();
                } else if (KSQLInputStreamExecutor.class.isInstance(curSQLProviderList.get(i))) {
                    list = ((KSQLInputStreamExecutor)curSQLProviderList.get(i)).getExceptions();
                }
                if (list == null || list.size() <= 0) continue;
                Throwable dbsqle = null;
                for (int j = 0; j < list.size(); ++j) {
                    DBSQLException sqlePrev = null;
                    if (dbsqle != null) {
                        sqlePrev = (DBSQLException)ObjectCloneUtils.clone(dbsqle);
                    }
                    if (DBException.class == list.get(j).getClass()) {
                        DBException dbe = (DBException)list.get(j);
                        dbsqle = new DBSQLException(dbe.getMessage(), dbe.getDBType());
                    } else {
                        dbsqle = (DBSQLException)list.get(j);
                    }
                    ((DBSQLException)dbsqle).setNexException(sqlePrev);
                    Exception ex = (Exception)list.get(j);
                    exp.append(ExceptionUtils.getStackTrace(ex));
                }
                if (null == dbsqle) continue;
                tempEx = providerException = new DBSQLProviderException("ExecuteSqlScriptFile failed!" + dbsqle.getMessage(), ((DBException)dbsqle).getDBType(), ((DBSQLException)dbsqle).getSourceSQL(), ((DBSQLException)dbsqle).getTranslateSQL(), ((DBSQLException)dbsqle).getSqlCode(), ((DBSQLException)dbsqle).getSqlState(), ((DBSQLException)dbsqle).getSqlMessage(), ((SqlProvider)curSQLProviderList.get(i)).getProviderName());
            }
            if (StringUtils.hasText(exp.toString())) {
                logger.error((Object)exp);
                DomainException e = new DomainException("run scripts on db [" + db.getDisplayDBName() + "] with user [" + db.getDbUserName() + "] error", new Throwable(exp.toString()));
                ExecuteScriptOnDCEvent event = new ExecuteScriptOnDCEvent(2, 2, dcInfo.getDcNumber());
                event.failed(e);
                throw tempEx;
            }
            new ExecuteScriptOnDCEvent(2, 1, dcInfo.getDcNumber());
        }
        catch (Exception ex) {
            DomainException e = new DomainException("run scripts on db [" + db.getDisplayDBName() + "] with user [" + db.getDbUserName() + "] error", ex);
            ExecuteScriptOnDCEvent event = new ExecuteScriptOnDCEvent(2, 2, dcInfo.getDcNumber());
            event.failed(e);
            if (ex instanceof AdminException) {
                throw (AdminException)ex;
            }
            throw e;
        }
    }

    public ScriptInfo[] getScriptInfoFromFile(DatabaseVO db, String filePath) {
        List<Object> scriptList = new ArrayList();
        try {
            File cXMLFile = new File(StringUtils.cleanPath(filePath));
            FileInputStream inStream = new FileInputStream(cXMLFile);
            SAXBuilder builder = new SAXBuilder();
            Document updateDoc = builder.build((InputStream)inStream);
            inStream.close();
            Element ele = updateDoc.getRootElement();
            boolean useRelativePathRules = Boolean.valueOf(ele.getAttributeValue("useRelativePathRule"));
            if (useRelativePathRules) {
                ExecuteScriptFileParser executeScriptFileParser = new ExecuteScriptFileParser(db, filePath);
                scriptList = executeScriptFileParser.scan();
            } else {
                List childList = ele.getChildren();
                if (childList != null && childList.size() > 0) {
                    for (int i = 0; i < childList.size(); ++i) {
                        Element e_child = (Element)childList.get(i);
                        String type = e_child.getAttributeValue("type");
                        if (StringUtils.hasText(type = this.getScriptSupportDBType(type)) && !ScriptInfo.SCRIPT_TYPE_ALL.equals(type) && type.indexOf(db.getDBType()) < 0) {
                            logger.warn((Object)("ScriptFile[" + e_child.getText() + "] is ignored, because is not compatible with the current dbType[" + db.getDBType() + "]!"));
                            continue;
                        }
                        String split = e_child.getAttributeValue("split");
                        String charset = e_child.getAttributeValue("encoding");
                        Boolean dialect = Boolean.valueOf(e_child.getAttributeValue("dialect"));
                        dialect = dialect == null ? Boolean.FALSE : dialect;
                        String path = e_child.getText();
                        if (!StringUtils.hasText(path)) continue;
                        if (path.indexOf("*") >= 0) {
                            int lastIndex = -1;
                            lastIndex = filePath.lastIndexOf("/");
                            if (lastIndex == -1) {
                                lastIndex = filePath.lastIndexOf("\\");
                            }
                            if (lastIndex == -1) {
                                lastIndex = filePath.lastIndexOf(File.pathSeparator);
                            }
                            String base = filePath.substring(0, lastIndex == -1 ? filePath.length() : lastIndex);
                            System.out.println("Script base filePath [" + base + "]");
                            int firstIndex = -1;
                            firstIndex = filePath.indexOf("/");
                            if (firstIndex == -1) {
                                firstIndex = filePath.indexOf("\\");
                            }
                            if (firstIndex == -1) {
                                firstIndex = filePath.indexOf(File.pathSeparator);
                            }
                            int index = -1;
                            index = path.lastIndexOf("/");
                            if (index == -1) {
                                index = path.lastIndexOf("\\");
                            }
                            if (index == -1) {
                                index = path.lastIndexOf(File.pathSeparator);
                            }
                            String relativePath = path.substring(firstIndex, index);
                            System.out.println("Script absolute filePath [" + base + relativePath + "]");
                            File[] files = new File(base + "/" + relativePath).listFiles();
                            StringBuffer errorBuf = new StringBuffer();
                            for (int j = 0; j < files.length; ++j) {
                                ScriptInfo info = new ScriptInfo();
                                info.scriptFilePath = files[j].getCanonicalPath();
                                if (StringUtils.hasText(type)) {
                                    info.scriptType = type;
                                }
                                if (StringUtils.hasText(split)) {
                                    info.scriptSplit = split;
                                }
                                if (StringUtils.hasText(charset)) {
                                    info.charset = charset;
                                }
                                info.dialect = dialect;
                                if (this.isFileExist(info, filePath)) {
                                    scriptList.add(info);
                                    continue;
                                }
                                System.out.println("File [" + info.scriptFilePath + "] does not exist!");
                            }
                            if (errorBuf.length() == 0) continue;
                            throw new Exception(errorBuf.toString());
                        }
                        ScriptInfo info = new ScriptInfo();
                        info.scriptFilePath = e_child.getText();
                        if (StringUtils.hasText(type)) {
                            info.scriptType = type;
                        }
                        if (StringUtils.hasText(split)) {
                            info.scriptSplit = split;
                        }
                        if (StringUtils.hasText(charset)) {
                            info.charset = charset;
                        }
                        info.dialect = dialect;
                        if (this.isFileExist(info, filePath)) {
                            scriptList.add(info);
                            continue;
                        }
                        System.out.println("File [" + info.scriptFilePath + "] does not exist!");
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Get script information from file error" + ex);
        }
        return scriptList.toArray(new ScriptInfo[scriptList.size()]);
    }

    private String getScriptSupportDBType(String type) {
        String supportType = "";
        if (StringUtils.hasText(type)) {
            boolean supportDB2;
            boolean supportSqlServer = type.toLowerCase().indexOf("sqlserver") >= 0;
            boolean supportOracle = type.toLowerCase().indexOf("oracle") >= 0;
            boolean bl = supportDB2 = type.toLowerCase().indexOf("db2") >= 0;
            if (supportSqlServer && supportOracle && supportDB2) {
                supportType = ScriptInfo.SCRIPT_TYPE_ALL;
            } else if (supportSqlServer && supportOracle) {
                supportType = ScriptInfo.SCRIPT_TYPE_SQLSERVER_ADN_ORACLE;
            } else if (supportOracle && supportDB2) {
                supportType = ScriptInfo.SCRIPT_TYPE_ORACLE_AND_DB2;
            } else if (supportSqlServer && supportDB2) {
                supportType = ScriptInfo.SCRIPT_TYPE_SQLSERVER_AND_DB2;
            } else if (supportSqlServer) {
                supportType = ScriptInfo.SCRIPT_TYPE_SQLSERVER;
            } else if (supportOracle) {
                supportType = ScriptInfo.SCRIPT_TYPE_ORACLE;
            } else if (supportDB2) {
                supportType = ScriptInfo.SCRIPT_TYPE_DB2;
            }
        }
        return supportType;
    }

    private boolean isFileExist(ScriptInfo info, String basePath) {
        String filePath = info.scriptFilePath;
        if (!new File(filePath).exists()) {
            int lastIndex = -1;
            lastIndex = basePath.lastIndexOf("/");
            if (lastIndex == -1) {
                lastIndex = basePath.lastIndexOf("\\");
            }
            if (lastIndex == -1) {
                lastIndex = basePath.lastIndexOf(File.pathSeparator);
            }
            String base = basePath.substring(0, lastIndex == -1 ? basePath.length() : lastIndex);
            int firstIndex = -1;
            firstIndex = filePath.indexOf("/");
            if (firstIndex == -1) {
                firstIndex = filePath.indexOf("\\");
            }
            if (firstIndex == -1) {
                firstIndex = filePath.indexOf(File.pathSeparator);
            }
            String path = filePath.substring(firstIndex == -1 ? 0 : firstIndex, filePath.length());
            if (firstIndex == -1) {
                path = "/" + path;
            }
            path = path.replaceAll("\\\\", "/");
            if (!new File(base + path).exists()) {
                String characterStr = "server/properties/upgradescript";
                if ((basePath = basePath.replaceAll("\\\\", "/")).indexOf(characterStr) > 0) {
                    if (new File((basePath = basePath.substring(0, basePath.indexOf(characterStr) + characterStr.length())) + path).exists()) {
                        info.scriptFilePath = basePath + path;
                        return true;
                    }
                    characterStr = "upgradescript";
                    basePath = basePath.replaceAll("\\\\", "/");
                    if (new File((basePath = basePath.substring(0, basePath.indexOf(characterStr))) + path).exists()) {
                        info.scriptFilePath = basePath + path;
                        return true;
                    }
                }
                logger.warn((Object)("Script file [" + filePath + "] and [" + base + path + "] doesn't exist!"));
                return false;
            }
            info.scriptFilePath = base + path;
            return true;
        }
        return true;
    }

    class ExecuteCustomerScriptProvider
    implements CompositeSqlProvider {
        private ArrayList curSQLProviderList;
        private int curSQLProviderIndex = 0;

        public ExecuteCustomerScriptProvider(ArrayList providerList) {
            this.curSQLProviderList = providerList;
        }

        @Override
        public SqlProvider getNextSqlProvider() {
            if (this.curSQLProviderList.size() >= 0 && this.curSQLProviderIndex <= this.curSQLProviderList.size() - 1) {
                return (SqlProvider)this.curSQLProviderList.get(this.curSQLProviderIndex++);
            }
            return null;
        }

        @Override
        public boolean handleException(DBSQLException sqle) {
            return false;
        }
    }
}

