/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.dydeploy.web.executeSql.AbstractDB;
import com.kingdee.shr.dydeploy.web.executeSql.AdminException;
import com.kingdee.shr.dydeploy.web.executeSql.CreateDBInfo;
import com.kingdee.shr.dydeploy.web.executeSql.DBException;
import com.kingdee.shr.dydeploy.web.executeSql.DBInstanceNotExistException;
import com.kingdee.shr.dydeploy.web.executeSql.DBLoginException;
import com.kingdee.shr.dydeploy.web.executeSql.DatabaseVO;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSQLProviderExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSQLQueryProviderExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.IMySQL;
import com.kingdee.shr.dydeploy.web.executeSql.IMySQLDriver;
import com.kingdee.shr.dydeploy.web.executeSql.JDBCDriverFactory;
import com.kingdee.shr.dydeploy.web.executeSql.MySQLVO;
import com.kingdee.shr.dydeploy.web.executeSql.SqlServer;
import com.kingdee.shr.dydeploy.web.executeSql.SqlTable;
import com.kingdee.shr.dydeploy.web.executeSql.StringUtils;
import com.kingdee.shr.dydeploy.web.executeSql.TableSpaceInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class MySQL
extends AbstractDB
implements IMySQL {
    private static final Logger logger = Logger.getLogger(SqlServer.class);
    public static final String PARAM_DB_COLLATE = "param_db_collate";
    private IMySQLDriver mySqlDriver;
    private MySQLVO mySql;

    public MySQL(MySQLVO dbvo) {
        this.mySql = dbvo;
        this.mySqlDriver = (IMySQLDriver)JDBCDriverFactory.getDBDriver(dbvo);
    }

    @Override
    public void runStatics(Connection conn, String tableName) {
        String sql = "UPDATE STATISTICS " + tableName;
        this.executeSqlProvider(conn, new DefaultSQLProviderExecutor(sql, false));
    }

    @Override
    public String getJDBCDriverClassName() {
        return this.mySqlDriver.getDriverClassName();
    }

    @Override
    public String getJDBCUrl(DatabaseVO dbVO) {
        return this.mySqlDriver.getJDBCUrl(dbVO);
    }

    @Override
    public String getJDBCReadOnlyUrl(DatabaseVO defaultDatabase) {
        return this.mySqlDriver.getJDBCReadOnlyUrl(defaultDatabase);
    }

    @Override
    protected Connection getPhysicalDBConnection() throws SQLException {
        this.testDBPort(this.mySql);
        Properties props = new Properties();
        props.setProperty("user", this.mySql.getDbUserName());
        props.setProperty("password", this.mySql.getDbPassword());
        logger.info((Object)("Create physical MySQL connection with user [" + props.getProperty("user") + "]"));
        Connection conn = null;
        try {
            conn = this.mySqlDriver.connect(this.getJDBCUrl(this.mySql), props);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 18456) {
                logger.error((Object)("Create MySQL connection error,login failed," + ex));
                throw new DBLoginException("Create MySQL connection error,login failed," + ex.getMessage(), this.mySql.getDBType(), this.mySql.getDbUserName(), this.mySql.getDisplayAddress(), this.mySql.getDbPort());
            }
            if (ex.getErrorCode() == 4060) {
                logger.error((Object)("Create MySQL connection error,get DBInstance failed," + ex));
                throw new DBInstanceNotExistException("Create MySQL connection error,get DBInstance failed,", this.mySql.getDBType(), this.mySql.getDisplayDBName(), this.mySql.getDisplayAddress(), this.mySql.getDbPort());
            }
            throw ex;
        }
        return conn;
    }

    @Override
    public SqlTable[] getDBTableAndViews() {
        final ArrayList tablesList = new ArrayList();
        try {
            this.execute(new DefaultSQLQueryProviderExecutor("show tables"){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String tbName = rs.getString(1);
                    SqlTable table = new SqlTable(tbName, false);
                    tablesList.add(table);
                }
            });
            return tablesList.toArray(new SqlTable[0]);
        }
        catch (Throwable e) {
            logger.error((Object)"Get MySQL table and view failed!", e);
            throw new AdminException("Get MySQL table and view failed!", e);
        }
    }

    @Override
    public String[] getDatabaseList() {
        final ArrayList dbList = new ArrayList();
        try {
            this.execute(new DefaultSQLQueryProviderExecutor("show databases"){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    dbList.add(rs.getString(1));
                }
            });
            return dbList.toArray(new String[0]);
        }
        catch (Throwable e) {
            if (e instanceof AdminException) {
                throw (AdminException)e;
            }
            logger.error((Object)"Get MySQL dblist failed!", e);
            throw new AdminException("Get MySQL dblist failed!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() throws SQLException {
        Connection conn = null;
        try {
            conn = this.getDBConnection();
            DatabaseMetaData meta = conn.getMetaData();
            logger.info((Object)("MySQL ProductVersion: " + meta.getDatabaseProductVersion()));
            String string = meta.getDatabaseProductVersion();
            return string;
        }
        finally {
            this.connectionHolder.release();
        }
    }

    @Override
    public String[] getDatabaseUserList() {
        final ArrayList userList = new ArrayList();
        try {
            this.execute(new DefaultSQLQueryProviderExecutor("select distinct user from user"){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    userList.add(rs.getString(1));
                }
            });
            return userList.toArray(new String[0]);
        }
        catch (Throwable e) {
            logger.error((Object)"Get MySQL userList failed!", e);
            throw new AdminException("Get MySQL userList failed!", e);
        }
    }

    @Override
    public void createDatabase(DatabaseVO dbVO, CreateDBInfo info) throws SQLException {
        String createDatabaseSql = this.initCreateDatabaseSql(info);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(createDatabaseSql);
        this.executeMultiSql(sqlList);
    }

    private String initCreateDatabaseSql(CreateDBInfo info) {
        String dbName = info.getNewDBName();
        String sql = "create database " + dbName + " default character set utf8";
        return sql;
    }

    @Override
    public HashMap getDBFKList(String dbSchema, String tableName) {
        final HashMap fkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "select name FK_NAME,object_name(parent_obj) TABLE_NAME from sysobjects where Xtype='F' and object_name(parent_obj)='" + tableName + "'" : "select name FK_NAME,object_name(parent_obj) TABLE_NAME from sysobjects where Xtype='F' and object_name(parent_obj) like 'T_%'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    fkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get sqlserver DB FK list failed!", e);
            throw new AdminException("Get sqlserver DB FK list failed!", e);
        }
        return fkList;
    }

    @Override
    public boolean isTablespaceExist(String spaceName) throws SQLException {
        final ArrayList list = new ArrayList();
        try {
            String sql = "select * from sysfiles WHERE name = '" + spaceName + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    list.add("success");
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list.size() > 0;
    }

    @Override
    public void getTableSpaceActualSize(final TableSpaceInfo spaceInfo, String fileName) {
        try {
            String name = fileName + "_data";
            spaceInfo.cleareNormalSizes();
            String sql = "Exec sp_spaceused";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String strTotalSize = rs.getString("database_size");
                    String strFreeSize = rs.getString("unallocated space");
                    String percent = new DecimalFormat("0.00").format((MySQL.this.dealSpaceSizeInfo(strTotalSize) - MySQL.this.dealSpaceSizeInfo(strFreeSize)) / MySQL.this.dealSpaceSizeInfo(strTotalSize) * 100.0);
                    spaceInfo.addNormalSize(MySQL.this.dealSpaceSizeInfo(strTotalSize) + "(" + percent + "%)");
                }
            });
            name = fileName + "_log";
            sql = "DBCC SQLPERF(LOGSPACE)";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)"Get table space actual size error !", (Throwable)ex);
            AdminException e = new AdminException("Get tablespae actual size error", ex);
            throw e;
        }
    }

    private double dealSpaceSizeInfo(String strSize) {
        String sizeNumber = "";
        int index1 = (strSize = strSize.toLowerCase()).indexOf("m");
        if (index1 > 0) {
            sizeNumber = strSize.substring(0, index1);
        }
        return new Double(sizeNumber);
    }

    @Override
    public TableSpaceInfo getOldVersionDCTableSpaceInfo() {
        final TableSpaceInfo spaceInfo = new TableSpaceInfo();
        try {
            String sql = "select * from sysfiles where groupid=1";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String path = rs.getString("filename");
                    String normalSize = String.valueOf(rs.getInt("size") * 8 / 1024);
                    String type = "standard";
                    spaceInfo.addNormalSize(normalSize);
                    spaceInfo.setSpaceType(type);
                    spaceInfo.setSpaceName(type);
                    spaceInfo.addSpacePath(path);
                }
            });
            sql = "select * from sysfiles where groupid=0";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String tempSize = String.valueOf(rs.getInt("size") * 8 / 1024);
                    spaceInfo.addTempSize(tempSize);
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)"Get old version datacenter table space info error !", (Throwable)ex);
            AdminException e = new AdminException("Get old version datacenter table space information error", ex);
            throw e;
        }
        return spaceInfo;
    }

    @Override
    public ArrayList getDBTableList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "select name from sysobjects where type = 'U' order by name";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get table list failed!", e);
            throw new DBException("Get table list form db error", e);
        }
        return tableList;
    }

    @Override
    public ArrayList getDBViewList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "select name from sysobjects where type = 'V' order by name";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get view list failed!", e);
            throw new DBException("Get view list form db error", e);
        }
        return tableList;
    }

    @Override
    public HashMap getDBPKList(String dbSchema, String tableName) {
        final HashMap pkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "select name PK_NAME,object_name(parent_obj) TABLE_NAME from sysobjects where xtype='PK' and object_name(parent_obj)='" + tableName + "'" : "select name PK_NAME,object_name(parent_obj) TABLE_NAME from sysobjects where xtype='PK'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    pkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get pk list failed!", e);
            throw new DBException("Get pk list form db error", e);
        }
        return pkList;
    }

    @Override
    public HashMap getDBIndexList(String dbSchema) {
        final HashMap indexList = new HashMap();
        try {
            String sql = "SELECT  O.name AS NAME, T.name AS TBNAME,0 AS fObj, keycnt AS KeyCount, keycnt AS devKeyCount,0 AS fKeyCount, O.status AS Status,O.status AS devStatus,0 AS fStatus FROM sysindexes O, sysobjects T WHERE O.Status & 2048 = 0 AND O.id = T.id AND T.xtype = 'U' AND O.status & 8388608 = 0 AND O.keycnt > 0 AND O.name NOT LIKE '_WA%' ORDER BY T.name, O.name";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    indexList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get index list failed!", e);
            throw new DBException("Get index list form db error", e);
        }
        return indexList;
    }

    @Override
    public String getID() {
        return "sqlserver:" + this.mySql.getID();
    }

    @Override
    public String getDetectSql() {
        return "SELECT 1";
    }
}

