/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.util;

import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.URL;

public class RemoteConnectUtil {
    public static String remoteConnect(String urlStr) throws Exception {
        if (urlStr == null || "".equals(urlStr.trim())) {
            return "";
        }
        StringWriter sw = null;
        BufferedReader bis = null;
        try {
            URL url = new URL(urlStr);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            bis = new BufferedReader(new InputStreamReader(huc.getInputStream(), "UTF-8"));
            sw = new StringWriter();
            char[] buffer = new char[10240];
            int len = 0;
            while ((len = bis.read(buffer)) != -1) {
                sw.write(buffer, 0, len);
            }
        }
        catch (NoRouteToHostException ne) {
            String string = "";
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != bis) {
                bis.close();
            }
        }
        return sw.toString();
    }

    public static boolean remoteDownload(String urlStr, String destDir) throws Exception {
        if (urlStr == null || "".equals(urlStr.trim())) {
            return false;
        }
        URL url = new URL(urlStr);
        HttpURLConnection huc = null;
        BufferedInputStream bis = null;
        FileOutputStream fw = null;
        try {
            huc = (HttpURLConnection)url.openConnection();
            huc.setConnectTimeout(10000);
            huc.setReadTimeout(60000);
            bis = new BufferedInputStream(huc.getInputStream());
            File dir = new File(SHRCheck.checkFilePath((String)destDir));
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String fileName = urlStr.substring(urlStr.lastIndexOf("/") + 1);
            fw = new FileOutputStream(new File(SHRCheck.checkFilePath((String)(destDir + fileName))));
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = bis.read(buffer)) != -1) {
                fw.write(buffer, 0, len);
            }
            File f = new File(SHRCheck.checkFilePath((String)(destDir + fileName)));
            boolean bl = f.exists();
            return bl;
        }
        catch (IOException e) {
            throw new Exception(SHRWebResource.getString((String)"com.kingdee.shr.dydeploy.DydeployResourse", (String)"conne_timeout"));
        }
        finally {
            if (null != bis) {
                bis.close();
            }
            if (null != fw) {
                fw.close();
            }
        }
    }
}

